package com.vsu.fcounter.restart;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;

import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.bridge.ReactContextBaseJavaModule;
import com.facebook.react.bridge.ReactMethod;

class RestartModule extends ReactContextBaseJavaModule {

    private ReactContext reactContext;

    @Override
    public String getName() {
        return "Restart";
    }

    RestartModule(ReactApplicationContext reactContext) {
        super(reactContext);
        this.reactContext = reactContext;
    }

    @ReactMethod
    private void restartApp() {
        Intent intent = reactContext.getPackageManager().getLaunchIntentForPackage(reactContext.getPackageName());
        PendingIntent restartIntent = PendingIntent.getActivity(reactContext.getApplicationContext(), 0, intent, PendingIntent.FLAG_ONE_SHOT);
        AlarmManager mgr = (AlarmManager)reactContext.getSystemService(Context.ALARM_SERVICE);
        mgr.set(AlarmManager.RTC, System.currentTimeMillis() + 50, restartIntent);
        android.os.Process.killProcess(android.os.Process.myPid());
    }


}
