package com.vsu.fcounter.autoclick;

import android.accessibilityservice.AccessibilityService;
import android.view.accessibility.AccessibilityEvent;

import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.modules.core.DeviceEventManagerModule;

import java.util.HashMap;

public class AutoClickService extends AccessibilityService {

    private void emit(String event, Object map) {
        AutoClickModule.getInstance().context
                .getJSModule(DeviceEventManagerModule.RCTDeviceEventEmitter.class)
                .emit(event, map);
    }

    @Override
    protected void onServiceConnected() {
        super.onServiceConnected();
    }

    @Override
    public void onAccessibilityEvent(AccessibilityEvent event) {
        // 此方法是在主线程中回调过来的，所以消息是阻塞执行的
        // 获取包名
        AccessibilityOperator.getInstance().updateEvent(this, event);
//        if (event.getEventType() == AccessibilityEvent.TYPE_VIEW_CLICKED) {
//            AccessibilityLog.printLog(event.getPackageName()+" | "
//                    +event.getClassName()+" | "
//                    +event.getSource().getViewIdResourceName());
//        }

        String pkgName = event.getPackageName().toString();
        AccessibilityOperator operator = AccessibilityOperator.getInstance();

        if (event.getEventType() == AccessibilityEvent.TYPE_VIEW_CLICKED) {
            WritableMap map = Arguments.createMap();
            map.putString("pkgName", pkgName);
            map.putString("text", event.getText().toString());
            this.emit("AccessibilityClick", map);
        }

        HashMap<String, ReadableMap> eventMap = AccessibilityOperator.getInstance().getEventMap();

        for (HashMap.Entry<String, ReadableMap> ev : eventMap.entrySet()) {
            String eventKey = ev.getKey();
            ReadableMap e = ev.getValue();
            String _pkgName = e.getString("pkgName");
            String method = e.getString("method");
            String search = e.getString("search");
            boolean parent = e.getBoolean("parent");
            if (pkgName.equals(_pkgName)) {
                boolean invoke = method.equals("clickById") && operator.clickById(search) ||
                        method.equals("clickByText") && operator.clickByText(search, parent) ||
                        method.equals("clickByExact") && operator.clickByExact(search, parent);
                if (invoke) {
                    WritableMap data = Arguments.createMap();
                    data.putString("key", eventKey);
                    this.emit("AccessibilityEvent", data);
                }
            }
        }

//        String wxPkg = "com.tencent.wxpayface";
//        String alPkg = "com.alipay.zoloz.smile";
//        if (pkgName.equals(wxPkg)) {
//            if (event.getEventType() == AccessibilityEvent.TYPE_VIEW_CLICKED) {
//                WritableMap map = Arguments.createMap();
//                map.putString("text", event.getText().toString());
//                this.emit("wxpayfaceInput", map);
//            }
//            AccessibilityOperator operator = AccessibilityOperator.getInstance();
//            if (operator.clickByText("确认支付", true)) {
//                this.emit("wxpayfaceConfirm", null);
//                return;
//            }
//            if (operator.clickById(wxPkg + ":id/container_register_allow_button")) {
//                operator.clickBackKey();
//                this.emit("wxpayfaceRegister", null);
//            }
//        } else if (pkgName.equals(alPkg)) {
//            AccessibilityOperator operator = AccessibilityOperator.getInstance();
//            if (operator.clickByExact("确认", true)) return;
//            if (operator.clickByExact("确认支付", true)) return;
//        }
    }

    @Override
    public void onInterrupt() {

    }
}
