package com.vsu.fcounter;

import android.app.Application;
import android.content.Context;
import com.facebook.react.PackageList;
import com.facebook.react.ReactApplication;
import com.facebook.react.ReactInstanceManager;
import com.facebook.react.ReactNativeHost;
import com.facebook.react.ReactPackage;
import com.facebook.soloader.SoLoader;
import com.gcrabtree.rctsocketio.SocketIoPackage;
import com.microsoft.codepush.react.CodePush;
import com.nanchen.crashmanager.CrashApplication;
import com.nanchen.crashmanager.UncaughtExceptionHandlerImpl;
import com.vsu.fcounter.autoclick.AutoClickPackage;
import com.vsu.fcounter.installer.InstallerPackage;
import com.vsu.fcounter.printer.PrinterPackage;
import com.vsu.fcounter.restart.RestartPackage;
import com.vsu.fcounter.smilepay.SmilepayPackage;
import com.vsu.fcounter.versioncode.VersioncodePackage;
import com.vsu.fcounter.speech.SpeechPackage;
import com.vsu.fcounter.tcprelay.TcpRelayPackage;
import com.vsu.fcounter.udpbroadcast.UdpBroadcastPackage;
import com.vsu.fcounter.wxfacepay.WxFacepayPackage;

import java.lang.reflect.InvocationTargetException;
import java.util.List;

public class MainApplication extends CrashApplication implements ReactApplication {

  private final ReactNativeHost mReactNativeHost =
      new ReactNativeHost(this) {

        @Override
        protected String getJSBundleFile() {
          return CodePush.getJSBundleFile();
        }

        @Override
        public boolean getUseDeveloperSupport() {
          return BuildConfig.DEBUG;
        }

        @Override
        protected List<ReactPackage> getPackages() {
          List<ReactPackage> packages = new PackageList(this).getPackages();
          // Packages that cannot be autolinked yet can be added manually here, for example:
          // packages.add(new MyReactNativePackage());
          packages.add(new RestartPackage());
          packages.add(new SpeechPackage());
          packages.add(new WxFacepayPackage());
          packages.add(new SocketIoPackage());
          packages.add(new InstallerPackage());
          packages.add(new TcpRelayPackage());
          packages.add(new UdpBroadcastPackage());
          packages.add(new SmilepayPackage());
          packages.add(new AutoClickPackage());
          packages.add(new PrinterPackage());
          packages.add(new VersioncodePackage());
          packages.add(new CodePush(BuildConfig.CODE_PUSH_KEY, MainApplication.this, BuildConfig.DEBUG, BuildConfig.CODE_PUSH_HOST));
          return packages;
        }

        @Override
        protected String getJSMainModuleName() {
          return "index";
        }
      };

  @Override
  public ReactNativeHost getReactNativeHost() {
    return mReactNativeHost;
  }

  @Override
  public void onCreate() {
    super.onCreate();
    // 闪退自动重启
    UncaughtExceptionHandlerImpl.getInstance().init(this.getApplicationContext(), BuildConfig.DEBUG, true, 0, MainActivity.class);
    SoLoader.init(this, /* native exopackage */ false);
    initializeFlipper(this, getReactNativeHost().getReactInstanceManager());
  }

  /**
   * Loads Flipper in React Native templates. Call this in the onCreate method with something like
   * initializeFlipper(this, getReactNativeHost().getReactInstanceManager());
   *
   * @param context
   * @param reactInstanceManager
   */
  private static void initializeFlipper(
      Context context, ReactInstanceManager reactInstanceManager) {
    if (BuildConfig.DEBUG) {
      try {
        /*
         We use reflection here to pick up the class that initializes Flipper,
        since Flipper library is not available in release mode
        */
        Class<?> aClass = Class.forName("com.vsu.fcounter.ReactNativeFlipper");
        aClass
            .getMethod("initializeFlipper", Context.class, ReactInstanceManager.class)
            .invoke(null, context, reactInstanceManager);
      } catch (ClassNotFoundException e) {
        e.printStackTrace();
      } catch (NoSuchMethodException e) {
        e.printStackTrace();
      } catch (IllegalAccessException e) {
        e.printStackTrace();
      } catch (InvocationTargetException e) {
        e.printStackTrace();
      }
    }
  }
}
