/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.zoloz.smile2pay.service;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.text.TextUtils;
import com.alipay.zoloz.smile2pay.camera.CameraPreviewCallback;
import com.alipay.zoloz.smile2pay.camera.ZolozCamera;
import com.alipay.zoloz.smile2pay.logger.Log;
import com.alipay.zoloz.smile2pay.service.ISmile2PayService;
import com.alipay.zoloz.smile2pay.service.ISmile2PayServiceCallback;
import com.alipay.zoloz.smile2pay.service.ZolozCallback;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

public class Zoloz {
    public static final String SMILE2PAY_SERVICE = "com.alipay.zoloz.smile2pay.service.Smile2PayService";
    public static final String SMILE2PAY_PACKAGE = "com.alipay.zoloz.smile";
    public static final int LOCK_WAIT_TIME = 15000;
    public static final int LOOP_TIME = 100;
    private static final String TAG = "zolozTime";
    private ISmile2PayService mISmile2PayService = null;
    private ZolozCallback mZolozVerifyCallback;
    private Activity mActivityContext;
    private Context mContext;
    private Object mLock = new Object();
    private String mMetaInfo = "";
    private Map mSmile2PayMerchantInfo;
    private Handler handler = new Handler(Looper.getMainLooper());
    private final AtomicBoolean mRunning = new AtomicBoolean(false);
    private static String DISCONNECT_ERROR = "Z1070";
    private static String SMILE_APP_ERROR = "Z1071";
    private static String SMILE_SERVICE_ERROR = "Z1072";
    private static String VERIFY_ERROR = "Z1073";
    private static String VERIFY_ERROR2 = "Z1074";
    private static String GET_METAINFO_ERROR = "Z1075";
    private static String GET_METAINFO_ERROR2 = "Z1076";
    private static Map map = new HashMap(){
        {
            this.put(DISCONNECT_ERROR, "\u5237\u8138\u670d\u52a1\u65ad\u5f00\u8fde\u63a5");
            this.put(SMILE_APP_ERROR, "\u8c03\u7528\u5237\u8138app\u51fa\u9519\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u5b89\u88c5\u5237\u8138app");
            this.put(SMILE_SERVICE_ERROR, "\u5237\u8138\u670d\u52a1\u5f02\u5e38");
            this.put(VERIFY_ERROR, "\u8c03\u7528\u5237\u8138\u5f02\u5e38");
            this.put(VERIFY_ERROR2, "\u8c03\u7528\u5237\u8138\u5f02\u5e38\u4e86");
            this.put(GET_METAINFO_ERROR, "\u83b7\u53d6metainfo\u5f02\u5e38");
            this.put(GET_METAINFO_ERROR2, "\u83b7\u53d6metainfo\u5f02\u5e38\u4e86");
        }
    };
    private static Zoloz sInstance;
    private ISmile2PayServiceCallback mISmile2PayServiceCallback = new ISmile2PayServiceCallback.Stub(){

        @Override
        public void smile2PayResponse(Map response) {
            if (Zoloz.this.mZolozVerifyCallback != null) {
                try {
                    Log.e(Zoloz.TAG, "smile2PayResponse is:" + response.get("code"));
                }
                catch (Throwable e) {
                    Log.e(Zoloz.TAG, "smile2PayResponse code is null");
                }
                Zoloz.this.mZolozVerifyCallback.response(response);
                Zoloz.this.mZolozVerifyCallback = null;
            }
            try {
                Log.i(Zoloz.TAG, "zolozRemoveCallback");
                Zoloz.this.mISmile2PayService.zolozRemoveCallback(Zoloz.this.mISmile2PayServiceCallback);
            }
            catch (Throwable e) {
                Log.e(Zoloz.TAG, "zolozRemoveCallback except:" + e);
            }
        }
    };
    private ServiceConnection mServiceConnection = new ServiceConnection(){

        public void onServiceDisconnected(ComponentName name) {
            Log.d(Zoloz.TAG, "onServiceDisconnected");
            Zoloz.this.callback(Zoloz.this.mZolozVerifyCallback, DISCONNECT_ERROR);
            Zoloz.this.mZolozVerifyCallback = null;
            Zoloz.this.mRunning.set(false);
            Zoloz.this.mISmile2PayService = null;
            ZolozCamera.getInstance().unregister();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onServiceConnected(ComponentName name, IBinder service) {
            Zoloz.this.mISmile2PayService = ISmile2PayService.Stub.asInterface(service);
            Log.d(Zoloz.TAG, "onServiceConnected");
            try {
                Zoloz.this.mISmile2PayService.zolozInstall(Zoloz.this.mSmile2PayMerchantInfo);
            }
            catch (Throwable e) {
                Log.e(Zoloz.TAG, "onServiceConnected:" + e);
            }
            Object object = Zoloz.this.mLock;
            synchronized (object) {
                Zoloz.this.mLock.notify();
            }
        }
    };

    public static String getMessage(String code) {
        return String.format("%s(%s)", map.get(code), code);
    }

    private void callback(ZolozCallback callback, String code) {
        if (callback != null) {
            HashMap<String, String> smile2PayResponse = new HashMap<String, String>();
            smile2PayResponse.put("code", code);
            smile2PayResponse.put("subCode", code);
            if (map.containsKey(code)) {
                smile2PayResponse.put("msg", Zoloz.getMessage(code));
            }
            Log.e(TAG, "callback is:" + code);
            callback.response(smile2PayResponse);
            callback = null;
            this.mZolozVerifyCallback = null;
        } else {
            Log.e(TAG, "callback is null");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Zoloz getInstance(Context context) {
        if (null != sInstance) return sInstance;
        Class<Zoloz> clazz = Zoloz.class;
        synchronized (Zoloz.class) {
            if (null != sInstance) return sInstance;
            Zoloz instance = new Zoloz(context);
            Log.i(TAG, "zoloz getInstance");
            sInstance = instance;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return sInstance;
        }
    }

    private Zoloz(Activity context) {
        this.mActivityContext = context;
    }

    private Zoloz(Context context) {
        this.mContext = context.getApplicationContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zolozVerify(final String zimId, final Map params, final ZolozCallback zolozCallback) {
        block9: {
            Log.i(TAG, " zolozVerify");
            if (this.mRunning.get()) {
                this.handler.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        Zoloz.this.zolozVerify(zimId, params, zolozCallback);
                    }
                }, 100L);
                return;
            }
            if (TextUtils.isEmpty((CharSequence)zimId) || zolozCallback == null) {
                Log.e(TAG, "zimId or zolozVerifyCallback is null, fail!");
                this.mRunning.set(false);
                throw new IllegalArgumentException("zimId or zolozVerifyCallback is null");
            }
            this.mZolozVerifyCallback = zolozCallback;
            Log.i(TAG, "zolozVerify begin");
            try {
                if (this.mISmile2PayService == null) {
                    boolean bBindSuccess = this.bindZolozService();
                    if (!bBindSuccess) {
                        Log.e(TAG, "bind service fail!");
                        this.mRunning.set(false);
                        this.callback(zolozCallback, SMILE_APP_ERROR);
                    } else {
                        this.mRunning.set(true);
                        new Thread(new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                try {
                                    Object object = Zoloz.this.mLock;
                                    synchronized (object) {
                                        Zoloz.this.mLock.wait(15000L);
                                    }
                                    if (Zoloz.this.mISmile2PayService != null) {
                                        Log.i(Zoloz.TAG, "zolozAddCallback");
                                        Zoloz.this.mISmile2PayService.zolozAddCallback(Zoloz.this.mISmile2PayServiceCallback);
                                        Zoloz.this.mISmile2PayService.zolozVerify(zimId, params);
                                        Log.i(Zoloz.TAG, "zolozVerify end");
                                    } else {
                                        Zoloz.this.mRunning.set(false);
                                        Zoloz.this.callback(zolozCallback, SMILE_SERVICE_ERROR);
                                    }
                                }
                                catch (Throwable e) {
                                    Log.e(Zoloz.TAG, "zolozVerify fail:" + e);
                                    Zoloz.this.mISmile2PayService = null;
                                    Zoloz.this.mRunning.set(false);
                                    Zoloz.this.callback(zolozCallback, VERIFY_ERROR);
                                }
                                finally {
                                    Zoloz.this.mRunning.set(false);
                                }
                            }
                        }).start();
                    }
                    break block9;
                }
                Log.i(TAG, "zolozAddCallback");
                this.mISmile2PayService.zolozAddCallback(this.mISmile2PayServiceCallback);
                this.mISmile2PayService.zolozVerify(zimId, params);
                Log.i(TAG, "zolozVerify end");
            }
            catch (Throwable e) {
                this.mISmile2PayService = null;
                Log.e(TAG, "zolozVerify fail:" + e);
                this.mRunning.set(false);
                this.callback(zolozCallback, VERIFY_ERROR2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zolozGetMetaInfo(final Map info, final ZolozCallback zolozCallback) {
        block9: {
            Log.i(TAG, " zolozGetMetaInfo");
            if (this.mRunning.get()) {
                this.handler.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        Zoloz.this.zolozGetMetaInfo(info, zolozCallback);
                    }
                }, 100L);
                return;
            }
            if (zolozCallback == null) {
                Log.e(TAG, "zolozCallback is null, fail!");
                this.mRunning.set(false);
                throw new IllegalArgumentException("zolozGetMetaInfo zolozCallback null");
            }
            this.mZolozVerifyCallback = zolozCallback;
            Log.i(TAG, "zolozGetMetaInfo beging");
            try {
                if (this.mISmile2PayService == null) {
                    boolean bBindSuccess = this.bindZolozService();
                    if (!bBindSuccess) {
                        Log.e(TAG, "bind service fail!");
                        this.mRunning.set(false);
                        this.callback(zolozCallback, SMILE_APP_ERROR);
                    } else {
                        this.mRunning.set(true);
                        new Thread(new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                try {
                                    Object object = Zoloz.this.mLock;
                                    synchronized (object) {
                                        Zoloz.this.mLock.wait(15000L);
                                    }
                                    if (Zoloz.this.mISmile2PayService != null) {
                                        Zoloz.this.mMetaInfo = Zoloz.this.mISmile2PayService.zolozGetMetaInfo(info);
                                        HashMap<String, String> smile2PayResponse = new HashMap<String, String>();
                                        smile2PayResponse.put("code", "1000");
                                        smile2PayResponse.put("metainfo", Zoloz.this.mMetaInfo);
                                        zolozCallback.response(smile2PayResponse);
                                        Zoloz.this.mZolozVerifyCallback = null;
                                        Log.i(Zoloz.TAG, "zolozGetMetaInfo end:" + Zoloz.this.mMetaInfo);
                                    } else {
                                        Zoloz.this.mRunning.set(false);
                                        Zoloz.this.callback(zolozCallback, SMILE_SERVICE_ERROR);
                                    }
                                }
                                catch (Throwable e) {
                                    Log.e(Zoloz.TAG, "zolozGetMetaInfo fail:" + e);
                                    Zoloz.this.mISmile2PayService = null;
                                    Zoloz.this.mRunning.set(false);
                                    Zoloz.this.callback(zolozCallback, GET_METAINFO_ERROR);
                                }
                                finally {
                                    Zoloz.this.mRunning.set(false);
                                }
                            }
                        }).start();
                    }
                    break block9;
                }
                this.mMetaInfo = this.mISmile2PayService.zolozGetMetaInfo(info);
                HashMap<String, String> smile2PayResponse = new HashMap<String, String>();
                smile2PayResponse.put("code", "1000");
                smile2PayResponse.put("metainfo", this.mMetaInfo);
                zolozCallback.response(smile2PayResponse);
                Log.i(TAG, "zolozGetMetaInfo end:" + this.mMetaInfo);
            }
            catch (Throwable e) {
                Log.e(TAG, "zolozGetMetaInfo fail:" + e);
                this.mISmile2PayService = null;
                this.mRunning.set(false);
                this.callback(zolozCallback, GET_METAINFO_ERROR2);
            }
        }
    }

    public void zolozGetMetaInfo(final ZolozCallback zolozCallback) {
        block8: {
            if (this.mRunning.get()) {
                this.handler.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        Zoloz.this.zolozGetMetaInfo(zolozCallback);
                    }
                }, 100L);
                return;
            }
            if (zolozCallback == null) {
                Log.e(TAG, "zolozCallback is null, fail!");
                this.mRunning.set(false);
                return;
            }
            Log.i(TAG, "zolozGetMetaInfo");
            try {
                if (this.mISmile2PayService == null) {
                    boolean bBindSuccess = this.bindZolozService();
                    if (!bBindSuccess) {
                        Log.e(TAG, "bind service fail!");
                        this.mRunning.set(false);
                        return;
                    }
                    this.mRunning.set(true);
                    new Thread(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            try {
                                Object object = Zoloz.this.mLock;
                                synchronized (object) {
                                    Zoloz.this.mLock.wait(15000L);
                                }
                                if (Zoloz.this.mISmile2PayService != null) {
                                    Zoloz.this.mMetaInfo = Zoloz.this.mISmile2PayService.zolozGetMeta();
                                    HashMap<String, String> smile2PayResponse = new HashMap<String, String>();
                                    smile2PayResponse.put("code", "1000");
                                    smile2PayResponse.put("metainfo", Zoloz.this.mMetaInfo);
                                    zolozCallback.response(smile2PayResponse);
                                    Log.i(Zoloz.TAG, "zolozGetMetaInfo end");
                                }
                            }
                            catch (Throwable e) {
                                Zoloz.this.mISmile2PayService = null;
                                Log.e(Zoloz.TAG, "zolozGetMetaInfo fail:" + e);
                            }
                            finally {
                                Zoloz.this.mRunning.set(false);
                            }
                        }
                    }).start();
                    break block8;
                }
                this.mMetaInfo = this.mISmile2PayService.zolozGetMeta();
                HashMap<String, String> smile2PayResponse = new HashMap<String, String>();
                smile2PayResponse.put("code", "1000");
                smile2PayResponse.put("metainfo", this.mMetaInfo);
                zolozCallback.response(smile2PayResponse);
                Log.i(TAG, "zolozGetMetaInfo end");
            }
            catch (Throwable e) {
                this.mISmile2PayService = null;
                this.mRunning.set(false);
                Log.e(TAG, "zolozGetMetaInfo fail:" + e);
            }
        }
    }

    public void zolozInstall(final Map info) {
        if (this.mRunning.get()) {
            this.handler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    Zoloz.this.zolozInstall(info);
                }
            }, 100L);
            return;
        }
        Log.i(TAG, "zolozInstall being");
        this.mSmile2PayMerchantInfo = info;
        try {
            if (this.mISmile2PayService == null) {
                boolean bBindSuccess = this.bindZolozService();
                if (!bBindSuccess) {
                    Log.e(TAG, "bind service fail!");
                    return;
                }
                this.mRunning.set(true);
                new Thread(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            Object object = Zoloz.this.mLock;
                            synchronized (object) {
                                Zoloz.this.mLock.wait(15000L);
                            }
                            Log.i(Zoloz.TAG, "zolozInstall end");
                        }
                        catch (Throwable e) {
                            Zoloz.this.mISmile2PayService = null;
                            Log.e(Zoloz.TAG, "zolozInstall fail:" + e);
                        }
                        finally {
                            Zoloz.this.mRunning.set(false);
                        }
                    }
                }).start();
            } else {
                Log.i(TAG, "zolozInstall end");
            }
        }
        catch (Throwable e) {
            this.mISmile2PayService = null;
            this.mRunning.set(false);
            Log.e(TAG, "zolozInstall fail:" + e);
        }
    }

    public boolean zolozInstall(final Map info, String flag) {
        Log.i(TAG, "zolozInstall");
        if (this.mRunning.get()) {
            this.handler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    Zoloz.this.zolozInstall(info);
                }
            }, 100L);
            return true;
        }
        Log.i(TAG, "zolozInstall begin");
        this.mSmile2PayMerchantInfo = info;
        try {
            if (this.mISmile2PayService == null) {
                boolean bBindSuccess = this.bindZolozService();
                if (!bBindSuccess) {
                    Log.e(TAG, "bind service fail!");
                    return false;
                }
                this.mRunning.set(true);
                new Thread(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            Object object = Zoloz.this.mLock;
                            synchronized (object) {
                                Zoloz.this.mLock.wait(15000L);
                            }
                            if (Zoloz.this.mISmile2PayService != null) {
                                Zoloz.this.mISmile2PayService.zolozInstall(info);
                            }
                            Log.i(Zoloz.TAG, "zolozInstall end");
                        }
                        catch (Throwable e) {
                            Zoloz.this.mISmile2PayService = null;
                            Log.e(Zoloz.TAG, "zolozInstall fail:" + e);
                        }
                        finally {
                            Zoloz.this.mRunning.set(false);
                        }
                    }
                }).start();
            } else {
                Log.i(TAG, "zolozInstall end");
            }
        }
        catch (Throwable e) {
            this.mISmile2PayService = null;
            this.mRunning.set(false);
            Log.e(TAG, "zolozInstall fail:" + e);
        }
        return true;
    }

    public void zolozUninstall() {
    }

    boolean bindZolozService() {
        Intent intent = new Intent();
        intent.setAction(SMILE2PAY_SERVICE);
        intent.setPackage(SMILE2PAY_PACKAGE);
        boolean ret = false;
        if (this.mContext != null) {
            ret = this.mContext.bindService(intent, this.mServiceConnection, 1);
        } else if (this.mActivityContext != null) {
            ret = this.mActivityContext.getApplicationContext().bindService(intent, this.mServiceConnection, 1);
        }
        Log.i(TAG, "bindZolozService:" + ret);
        return ret;
    }

    public void zolozSendKeyboardInfo(final Map info) {
        block8: {
            Log.i(TAG, "zolozSendKeyboardInfo!");
            if (this.mRunning.get()) {
                this.handler.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        Zoloz.this.zolozSendKeyboardInfo(info);
                    }
                }, 100L);
                return;
            }
            if (info == null) {
                Log.e(TAG, "info is null, fail!");
                this.mRunning.set(false);
                return;
            }
            Log.i(TAG, "zolozSendKeyboardInfo begin!");
            try {
                if (this.mISmile2PayService == null) {
                    boolean bBindSuccess = this.bindZolozService();
                    if (!bBindSuccess) {
                        Log.e(TAG, "bind service fail!");
                        this.mRunning.set(false);
                        return;
                    }
                    this.mRunning.set(true);
                    new Thread(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            try {
                                Object object = Zoloz.this.mLock;
                                synchronized (object) {
                                    Zoloz.this.mLock.wait(15000L);
                                }
                                if (Zoloz.this.mISmile2PayService != null) {
                                    Zoloz.this.mISmile2PayService.zolozSendKeyboardInfo(info);
                                    Log.i(Zoloz.TAG, "zolozSendKeyboardInfo end");
                                }
                            }
                            catch (Throwable e) {
                                Zoloz.this.mISmile2PayService = null;
                                Log.e(Zoloz.TAG, "zolozSendKeyboardInfo fail:" + e);
                            }
                            finally {
                                Zoloz.this.mRunning.set(false);
                            }
                        }
                    }).start();
                    break block8;
                }
                this.mISmile2PayService.zolozSendKeyboardInfo(info);
                Log.i(TAG, "zolozSendKeyboardInfo end");
            }
            catch (Throwable e) {
                this.mISmile2PayService = null;
                this.mRunning.set(false);
                Log.e(TAG, "zolozSendKeyboardInfo fail:" + e);
            }
        }
    }

    public void register(final CameraPreviewCallback cameraPreviewCallback) {
        if (this.mRunning.get()) {
            this.handler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    Zoloz.this.register(cameraPreviewCallback);
                }
            }, 100L);
        } else {
            try {
                if (this.mISmile2PayService == null) {
                    boolean bBindSuccess = this.bindZolozService();
                    if (!bBindSuccess) {
                        Log.e(TAG, "bind service fail!");
                    } else {
                        this.mRunning.set(true);
                        new Thread(new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                try {
                                    Object object = Zoloz.this.mLock;
                                    synchronized (object) {
                                        Zoloz.this.mLock.wait(15000L);
                                    }
                                    ZolozCamera.getInstance().register(Zoloz.this.mISmile2PayService, cameraPreviewCallback);
                                    Log.i(Zoloz.TAG, "register CameraPreviewCallback end");
                                }
                                catch (Throwable e) {
                                    Log.e(Zoloz.TAG, "register CameraPreviewCallback fail:", e);
                                }
                                finally {
                                    Zoloz.this.mRunning.set(false);
                                }
                            }
                        }).start();
                    }
                } else {
                    ZolozCamera.getInstance().register(this.mISmile2PayService, cameraPreviewCallback);
                    Log.i(TAG, "register CameraPreviewCallback end");
                }
            }
            catch (Throwable e) {
                this.mRunning.set(false);
                Log.e(TAG, "register CameraPreviewCallback fail:", e);
            }
        }
    }

    public void unregister(CameraPreviewCallback cameraPreviewCallback) {
        ZolozCamera.getInstance().unregister(cameraPreviewCallback);
    }
}

