/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.zoloz.smile2pay.logger;

import android.util.Log;

public abstract class Logger {
    public static final int VERBOSE = 2;
    public static final int DEBUG = 3;
    public static final int INFO = 4;
    public static final int WARN = 5;
    public static final int ERROR = 6;
    public static final int ASSERT = 7;
    private int LOG_LEVEL = 2;

    public void setLogLevel(int level) {
        if (level < 2 || level > 7) {
            throw new RuntimeException("The level value should between [2 , 7]");
        }
        this.LOG_LEVEL = level;
    }

    public abstract int verbose(String var1, String var2);

    public int v(String tag, String msg) {
        if (this.LOG_LEVEL <= 2) {
            return this.verbose(tag, msg);
        }
        return -1;
    }

    public int v(String tag, String msg, Throwable tr) {
        if (this.LOG_LEVEL <= 2) {
            return this.verbose(tag, msg + '\n' + Log.getStackTraceString((Throwable)tr));
        }
        return -1;
    }

    public int v(String tag, Throwable tr) {
        if (this.LOG_LEVEL <= 2) {
            return this.verbose(tag, Log.getStackTraceString((Throwable)tr));
        }
        return -1;
    }

    public abstract int debug(String var1, String var2);

    public int d(String tag, String msg) {
        if (this.LOG_LEVEL <= 3) {
            return this.debug(tag, msg);
        }
        return -1;
    }

    public int d(String tag, String msg, Throwable tr) {
        if (this.LOG_LEVEL <= 3) {
            return this.debug(tag, msg + '\n' + Log.getStackTraceString((Throwable)tr));
        }
        return -1;
    }

    public int d(String tag, Throwable tr) {
        if (this.LOG_LEVEL <= 3) {
            return this.debug(tag, Log.getStackTraceString((Throwable)tr));
        }
        return -1;
    }

    public abstract int info(String var1, String var2);

    public int i(String tag, String msg) {
        if (this.LOG_LEVEL <= 4) {
            return this.info(tag, msg);
        }
        return -1;
    }

    public int i(String tag, String msg, Throwable tr) {
        if (this.LOG_LEVEL <= 4) {
            return this.info(tag, msg + '\n' + Log.getStackTraceString((Throwable)tr));
        }
        return -1;
    }

    public int i(String tag, Throwable tr) {
        if (this.LOG_LEVEL <= 4) {
            return this.info(tag, Log.getStackTraceString((Throwable)tr));
        }
        return -1;
    }

    public abstract int warn(String var1, String var2);

    public int w(String tag, String msg) {
        if (this.LOG_LEVEL <= 5) {
            return this.warn(tag, msg);
        }
        return -1;
    }

    public int w(String tag, String msg, Throwable tr) {
        if (this.LOG_LEVEL <= 5) {
            return this.warn(tag, msg + '\n' + Log.getStackTraceString((Throwable)tr));
        }
        return -1;
    }

    public int w(String tag, Throwable tr) {
        if (this.LOG_LEVEL <= 5) {
            return this.warn(tag, Log.getStackTraceString((Throwable)tr));
        }
        return -1;
    }

    public abstract int error(String var1, String var2);

    public int e(String tag, String msg) {
        if (this.LOG_LEVEL <= 6) {
            return this.error(tag, msg);
        }
        return -1;
    }

    public int e(String tag, String msg, Throwable tr) {
        if (this.LOG_LEVEL <= 6) {
            return this.error(tag, msg + '\n' + Log.getStackTraceString((Throwable)tr));
        }
        return -1;
    }

    public int e(String tag, Throwable tr) {
        if (this.LOG_LEVEL <= 6) {
            return this.error(tag, Log.getStackTraceString((Throwable)tr));
        }
        return -1;
    }
}

