/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.zoloz.smile2pay.logger;

import com.alipay.zoloz.smile2pay.logger.Logger;

public final class Log {
    private static final String TAG = "Zoloz";
    private static final String TAG_PREFIX = "Zoloz_";
    private static Logger sTargetLogger = new AndroidLogger();

    private Log() {
    }

    public static void setLogger(Logger logger) {
        sTargetLogger = logger;
    }

    public static void v(String msg) {
        sTargetLogger.v(TAG, msg);
    }

    public static void v(String tag, String msg) {
        sTargetLogger.v(TAG_PREFIX + tag, msg);
    }

    public static void d(String msg) {
        sTargetLogger.d(TAG, msg);
    }

    public static void d(String tag, String msg) {
        sTargetLogger.d(TAG_PREFIX + tag, msg);
    }

    public static void i(String msg) {
        sTargetLogger.i(TAG, msg);
    }

    public static void i(String tag, String msg) {
        sTargetLogger.i(TAG_PREFIX + tag, msg);
    }

    public static void w(String msg) {
        sTargetLogger.w(TAG, msg);
    }

    public static void w(String tag, String msg) {
        sTargetLogger.w(TAG_PREFIX + tag, msg);
    }

    public static void w(Throwable e) {
        sTargetLogger.w(TAG, e);
    }

    public static void w(String tag, Throwable e) {
        sTargetLogger.w(TAG_PREFIX + tag, e);
    }

    public static void w(String tag, String msg, Throwable e) {
        sTargetLogger.w(TAG_PREFIX + tag, msg, e);
    }

    public static void e(String msg) {
        sTargetLogger.e(TAG, msg);
    }

    public static void e(String tag, String msg) {
        sTargetLogger.e(TAG_PREFIX + tag, msg);
    }

    public static void e(Throwable e) {
        sTargetLogger.e(TAG, e);
    }

    public static void e(String tag, Throwable e) {
        sTargetLogger.e(TAG_PREFIX + tag, e);
    }

    public static void e(String tag, String msg, Throwable e) {
        sTargetLogger.e(TAG_PREFIX + tag, msg, e);
    }

    private static final class AndroidLogger
    extends Logger {
        private AndroidLogger() {
        }

        @Override
        public int verbose(String tag, String msg) {
            return android.util.Log.v((String)tag, (String)("[" + Thread.currentThread().getName() + "]: " + msg));
        }

        @Override
        public int debug(String tag, String msg) {
            return android.util.Log.d((String)tag, (String)("[" + Thread.currentThread().getName() + "]: " + msg));
        }

        @Override
        public int info(String tag, String msg) {
            return android.util.Log.i((String)tag, (String)("[" + Thread.currentThread().getName() + "]: " + msg));
        }

        @Override
        public int warn(String tag, String msg) {
            return android.util.Log.w((String)tag, (String)("[" + Thread.currentThread().getName() + "]: " + msg));
        }

        @Override
        public int error(String tag, String msg) {
            return android.util.Log.e((String)tag, (String)("[" + Thread.currentThread().getName() + "]: " + msg));
        }
    }
}

