/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.zoloz.smile2pay.camera;

import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.MemoryFile;
import android.os.ParcelFileDescriptor;
import android.system.OsConstants;
import com.alipay.zoloz.smile2pay.camera.CameraParams;
import com.alipay.zoloz.smile2pay.camera.CameraPreviewCallback;
import com.alipay.zoloz.smile2pay.camera.MemoryFileHelper;
import com.alipay.zoloz.smile2pay.logger.Log;
import com.alipay.zoloz.smile2pay.service.ISmile2PayService;
import java.io.InputStream;
import java.io.OutputStream;

public class ZolozCamera {
    private static final String TAG = "Camera";
    public static final int STATUS_INVALID = -1;
    public static final int STATUS_IDLE = 0;
    public static final int STATUS_WRITTEN = 1;
    public static final int STATUS_WRITING = 2;
    public static final int STATUS_READING = 3;
    private static final int PROT_READ = Build.VERSION.SDK_INT >= 21 ? OsConstants.PROT_READ : 1;
    private static final int PROT_WRITE = Build.VERSION.SDK_INT >= 21 ? OsConstants.PROT_WRITE : 2;
    private ISmile2PayService mSmile2PayService;
    private CameraPreviewCallback mPreviewCallback;
    private HandlerThread mWorkerThread;
    private Handler mWorkerThreadHandler;
    private MemoryFile mMemoryFile;
    private PreviewRunnable mPreviewRunnable = new PreviewRunnable();
    private static ZolozCamera sInstance = new ZolozCamera();

    private ZolozCamera() {
    }

    public static synchronized ZolozCamera getInstance() {
        return sInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(ISmile2PayService smile2PayService, CameraPreviewCallback previewCallback) {
        Log.d(TAG, this.getClass().getSimpleName() + ".register() : smile2PayService=" + smile2PayService + ", previewCallback=" + previewCallback);
        if (null == previewCallback) {
            return;
        }
        Class<ZolozCamera> clazz = ZolozCamera.class;
        synchronized (ZolozCamera.class) {
            if (null != this.mPreviewCallback) {
                previewCallback.error(-1, "null != mPreviewCallback", null);
            } else if (null == smile2PayService) {
                previewCallback.error(-2, "null == smile2PayService", null);
            } else {
                this.mSmile2PayService = smile2PayService;
                this.mPreviewCallback = previewCallback;
                int length = 0;
                CameraParams cameraParams = new CameraParams();
                try {
                    smile2PayService.initCamera(cameraParams);
                    Log.d(TAG, "cameraParams=" + cameraParams);
                    this.mPreviewCallback.cameraInit(cameraParams, null);
                    length = ZolozCamera.length(cameraParams.getWidth(), cameraParams.getHeight(), cameraParams.getFrameFormat());
                    Log.d(TAG, "length=" + length);
                    this.mPreviewCallback.mByteBuffer = new byte[length];
                    ParcelFileDescriptor pfd = cameraParams.getParcelFileDescriptor();
                    this.mMemoryFile = MemoryFileHelper.openMemoryFile(pfd, length + 1, PROT_WRITE | PROT_READ);
                }
                catch (Throwable e) {
                    Log.w(TAG, e);
                    previewCallback.error(-2, android.util.Log.getStackTraceString((Throwable)e), null);
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return;
                }
                this.mWorkerThread = new HandlerThread("zoloz_ashmem_camera");
                this.mWorkerThread.setDaemon(true);
                this.mWorkerThread.setPriority(10);
                this.mWorkerThread.start();
                this.mWorkerThreadHandler = new Handler(this.mWorkerThread.getLooper());
                this.mWorkerThreadHandler.post((Runnable)this.mPreviewRunnable);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    private static int length(int width, int height, int frameMode) {
        int length = -1;
        switch (frameMode) {
            case 0: {
                length = width * height * 3 / 2;
                break;
            }
            case 4: {
                length = width * height * 3;
                break;
            }
            case 3: {
                length = width * height * 4;
                break;
            }
            case 2: {
                break;
            }
            case 1: {
                break;
            }
        }
        return length;
    }

    public void unregister() {
        Log.d(TAG, this.getClass().getSimpleName() + ".unregister()");
        if (null != this.mPreviewCallback) {
            this.unregister(this.mPreviewCallback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(CameraPreviewCallback previewCallback) {
        Log.d(TAG, this.getClass().getSimpleName() + ".unregister() : previewCallback=" + previewCallback);
        if (null == previewCallback) {
            return;
        }
        Class<ZolozCamera> clazz = ZolozCamera.class;
        synchronized (ZolozCamera.class) {
            if (null == this.mPreviewCallback) {
                Log.w(TAG, "IllegalState : null == mPreviewCallback, already unregister before ???");
            } else if (this.mPreviewCallback == previewCallback) {
                try {
                    this.mSmile2PayService.releaseCamera();
                }
                catch (Throwable e) {
                    Log.w(TAG, e);
                    previewCallback.error(-3, android.util.Log.getStackTraceString((Throwable)e), null);
                }
                finally {
                    if (null != this.mWorkerThreadHandler) {
                        this.mWorkerThreadHandler.removeCallbacks((Runnable)this.mPreviewRunnable);
                        this.mWorkerThreadHandler = null;
                    }
                    if (null != this.mWorkerThread) {
                        if (Build.VERSION.SDK_INT >= 18) {
                            this.mWorkerThread.quitSafely();
                        } else {
                            this.mWorkerThread.quit();
                        }
                        Log.d(TAG, "mWorkerThread.quitSafely()");
                        this.mWorkerThread = null;
                    }
                    if (null != this.mPreviewCallback) {
                        this.mPreviewCallback.mByteBuffer = null;
                        this.mPreviewCallback.cameraRelease(null);
                        this.mPreviewCallback = null;
                    }
                    this.mSmile2PayService = null;
                }
            } else {
                previewCallback.error(-1, android.util.Log.getStackTraceString((Throwable)new RuntimeException("mPreviewCallback != previewCallback")), null);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public static String status(int status) {
        switch (status) {
            case 0: {
                return "STATUS_IDLE";
            }
            case 3: {
                return "STATUS_READING";
            }
            case 2: {
                return "STATUS_WRITING";
            }
            case 1: {
                return "STATUS_WRITTEN";
            }
        }
        return "STATUS_INVALID";
    }

    class PreviewRunnable
    implements Runnable {
        static final int DELAY_MILLIS = 20;

        PreviewRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block58: {
                if (null == ZolozCamera.this.mMemoryFile) break block58;
                int status = -1;
                InputStream is = null;
                try {
                    is = ZolozCamera.this.mMemoryFile.getInputStream();
                    status = is.read();
                }
                catch (Throwable e) {
                    Log.w(ZolozCamera.TAG, e);
                }
                finally {
                    if (null != is) {
                        try {
                            is.close();
                        }
                        catch (Throwable e) {
                            Log.w(ZolozCamera.TAG, e);
                        }
                    }
                }
                switch (status) {
                    case 1: {
                        OutputStream os = null;
                        try {
                            os = ZolozCamera.this.mMemoryFile.getOutputStream();
                            os.write(3);
                            os.flush();
                        }
                        catch (Throwable e) {
                            Log.w(ZolozCamera.TAG, e);
                        }
                        finally {
                            if (null != os) {
                                try {
                                    os.close();
                                }
                                catch (Throwable e) {
                                    Log.w(ZolozCamera.TAG, e);
                                }
                            }
                        }
                        boolean callback = true;
                        int count = 0;
                        try {
                            is = ZolozCamera.this.mMemoryFile.getInputStream();
                            status = is.read();
                            if (null == ZolozCamera.this.mPreviewCallback) {
                                Log.w(ZolozCamera.TAG, "IllegalState: null == mPreviewCallback");
                            } else if (3 == status) {
                                count = is.read(((ZolozCamera)ZolozCamera.this).mPreviewCallback.mByteBuffer, 0, ((ZolozCamera)ZolozCamera.this).mPreviewCallback.mByteBuffer.length);
                            } else {
                                callback = false;
                                Log.i(ZolozCamera.TAG, "read: status == " + ZolozCamera.status(status) + ", callback=false, count=0");
                            }
                        }
                        catch (Throwable e) {
                            Log.w(ZolozCamera.TAG, e);
                        }
                        finally {
                            if (null != is) {
                                try {
                                    is.close();
                                }
                                catch (Throwable e) {
                                    Log.w(ZolozCamera.TAG, e);
                                }
                            }
                        }
                        if (!callback) break;
                        try {
                            os = ZolozCamera.this.mMemoryFile.getOutputStream();
                            os.write(0);
                            os.flush();
                        }
                        catch (Throwable e) {
                            Log.w(ZolozCamera.TAG, e);
                        }
                        finally {
                            if (null != os) {
                                try {
                                    os.close();
                                }
                                catch (Throwable e) {
                                    Log.w(ZolozCamera.TAG, e);
                                }
                            }
                        }
                        if (null == ZolozCamera.this.mPreviewCallback) break;
                        if (count > 0) {
                            ZolozCamera.this.mPreviewCallback.previewFrame(((ZolozCamera)ZolozCamera.this).mPreviewCallback.mByteBuffer);
                            break;
                        }
                        ZolozCamera.this.mPreviewCallback.error(-4, "read camera data count = " + count, null);
                        break;
                    }
                }
            }
            if (null != ZolozCamera.this.mWorkerThreadHandler) {
                ZolozCamera.this.mWorkerThreadHandler.postDelayed((Runnable)this, 20L);
            }
        }
    }
}

