/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.zoloz.smile2pay.camera;

import android.os.MemoryFile;
import android.os.ParcelFileDescriptor;
import com.alipay.zoloz.smile2pay.camera.ReflectUtil;
import com.alipay.zoloz.smile2pay.logger.Log;
import java.io.FileDescriptor;
import java.io.IOException;
import java.lang.reflect.Method;

public class MemoryFileHelper {
    private static final String TAG = "Ashmen";

    public static MemoryFile createMemoryFile(String name, int length) {
        try {
            return new MemoryFile(name, length);
        }
        catch (IOException e) {
            Log.w(TAG, e);
            return null;
        }
    }

    public static MemoryFile openMemoryFile(ParcelFileDescriptor pfd, int length, int mode) {
        if (pfd == null) {
            throw new IllegalArgumentException("ParcelFileDescriptor \u4e0d\u80fd\u4e3a\u7a7a");
        }
        FileDescriptor fd = pfd.getFileDescriptor();
        return MemoryFileHelper.openMemoryFile(fd, length, mode);
    }

    public static MemoryFile openMemoryFile(FileDescriptor fd, int length, int mode) {
        MemoryFile memoryFile = null;
        try {
            memoryFile = new MemoryFile("tem", 1);
            memoryFile.close();
            Class<MemoryFile> c = MemoryFile.class;
            Method native_mmap = null;
            Method[] ms = c.getDeclaredMethods();
            for (int i = 0; ms != null && i < ms.length; ++i) {
                if (!ms[i].getName().equals("native_mmap")) continue;
                native_mmap = ms[i];
            }
            ReflectUtil.setField("android.os.MemoryFile", memoryFile, "mFD", fd);
            ReflectUtil.setField("android.os.MemoryFile", memoryFile, "mLength", length);
            long address = (Long)ReflectUtil.invokeMethod(null, native_mmap, fd, length, mode);
            ReflectUtil.setField("android.os.MemoryFile", memoryFile, "mAddress", address);
        }
        catch (Exception e) {
            Log.w(TAG, e);
        }
        return memoryFile;
    }

    public static ParcelFileDescriptor getParcelFileDescriptor(MemoryFile memoryFile) {
        if (memoryFile == null) {
            throw new IllegalArgumentException("memoryFile \u4e0d\u80fd\u4e3a\u7a7a");
        }
        FileDescriptor fd = MemoryFileHelper.getFileDescriptor(memoryFile);
        ParcelFileDescriptor pfd = (ParcelFileDescriptor)ReflectUtil.getInstance("android.os.ParcelFileDescriptor", fd);
        return pfd;
    }

    public static FileDescriptor getFileDescriptor(MemoryFile memoryFile) {
        if (memoryFile == null) {
            throw new IllegalArgumentException("memoryFile \u4e0d\u80fd\u4e3a\u7a7a");
        }
        FileDescriptor fd = (FileDescriptor)ReflectUtil.invoke("android.os.MemoryFile", memoryFile, "getFileDescriptor", new Object[0]);
        return fd;
    }
}

