/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.zoloz.smile2pay.camera;

import com.alipay.zoloz.smile2pay.camera.CameraParams;
import com.alipay.zoloz.smile2pay.logger.Log;
import java.util.Map;

public abstract class CameraPreviewCallback {
    byte[] mByteBuffer;
    private static final String TAG = "CameraPreview";
    public static final int ERROR_CODE_EXCLUSIVE = -1;
    public static final int ERROR_CODE_CAMERA_INIT = -2;
    public static final int ERROR_CODE_CAMERA_RELEASE = -3;
    public static final int ERROR_CODE_CAMERA_DATA = -4;

    void cameraInit(CameraParams cameraParams, Map<String, Object> params) {
        Log.d(TAG, this.getClass().getSimpleName() + ".cameraInit() cameraParams=" + cameraParams + ",params=" + params);
        try {
            this.onCameraInit(cameraParams, params);
        }
        catch (Throwable e) {
            Log.w(TAG, e);
        }
    }

    public abstract void onCameraInit(CameraParams var1, Map<String, Object> var2);

    void previewFrame(byte[] data) {
        int length = null == data ? 0 : data.length;
        Log.d(TAG, this.getClass().getSimpleName() + ".previewFrame(date[" + length + "])");
        try {
            this.onPreviewFrame(data);
        }
        catch (Throwable e) {
            Log.w(TAG, e);
        }
    }

    public abstract void onPreviewFrame(byte[] var1);

    void cameraRelease(Map<String, Object> params) {
        Log.d(TAG, this.getClass().getSimpleName() + ".cameraRelease() params=" + params);
        try {
            this.onCameraRelease(params);
        }
        catch (Throwable e) {
            Log.w(TAG, e);
        }
    }

    public abstract void onCameraRelease(Map<String, Object> var1);

    public final void error(int code, String msg, Map<String, Object> params) {
        Log.w(TAG, this.getClass().getSimpleName() + ".error(code=" + code + ", msg=" + msg + ") params=" + params);
        try {
            this.onError(code, msg, params);
        }
        catch (Throwable e) {
            Log.w(TAG, e);
        }
    }

    public abstract void onError(int var1, String var2, Map<String, Object> var3);
}

