/*
 * Decompiled with CFR 0.152.
 */
package com.printer.sdk.zxing.qrcode.decoder;

import com.printer.sdk.zxing.ChecksumException;
import com.printer.sdk.zxing.DecodeHintType;
import com.printer.sdk.zxing.FormatException;
import com.printer.sdk.zxing.common.BitMatrix;
import com.printer.sdk.zxing.common.DecoderResult;
import com.printer.sdk.zxing.common.reedsolomon.GenericGF;
import com.printer.sdk.zxing.common.reedsolomon.ReedSolomonDecoder;
import com.printer.sdk.zxing.common.reedsolomon.ReedSolomonException;
import com.printer.sdk.zxing.qrcode.decoder.BitMatrixParser;
import com.printer.sdk.zxing.qrcode.decoder.DataBlock;
import com.printer.sdk.zxing.qrcode.decoder.DecodedBitStreamParser;
import com.printer.sdk.zxing.qrcode.decoder.ErrorCorrectionLevel;
import com.printer.sdk.zxing.qrcode.decoder.QRCodeDecoderMetaData;
import com.printer.sdk.zxing.qrcode.decoder.Version;
import java.util.Map;

public final class Decoder {
    private final ReedSolomonDecoder rsDecoder = new ReedSolomonDecoder(GenericGF.QR_CODE_FIELD_256);

    public DecoderResult decode(boolean[][] image) throws ChecksumException, FormatException {
        return this.decode(image, null);
    }

    public DecoderResult decode(boolean[][] image, Map<DecodeHintType, ?> hints) throws ChecksumException, FormatException {
        return this.decode(BitMatrix.parse(image), hints);
    }

    public DecoderResult decode(BitMatrix bits) throws ChecksumException, FormatException {
        return this.decode(bits, null);
    }

    public DecoderResult decode(BitMatrix bits, Map<DecodeHintType, ?> hints) throws FormatException, ChecksumException {
        BitMatrixParser parser = new BitMatrixParser(bits);
        FormatException fe = null;
        ChecksumException ce = null;
        try {
            return this.decode(parser, hints);
        }
        catch (FormatException e) {
            fe = e;
        }
        catch (ChecksumException e) {
            ce = e;
        }
        try {
            parser.remask();
            parser.setMirror(true);
            parser.readVersion();
            parser.readFormatInformation();
            parser.mirror();
            DecoderResult result = this.decode(parser, hints);
            result.setOther(new QRCodeDecoderMetaData(true));
            return result;
        }
        catch (ChecksumException | FormatException e) {
            if (fe != null) {
                throw fe;
            }
            throw ce;
        }
    }

    private DecoderResult decode(BitMatrixParser parser, Map<DecodeHintType, ?> hints) throws FormatException, ChecksumException {
        Version version = parser.readVersion();
        ErrorCorrectionLevel ecLevel = parser.readFormatInformation().getErrorCorrectionLevel();
        byte[] codewords = parser.readCodewords();
        DataBlock[] dataBlocks = DataBlock.getDataBlocks(codewords, version, ecLevel);
        int totalBytes = 0;
        for (DataBlock dataBlock : dataBlocks) {
            totalBytes += dataBlock.getNumDataCodewords();
        }
        byte[] resultBytes = new byte[totalBytes];
        int resultOffset = 0;
        for (DataBlock dataBlock : dataBlocks) {
            byte[] codewordBytes = dataBlock.getCodewords();
            int numDataCodewords = dataBlock.getNumDataCodewords();
            this.correctErrors(codewordBytes, numDataCodewords);
            for (int i = 0; i < numDataCodewords; ++i) {
                resultBytes[resultOffset++] = codewordBytes[i];
            }
        }
        return DecodedBitStreamParser.decode(resultBytes, version, ecLevel, hints);
    }

    private void correctErrors(byte[] codewordBytes, int numDataCodewords) throws ChecksumException {
        int i;
        int numCodewords = codewordBytes.length;
        int[] codewordsInts = new int[numCodewords];
        for (i = 0; i < numCodewords; ++i) {
            codewordsInts[i] = codewordBytes[i] & 0xFF;
        }
        try {
            this.rsDecoder.decode(codewordsInts, codewordBytes.length - numDataCodewords);
        }
        catch (ReedSolomonException ignored) {
            throw ChecksumException.getChecksumInstance();
        }
        for (i = 0; i < numDataCodewords; ++i) {
            codewordBytes[i] = (byte)codewordsInts[i];
        }
    }
}

