/*
 * Decompiled with CFR 0.152.
 */
package com.printer.sdk.zxing.pdf417;

import com.printer.sdk.zxing.BarcodeFormat;
import com.printer.sdk.zxing.EncodeHintType;
import com.printer.sdk.zxing.Writer;
import com.printer.sdk.zxing.WriterException;
import com.printer.sdk.zxing.common.BitMatrix;
import com.printer.sdk.zxing.pdf417.encoder.Compaction;
import com.printer.sdk.zxing.pdf417.encoder.Dimensions;
import com.printer.sdk.zxing.pdf417.encoder.PDF417;
import java.nio.charset.Charset;
import java.util.Map;

public final class PDF417Writer
implements Writer {
    private static final int WHITE_SPACE = 30;
    private static final int DEFAULT_ERROR_CORRECTION_LEVEL = 2;

    @Override
    public BitMatrix encode(String contents, BarcodeFormat format, int width, int height, Map<EncodeHintType, ?> hints) throws WriterException {
        if (format != BarcodeFormat.PDF_417) {
            throw new IllegalArgumentException("Can only encode PDF_417, but got " + (Object)((Object)format));
        }
        PDF417 encoder = new PDF417();
        int margin = 30;
        int errorCorrectionLevel = 2;
        if (hints != null) {
            if (hints.containsKey((Object)EncodeHintType.PDF417_COMPACT)) {
                encoder.setCompact(Boolean.valueOf(hints.get((Object)EncodeHintType.PDF417_COMPACT).toString()));
            }
            if (hints.containsKey((Object)EncodeHintType.PDF417_COMPACTION)) {
                encoder.setCompaction(Compaction.valueOf(hints.get((Object)EncodeHintType.PDF417_COMPACTION).toString()));
            }
            if (hints.containsKey((Object)EncodeHintType.PDF417_DIMENSIONS)) {
                Dimensions dimensions = (Dimensions)hints.get((Object)EncodeHintType.PDF417_DIMENSIONS);
                encoder.setDimensions(dimensions.getMaxCols(), dimensions.getMinCols(), dimensions.getMaxRows(), dimensions.getMinRows());
            }
            if (hints.containsKey((Object)EncodeHintType.MARGIN)) {
                margin = Integer.parseInt(hints.get((Object)EncodeHintType.MARGIN).toString());
            }
            if (hints.containsKey((Object)EncodeHintType.ERROR_CORRECTION)) {
                errorCorrectionLevel = Integer.parseInt(hints.get((Object)EncodeHintType.ERROR_CORRECTION).toString());
            }
            if (hints.containsKey((Object)EncodeHintType.CHARACTER_SET)) {
                Charset encoding = Charset.forName(hints.get((Object)EncodeHintType.CHARACTER_SET).toString());
                encoder.setEncoding(encoding);
            }
        }
        return PDF417Writer.bitMatrixFromEncoder(encoder, contents, errorCorrectionLevel, width, height, margin);
    }

    @Override
    public BitMatrix encode(String contents, BarcodeFormat format, int width, int height) throws WriterException {
        return this.encode(contents, format, width, height, null);
    }

    private static BitMatrix bitMatrixFromEncoder(PDF417 encoder, String contents, int errorCorrectionLevel, int width, int height, int margin) throws WriterException {
        int scaleY;
        int scaleX;
        int scale;
        encoder.generateBarcodeLogic(contents, errorCorrectionLevel);
        int aspectRatio = 4;
        byte[][] originalScale = encoder.getBarcodeMatrix().getScaledMatrix(1, aspectRatio);
        boolean rotated = false;
        if (height > width != originalScale[0].length < originalScale.length) {
            originalScale = PDF417Writer.rotateArray(originalScale);
            rotated = true;
        }
        if ((scale = (scaleX = width / originalScale[0].length) < (scaleY = height / originalScale.length) ? scaleX : scaleY) > 1) {
            byte[][] scaledMatrix = encoder.getBarcodeMatrix().getScaledMatrix(scale, scale * aspectRatio);
            if (rotated) {
                scaledMatrix = PDF417Writer.rotateArray(scaledMatrix);
            }
            return PDF417Writer.bitMatrixFromBitArray(scaledMatrix, margin);
        }
        return PDF417Writer.bitMatrixFromBitArray(originalScale, margin);
    }

    private static BitMatrix bitMatrixFromBitArray(byte[][] input, int margin) {
        BitMatrix output = new BitMatrix(input[0].length + 2 * margin, input.length + 2 * margin);
        output.clear();
        int y = 0;
        int yOutput = output.getHeight() - margin - 1;
        while (y < input.length) {
            byte[] inputY = input[y];
            for (int x = 0; x < input[0].length; ++x) {
                if (inputY[x] != 1) continue;
                output.set(x + margin, yOutput);
            }
            ++y;
            --yOutput;
        }
        return output;
    }

    private static byte[][] rotateArray(byte[][] bitarray) {
        byte[][] temp = new byte[bitarray[0].length][bitarray.length];
        for (int ii = 0; ii < bitarray.length; ++ii) {
            int inverseii = bitarray.length - ii - 1;
            for (int jj = 0; jj < bitarray[0].length; ++jj) {
                temp[jj][inverseii] = bitarray[ii][jj];
            }
        }
        return temp;
    }
}

