/*
 * Decompiled with CFR 0.152.
 */
package com.printer.sdk.zxing.pdf417;

import com.printer.sdk.zxing.BarcodeFormat;
import com.printer.sdk.zxing.BinaryBitmap;
import com.printer.sdk.zxing.ChecksumException;
import com.printer.sdk.zxing.DecodeHintType;
import com.printer.sdk.zxing.FormatException;
import com.printer.sdk.zxing.NotFoundException;
import com.printer.sdk.zxing.Reader;
import com.printer.sdk.zxing.Result;
import com.printer.sdk.zxing.ResultMetadataType;
import com.printer.sdk.zxing.ResultPoint;
import com.printer.sdk.zxing.common.DecoderResult;
import com.printer.sdk.zxing.multi.MultipleBarcodeReader;
import com.printer.sdk.zxing.pdf417.PDF417ResultMetadata;
import com.printer.sdk.zxing.pdf417.decoder.PDF417ScanningDecoder;
import com.printer.sdk.zxing.pdf417.detector.Detector;
import com.printer.sdk.zxing.pdf417.detector.PDF417DetectorResult;
import java.util.ArrayList;
import java.util.Map;

public final class PDF417Reader
implements Reader,
MultipleBarcodeReader {
    private static final Result[] EMPTY_RESULT_ARRAY = new Result[0];

    @Override
    public Result decode(BinaryBitmap image) throws NotFoundException, FormatException, ChecksumException {
        return this.decode(image, null);
    }

    @Override
    public Result decode(BinaryBitmap image, Map<DecodeHintType, ?> hints) throws NotFoundException, FormatException, ChecksumException {
        Result[] result = PDF417Reader.decode(image, hints, false);
        if (result == null || result.length == 0 || result[0] == null) {
            throw NotFoundException.getNotFoundInstance();
        }
        return result[0];
    }

    @Override
    public Result[] decodeMultiple(BinaryBitmap image) throws NotFoundException {
        return this.decodeMultiple(image, null);
    }

    @Override
    public Result[] decodeMultiple(BinaryBitmap image, Map<DecodeHintType, ?> hints) throws NotFoundException {
        try {
            return PDF417Reader.decode(image, hints, true);
        }
        catch (ChecksumException | FormatException ignored) {
            throw NotFoundException.getNotFoundInstance();
        }
    }

    private static Result[] decode(BinaryBitmap image, Map<DecodeHintType, ?> hints, boolean multiple) throws NotFoundException, FormatException, ChecksumException {
        ArrayList<Result> results = new ArrayList<Result>();
        PDF417DetectorResult detectorResult = Detector.detect(image, hints, multiple);
        for (ResultPoint[] points : detectorResult.getPoints()) {
            DecoderResult decoderResult = PDF417ScanningDecoder.decode(detectorResult.getBits(), points[4], points[5], points[6], points[7], PDF417Reader.getMinCodewordWidth(points), PDF417Reader.getMaxCodewordWidth(points));
            Result result = new Result(decoderResult.getText(), decoderResult.getRawBytes(), points, BarcodeFormat.PDF_417);
            result.putMetadata(ResultMetadataType.ERROR_CORRECTION_LEVEL, decoderResult.getECLevel());
            PDF417ResultMetadata pdf417ResultMetadata = (PDF417ResultMetadata)decoderResult.getOther();
            if (pdf417ResultMetadata != null) {
                result.putMetadata(ResultMetadataType.PDF417_EXTRA_METADATA, pdf417ResultMetadata);
            }
            results.add(result);
        }
        return results.toArray(EMPTY_RESULT_ARRAY);
    }

    private static int getMaxWidth(ResultPoint p1, ResultPoint p2) {
        if (p1 == null || p2 == null) {
            return 0;
        }
        return (int)Math.abs(p1.getX() - p2.getX());
    }

    private static int getMinWidth(ResultPoint p1, ResultPoint p2) {
        if (p1 == null || p2 == null) {
            return Integer.MAX_VALUE;
        }
        return (int)Math.abs(p1.getX() - p2.getX());
    }

    private static int getMaxCodewordWidth(ResultPoint[] p) {
        return Math.max(Math.max(PDF417Reader.getMaxWidth(p[0], p[4]), PDF417Reader.getMaxWidth(p[6], p[2]) * 17 / 18), Math.max(PDF417Reader.getMaxWidth(p[1], p[5]), PDF417Reader.getMaxWidth(p[7], p[3]) * 17 / 18));
    }

    private static int getMinCodewordWidth(ResultPoint[] p) {
        return Math.min(Math.min(PDF417Reader.getMinWidth(p[0], p[4]), PDF417Reader.getMinWidth(p[6], p[2]) * 17 / 18), Math.min(PDF417Reader.getMinWidth(p[1], p[5]), PDF417Reader.getMinWidth(p[7], p[3]) * 17 / 18));
    }

    @Override
    public void reset() {
    }
}

