/*
 * Decompiled with CFR 0.152.
 */
package com.printer.sdk.zxing.oned.rss.expanded;

import com.printer.sdk.zxing.common.BitArray;
import com.printer.sdk.zxing.oned.rss.expanded.ExpandedPair;
import java.util.List;

final class BitArrayBuilder {
    private BitArrayBuilder() {
    }

    static BitArray buildBitArray(List<ExpandedPair> pairs) {
        int i;
        int charNumber = pairs.size() * 2 - 1;
        if (pairs.get(pairs.size() - 1).getRightChar() == null) {
            --charNumber;
        }
        int size = 12 * charNumber;
        BitArray binary = new BitArray(size);
        int accPos = 0;
        ExpandedPair firstPair = pairs.get(0);
        int firstValue = firstPair.getRightChar().getValue();
        for (i = 11; i >= 0; --i) {
            if ((firstValue & 1 << i) != 0) {
                binary.set(accPos);
            }
            ++accPos;
        }
        for (i = 1; i < pairs.size(); ++i) {
            ExpandedPair currentPair = pairs.get(i);
            int leftValue = currentPair.getLeftChar().getValue();
            for (int j = 11; j >= 0; --j) {
                if ((leftValue & 1 << j) != 0) {
                    binary.set(accPos);
                }
                ++accPos;
            }
            if (currentPair.getRightChar() == null) continue;
            int rightValue = currentPair.getRightChar().getValue();
            for (int j = 11; j >= 0; --j) {
                if ((rightValue & 1 << j) != 0) {
                    binary.set(accPos);
                }
                ++accPos;
            }
        }
        return binary;
    }
}

