/*
 * Decompiled with CFR 0.152.
 */
package com.printer.sdk.zxing.oned;

import com.printer.sdk.zxing.BarcodeFormat;
import com.printer.sdk.zxing.BinaryBitmap;
import com.printer.sdk.zxing.ChecksumException;
import com.printer.sdk.zxing.DecodeHintType;
import com.printer.sdk.zxing.FormatException;
import com.printer.sdk.zxing.NotFoundException;
import com.printer.sdk.zxing.Result;
import com.printer.sdk.zxing.common.BitArray;
import com.printer.sdk.zxing.oned.EAN13Reader;
import com.printer.sdk.zxing.oned.UPCEANReader;
import java.util.Map;

public final class UPCAReader
extends UPCEANReader {
    private final UPCEANReader ean13Reader = new EAN13Reader();

    @Override
    public Result decodeRow(int rowNumber, BitArray row, int[] startGuardRange, Map<DecodeHintType, ?> hints) throws NotFoundException, FormatException, ChecksumException {
        return UPCAReader.maybeReturnResult(this.ean13Reader.decodeRow(rowNumber, row, startGuardRange, hints));
    }

    @Override
    public Result decodeRow(int rowNumber, BitArray row, Map<DecodeHintType, ?> hints) throws NotFoundException, FormatException, ChecksumException {
        return UPCAReader.maybeReturnResult(this.ean13Reader.decodeRow(rowNumber, row, hints));
    }

    @Override
    public Result decode(BinaryBitmap image) throws NotFoundException, FormatException {
        return UPCAReader.maybeReturnResult(this.ean13Reader.decode(image));
    }

    @Override
    public Result decode(BinaryBitmap image, Map<DecodeHintType, ?> hints) throws NotFoundException, FormatException {
        return UPCAReader.maybeReturnResult(this.ean13Reader.decode(image, hints));
    }

    @Override
    BarcodeFormat getBarcodeFormat() {
        return BarcodeFormat.UPC_A;
    }

    @Override
    protected int decodeMiddle(BitArray row, int[] startRange, StringBuilder resultString) throws NotFoundException {
        return this.ean13Reader.decodeMiddle(row, startRange, resultString);
    }

    private static Result maybeReturnResult(Result result) throws FormatException {
        String text = result.getText();
        if (text.charAt(0) == '0') {
            Result upcaResult = new Result(text.substring(1), null, result.getResultPoints(), BarcodeFormat.UPC_A);
            if (result.getResultMetadata() != null) {
                upcaResult.putAllMetadata(result.getResultMetadata());
            }
            return upcaResult;
        }
        throw FormatException.getFormatInstance();
    }
}

