/*
 * Decompiled with CFR 0.152.
 */
package com.printer.sdk.zxing.oned;

import com.printer.sdk.zxing.BarcodeFormat;
import com.printer.sdk.zxing.DecodeHintType;
import com.printer.sdk.zxing.NotFoundException;
import com.printer.sdk.zxing.ReaderException;
import com.printer.sdk.zxing.Result;
import com.printer.sdk.zxing.common.BitArray;
import com.printer.sdk.zxing.oned.EAN13Reader;
import com.printer.sdk.zxing.oned.EAN8Reader;
import com.printer.sdk.zxing.oned.OneDReader;
import com.printer.sdk.zxing.oned.UPCAReader;
import com.printer.sdk.zxing.oned.UPCEANReader;
import com.printer.sdk.zxing.oned.UPCEReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;

public final class MultiFormatUPCEANReader
extends OneDReader {
    private static final UPCEANReader[] EMPTY_READER_ARRAY = new UPCEANReader[0];
    private final UPCEANReader[] readers;

    public MultiFormatUPCEANReader(Map<DecodeHintType, ?> hints) {
        Collection possibleFormats = hints == null ? null : (Collection)hints.get((Object)DecodeHintType.POSSIBLE_FORMATS);
        ArrayList<UPCEANReader> readers = new ArrayList<UPCEANReader>();
        if (possibleFormats != null) {
            if (possibleFormats.contains((Object)BarcodeFormat.EAN_13)) {
                readers.add(new EAN13Reader());
            } else if (possibleFormats.contains((Object)BarcodeFormat.UPC_A)) {
                readers.add(new UPCAReader());
            }
            if (possibleFormats.contains((Object)BarcodeFormat.EAN_8)) {
                readers.add(new EAN8Reader());
            }
            if (possibleFormats.contains((Object)BarcodeFormat.UPC_E)) {
                readers.add(new UPCEReader());
            }
        }
        if (readers.isEmpty()) {
            readers.add(new EAN13Reader());
            readers.add(new EAN8Reader());
            readers.add(new UPCEReader());
        }
        this.readers = readers.toArray(EMPTY_READER_ARRAY);
    }

    @Override
    public Result decodeRow(int rowNumber, BitArray row, Map<DecodeHintType, ?> hints) throws NotFoundException {
        int[] startGuardPattern = UPCEANReader.findStartGuardPattern(row);
        for (UPCEANReader reader : this.readers) {
            try {
                boolean canReturnUPCA;
                Result result = reader.decodeRow(rowNumber, row, startGuardPattern, hints);
                boolean ean13MayBeUPCA = result.getBarcodeFormat() == BarcodeFormat.EAN_13 && result.getText().charAt(0) == '0';
                Collection possibleFormats = hints == null ? null : (Collection)hints.get((Object)DecodeHintType.POSSIBLE_FORMATS);
                boolean bl = canReturnUPCA = possibleFormats == null || possibleFormats.contains((Object)BarcodeFormat.UPC_A);
                if (ean13MayBeUPCA && canReturnUPCA) {
                    Result resultUPCA = new Result(result.getText().substring(1), result.getRawBytes(), result.getResultPoints(), BarcodeFormat.UPC_A);
                    resultUPCA.putAllMetadata(result.getResultMetadata());
                    return resultUPCA;
                }
                return result;
            }
            catch (ReaderException readerException) {
            }
        }
        throw NotFoundException.getNotFoundInstance();
    }

    @Override
    public void reset() {
        for (UPCEANReader reader : this.readers) {
            reader.reset();
        }
    }
}

