/*
 * Decompiled with CFR 0.152.
 */
package com.printer.sdk.zxing.maxicode;

import com.printer.sdk.zxing.BarcodeFormat;
import com.printer.sdk.zxing.BinaryBitmap;
import com.printer.sdk.zxing.ChecksumException;
import com.printer.sdk.zxing.DecodeHintType;
import com.printer.sdk.zxing.FormatException;
import com.printer.sdk.zxing.NotFoundException;
import com.printer.sdk.zxing.Reader;
import com.printer.sdk.zxing.Result;
import com.printer.sdk.zxing.ResultMetadataType;
import com.printer.sdk.zxing.ResultPoint;
import com.printer.sdk.zxing.common.BitMatrix;
import com.printer.sdk.zxing.common.DecoderResult;
import com.printer.sdk.zxing.maxicode.decoder.Decoder;
import java.util.Map;

public final class MaxiCodeReader
implements Reader {
    private static final ResultPoint[] NO_POINTS = new ResultPoint[0];
    private static final int MATRIX_WIDTH = 30;
    private static final int MATRIX_HEIGHT = 33;
    private final Decoder decoder = new Decoder();

    @Override
    public Result decode(BinaryBitmap image) throws NotFoundException, ChecksumException, FormatException {
        return this.decode(image, null);
    }

    @Override
    public Result decode(BinaryBitmap image, Map<DecodeHintType, ?> hints) throws NotFoundException, ChecksumException, FormatException {
        BitMatrix bits = MaxiCodeReader.extractPureBits(image.getBlackMatrix());
        DecoderResult decoderResult = this.decoder.decode(bits, hints);
        Result result = new Result(decoderResult.getText(), decoderResult.getRawBytes(), NO_POINTS, BarcodeFormat.MAXICODE);
        String ecLevel = decoderResult.getECLevel();
        if (ecLevel != null) {
            result.putMetadata(ResultMetadataType.ERROR_CORRECTION_LEVEL, ecLevel);
        }
        return result;
    }

    @Override
    public void reset() {
    }

    private static BitMatrix extractPureBits(BitMatrix image) throws NotFoundException {
        int[] enclosingRectangle = image.getEnclosingRectangle();
        if (enclosingRectangle == null) {
            throw NotFoundException.getNotFoundInstance();
        }
        int left = enclosingRectangle[0];
        int top = enclosingRectangle[1];
        int width = enclosingRectangle[2];
        int height = enclosingRectangle[3];
        BitMatrix bits = new BitMatrix(30, 33);
        for (int y = 0; y < 33; ++y) {
            int iy = top + (y * height + height / 2) / 33;
            for (int x = 0; x < 30; ++x) {
                int ix = left + (x * width + width / 2 + (y & 1) * width / 2) / 30;
                if (!image.get(ix, iy)) continue;
                bits.set(x, y);
            }
        }
        return bits;
    }
}

