/*
 * Decompiled with CFR 0.152.
 */
package com.printer.sdk.zxing.client.result;

import com.printer.sdk.zxing.Result;
import com.printer.sdk.zxing.client.result.ResultParser;
import com.printer.sdk.zxing.client.result.WifiParsedResult;

public final class WifiResultParser
extends ResultParser {
    @Override
    public WifiParsedResult parse(Result result) {
        String rawText = WifiResultParser.getMassagedText(result);
        if (!rawText.startsWith("WIFI:")) {
            return null;
        }
        String ssid = WifiResultParser.matchSinglePrefixedField("S:", rawText = rawText.substring("WIFI:".length()), ';', false);
        if (ssid == null || ssid.isEmpty()) {
            return null;
        }
        String pass = WifiResultParser.matchSinglePrefixedField("P:", rawText, ';', false);
        String type = WifiResultParser.matchSinglePrefixedField("T:", rawText, ';', false);
        if (type == null) {
            type = "nopass";
        }
        boolean hidden = Boolean.parseBoolean(WifiResultParser.matchSinglePrefixedField("H:", rawText, ';', false));
        String identity = WifiResultParser.matchSinglePrefixedField("I:", rawText, ';', false);
        String anonymousIdentity = WifiResultParser.matchSinglePrefixedField("A:", rawText, ';', false);
        String eapMethod = WifiResultParser.matchSinglePrefixedField("E:", rawText, ';', false);
        String phase2Method = WifiResultParser.matchSinglePrefixedField("H:", rawText, ';', false);
        return new WifiParsedResult(type, ssid, pass, hidden, identity, anonymousIdentity, eapMethod, phase2Method);
    }
}

