/*
 * Decompiled with CFR 0.152.
 */
package com.printer.sdk.zxing.aztec;

import com.printer.sdk.zxing.BarcodeFormat;
import com.printer.sdk.zxing.BinaryBitmap;
import com.printer.sdk.zxing.DecodeHintType;
import com.printer.sdk.zxing.FormatException;
import com.printer.sdk.zxing.NotFoundException;
import com.printer.sdk.zxing.Reader;
import com.printer.sdk.zxing.Result;
import com.printer.sdk.zxing.ResultMetadataType;
import com.printer.sdk.zxing.ResultPoint;
import com.printer.sdk.zxing.ResultPointCallback;
import com.printer.sdk.zxing.aztec.AztecDetectorResult;
import com.printer.sdk.zxing.aztec.decoder.Decoder;
import com.printer.sdk.zxing.aztec.detector.Detector;
import com.printer.sdk.zxing.common.DecoderResult;
import java.util.List;
import java.util.Map;

public final class AztecReader
implements Reader {
    @Override
    public Result decode(BinaryBitmap image) throws NotFoundException, FormatException {
        return this.decode(image, null);
    }

    @Override
    public Result decode(BinaryBitmap image, Map<DecodeHintType, ?> hints) throws NotFoundException, FormatException {
        String ecLevel;
        ResultPointCallback rpcb;
        AztecDetectorResult detectorResult;
        NotFoundException notFoundException = null;
        FormatException formatException = null;
        Detector detector = new Detector(image.getBlackMatrix());
        ResultPoint[] points = null;
        DecoderResult decoderResult = null;
        try {
            detectorResult = detector.detect(false);
            points = detectorResult.getPoints();
            decoderResult = new Decoder().decode(detectorResult);
        }
        catch (NotFoundException e) {
            notFoundException = e;
        }
        catch (FormatException e) {
            formatException = e;
        }
        if (decoderResult == null) {
            try {
                detectorResult = detector.detect(true);
                points = detectorResult.getPoints();
                decoderResult = new Decoder().decode(detectorResult);
            }
            catch (FormatException | NotFoundException e) {
                if (notFoundException != null) {
                    throw notFoundException;
                }
                if (formatException != null) {
                    throw formatException;
                }
                throw e;
            }
        }
        if (hints != null && (rpcb = (ResultPointCallback)hints.get((Object)DecodeHintType.NEED_RESULT_POINT_CALLBACK)) != null) {
            for (ResultPoint point : points) {
                rpcb.foundPossibleResultPoint(point);
            }
        }
        Result result = new Result(decoderResult.getText(), decoderResult.getRawBytes(), decoderResult.getNumBits(), points, BarcodeFormat.AZTEC, System.currentTimeMillis());
        List<byte[]> byteSegments = decoderResult.getByteSegments();
        if (byteSegments != null) {
            result.putMetadata(ResultMetadataType.BYTE_SEGMENTS, byteSegments);
        }
        if ((ecLevel = decoderResult.getECLevel()) != null) {
            result.putMetadata(ResultMetadataType.ERROR_CORRECTION_LEVEL, ecLevel);
        }
        return result;
    }

    @Override
    public void reset() {
    }
}

