/*
 * Decompiled with CFR 0.152.
 */
package com.printer.sdk.wifi;

import android.os.Handler;
import com.printer.sdk.BasePrinterPort;
import com.printer.sdk.utils.XLog;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;

public class WiFiPort
implements BasePrinterPort {
    private static String TAG = "WifiPrinter";
    private String address;
    private int port;
    private Socket mSocket;
    private OutputStream outputStream;
    private InputStream inputStream;
    private Handler mHandler;
    private int mState;

    public WiFiPort(String ipAddress, int portNumber, Handler handler) {
        this.address = ipAddress;
        this.port = portNumber;
        this.mHandler = handler;
        this.mState = 103;
    }

    @Override
    public boolean open() {
        XLog.d(TAG, "yxz at WifiPort.java open()  ----begin.");
        boolean isConnected = false;
        XLog.d(TAG, "yxz at WifiPort.java open() open connect to: " + this.address);
        if (this.mState != 103) {
            this.close();
        }
        InetSocketAddress mSocketAddress = new InetSocketAddress(this.address, this.port);
        try {
            this.mSocket = new Socket();
            this.mSocket.setSoTimeout(3000);
            this.mSocket.connect(mSocketAddress, 3000);
            this.outputStream = this.mSocket.getOutputStream();
            this.inputStream = this.mSocket.getInputStream();
            isConnected = true;
        }
        catch (SocketException e) {
            XLog.d(TAG, "yxz at WifiPort.java open() SocketException");
            e.printStackTrace();
        }
        catch (IOException e) {
            XLog.d(TAG, "yxz at WifiPort.java open() IOException");
            e.printStackTrace();
        }
        catch (Exception e) {
            XLog.d(TAG, "yxz at WifiPort.java open() Exception");
            e.printStackTrace();
        }
        if (!isConnected) {
            this.setState(102);
            this.close();
        } else {
            this.setState(101);
        }
        XLog.d(TAG, "yxz at WifiPort.java open()  ----end.");
        return isConnected;
    }

    @Override
    public void close() {
        XLog.d(TAG, "yxz at WifiPort.java close()  ----begin.");
        try {
            if (this.outputStream != null) {
                this.outputStream.close();
            }
            if (this.inputStream != null) {
                this.inputStream.close();
            }
            if (this.mSocket != null) {
                this.mSocket.close();
            }
        }
        catch (IOException e) {
            XLog.e(TAG, "yxz at WifiPort.java close() IOException.");
            e.printStackTrace();
        }
        catch (Exception e) {
            XLog.e(TAG, "yxz at WifiPort.java close() Exception.");
            e.printStackTrace();
        }
        this.outputStream = null;
        this.inputStream = null;
        this.mSocket = null;
        if (this.mState != 102) {
            this.setState(103);
        }
        XLog.d(TAG, "yxz at WifiPort.java close()  ----end.");
    }

    @Override
    public int write(byte[] srcData) {
        XLog.d(TAG, "yxz at WifiPort.java write()  ----begin.");
        try {
            if (this.outputStream == null) {
                XLog.e(TAG, "yxz at WifiPort.java write() outputStream==null.");
                return -3;
            }
            this.outputStream.write(srcData);
            this.outputStream.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
            XLog.e(TAG, "yxz at WifiPort.java write() IOException.");
            return -1;
        }
        catch (Exception e) {
            e.printStackTrace();
            XLog.e(TAG, "yxz at WifiPort.java write() Exception.");
            return -2;
        }
        XLog.d(TAG, "yxz at WifiPort.java write()  ----end.");
        return srcData.length;
    }

    @Override
    public int read(byte[] buffer) {
        XLog.d(TAG, "yxz at WifiPort.java read()  ----begin.");
        int readLen = -1;
        if (buffer == null) {
            throw new NullPointerException("yxz at WifiPort.java read() buffer is null!");
        }
        try {
            if (this.inputStream == null) {
                XLog.e(TAG, "yxz at WifiPort.java read()  inputStream==null.");
                return readLen;
            }
            readLen = this.inputStream.available();
            if (readLen > 0) {
                this.inputStream.read(buffer);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            XLog.e(TAG, "yxz at WifiPort.java read() IOException.");
            return -1;
        }
        catch (Exception e) {
            XLog.e(TAG, "yxz at WifiPort.java read() Exception.");
            e.printStackTrace();
            return -1;
        }
        XLog.d(TAG, "yxz at WifiPort.java read() read length:" + readLen);
        XLog.d(TAG, "yxz at WifiPort.java read()  ----end.");
        return readLen;
    }

    private synchronized void setState(int state) {
        XLog.d(TAG, "yxz at WifiPort.java setState()  ----begin.");
        XLog.d(TAG, "yxz at WifiPort.java setState() " + this.mState + " -> " + state);
        if (this.mState != state) {
            this.mState = state;
            if (this.mHandler != null) {
                this.mHandler.obtainMessage(this.mState).sendToTarget();
            }
        }
        XLog.d(TAG, "yxz at WifiPort.java setState()  ----end.");
    }

    public Boolean isServerClose() {
        try {
            this.mSocket.sendUrgentData(255);
            return false;
        }
        catch (Exception se) {
            return true;
        }
    }

    @Override
    public boolean open(String host, int port) {
        return false;
    }
}

