/*
 * Decompiled with CFR 0.152.
 */
package com.printer.sdk.utils.recordlog;

import android.util.Log;
import com.printer.sdk.utils.recordlog.LogBean;
import com.printer.sdk.utils.recordlog.LogQueue;
import com.printer.sdk.utils.recordlog.LogType;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class ZLog {
    private static LogQueue mLogQueue;
    private static SimpleDateFormat simpleDateFormat;
    private static Boolean saveToFile;
    private static String mLogDir;

    public static synchronized void openSaveToFile() {
        saveToFile = true;
    }

    public static synchronized void closeSaveToFile() {
        saveToFile = false;
    }

    public static synchronized void Init(String logDir) {
        mLogDir = logDir;
        mLogQueue = new LogQueue(logDir);
        mLogQueue.start();
    }

    public static void e(String TAG, String text) {
        ZLog.error(TAG, text);
    }

    public static void error(String TAG, String text) {
        Log.e((String)TAG, (String)text);
        if (mLogQueue != null && saveToFile.booleanValue()) {
            mLogQueue.add(new LogBean(ZLog.buildMessage(TAG, text), LogType.ERROR));
        }
    }

    public static void d(String TAG, String text) {
        ZLog.debug(TAG, text);
    }

    public static void debug(String TAG, String text) {
        Log.d((String)TAG, (String)text);
        if (mLogQueue != null && saveToFile.booleanValue()) {
            mLogQueue.add(new LogBean(ZLog.buildMessage(TAG, text), LogType.DEBUG));
        }
    }

    public static void i(String TAG, String text) {
        ZLog.info(TAG, text);
    }

    public static void info(String TAG, String text) {
        Log.i((String)TAG, (String)text);
        if (mLogQueue != null && saveToFile.booleanValue()) {
            mLogQueue.add(new LogBean(ZLog.buildMessage(TAG, text), LogType.INFO));
        }
    }

    public static void w(String TAG, String text) {
        ZLog.wtf(TAG, text);
    }

    public static void wtf(String TAG, String text) {
        Log.w((String)TAG, (String)text);
        if (mLogQueue != null && saveToFile.booleanValue()) {
            mLogQueue.add(new LogBean(ZLog.buildMessage(TAG, text), LogType.WTF));
        }
    }

    public static void v(String TAG, String text) {
        ZLog.ver(TAG, text);
    }

    public static void ver(String TAG, String text) {
        Log.v((String)TAG, (String)text);
        if (mLogQueue != null && saveToFile.booleanValue()) {
            mLogQueue.add(new LogBean(ZLog.buildMessage(TAG, text), LogType.VERBOSE));
        }
    }

    private static String buildMessage(String TAG, String text) {
        try {
            StringBuilder sbLog = new StringBuilder();
            sbLog.append(simpleDateFormat.format(new Date()));
            sbLog.append("/");
            sbLog.append(TAG);
            sbLog.append("--->");
            sbLog.append(text);
            sbLog.append("\n\n");
            return sbLog.toString();
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"buildMessage: ", (Throwable)e);
            return "";
        }
    }

    static {
        simpleDateFormat = new SimpleDateFormat("MM-dd HH:mm:ss.SSS", Locale.CHINA);
        saveToFile = true;
    }
}

