/*
 * Decompiled with CFR 0.152.
 */
package com.printer.sdk.utils.recordlog;

import android.os.Process;
import android.util.Log;
import com.printer.sdk.utils.recordlog.LogBean;
import com.printer.sdk.utils.recordlog.LogType;
import java.io.File;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.LinkedBlockingQueue;

class LogDispatcher
extends Thread {
    private static final String TAG = "LogDispatcher";
    private final int MAX_LOG_SIZE = 0x200000;
    private LinkedBlockingQueue<LogBean> mLogQueue;
    private String mLogDir;

    LogDispatcher(LinkedBlockingQueue<LogBean> logQueue, String logDir) {
        this.mLogQueue = logQueue;
        this.mLogDir = logDir;
    }

    @Override
    public void run() {
        try {
            Process.setThreadPriority((int)10);
            while (true) {
                try {
                    while (true) {
                        LogBean logBean = this.mLogQueue.take();
                        this.saveTextToFile(this.getLogFilePath(logBean.getLogType()), logBean.getLogText());
                    }
                }
                catch (InterruptedException e) {
                    Log.e((String)TAG, (String)"run: ", (Throwable)e);
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"run: ", (Throwable)e);
            return;
        }
    }

    private String getLogFilePath(LogType logType) {
        String returnFileName = "";
        try {
            switch (logType) {
                case ERROR: 
                case INFO: 
                case WTF: 
                case DEBUG: 
                case VERBOSE: {
                    returnFileName = this.getLastLogFileName(this.mLogDir, "log");
                }
            }
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"getLogFile: ", (Throwable)e);
        }
        return returnFileName;
    }

    private String getLastLogFileName(String dir, String logName) {
        String[] fileArray;
        String returnFileName = String.format("%s/%s1.txt", dir, logName);
        File file = new File(dir);
        if (file.exists() && (fileArray = file.list()) != null && fileArray.length > 0) {
            ArrayList<String> logList = new ArrayList<String>();
            for (String s : fileArray) {
                if (!s.startsWith(logName) || s.length() != logName.length() + 5) continue;
                logList.add(s);
            }
            if (!logList.isEmpty()) {
                Collections.sort(logList);
                String lastFileName = (String)logList.get(logList.size() - 1);
                if (new File(String.format("%s/%s", dir, lastFileName)).length() > 0x200000L) {
                    if (lastFileName.contains(".")) {
                        int LastLogCount = Integer.valueOf(lastFileName.split("\\.")[0].replaceAll(logName, "").trim());
                        if (LastLogCount > 8) {
                            String replaceLogName = "";
                            for (int i = 0; i < logList.size(); ++i) {
                                String itemLogName = (String)logList.get(i);
                                if (replaceLogName.equals("")) {
                                    File itemFile = new File(String.format("%s/%s", dir, itemLogName));
                                    itemFile.delete();
                                    Log.i((String)TAG, (String)("delete: " + itemFile.getPath()));
                                } else {
                                    this.renameFile(dir + itemLogName, dir + replaceLogName);
                                }
                                replaceLogName = itemLogName;
                            }
                            return this.getLastLogFileName(dir, logName);
                        }
                        returnFileName = String.format("%s/%s%s.txt", dir, logName, ++LastLogCount);
                    }
                } else {
                    returnFileName = String.format("%s/%s", dir, lastFileName);
                }
            }
        }
        return returnFileName;
    }

    private void renameFile(String oldPath, String newPath) {
        File oleFile = new File(oldPath);
        File newFile = new File(newPath);
        oleFile.renameTo(newFile);
    }

    private void saveTextToFile(String filePath, String text) {
        try {
            File file = new File(filePath);
            if (!new File(file.getParent()).exists()) {
                File parentFile1 = new File(file.getParent());
                if (!parentFile1.exists()) {
                    File parentFile2 = new File(parentFile1.getParent());
                    if (!parentFile2.exists()) {
                        parentFile2.mkdir();
                    }
                    parentFile1.mkdir();
                }
                new File(file.getParent()).mkdir();
            }
            if (!file.exists()) {
                file.createNewFile();
            }
            FileWriter writer = new FileWriter(file, true);
            writer.write(text);
            writer.close();
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"saveTextToFile: ", (Throwable)e);
        }
    }
}

