/*
 * Decompiled with CFR 0.152.
 */
package com.printer.sdk.utils;

import android.graphics.Bitmap;
import android.graphics.Color;
import android.graphics.Matrix;
import android.os.Environment;
import android.util.Log;
import com.printer.sdk.PrinterConstants;
import com.printer.sdk.utils.XLog;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;

public class Utils {
    private static final String TAG = "Utils";

    public static byte[] originalBmpToPrintByte(Bitmap bmpOriginal, PrinterConstants.PAlign alignType, int left, int level) {
        XLog.d(TAG, "yxz at Utils.java originalBmpToPrintByte() ----begin");
        if (level < 0 | level > 255 | level == 255) {
            level = 128;
        }
        int picBytes = 0;
        int leftBytes = 0;
        int width = bmpOriginal.getWidth();
        int height = bmpOriginal.getHeight();
        switch (alignType) {
            case START: {
                left = 0;
                break;
            }
            case CENTER: {
                left = (PrinterConstants.paperWidth - width) / 2;
                if (left % 8 == 0) break;
                left = left / 8 * 8;
                break;
            }
            case END: {
                left = PrinterConstants.paperWidth - width;
                if (left % 8 == 0) break;
                left = left / 8 * 8;
                break;
            }
            case NONE: {
                if (left % 8 == 0) break;
                left = left / 8 * 8;
                break;
            }
            default: {
                if (left % 8 == 0) break;
                left = left / 8 * 8;
            }
        }
        int last = width % 8;
        picBytes = last != 0 ? width / 8 + 1 : width / 8;
        XLog.d(TAG, "yxz at Utils.java originalBmpToPrintByte() \u56fe\u7247\u6570\u636e\u6bcf\u70b9\u884c\u6709\u591a\u5c11\u4e2a\u5b57\u8282\uff1a" + picBytes);
        leftBytes = left % 8 != 0 ? left / 8 + 1 : left / 8;
        byte[] imgBuf = new byte[(picBytes + leftBytes + 4) * height];
        byte[] perLineBuf = null;
        int[] p = new int[8];
        int s = 0;
        int B = 0;
        int G = 0;
        int R = 0;
        try {
            for (int x = 0; x < height; ++x) {
                int pixel;
                int m;
                perLineBuf = new byte[picBytes];
                for (int z = 0; z < width / 8; ++z) {
                    for (m = 0; m < 8; ++m) {
                        pixel = bmpOriginal.getPixel(z * 8 + m, x);
                        R = Color.red((int)pixel);
                        G = Color.green((int)pixel);
                        B = Color.blue((int)pixel);
                        G = B = (int)(0.299 * (double)R + 0.587 * (double)G + 0.114 * (double)B);
                        R = B;
                        p[m] = R < level ? 1 : 0;
                    }
                    int value = p[0] << 7 | p[1] << 6 | p[2] << 5 | p[3] << 4 | p[4] << 3 | p[5] << 2 | p[6] << 1 | p[7];
                    perLineBuf[z] = (byte)value;
                }
                if (last > 0) {
                    int tmp = 0;
                    p = new int[8];
                    for (m = 0; m < last; ++m) {
                        pixel = bmpOriginal.getPixel(width - (last - m), x);
                        R = Color.red((int)pixel);
                        G = Color.green((int)pixel);
                        B = Color.blue((int)pixel);
                        G = B = (int)(0.299 * (double)R + 0.587 * (double)G + 0.114 * (double)B);
                        R = B;
                        p[m] = R < level ? 1 : 0;
                        tmp = p[0] << 7 | p[1] << 6 | p[2] << 5 | p[3] << 4 | p[4] << 3 | p[5] << 2 | p[6] << 1 | p[7];
                    }
                    perLineBuf[picBytes - 1] = (byte)tmp;
                }
                if (x != 0) {
                    imgBuf[++s] = 22;
                } else {
                    imgBuf[s] = 22;
                }
                imgBuf[++s] = (byte)(picBytes + leftBytes);
                for (int j = 0; j < left / 8; ++j) {
                    imgBuf[++s] = 0;
                }
                for (int n = 0; n < picBytes; ++n) {
                    imgBuf[++s] = perLineBuf[n];
                }
                imgBuf[++s] = 21;
                imgBuf[++s] = 1;
            }
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)e.toString());
        }
        XLog.d(TAG, "yxz at Utils.java originalBmpToPrintByte() length:" + imgBuf.length);
        XLog.d(TAG, "yxz at Utils.java originalBmpToPrintByte() ----end");
        return imgBuf;
    }

    public static byte[] bitmap2PrinterBytesD(Bitmap bitmap, PrinterConstants.PAlign alignType, int left) {
        switch (alignType) {
            case START: {
                left = 0;
                break;
            }
            case CENTER: {
                left = (PrinterConstants.paperWidth - bitmap.getWidth()) / 2;
                if (left % 8 == 0) break;
                left = left / 8 * 8;
                break;
            }
            case END: {
                left = PrinterConstants.paperWidth - bitmap.getWidth();
                if (left % 8 == 0) break;
                left = left / 8 * 8;
                break;
            }
            case NONE: {
                if (left % 8 == 0) break;
                left = left / 8 * 8;
                break;
            }
            default: {
                if (left % 8 == 0) break;
                left = left / 8 * 8;
            }
        }
        int width = bitmap.getWidth();
        int height = bitmap.getHeight();
        byte[] imgbuf = new byte[(width / 8 + left / 8 + 4) * height];
        byte[] bitbuf = new byte[width / 8];
        int[] p = new int[8];
        int s = 0;
        System.out.println("+++++++++++++++ Total Bytes: " + (width / 8 + 4) * height);
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width / 8; ++x) {
                for (int m = 0; m < 8; ++m) {
                    p[m] = bitmap.getPixel(x * 8 + m, y) == -1 ? 0 : 1;
                }
                int value = p[0] * 128 + p[1] * 64 + p[2] * 32 + p[3] * 16 + p[4] * 8 + p[5] * 4 + p[6] * 2 + p[7];
                bitbuf[x] = (byte)value;
            }
            if (y != 0) {
                imgbuf[++s] = 22;
            } else {
                imgbuf[s] = 22;
            }
            imgbuf[++s] = (byte)(width / 8 + left / 8);
            for (int j = 0; j < left / 8; ++j) {
                imgbuf[++s] = 0;
            }
            for (int n = 0; n < width / 8; ++n) {
                imgbuf[++s] = bitbuf[n];
            }
            imgbuf[++s] = 21;
            imgbuf[++s] = 1;
        }
        return imgbuf;
    }

    public static byte[] bitmap2PrinterBytes(Bitmap bitmap, PrinterConstants.PAlign alignType, int left) {
        switch (alignType) {
            case START: {
                left = 0;
                break;
            }
            case CENTER: {
                left = (PrinterConstants.paperWidth - bitmap.getWidth()) / 2;
                if (left % 8 == 0) break;
                left = left / 8 * 8;
                break;
            }
            case END: {
                left = PrinterConstants.paperWidth - bitmap.getWidth();
                if (left % 8 == 0) break;
                left = left / 8 * 8;
                break;
            }
            case NONE: {
                if (left % 8 == 0) break;
                left = left / 8 * 8;
                break;
            }
            default: {
                if (left % 8 == 0) break;
                left = left / 8 * 8;
            }
        }
        int wBytes = 0;
        int leftBytes = 0;
        int width = bitmap.getWidth();
        int height = bitmap.getHeight();
        wBytes = bitmap.getWidth() % 8 != 0 ? width / 8 + 1 : width / 8;
        XLog.i(TAG, "wBytes " + wBytes);
        leftBytes = left % 8 != 0 ? left / 8 + 1 : left / 8;
        int k = bitmap.getWidth() % 8;
        byte[] imgbuf = new byte[(wBytes + leftBytes + 4) * height];
        byte[] linebuf = null;
        int[] p = new int[8];
        int s = 0;
        XLog.i(TAG, "+++++++++++++++ Total Bytes: " + imgbuf.length);
        for (int y = 0; y < height; ++y) {
            int m;
            linebuf = new byte[wBytes];
            for (int x = 0; x < width / 8; ++x) {
                for (m = 0; m < 8; ++m) {
                    p[m] = bitmap.getPixel(x * 8 + m, y) == -1 ? 0 : 1;
                    int n = bitmap.getPixel(x * 8 + m, y);
                }
                int value = p[0] * 128 + p[1] * 64 + p[2] * 32 + p[3] * 16 + p[4] * 8 + p[5] * 4 + p[6] * 2 + p[7];
                linebuf[x] = (byte)value;
            }
            if (k > 0) {
                int tmp = 0;
                p = new int[8];
                for (m = 0; m < k; ++m) {
                    tmp = (int)((double)tmp + (bitmap.getPixel(bitmap.getWidth() - m - 1, y) == -1 ? 0.0 : Math.pow(2.0, 7 - m)));
                }
                linebuf[wBytes - 1] = (byte)tmp;
            }
            if (y != 0) {
                imgbuf[++s] = 22;
            } else {
                imgbuf[s] = 22;
            }
            imgbuf[++s] = (byte)(wBytes + leftBytes);
            for (int j = 0; j < left / 8; ++j) {
                imgbuf[++s] = 0;
            }
            for (int n = 0; n < wBytes; ++n) {
                imgbuf[++s] = linebuf[n];
            }
            imgbuf[++s] = 21;
            imgbuf[++s] = 1;
        }
        return imgbuf;
    }

    public static byte[] bitmap2PrinterBytes_stylus(Bitmap bitmap, int multiple, int left) {
        byte[] imgBuf;
        int height = bitmap.getHeight();
        int width = bitmap.getWidth() + left;
        boolean need_0a = false;
        int maxWidth = 240;
        if (width < maxWidth) {
            imgBuf = new byte[(height / 8 + 1) * (width + 6)];
            need_0a = true;
        } else {
            imgBuf = new byte[(height / 8 + 1) * (width + 5) + 2];
        }
        byte[] tmpBuf = new byte[width + 5];
        int[] p = new int[8];
        int s = 0;
        int t = 0;
        boolean allZERO = true;
        for (int y = 0; y < height / 8 + 1; ++y) {
            t = 0;
            tmpBuf[t] = 27;
            tmpBuf[++t] = 42;
            tmpBuf[++t] = (byte)multiple;
            tmpBuf[++t] = (byte)(width % maxWidth);
            tmpBuf[++t] = (byte)(width / maxWidth > 0 ? 1 : 0);
            allZERO = true;
            for (int x = 0; x < width; ++x) {
                for (int m = 0; m < 8; ++m) {
                    p[m] = y * 8 + m >= height || x < left ? 0 : (bitmap.getPixel(x - left, y * 8 + m) == -1 ? 0 : 1);
                }
                int value = p[0] * 128 + p[1] * 64 + p[2] * 32 + p[3] * 16 + p[4] * 8 + p[5] * 4 + p[6] * 2 + p[7];
                tmpBuf[++t] = (byte)value;
            }
            if (allZERO) {
                if (s == 0) {
                    imgBuf[s] = 27;
                } else {
                    imgBuf[++s] = 27;
                }
                imgBuf[++s] = 74;
                imgBuf[++s] = 8;
                continue;
            }
            for (int i = 0; i < t + 1; ++i) {
                if (i == 0 && s == 0) {
                    imgBuf[s] = tmpBuf[i];
                    continue;
                }
                imgBuf[++s] = tmpBuf[i];
            }
            if (!need_0a) continue;
            imgBuf[++s] = 10;
        }
        if (!need_0a) {
            imgBuf[++s] = 13;
            imgBuf[++s] = 10;
        }
        byte[] realBuf = new byte[s + 1];
        for (int i = 0; i < s + 1; ++i) {
            realBuf[i] = imgBuf[i];
        }
        return realBuf;
    }

    public static byte[] compressBitmap2PrinterBytes(Bitmap bitmap, PrinterConstants.PAlign alignType, int left) {
        switch (alignType) {
            case START: {
                left = 0;
                break;
            }
            case CENTER: {
                left = (576 - bitmap.getWidth()) / 2;
                if (left % 8 == 0) break;
                left = left / 8 * 8;
                break;
            }
            case END: {
                left = 576 - bitmap.getWidth();
                if (left % 8 == 0) break;
                left = left / 8 * 8;
                break;
            }
            case NONE: {
                if (left % 8 == 0) break;
                left = left / 8 * 8;
                break;
            }
            default: {
                if (left % 8 == 0) break;
                left = left / 8 * 8;
            }
        }
        int width = bitmap.getWidth();
        int height = bitmap.getHeight();
        byte[] imgbuf = new byte[0xA00000];
        byte[] bitbuf = new byte[width / 8];
        int[] p = new int[8];
        int s = 0;
        int count = 0;
        byte[] lineData = null;
        byte[] lineData1 = null;
        byte[] compressedLineBytes = null;
        System.out.println("+++++++++++++++ Total Bytes: " + (width / 8 + 4) * height);
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width / 8; ++x) {
                for (int m = 0; m < 8; ++m) {
                    p[m] = bitmap.getPixel(x * 8 + m, y) == -1 ? 0 : 1;
                }
                int value = p[0] * 128 + p[1] * 64 + p[2] * 32 + p[3] * 16 + p[4] * 8 + p[5] * 4 + p[6] * 2 + p[7];
                bitbuf[x] = (byte)value;
            }
            lineData = new byte[1024];
            for (int j = 0; j < left / 8; ++j) {
                lineData[j] = 0;
            }
            System.arraycopy(bitbuf, 0, lineData, left / 8, bitbuf.length);
            lineData1 = new byte[left / 8 + bitbuf.length];
            System.arraycopy(lineData, 0, lineData1, 0, left / 8 + bitbuf.length);
            compressedLineBytes = Utils.compressByteData(lineData1);
            if (y != 0) {
                imgbuf[++s] = 24;
            } else {
                imgbuf[s] = 24;
            }
            ++count;
            imgbuf[++s] = (byte)compressedLineBytes.length;
            ++count;
            for (int i = 0; i < compressedLineBytes.length; ++i) {
                imgbuf[++s] = compressedLineBytes[i];
            }
            count += compressedLineBytes.length;
            XLog.i("sprt", "\u957f\u5ea6:" + compressedLineBytes.length);
            imgbuf[++s] = 21;
            imgbuf[++s] = 1;
            count += 2;
        }
        XLog.i("sprt", "count:" + count);
        byte[] pictureBytes = new byte[count];
        System.arraycopy(imgbuf, 0, pictureBytes, 0, count);
        XLog.v("imgbuf", "\u6570\u636e\u957f\u5ea6:" + pictureBytes.length);
        XLog.v("imgbuf", Utils.bytesToHexString(pictureBytes, pictureBytes.length));
        return pictureBytes;
    }

    public static byte[] compressByteData(byte[] buffer) {
        byte temp = -1;
        int count = 0;
        int number = 0;
        byte[] tempData = new byte[768];
        if (buffer == null || buffer.length == 0) {
            return null;
        }
        for (int i = 0; i < buffer.length; ++i) {
            if (i == 0) {
                temp = buffer[0];
            }
            if (temp != buffer[i]) {
                tempData[count++] = (byte)number;
                tempData[count++] = buffer[i - 1];
                temp = buffer[i];
                number = 1;
            } else {
                ++number;
            }
            if (i != buffer.length - 1) continue;
            tempData[count++] = (byte)number;
            tempData[count++] = buffer[buffer.length - 1];
        }
        byte[] compressedData = new byte[count];
        System.arraycopy(tempData, 0, compressedData, 0, count);
        return compressedData;
    }

    public static String bytesToHexString(byte[] src, int datalength) {
        StringBuilder stringBuilder = new StringBuilder("");
        if (src == null || src.length <= 0) {
            return null;
        }
        for (int i = 0; i < datalength; ++i) {
            int v = src[i] & 0xFF;
            String hv = Integer.toHexString(v);
            if (hv.length() < 2) {
                stringBuilder.append(0);
            }
            stringBuilder.append(hv).append(" ");
        }
        return stringBuilder.toString();
    }

    public static int getStringCharacterLength(String line) {
        int length = 0;
        for (int j = 0; j < line.length(); ++j) {
            if (line.charAt(j) > '\u0100') {
                length += 2;
                continue;
            }
            ++length;
        }
        return length;
    }

    public static int getSubLength(String line, int width) {
        int length = 0;
        for (int j = 0; j < line.length(); ++j) {
            length = line.charAt(j) > '\u0100' ? (length += 2) : ++length;
            if (length <= width) continue;
            int temp = line.substring(0, j - 1).lastIndexOf(" ");
            if (temp != -1) {
                return temp;
            }
            return j - 1 == 0 ? 1 : j - 1;
        }
        return line.length();
    }

    public static Map<Integer, String[]> dealContentTL(String text, int areawidth, int areaHeight, int xMultiplication) {
        XLog.i("sp", "areaWidth:" + areawidth + "  areaHeight:" + areaHeight);
        XLog.i("test1", "str:" + text);
        HashMap<Integer, String[]> rowMap = new HashMap<Integer, String[]>();
        int rowNum = 0;
        int curentXWidth = 0;
        int nextXwidth = 0;
        int XdotNumber = 0;
        int count = 0;
        switch (xMultiplication) {
            case 1: {
                XdotNumber = 24;
                break;
            }
            case 2: {
                XdotNumber = 48;
                break;
            }
            case 3: {
                XdotNumber = 72;
                break;
            }
            case 4: {
                XdotNumber = 96;
                break;
            }
            default: {
                XdotNumber = 24;
            }
        }
        char[] testArrays = text.toCharArray();
        int length = testArrays.length;
        for (int i = 0; i < length; ++i) {
            String rowStr;
            curentXWidth = Utils.isChinese(testArrays[i]) ? (curentXWidth += XdotNumber) : (curentXWidth += XdotNumber / 2);
            nextXwidth = i <= length - 2 && Utils.isChinese(testArrays[i + 1]) ? XdotNumber : XdotNumber / 2;
            if (curentXWidth <= areawidth && curentXWidth + nextXwidth > areawidth) {
                XLog.i("sprt", "curentXWidth:" + curentXWidth + "areawidth:" + areawidth);
                rowStr = text.substring(count, i + 1);
                rowMap.put(rowNum++, new String[]{curentXWidth + "", rowStr});
                count = i + 1;
                curentXWidth = 0;
            }
            if (i != testArrays.length - 1 || curentXWidth <= 0 || curentXWidth > areawidth) continue;
            rowStr = text.substring(count);
            rowMap.put(rowNum++, new String[]{curentXWidth + "", rowStr});
        }
        return rowMap;
    }

    public static Map<Integer, String[]> dealContent(String text, int areawidth, int areaHeight, PrinterConstants.LableFontSize fontSize) {
        XLog.i("sp", "areaWidth:" + areawidth + "  areaHeight:" + areaHeight);
        XLog.i("test1", "str:" + text);
        HashMap<Integer, String[]> rowMap = new HashMap<Integer, String[]>();
        int rowNum = 0;
        int curentXWidth = 0;
        int nextXwidth = 0;
        int XdotNumber = 0;
        int count = 0;
        switch (fontSize) {
            case Size_16: {
                XdotNumber = 16;
                break;
            }
            case Size_24: {
                XdotNumber = 24;
                break;
            }
            case Size_32: {
                XdotNumber = 32;
                break;
            }
            case Size_48: {
                XdotNumber = 48;
                break;
            }
            case Size_64: {
                XdotNumber = 64;
                break;
            }
            case Size_72: {
                XdotNumber = 72;
                break;
            }
            case Size_96: {
                XdotNumber = 96;
                break;
            }
            default: {
                XdotNumber = 24;
            }
        }
        char[] testArrays = text.toCharArray();
        int length = testArrays.length;
        for (int i = 0; i < length; ++i) {
            String rowStr;
            curentXWidth = Utils.isChinese(testArrays[i]) ? (curentXWidth += XdotNumber) : (curentXWidth += XdotNumber / 2);
            nextXwidth = i <= length - 2 && Utils.isChinese(testArrays[i + 1]) ? XdotNumber : XdotNumber / 2;
            if (curentXWidth <= areawidth && curentXWidth + nextXwidth > areawidth) {
                XLog.i("sprt", "curentXWidth:" + curentXWidth + "areawidth:" + areawidth);
                rowStr = text.substring(count, i + 1);
                rowMap.put(rowNum++, new String[]{curentXWidth + "", rowStr});
                count = i + 1;
                curentXWidth = 0;
            }
            if (i != testArrays.length - 1 || curentXWidth <= 0 || curentXWidth > areawidth) continue;
            rowStr = text.substring(count);
            rowMap.put(rowNum++, new String[]{curentXWidth + "", rowStr});
        }
        return rowMap;
    }

    private static int calcStringWidth(String text, int fontSize) {
        char[] textArray = text.toCharArray();
        int textWidth = 0;
        for (int i = 0; i < textArray.length; ++i) {
            if (Utils.isChinese(textArray[i])) {
                textWidth += fontSize;
                continue;
            }
            textWidth += fontSize / 2;
        }
        return textWidth;
    }

    private static boolean isChinese(char c) {
        Character.UnicodeBlock ub = Character.UnicodeBlock.of(c);
        return ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS || ub == Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS || ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A || ub == Character.UnicodeBlock.GENERAL_PUNCTUATION || ub == Character.UnicodeBlock.CJK_SYMBOLS_AND_PUNCTUATION || ub == Character.UnicodeBlock.HALFWIDTH_AND_FULLWIDTH_FORMS;
    }

    public static byte[] convertGreyImg(Bitmap img, PrinterConstants.PAlign alignType, int left, boolean isCompressed) {
        int j;
        int i;
        int startByte = 22;
        int widthByteSize = 0;
        switch (alignType) {
            case START: {
                left = 0;
                break;
            }
            case CENTER: {
                left = (PrinterConstants.paperWidth - img.getWidth()) / 2;
                if (left % 8 == 0) break;
                left = left / 8 * 8;
                break;
            }
            case END: {
                left = PrinterConstants.paperWidth - img.getWidth();
                if (left % 8 == 0) break;
                left = left / 8 * 8;
                break;
            }
            case NONE: {
                if (left % 8 == 0) break;
                left = left / 8 * 8;
                break;
            }
            default: {
                if (left % 8 == 0) break;
                left = left / 8 * 8;
            }
        }
        XLog.i("fdh", "paperWidth" + PrinterConstants.paperWidth);
        XLog.i("fdh", "wid:" + img.getWidth() + "---hei:" + img.getHeight());
        XLog.i("fdh", "left:" + left);
        int width = img.getWidth();
        int height = img.getHeight();
        byte[][] BayerPattern = new byte[][]{{0, 32, 8, 40, 2, 34, 10, 42}, {48, 16, 56, 24, 50, 18, 58, 26}, {12, 44, 4, 36, 14, 46, 6, 38}, {60, 28, 52, 20, 62, 30, 54, 22}, {3, 35, 11, 43, 1, 33, 9, 41}, {51, 19, 59, 27, 49, 17, 57, 25}, {15, 47, 7, 39, 13, 45, 5, 37}, {63, 31, 55, 23, 61, 29, 53, 21}};
        int bytesPerLine = (width + 7) / 8;
        int[] pixels = new int[width * height];
        img.getPixels(pixels, 0, width, 0, 0, width, height);
        byte[][] bitmap = new byte[height][bytesPerLine];
        for (i = 0; i < height; ++i) {
            for (j = 0; j < bytesPerLine; ++j) {
                bitmap[i][j] = 0;
            }
        }
        for (i = 0; i < height; ++i) {
            for (j = 0; j < width; ++j) {
                int grey = pixels[width * i + j];
                int red = (grey & 0xFF0000) >> 16;
                int green = (grey & 0xFF00) >> 8;
                int blue = grey & 0xFF;
                if ((grey = (int)((double)red * 0.3 + (double)green * 0.59 + (double)blue * 0.11)) >> 2 >= BayerPattern[i % 8][j % 8]) continue;
                byte[] byArray = bitmap[i];
                int n = j / 8;
                byArray[n] = (byte)(byArray[n] | 1 << 7 - j % 8);
                pixels[width * i + j] = grey;
            }
        }
        if (!isCompressed) {
            widthByteSize = bytesPerLine + 4 + left / 8;
            startByte = 22;
        } else {
            widthByteSize = (bytesPerLine + 4 + left / 8) * 2;
            startByte = 22;
        }
        int mcount = 0;
        byte[] startData = new byte[2];
        startData[0] = 22;
        byte[] endData = new byte[]{21, 1};
        byte[] lineData = new byte[widthByteSize * height];
        for (int i2 = 0; i2 < bitmap.length; ++i2) {
            int j2;
            int count = 0;
            byte[] tempData = new byte[1024];
            tempData[count++] = startByte;
            tempData[count++] = (byte)(bytesPerLine + left / 8);
            for (j2 = 0; j2 < left / 8; ++j2) {
                tempData[count++] = 0;
            }
            for (j2 = 0; j2 < bytesPerLine; ++j2) {
                tempData[count++] = bitmap[i2][j2];
            }
            tempData[count++] = 21;
            tempData[count++] = 1;
            if (isCompressed) {
                byte[] lineValueData = new byte[count - 4];
                System.arraycopy(tempData, 2, lineValueData, 0, count - 4);
                byte[] compressByteData = Utils.compressByteData(lineValueData);
                startData[1] = (byte)compressByteData.length;
                System.arraycopy(startData, 0, lineData, mcount, 2);
                count = compressByteData.length;
                System.arraycopy(compressByteData, 0, lineData, mcount += 2, count);
                System.arraycopy(endData, 0, lineData, mcount += count, 2);
                mcount += 2;
                continue;
            }
            System.arraycopy(tempData, 0, lineData, widthByteSize * i2, widthByteSize);
        }
        if (isCompressed) {
            XLog.i("fdh", "\u538b\u7f29\u524d\u5927\u5c0f\uff1a" + (bytesPerLine + 4 + left / 8) * height);
            byte[] compressedData = new byte[mcount];
            System.arraycopy(lineData, 0, compressedData, 0, mcount);
            XLog.i("fdh", "\u538b\u7f29\u540e\u5927\u5c0f\uff1a" + mcount + "------\u76f8\u5dee\uff1a" + ((bytesPerLine + 4 + left / 8) * height - mcount) + "\u538b\u7f29\u7387\uff1a" + 100 * ((bytesPerLine + 4 + left / 8) * height - mcount) / ((bytesPerLine + 4 + left / 8) * height) + "%");
            return compressedData;
        }
        XLog.i("fdh", "\u539f\u59cb\u5927\u5c0f:" + lineData.length);
        return lineData;
    }

    public static Bitmap zoomImage(Bitmap bgimage, double newWidth) {
        boolean newHeight = false;
        float width = bgimage.getWidth();
        float height = bgimage.getHeight();
        float scaleWidth = (float)(newWidth / (double)bgimage.getWidth());
        Matrix matrix = new Matrix();
        matrix.postScale(scaleWidth, scaleWidth);
        Bitmap bitmap = Bitmap.createBitmap((Bitmap)bgimage, (int)0, (int)0, (int)((int)width), (int)((int)height), (Matrix)matrix, (boolean)true);
        return bitmap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write2File(byte[] recvData, String filePath, String fileName, boolean isHexdata) {
        File file;
        byte[] data = null;
        String sdState = Environment.getExternalStorageState();
        if (!sdState.equals("mounted")) {
            XLog.w("sprt", "\u6ca1\u6709SD\u5361\uff01");
            return;
        }
        File path = new File(filePath);
        if (!path.exists()) {
            XLog.d("sprt", "creating the path:" + filePath);
            path.mkdir();
        }
        if (!(file = new File(filePath, fileName)).exists()) {
            XLog.d("sprt", "creating the file:" + fileName);
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        String str = Utils.bytesToHexString(recvData, recvData.length);
        if (isHexdata) {
            try {
                data = str.getBytes("gbk");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        } else {
            data = recvData;
        }
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(file, true);
            fos.write(data);
            fos.flush();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFromFile(File f) {
        FileInputStream is = null;
        int count = 0;
        byte[] b = null;
        String str = null;
        try {
            is = new FileInputStream(f);
            count = is.available();
            if (count > 0) {
                b = new byte[count];
                is.read(b);
            }
            str = new String(b, "gbk");
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return str;
    }

    public static byte[] conver16HexToByte(String hex16Str) {
        String str = hex16Str.trim().replace(" ", "");
        char[] c = str.toCharArray();
        byte[] b = new byte[c.length / 2];
        for (int i = 0; i < b.length; ++i) {
            int pos = i * 2;
            b[i] = (byte)("0123456789ABCDEF".indexOf(c[pos]) << 4 | "0123456789ABCDEF".indexOf(c[pos + 1]));
        }
        return b;
    }
}

