/*
 * Decompiled with CFR 0.152.
 */
package com.printer.sdk.usb;

import android.annotation.TargetApi;
import android.content.Context;
import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbEndpoint;
import android.hardware.usb.UsbInterface;
import android.hardware.usb.UsbManager;
import android.os.Handler;
import com.printer.sdk.BasePrinterPort;
import com.printer.sdk.utils.XLog;

@TargetApi(value=12)
public class USBPort
implements BasePrinterPort {
    private static final String TAG = "USBPrinter";
    private UsbManager mUsbManager;
    private UsbDevice mUsbDevice;
    private UsbDeviceConnection connection;
    private UsbInterface usbInterface;
    private UsbEndpoint inEndpoint;
    private UsbEndpoint outEndpoint;
    private Handler mHandler;
    private int mState;
    private Context mContext;
    private final String ACTION_USB_PERMISSION = "com.android.usb.USB_PERMISSION";
    private static int TIME_OUT = 0;

    public static synchronized void setTimeOut(int timeOut) {
        TIME_OUT = timeOut;
    }

    public USBPort(Context context, UsbDevice usbDevice, Handler handler) {
        this.mContext = context;
        this.mUsbManager = (UsbManager)this.mContext.getSystemService("usb");
        this.mUsbDevice = usbDevice;
        this.mHandler = handler;
        this.mState = 103;
    }

    @Override
    public boolean open() {
        XLog.d(TAG, "yxz at USBPort.java open()  ----begin.");
        XLog.d(TAG, "yxz at USBPort.java open() connect to: " + this.mUsbDevice.getDeviceName());
        boolean isConnected = false;
        if (this.mState != 103) {
            this.close();
        }
        if (USBPort.isUsbPrinter(this.mUsbDevice)) {
            isConnected = this.connect();
        } else {
            this.setState(102);
        }
        XLog.d(TAG, "yxz at USBPort.java open()  ----end.");
        return isConnected;
    }

    private boolean connect() {
        XLog.d(TAG, "yxz at USBPort.java connect()  ----begin.");
        boolean hasError = false;
        if (this.mUsbManager.hasPermission(this.mUsbDevice)) {
            XLog.d(TAG, "yxz at USBPort.java connect() usb device has permission.");
            try {
                this.usbInterface = this.mUsbDevice.getInterface(0);
                for (int i = 0; i < this.usbInterface.getEndpointCount(); ++i) {
                    UsbEndpoint ep = this.usbInterface.getEndpoint(i);
                    if (ep.getType() != 2) continue;
                    if (ep.getDirection() == 0) {
                        this.outEndpoint = ep;
                        continue;
                    }
                    if (ep.getDirection() != 128) continue;
                    this.inEndpoint = ep;
                }
                this.connection = this.mUsbManager.openDevice(this.mUsbDevice);
                if (this.connection != null && this.connection.claimInterface(this.usbInterface, true)) {
                    XLog.d(TAG, "yxz at USBPort.java connect() open success.");
                    hasError = false;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            XLog.d(TAG, "yxz at USBPort.java connect() usb device doesn't has permission.");
            hasError = true;
        }
        if (hasError) {
            this.setState(102);
            this.close();
        } else {
            this.setState(101);
        }
        XLog.d(TAG, "yxz at USBPort.java connect()  ----end.");
        return !hasError;
    }

    @Override
    public void close() {
        XLog.d(TAG, "yxz at USBPort.java close()  ----begin.");
        try {
            if (this.connection != null) {
                this.connection.releaseInterface(this.usbInterface);
                this.connection.close();
                this.connection = null;
            }
            if (this.mState != 102) {
                this.setState(103);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        XLog.d(TAG, "yxz at USBPort.java close()  ----end.");
    }

    @Override
    public int write(byte[] srcData) {
        XLog.d(TAG, "yxz at USBPort.java write()  ----begin.");
        int writLen = -1;
        try {
            if (this.connection == null) {
                XLog.e(TAG, "yxz at USBPort.java write()  write failed connection==null");
                return -1;
            }
            writLen = this.connection.bulkTransfer(this.outEndpoint, srcData, srcData.length, TIME_OUT);
        }
        catch (Exception e) {
            XLog.e(TAG, "yxz at USBPort.java write()  Exception write failed");
            e.printStackTrace();
            return -1;
        }
        XLog.d(TAG, "yxz at USBPort.java write()  ----end.");
        return writLen;
    }

    @Override
    public int read(byte[] buffer) {
        XLog.d(TAG, "yxz at USBPort.java read()  ----begin.");
        int readLen = -1;
        if (this.connection == null) {
            XLog.d(TAG, "yxz at USBPort.java read() connection == null.");
            return readLen;
        }
        readLen = this.connection.bulkTransfer(this.inEndpoint, buffer, buffer.length, 100);
        XLog.d(TAG, "yxz at USBPort.java read() read length:" + readLen);
        XLog.d(TAG, "yxz at USBPort.java read()  ----end.");
        return readLen;
    }

    public static boolean isUsbPrinter(UsbDevice device) {
        XLog.d(TAG, "yxz at USBPort.java isUsbPrinter()  ----begin.");
        int vendorId = device.getVendorId();
        int productId = device.getProductId();
        XLog.d(TAG, "yxz at USBPort.java isUsbPrinter() device name: " + device.getDeviceName());
        XLog.d(TAG, "yxz at USBPort.java isUsbPrinter() vid:" + vendorId + "-------pid:" + productId);
        if (1155 == vendorId && 22304 == productId || 1659 == vendorId && 8965 == productId) {
            XLog.d(TAG, "yxz at USBPort.java isUsbPrinter() is SPRT Printer.");
            XLog.d(TAG, "yxz at USBPort.java isUsbPrinter()  ----end.");
            return true;
        }
        XLog.d(TAG, "yxz at USBPort.java isUsbPrinter() is Not SPRT Printer.");
        XLog.d(TAG, "yxz at USBPort.java isUsbPrinter()  ----end.");
        return false;
    }

    private synchronized void setState(int state) {
        XLog.d(TAG, "yxz at USBPort.java setState()  ----begin.");
        XLog.d(TAG, "yxz at USBPort.java setState() " + this.mState + " -> " + state);
        if (this.mState != state) {
            this.mState = state;
            if (this.mHandler != null) {
                this.mHandler.obtainMessage(this.mState).sendToTarget();
            }
        }
        XLog.d(TAG, "yxz at USBPort.java setState()  ----end.");
    }

    @Override
    public boolean open(String host, int port) {
        return false;
    }
}

