/*
 * Decompiled with CFR 0.152.
 */
package com.printer.sdk.serial;

import android.os.Handler;
import com.printer.sdk.BasePrinterPort;
import com.printer.sdk.utils.XLog;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public class SerialPort
implements BasePrinterPort {
    private FileDescriptor mFd;
    private FileInputStream mFileInputStream;
    private FileOutputStream mFileOutputStream;
    private File comDevice;
    private int comBaudrate;
    private int comFlags;
    private int ctsrts;
    private int mState = 103;
    private Handler mHandler;
    private static String TAG = "SerialPort";

    public SerialPort(File device, int baudrate, int flags, int ctsrts, Handler handler) throws SecurityException, IOException {
        this.comDevice = device;
        this.comBaudrate = baudrate;
        this.comFlags = flags;
        this.ctsrts = ctsrts;
        this.mHandler = handler;
        this.mState = 103;
        if (!device.canRead() || !device.canWrite()) {
            try {
                Process su = Runtime.getRuntime().exec("/system/bin/su");
                String cmd = "chmod 777 " + device.getAbsolutePath() + "\nexit\n";
                su.getOutputStream().write(cmd.getBytes());
                if (su.waitFor() != 0 || !device.canRead() || !device.canWrite()) {
                    throw new SecurityException();
                }
            }
            catch (Exception e) {
                device = null;
                this.setState(102);
                e.printStackTrace();
                throw new SecurityException();
            }
        }
    }

    private static native FileDescriptor open(String var0, int var1, int var2, int var3);

    public native void close1();

    @Override
    public boolean open() {
        XLog.d(TAG, "yxz at SerialPort.java open()  ----begin.");
        try {
            if (this.comDevice == null) {
                XLog.d(TAG, "yxz at SerialPort.java open()  comDevice==null.");
                return false;
            }
            this.mFd = SerialPort.open(this.comDevice.getAbsolutePath(), this.comBaudrate, this.comFlags, this.ctsrts);
        }
        catch (Exception e) {
            this.mFd = null;
            XLog.d(TAG, "yxz at SerialPort.java open() Exception e.getMessage:" + e.getMessage());
            e.printStackTrace();
        }
        if (this.mFd == null) {
            XLog.e(TAG, "yxz at SerialPort.java open() native open returns null");
            this.setState(102);
            return false;
        }
        this.mFileInputStream = new FileInputStream(this.mFd);
        this.mFileOutputStream = new FileOutputStream(this.mFd);
        this.setState(101);
        XLog.d(TAG, "yxz at SerialPort.java open()  ----end.");
        return true;
    }

    @Override
    public void close() {
        XLog.d(TAG, "yxz at SerialPort.java close()  ----begin.");
        this.close1();
        this.comDevice = null;
        this.mFileInputStream = null;
        this.mFileOutputStream = null;
        if (this.mState != 102) {
            this.setState(103);
        }
        XLog.d(TAG, "yxz at SerialPort.java close()  ----end.");
    }

    @Override
    public int write(byte[] srcData) {
        XLog.d(TAG, "yxz at SerialPort.java write()  ----begin.");
        if (this.mFileOutputStream == null) {
            XLog.e(TAG, "yxz at SerialPort.java write() mFileOutputStream==null.");
            return -3;
        }
        try {
            this.mFileOutputStream.write(srcData);
            this.mFileOutputStream.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
            XLog.e(TAG, "yxz at SerialPort.java write() write failed. IOEception e.getMessage:" + e.getMessage());
            return -1;
        }
        catch (Exception e) {
            e.printStackTrace();
            XLog.e(TAG, "yxz at SerialPort.java write() write failed. Exception e.getMessage:" + e.getMessage());
            return -2;
        }
        XLog.d(TAG, "yxz at SerialPort.java write()  ----end.");
        return srcData.length;
    }

    @Override
    public int read(byte[] buffer) {
        XLog.d(TAG, "yxz at SerialPort.java read()  ----begin.");
        int readLen = -1;
        if (buffer == null) {
            throw new NullPointerException("yxz at SerialPort.java read() buffer is null!");
        }
        try {
            if (this.mFileInputStream == null) {
                XLog.d(TAG, "yxz at SerialPort.java read() mFileInputStream == null.");
                return readLen;
            }
            readLen = this.mFileInputStream.available();
            if (readLen > 0) {
                this.mFileInputStream.read(buffer);
            }
        }
        catch (IOException e) {
            XLog.e(TAG, "yxz at SerialPort.java read() read error");
            e.printStackTrace();
            return -1;
        }
        XLog.d(TAG, "yxz at SerialPort.java read() read length:" + readLen);
        XLog.d(TAG, "yxz at SerialPort.java read()  ----end.");
        return readLen;
    }

    private synchronized void setState(int state) {
        XLog.d(TAG, "yxz at SerialPort.java setState()  ----begin.");
        XLog.d(TAG, "yxz at SerialPort.java setState() " + this.mState + " -> " + state);
        this.mState = state;
        if (this.mHandler != null) {
            this.mHandler.obtainMessage(this.mState).sendToTarget();
        }
        XLog.d(TAG, "yxz at SerialPort.java setState()  ----end.");
    }

    @Override
    public boolean open(String host, int port) {
        return false;
    }

    static {
        System.loadLibrary("serial_port_sp");
    }
}

