/*
 * Decompiled with CFR 0.152.
 */
package com.printer.sdk.mupdf;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.PointF;
import android.graphics.RectF;
import com.printer.sdk.mupdf.Annotation;
import com.printer.sdk.mupdf.LinkInfo;
import com.printer.sdk.mupdf.MuPDFAlert;
import com.printer.sdk.mupdf.MuPDFAlertInternal;
import com.printer.sdk.mupdf.OutlineItem;
import com.printer.sdk.mupdf.TextChar;
import com.printer.sdk.mupdf.TextWord;
import java.util.ArrayList;

public class MuPDFCore {
    private int numPages = -1;
    private float pageWidth;
    private float pageHeight;
    private long globals;
    private byte[] fileBuffer;
    private String file_format;
    private boolean isUnencryptedPDF;
    private final boolean wasOpenedFromBuffer;

    private native long openFile(String var1);

    private native long openBuffer(String var1);

    private native String fileFormatInternal();

    private native boolean isUnencryptedPDFInternal();

    private native int countPagesInternal();

    private native void gotoPageInternal(int var1);

    private native float getPageWidth();

    private native float getPageHeight();

    private native void drawPage(Bitmap var1, int var2, int var3, int var4, int var5, int var6, int var7, long var8);

    private native void updatePageInternal(Bitmap var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, long var9);

    private native RectF[] searchPage(String var1);

    private native TextChar[][][][] text();

    private native byte[] textAsHtml();

    private native void addMarkupAnnotationInternal(PointF[] var1, int var2);

    private native void addInkAnnotationInternal(PointF[][] var1);

    private native void deleteAnnotationInternal(int var1);

    private native void setFocusedWidgetChoiceSelectedInternal(String[] var1);

    private native String checkFocusedSignatureInternal();

    private native boolean signFocusedSignatureInternal(String var1, String var2);

    private native int setFocusedWidgetTextInternal(String var1);

    private native LinkInfo[] getPageLinksInternal(int var1);

    private native RectF[] getWidgetAreasInternal(int var1);

    private native Annotation[] getAnnotationsInternal(int var1);

    private native OutlineItem[] getOutlineInternal();

    private native boolean hasOutlineInternal();

    private native boolean needsPasswordInternal();

    private native boolean authenticatePasswordInternal(String var1);

    private native MuPDFAlertInternal waitForAlertInternal();

    private native void replyToAlertInternal(MuPDFAlertInternal var1);

    private native void startAlertsInternal();

    private native void stopAlertsInternal();

    private native void destroying();

    private native boolean hasChangesInternal();

    private native void saveInternal();

    private native long createCookie();

    private native void destroyCookie(long var1);

    private native void abortCookie(long var1);

    public native boolean javascriptSupported();

    public MuPDFCore(Context context, String filename) throws Exception {
        this.globals = this.openFile(filename);
        if (this.globals == 0L) {
            throw new Exception("Failed to open " + filename);
        }
        this.file_format = this.fileFormatInternal();
        this.isUnencryptedPDF = this.isUnencryptedPDFInternal();
        this.wasOpenedFromBuffer = false;
    }

    public MuPDFCore(Context context, byte[] buffer, String magic) throws Exception {
        this.fileBuffer = buffer;
        this.globals = this.openBuffer(magic != null ? magic : "");
        if (this.globals <= 0L) {
            throw new Exception("Failed to open " + magic);
        }
        this.file_format = this.fileFormatInternal();
        this.isUnencryptedPDF = this.isUnencryptedPDFInternal();
        this.wasOpenedFromBuffer = true;
    }

    public int countPages() {
        if (this.numPages < 0) {
            this.numPages = this.countPagesSynchronized();
        }
        return this.numPages;
    }

    public String fileFormat() {
        return this.file_format;
    }

    public boolean isUnencryptedPDF() {
        return this.isUnencryptedPDF;
    }

    public boolean wasOpenedFromBuffer() {
        return this.wasOpenedFromBuffer;
    }

    private synchronized int countPagesSynchronized() {
        return this.countPagesInternal();
    }

    private void gotoPage(int page) {
        if (page > this.numPages - 1) {
            page = this.numPages - 1;
        } else if (page < 0) {
            page = 0;
        }
        this.gotoPageInternal(page);
        this.pageWidth = this.getPageWidth();
        this.pageHeight = this.getPageHeight();
    }

    public synchronized PointF getPageSize(int page) {
        this.gotoPage(page);
        return new PointF(this.pageWidth, this.pageHeight);
    }

    public MuPDFAlert waitForAlert() {
        MuPDFAlertInternal alert = this.waitForAlertInternal();
        return alert != null ? alert.toAlert() : null;
    }

    public void replyToAlert(MuPDFAlert alert) {
        this.replyToAlertInternal(new MuPDFAlertInternal(alert));
    }

    public void stopAlerts() {
        this.stopAlertsInternal();
    }

    public void startAlerts() {
        this.startAlertsInternal();
    }

    public synchronized void onDestroy() {
        this.destroying();
        this.globals = 0L;
    }

    public synchronized void drawPage(int page, Bitmap bm, int pageW, int pageH, int patchX, int patchY, int patchW, int patchH) {
        this.gotoPage(page);
        this.drawPage(bm, pageW, pageH, patchX, patchY, patchW, patchH, 0L);
    }

    public synchronized void updatePage(Bitmap bm, int page, int pageW, int pageH, int patchX, int patchY, int patchW, int patchH, Cookie cookie) {
        this.updatePageInternal(bm, page, pageW, pageH, patchX, patchY, patchW, patchH, cookie.cookiePtr);
    }

    public synchronized boolean setFocusedWidgetText(int page, String text) {
        this.gotoPage(page);
        boolean success = this.setFocusedWidgetTextInternal(text) != 0;
        return success;
    }

    public synchronized void setFocusedWidgetChoiceSelected(String[] selected) {
        this.setFocusedWidgetChoiceSelectedInternal(selected);
    }

    public synchronized String checkFocusedSignature() {
        return this.checkFocusedSignatureInternal();
    }

    public synchronized boolean signFocusedSignature(String keyFile, String password) {
        return this.signFocusedSignatureInternal(keyFile, password);
    }

    public synchronized LinkInfo[] getPageLinks(int page) {
        return this.getPageLinksInternal(page);
    }

    public synchronized RectF[] getWidgetAreas(int page) {
        return this.getWidgetAreasInternal(page);
    }

    public synchronized Annotation[] getAnnoations(int page) {
        return this.getAnnotationsInternal(page);
    }

    public synchronized RectF[] searchPage(int page, String text) {
        this.gotoPage(page);
        return this.searchPage(text);
    }

    public synchronized byte[] html(int page) {
        this.gotoPage(page);
        return this.textAsHtml();
    }

    public synchronized TextWord[][] textLines(int page) {
        this.gotoPage(page);
        TextChar[][][][] chars = this.text();
        ArrayList<TextWord[]> lns = new ArrayList<TextWord[]>();
        for (TextChar[][][] bl : chars) {
            if (bl == null) continue;
            for (TextChar[][] ln : bl) {
                ArrayList<TextWord> wds = new ArrayList<TextWord>();
                TextWord wd = new TextWord();
                TextChar[][] textCharArray = ln;
                int n = textCharArray.length;
                for (int i = 0; i < n; ++i) {
                    TextChar[] sp;
                    for (TextChar tc : sp = textCharArray[i]) {
                        if (tc.c != ' ') {
                            wd.Add(tc);
                            continue;
                        }
                        if (wd.w.length() <= 0) continue;
                        wds.add(wd);
                        wd = new TextWord();
                    }
                }
                if (wd.w.length() > 0) {
                    wds.add(wd);
                }
                if (wds.size() <= 0) continue;
                lns.add(wds.toArray(new TextWord[wds.size()]));
            }
        }
        return (TextWord[][])lns.toArray((T[])new TextWord[lns.size()][]);
    }

    public synchronized void addMarkupAnnotation(int page, PointF[] quadPoints, Annotation.Type type) {
        this.gotoPage(page);
        this.addMarkupAnnotationInternal(quadPoints, type.ordinal());
    }

    public synchronized void addInkAnnotation(int page, PointF[][] arcs) {
        this.gotoPage(page);
        this.addInkAnnotationInternal(arcs);
    }

    public synchronized void deleteAnnotation(int page, int annot_index) {
        this.gotoPage(page);
        this.deleteAnnotationInternal(annot_index);
    }

    public synchronized boolean hasOutline() {
        return this.hasOutlineInternal();
    }

    public synchronized OutlineItem[] getOutline() {
        return this.getOutlineInternal();
    }

    public synchronized boolean needsPassword() {
        return this.needsPasswordInternal();
    }

    public synchronized boolean authenticatePassword(String password) {
        return this.authenticatePasswordInternal(password);
    }

    public synchronized boolean hasChanges() {
        return this.hasChangesInternal();
    }

    public synchronized void save() {
        this.saveInternal();
    }

    static {
        System.loadLibrary("mupdf");
    }

    public class Cookie {
        private final long cookiePtr;

        public Cookie() {
            this.cookiePtr = MuPDFCore.this.createCookie();
            if (this.cookiePtr == 0L) {
                throw new OutOfMemoryError();
            }
        }

        public void abort() {
            MuPDFCore.this.abortCookie(this.cookiePtr);
        }

        public void destroy() {
            MuPDFCore.this.destroyCookie(this.cookiePtr);
        }
    }
}

