/*
 * Decompiled with CFR 0.152.
 */
package com.printer.sdk.monochrome;

import android.app.ProgressDialog;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Color;
import android.os.AsyncTask;
import android.os.Environment;
import android.util.Log;
import android.widget.Toast;
import com.printer.sdk.monochrome.BMPFile;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class BitmapConvertor {
    private int mDataWidth;
    private byte[] mRawBitmapData;
    private byte[] mDataArray;
    private static final String TAG = "BitmapConvertor";
    private ProgressDialog mPd;
    private Context mContext;
    private int mWidth;
    private int mHeight;
    private String mStatus;
    private String mFileName;
    private File file = null;
    private static final String SAVE_PIC_PATH = Environment.getExternalStorageState().equalsIgnoreCase("mounted") ? Environment.getExternalStorageDirectory().getAbsolutePath() : "/mnt/sdcard";
    private static final String SAVA_REAL_PATH = SAVE_PIC_PATH + "/good/savaPic";

    public BitmapConvertor(Context context) {
        this.mContext = context;
    }

    public Bitmap convertBitmap(Bitmap inputBitmap) {
        Bitmap bitmap = null;
        this.mWidth = inputBitmap.getWidth();
        this.mHeight = inputBitmap.getHeight();
        this.mFileName = "my_monochrome_image";
        this.mDataWidth = (this.mWidth + 31) / 32 * 4 * 8;
        this.mDataArray = new byte[this.mDataWidth * this.mHeight];
        this.mRawBitmapData = new byte[this.mDataWidth * this.mHeight / 8];
        this.convertArgbToGrayscale(inputBitmap, this.mWidth, this.mHeight);
        this.createRawMonochromeData();
        this.mStatus = this.saveImage(this.mFileName, this.mWidth, this.mHeight);
        Log.i((String)TAG, (String)("mStatus:" + this.mStatus));
        if (this.mStatus == "Success") {
            bitmap = BitmapConvertor.getmonoChromeImage(this.file.getPath());
        }
        return bitmap;
    }

    private void convertArgbToGrayscale(Bitmap bmpOriginal, int width, int height) {
        int k = 0;
        int B = 0;
        int G = 0;
        int R = 0;
        try {
            for (int x = 0; x < height; ++x) {
                int y = 0;
                while (y < width) {
                    int pixel = bmpOriginal.getPixel(y, x);
                    R = Color.red((int)pixel);
                    G = Color.green((int)pixel);
                    B = Color.blue((int)pixel);
                    G = B = (int)(0.299 * (double)R + 0.587 * (double)G + 0.114 * (double)B);
                    R = B;
                    this.mDataArray[k] = R < 128 ? (byte)0 : 1;
                    ++y;
                    ++k;
                }
                if (this.mDataWidth <= width) continue;
                int p = width;
                while (p < this.mDataWidth) {
                    this.mDataArray[k] = 1;
                    ++p;
                    ++k;
                }
            }
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)e.toString());
        }
    }

    private void createRawMonochromeData() {
        int length = 0;
        for (int i = 0; i < this.mDataArray.length; i += 8) {
            byte first = this.mDataArray[i];
            for (int j = 0; j < 7; ++j) {
                byte second;
                first = second = (byte)(first << 1 | this.mDataArray[i + j]);
            }
            this.mRawBitmapData[length] = first;
            ++length;
        }
    }

    private String saveImage(String fileName, int width, int height) {
        FileOutputStream fileOutputStream;
        BMPFile bmpFile = new BMPFile();
        String PATH_LOGCAT = null;
        PATH_LOGCAT = Environment.getExternalStorageState().equals("mounted") ? Environment.getExternalStorageDirectory().getAbsolutePath() + File.separator + "Logs" : this.mContext.getFilesDir().getAbsolutePath() + File.separator + "Logs";
        File dir = new File(PATH_LOGCAT);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        this.file = new File(PATH_LOGCAT, fileName + ".bmp");
        Log.i((String)"fdh", (String)this.file.getPath());
        try {
            this.file.createNewFile();
            fileOutputStream = new FileOutputStream(this.file);
        }
        catch (IOException e) {
            e.printStackTrace();
            return "Memory Access Denied";
        }
        catch (Exception e) {
            e.printStackTrace();
            return "Memory Access Denied";
        }
        bmpFile.saveBitmap(fileOutputStream, this.mRawBitmapData, width, height);
        return "Success";
    }

    public static Bitmap getmonoChromeImage(String filePath) {
        FileInputStream is = null;
        try {
            is = new FileInputStream(filePath);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        return BitmapFactory.decodeStream((InputStream)is);
    }

    class ConvertInBackground
    extends AsyncTask<Bitmap, String, Void> {
        ConvertInBackground() {
        }

        protected Void doInBackground(Bitmap ... params) {
            BitmapConvertor.this.convertArgbToGrayscale(params[0], BitmapConvertor.this.mWidth, BitmapConvertor.this.mHeight);
            BitmapConvertor.this.createRawMonochromeData();
            BitmapConvertor.this.mStatus = BitmapConvertor.this.saveImage(BitmapConvertor.this.mFileName, BitmapConvertor.this.mWidth, BitmapConvertor.this.mHeight);
            Log.i((String)BitmapConvertor.TAG, (String)("mStatus:" + BitmapConvertor.this.mStatus));
            return null;
        }

        protected void onPostExecute(Void result) {
            BitmapConvertor.this.mPd.dismiss();
            Toast.makeText((Context)BitmapConvertor.this.mContext, (CharSequence)"Monochrome bitmap created successfully. Please check in sdcard", (int)1).show();
            Bitmap bitmap = BitmapConvertor.getmonoChromeImage(BitmapConvertor.this.file.getPath());
            Log.i((String)BitmapConvertor.TAG, (String)("bitmap:" + bitmap));
        }

        protected void onPreExecute() {
            BitmapConvertor.this.mPd = ProgressDialog.show((Context)BitmapConvertor.this.mContext, (CharSequence)"Converting Image", (CharSequence)"Please Wait", (boolean)true, (boolean)false, null);
        }
    }
}

