/*
 * Decompiled with CFR 0.152.
 */
package com.printer.sdk.bluetooth;

import android.annotation.SuppressLint;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothSocket;
import android.os.Build;
import android.os.Handler;
import com.printer.sdk.BasePrinterPort;
import com.printer.sdk.utils.XLog;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.UUID;

public class BluetoothPort
implements BasePrinterPort {
    private static final String TAG = "BluetoothPort";
    private BluetoothSocket mSocket;
    private BluetoothAdapter mAdapter;
    private static InputStream inputStream;
    private static OutputStream outputStream;
    private Handler mHandler;
    private int mState;
    private BluetoothDevice mDevice;
    private final UUID PRINTER_UUID = UUID.fromString("00001101-0000-1000-8000-00805f9b34fb");

    public BluetoothPort(BluetoothDevice bluetoothDevice, Handler handler) {
        this.mHandler = handler;
        this.mDevice = bluetoothDevice;
        this.mAdapter = BluetoothAdapter.getDefaultAdapter();
        this.mState = 103;
    }

    public BluetoothPort(String address, Handler handler) {
        this.mHandler = handler;
        this.mAdapter = BluetoothAdapter.getDefaultAdapter();
        this.mDevice = this.mAdapter.getRemoteDevice(address);
        this.mState = 103;
    }

    @Override
    public boolean open() {
        XLog.d(TAG, "yxz at BluetoothPort.java open()  ----begin");
        boolean isConneted = false;
        XLog.d(TAG, "yxz at BluetoothPort.java open() connect to: " + this.mDevice.getName());
        if (this.mState != 103) {
            this.close();
        }
        isConneted = this.connect2Device();
        XLog.d(TAG, "yxz at BluetoothPort.java open()  ----end");
        return isConneted;
    }

    @SuppressLint(value={"NewApi"})
    private boolean connect2Device() {
        XLog.d(TAG, "yxz at BluetoothPort.java connect2Device()  ----begin");
        boolean hasError = false;
        if (this.mAdapter.isDiscovering()) {
            this.mAdapter.cancelDiscovery();
        }
        try {
            this.mSocket = this.mDevice.createRfcommSocketToServiceRecord(this.PRINTER_UUID);
            this.mSocket.connect();
        }
        catch (IOException e) {
            XLog.d(TAG, "yxz at BluetoothPort.java connect2Device() ConnectThread failed. retry.");
            XLog.d(TAG, "yxz at BluetoothPort.java connect2Device() IOException e.getMessage" + e.getMessage());
            e.printStackTrace();
            try {
                if (this.mSocket != null) {
                    this.mSocket.close();
                }
                Thread.sleep(2000L);
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            catch (InterruptedException e1) {
                e1.printStackTrace();
            }
            hasError = this.ReTryConnect();
        }
        catch (Exception e) {
            XLog.d(TAG, "yxz at BluetoothPort.java connect2Device() Exception e.getMessage" + e.getMessage());
            try {
                if (this.mSocket != null) {
                    this.mSocket.close();
                }
                Thread.sleep(2000L);
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            catch (InterruptedException e1) {
                e1.printStackTrace();
            }
            hasError = this.ReTryConnect();
        }
        if (!hasError) {
            try {
                inputStream = this.mSocket.getInputStream();
                outputStream = this.mSocket.getOutputStream();
            }
            catch (IOException e) {
                hasError = true;
                XLog.e(TAG, "yxz at BluetoothPort.java connect2Device() Get Stream failed");
                e.printStackTrace();
            }
        }
        if (hasError) {
            this.setState(102);
            this.close();
        } else {
            this.setState(101);
        }
        XLog.d(TAG, "yxz at BluetoothPort.java connect2Device()  ----end");
        return !hasError;
    }

    @Override
    public void close() {
        XLog.d(TAG, "yxz at BluetoothPort.java close()  ----begin.");
        try {
            if (this.mSocket != null) {
                this.mSocket.close();
            }
            if (outputStream != null) {
                outputStream.close();
            }
            if (inputStream != null) {
                inputStream.close();
            }
        }
        catch (IOException e) {
            XLog.e(TAG, "yxz at BluetoothPort.java close() close socket failed");
            e.printStackTrace();
        }
        this.mDevice = null;
        this.mSocket = null;
        outputStream = null;
        inputStream = null;
        if (this.mState != 102) {
            this.setState(103);
        }
        XLog.d(TAG, "yxz at BluetoothPort.java close()  ----end.");
    }

    @Override
    public int write(byte[] srcData) {
        XLog.d(TAG, "yxz at BluetoothPort.java write()  ----begin.");
        try {
            if (outputStream == null) {
                XLog.e(TAG, "yxz at BluetoothPort.java write()  outputStream is null.");
                return -3;
            }
            outputStream.write(srcData);
            outputStream.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
            XLog.e(TAG, "yxz at BluetoothPort.java write() IOException write error.");
            return -1;
        }
        catch (Exception e) {
            XLog.e(TAG, "yxz at BluetoothPort.java write() Exception write error.");
            e.printStackTrace();
            return -2;
        }
        XLog.d(TAG, "yxz at BluetoothPort.java write()  ----end.");
        return srcData.length;
    }

    @Override
    public int read(byte[] buffer) {
        XLog.d(TAG, "yxz at BluetoothPort.java read()  ----begin.");
        int readLen = -1;
        try {
            if (inputStream != null && (readLen = inputStream.available()) > 0) {
                inputStream.read(buffer);
            }
        }
        catch (IOException e) {
            XLog.e(TAG, "yxz at BluetoothPort.java write() IOException read error.");
            e.printStackTrace();
            return -1;
        }
        catch (Exception e) {
            XLog.e(TAG, "yxz at BluetoothPort.java write() Exception read error.");
            e.printStackTrace();
            return -1;
        }
        XLog.d(TAG, "yxz at BluetoothPort.java read() read length:" + readLen);
        XLog.d(TAG, "yxz at BluetoothPort.java read()  ----end.");
        return readLen;
    }

    public int read(int timeout, byte[] buffer) {
        int readLen = -1;
        try {
            while ((readLen = inputStream.available()) <= 0 && (timeout -= 50) > 0) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e1) {
                    e1.printStackTrace();
                }
            }
            if (readLen > 0) {
                buffer = new byte[readLen];
                inputStream.read(buffer);
            }
        }
        catch (IOException e) {
            XLog.e(TAG, "read error1");
            e.printStackTrace();
        }
        return readLen;
    }

    @SuppressLint(value={"NewApi"})
    private boolean ReTryConnect() {
        XLog.d(TAG, "yxz at BluetoothPort.java RetryConnect()  ----begin");
        XLog.d(TAG, "yxz at BluetoothPort.java RetryConnect() android SDK version is:" + Build.VERSION.SDK_INT);
        try {
            if (Build.VERSION.SDK_INT >= 10) {
                this.mSocket = this.mDevice.createInsecureRfcommSocketToServiceRecord(this.PRINTER_UUID);
            } else {
                Method method = this.mDevice.getClass().getMethod("createRfcommSocket", Integer.TYPE);
                this.mSocket = (BluetoothSocket)method.invoke((Object)this.mDevice, 1);
            }
            this.mSocket.connect();
        }
        catch (Exception e) {
            XLog.e(TAG, "yxz at BluetoothPort.java RetryConnect() connect failed");
            if (this.mSocket != null) {
                try {
                    this.mSocket.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
            e.printStackTrace();
            return true;
        }
        return false;
    }

    private synchronized void setState(int state) {
        XLog.d(TAG, "yxz at BluetoothPort.java setState()  ----begin.");
        XLog.d(TAG, "yxz at BluetoothPort.java setState() " + this.mState + " -> " + state);
        if (this.mState != state) {
            this.mState = state;
            if (this.mHandler != null) {
                this.mHandler.obtainMessage(this.mState).sendToTarget();
            }
        }
        XLog.d(TAG, "yxz at BluetoothPort.java setState()  ----end.");
    }

    @Override
    public boolean open(String host, int port) {
        return false;
    }

    public boolean verifyEncryption(String mac) {
        block9: {
            byte[] tmpData = null;
            int receiveLength = 0;
            try {
                byte[] tmpSend = new byte[]{29, 31, 0};
                int writeLen = this.write(tmpSend);
                if (writeLen <= 0) break block9;
                XLog.d(TAG, "writeLenth length is : " + writeLen);
                Thread.sleep(200L);
                byte[] buffer = new byte[4];
                receiveLength = this.read(buffer);
                int testTime = 15;
                while (receiveLength <= 0 && testTime-- > 0) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e1) {
                        e1.printStackTrace();
                    }
                    receiveLength = this.read(buffer);
                    XLog.d(TAG, "receiveStream length is : " + receiveLength);
                    for (int i = 0; i < receiveLength; ++i) {
                        XLog.i(TAG, "buffer[ : " + i + "]" + buffer[i]);
                    }
                }
                if (receiveLength <= 0) {
                    return false;
                }
                tmpData = buffer;
                mac = mac.replaceAll(":", "").toUpperCase();
                char[] tmpChar = mac.toCharArray();
                int CheckSum = 0;
                XLog.d(TAG, "btDevice.getAddress() is : " + mac);
                for (int i = 0; i < 12; ++i) {
                    CheckSum += tmpChar[i] << 8 * (i % 4);
                }
                XLog.d(TAG, "CheckSum is : " + CheckSum);
                XLog.d(TAG, "CheckSum is(after ..) : " + (CheckSum ^= 0x53505254));
                byte[] tmpResult = new byte[4];
                for (int j = 0; j < 4; ++j) {
                    tmpResult[j] = (byte)(CheckSum >> (3 - j) * 8);
                }
                XLog.d(TAG, "receive tmpData[0] is : " + tmpData[0] + ", self tmpResult[0] is: " + tmpResult[0]);
                return tmpData[0] == tmpResult[0] && tmpData[1] == tmpResult[1] && tmpData[2] == tmpResult[2] && tmpData[3] == tmpResult[3];
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return false;
    }
}

