/*
 * Decompiled with CFR 0.152.
 */
package com.printer.sdk.aidl;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Log;
import com.printer.sdk.BasePrinterPort;
import com.printer.sdk.listener.OnPrintListener;
import com.printer.sdk.utils.XLog;
import com.sprt.yxz.printservice.ui.PrintInterface;

public class AIDLPort
implements BasePrinterPort {
    private Context mContext;
    private static final String TAG = "yxz";
    public static boolean isBind = false;
    OnPrintListener printListener;
    private PrintInterface printInterface;
    private ServiceConnection mConnection = new ServiceConnection(){

        public void onServiceConnected(ComponentName name, IBinder service) {
            Log.i((String)AIDLPort.TAG, (String)"\u5ba2\u6237\u7aef yxz at AIDLPort.java onServiceConnected()");
            isBind = true;
            AIDLPort.this.printInterface = PrintInterface.Stub.asInterface(service);
        }

        public void onServiceDisconnected(ComponentName name) {
            XLog.i(AIDLPort.TAG, "\u5ba2\u6237\u7aef yxz at AIDLPort.java onServiceDisconnected()\u5f02\u5e38\u65ad\u5f00\uff0c\u91cd\u65b0bind\u8fdc\u7a0bService");
            isBind = false;
            if (AIDLPort.this.open()) {
                XLog.i(AIDLPort.TAG, "\u91cd\u65b0bind\u8fdc\u7a0bService\u6210\u529f");
            }
        }
    };

    public AIDLPort(Context context) {
        this.mContext = context;
    }

    @Override
    public boolean open() {
        if (isBind) {
            XLog.e(TAG, "\u5ba2\u6237\u7aef yxz at AIDLPort.java open() isBind==true,\u5df2\u7ed1\u5b9a\u5230Service\uff0c\u65e0\u9700\u518d\u6b21\u7ed1\u5b9a");
            return true;
        }
        isBind = this.bindAIDLService();
        return isBind;
    }

    @Override
    public boolean open(String host, int port) {
        return false;
    }

    @Override
    public void close() {
        this.unBindAIDLService();
    }

    @Override
    public int write(byte[] srcData) {
        if (!isBind) {
            XLog.e(TAG, "\u5ba2\u6237\u7aef yxz at AIDLPort.java write() isBind==false,\u672a\u7ed1\u5b9aAIDL");
            return -101;
        }
        try {
            return this.printInterface.sendBytesDataAIDL(srcData, 2);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return -103;
        }
    }

    @Override
    public int read(byte[] buffer) {
        if (!isBind) {
            XLog.e(TAG, "\u5ba2\u6237\u7aef yxz at AIDLPort.java read() isBind==false,\u672a\u7ed1\u5b9aAIDL");
            return -101;
        }
        try {
            return this.printInterface.readAIDL(buffer, 130);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return -103;
        }
    }

    public boolean bindAIDLService() {
        try {
            Intent i = new Intent();
            i.setComponent(new ComponentName("com.sprt.yxz.printservice.ui", "com.sprt.yxz.printservice.service.PrintService"));
            return this.mContext.bindService(i, this.mConnection, 1);
        }
        catch (Exception e) {
            XLog.e(TAG, "bindAIDLService().java \u5f02\u5e38\uff1a" + e.getMessage());
            return false;
        }
    }

    public void unBindAIDLService() {
        if (!isBind) {
            XLog.e(TAG, "\u5ba2\u6237\u7aef yxz at AIDLPort.java unBindAIDLService() isBind==false,\u5f53\u524d\u672a\u7ed1\u5b9a\u5230Service\uff0c\u65e0\u9700\u89e3\u9664\u7ed1\u5b9a");
            return;
        }
        this.mContext.unbindService(this.mConnection);
        isBind = false;
    }

    public void isSetAble(boolean isSetable) {
        if (!isBind) {
            XLog.e(TAG, "\u5ba2\u6237\u7aef yxz at AIDLPort.java isSetAble() isBind==false,\u672a\u7ed1\u5b9aAIDL");
            return;
        }
        if (this.printInterface == null) {
            XLog.e(TAG, "\u5ba2\u6237\u7aef yxz at AIDLPort.java isSetAble() printInterface==null");
            return;
        }
        XLog.d(TAG, "\u5ba2\u6237\u7aef yxz at AIDLPort.java isSetAble() printInterface!=null");
        try {
            this.printInterface.isSetable(isSetable);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            XLog.e(TAG, "\u5ba2\u6237\u7aef yxz at AIDLPort.java isSetAble() RemoteException");
        }
    }

    public boolean getSetAble() {
        if (!isBind) {
            XLog.e(TAG, "\u5ba2\u6237\u7aef yxz at AIDLPort.java getSetAble() isBind==false,\u672a\u7ed1\u5b9aAIDL");
            return false;
        }
        if (this.printInterface == null) {
            XLog.e(TAG, "\u5ba2\u6237\u7aef yxz at AIDLPort.java getSetAble() printInterface==null");
            return false;
        }
        XLog.d(TAG, "\u5ba2\u6237\u7aef yxz at AIDLPort.java getSetAble() printInterface!=null");
        try {
            return this.printInterface.getSetable();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            XLog.e(TAG, "\u5ba2\u6237\u7aef yxz at AIDLPort.java isSetAble() RemoteException");
            return false;
        }
    }

    public void setOnPrintListener(OnPrintListener listener) {
        this.printListener = listener;
    }

    public boolean doBeforePrint() {
        if (this.printListener != null) {
            this.printListener.doBeforePrint();
            return false;
        }
        return true;
    }

    public boolean doAfterPrint() {
        if (this.printListener != null) {
            this.printListener.doAfterPrint();
            return false;
        }
        return true;
    }

    public boolean doOnReceiveParserdata(int type, byte[] data) {
        if (this.printListener != null) {
            this.printListener.onReceiveParserData(type, data);
            return false;
        }
        return true;
    }
}

