/*
 * Decompiled with CFR 0.152.
 */
package com.printer.sdk;

import android.annotation.SuppressLint;
import android.bluetooth.BluetoothDevice;
import android.content.Context;
import android.graphics.Bitmap;
import android.hardware.usb.UsbDevice;
import android.os.Handler;
import com.printer.sdk.Barcode;
import com.printer.sdk.BasePrinterPort;
import com.printer.sdk.LabelPrint;
import com.printer.sdk.PrinterConstants;
import com.printer.sdk.Table;
import com.printer.sdk.aidl.AIDLPort;
import com.printer.sdk.application.MyApplication;
import com.printer.sdk.bluetooth.BluetoothPort;
import com.printer.sdk.exception.ParameterErrorException;
import com.printer.sdk.exception.PrinterPortNullException;
import com.printer.sdk.exception.ReadException;
import com.printer.sdk.exception.WriteException;
import com.printer.sdk.listener.OnPrintListener;
import com.printer.sdk.serial.SerialPort;
import com.printer.sdk.usb.USBPort;
import com.printer.sdk.utils.Utils;
import com.printer.sdk.utils.XLog;
import com.printer.sdk.wifi.WiFiPort;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Map;

public class PrinterInstance {
    private static final String TAG = "PrinterInstance";
    private static BasePrinterPort myPrinterPort;
    private String charsetName = "gb18030";
    public static PrinterInstance mPrinter;
    private MyApplication myApplication;
    int paperWidth;
    int mLineWidth;
    int paperWidthTSPL;
    int paperHeightTSPL;

    private PrinterInstance() {
        XLog.setLEVEL(XLog.DEBUG);
        this.paperWidth = 576;
        this.mLineWidth = 0;
        this.paperWidthTSPL = 440;
        this.paperHeightTSPL = 1500;
        this.myApplication = MyApplication.getApplication();
        myPrinterPort = new AIDLPort((Context)this.myApplication);
    }

    public static synchronized PrinterInstance getPrinterInstance() {
        if (mPrinter == null) {
            mPrinter = new PrinterInstance();
        }
        return mPrinter;
    }

    private PrinterInstance(BluetoothDevice mdevices, Handler handler) {
        XLog.setLEVEL(XLog.DEBUG);
        this.paperWidth = 576;
        this.mLineWidth = 0;
        this.paperWidthTSPL = 440;
        this.paperHeightTSPL = 1500;
        myPrinterPort = new BluetoothPort(mdevices, handler);
    }

    public static synchronized PrinterInstance getPrinterInstance(BluetoothDevice bthDevice, Handler handler) {
        if (mPrinter == null) {
            mPrinter = new PrinterInstance(bthDevice, handler);
        }
        return mPrinter;
    }

    private PrinterInstance(Context context, UsbDevice usbDevice, Handler handler) {
        XLog.setLEVEL(XLog.DEBUG);
        this.paperWidth = 576;
        this.mLineWidth = 0;
        this.paperWidthTSPL = 440;
        this.paperHeightTSPL = 1500;
        myPrinterPort = new USBPort(context, usbDevice, handler);
    }

    public static synchronized PrinterInstance getPrinterInstance(Context context, UsbDevice usbDevice, Handler handler) {
        if (mPrinter == null) {
            mPrinter = new PrinterInstance(context, usbDevice, handler);
        }
        return mPrinter;
    }

    private PrinterInstance(String ipAddress, int portNumber, Handler handler) {
        XLog.setLEVEL(XLog.DEBUG);
        this.paperWidth = 576;
        this.mLineWidth = 0;
        this.paperWidthTSPL = 440;
        this.paperHeightTSPL = 1500;
        myPrinterPort = new WiFiPort(ipAddress, portNumber, handler);
    }

    public static synchronized PrinterInstance getPrinterInstance(String ipAddress, int portNumber, Handler handler) {
        if (mPrinter == null) {
            mPrinter = new PrinterInstance(ipAddress, portNumber, handler);
        }
        return mPrinter;
    }

    public PrinterInstance(File device, int baudrate, int flags, int ctsrts, Handler handler) {
        XLog.setLEVEL(XLog.DEBUG);
        this.paperWidth = 576;
        this.mLineWidth = 0;
        this.paperWidthTSPL = 440;
        this.paperHeightTSPL = 1500;
        try {
            myPrinterPort = new SerialPort(device, baudrate, flags, ctsrts, handler);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static synchronized PrinterInstance getPrinterInstance(File device, int baudrate, int flags, int ctsrts, Handler handler) {
        if (mPrinter == null) {
            mPrinter = new PrinterInstance(device, baudrate, flags, ctsrts, handler);
        }
        return mPrinter;
    }

    public boolean openConnection() {
        XLog.d(TAG, "yxz at PrinterInstance.java openConnection()  ----begin");
        boolean isConnected = false;
        if (myPrinterPort == null) {
            XLog.e(TAG, "yxz at PrinterInstance.java openConnection() no init the printer and myPrinterPort is null");
            return false;
        }
        if (myPrinterPort instanceof AIDLPort) {
            // empty if block
        }
        if (!(isConnected = myPrinterPort.open())) {
            mPrinter = null;
        }
        XLog.e(TAG, "yxz at PrinterInstance.java openConnection() ----end");
        return isConnected;
    }

    public void closeConnection() {
        if (myPrinterPort == null) {
            XLog.e("printer", "close failed! myPrinterPort is null");
        } else {
            myPrinterPort.close();
        }
        mPrinter = null;
    }

    public int sendBytesData(byte[] srcData) {
        XLog.v(TAG, "" + Utils.bytesToHexString(srcData, srcData.length));
        XLog.d(TAG, "yxz at PrinterInstance.java sendBytesData() -------begin");
        if (myPrinterPort == null) {
            XLog.e(TAG, "yxz at PrinterInstance.java sendBytesData() sendBytesData failed! myPrinterPort is null");
            return -1;
        }
        if (srcData == null || srcData.length == 0) {
            XLog.e(TAG, "yxz at PrinterInstance.java sendBytesData() sendBytesData failed! srcData is null or srcData has no srcData!");
            return -2;
        }
        if (myPrinterPort instanceof SerialPort) {
            int packetSize = 512;
            int num = srcData.length / packetSize;
            byte[] pack = new byte[packetSize];
            byte[] temp = new byte[srcData.length - packetSize * num];
            if (num >= 1) {
                for (int i = 0; i <= num - 1; ++i) {
                    System.arraycopy(srcData, i * packetSize, pack, 0, packetSize);
                    myPrinterPort.write(pack);
                    try {
                        Thread.sleep(20L);
                        continue;
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                System.arraycopy(srcData, num * packetSize, temp, 0, srcData.length - packetSize * num);
                if (myPrinterPort.write(temp) < 0) {
                    XLog.e(TAG, "yxz at PrinterInstance.java sendBytesData() sendBytesData failed! \u7b2c" + num + "\u5305\u53d1\u9001\u5931\u8d25");
                    return -3;
                }
            } else if (myPrinterPort.write(srcData) < 0) {
                XLog.e(TAG, "yxz at PrinterInstance.java sendBytesData() sendBytesData failed! SerialPort \u7b2c" + num + "\u5305\u53d1\u9001\u5931\u8d25");
                return -3;
            }
        } else if (myPrinterPort instanceof USBPort || myPrinterPort instanceof AIDLPort) {
            int packetSize = 16384;
            int num = srcData.length / packetSize;
            byte[] pack = new byte[packetSize];
            byte[] temp = new byte[srcData.length - packetSize * num];
            if (num >= 1) {
                for (int i = 0; i <= num - 1; ++i) {
                    System.arraycopy(srcData, i * packetSize, pack, 0, packetSize);
                    myPrinterPort.write(pack);
                    try {
                        Thread.sleep(5L);
                        continue;
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                System.arraycopy(srcData, num * packetSize, temp, 0, srcData.length - packetSize * num);
                if (myPrinterPort.write(temp) < 0) {
                    XLog.e(TAG, "yxz at PrinterInstance.java sendBytesData() sendBytesData failed! USBPort \u7b2c" + num + "\u5305\u53d1\u9001\u5931\u8d25");
                    return -3;
                }
            } else if (myPrinterPort.write(srcData) < 0) {
                XLog.e(TAG, "yxz at PrinterInstance.java sendBytesData() sendBytesData failed! USBPort \u7b2c" + num + "\u5305\u53d1\u9001\u5931\u8d25");
                return -3;
            }
        } else if (myPrinterPort.write(srcData) < 0) {
            XLog.e(TAG, "yxz at PrinterInstance.java sendBytesData() sendBytesData failed! BluetoothPort|WifiPort\u53d1\u9001\u5931\u8d25");
            return -3;
        }
        XLog.d(TAG, "yxz at PrinterInstance.java sendBytesData() sendBytesData success!");
        XLog.d(TAG, "yxz at PrinterInstance.java sendBytesData() -------end");
        return srcData.length;
    }

    public int read(byte[] buffer) {
        XLog.d(TAG, "yxz at PrinterInstance.java read() -------begin");
        if (myPrinterPort == null) {
            XLog.e(TAG, "yxz at PrinterInstance.java read() sendBytesData failed! myPrinterPort is null");
            return -1;
        }
        if (buffer == null || buffer.length == 0) {
            XLog.e(TAG, "yxz at PrinterInstance.java read() sendBytesData failed! buffer == null || buffer.length == 0");
            return -2;
        }
        XLog.d(TAG, "yxz at PrinterInstance.java read() -------end");
        return myPrinterPort.read(buffer);
    }

    public int printText(String content) {
        XLog.v(TAG, content);
        byte[] data = null;
        try {
            data = this.charsetName != "" ? content.getBytes(this.charsetName) : content.getBytes("gbk");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            data = content.getBytes();
        }
        int result = this.sendBytesData(data);
        return result;
    }

    public void printImage(Bitmap bitmap, PrinterConstants.PAlign alignType, int left, boolean isCompressed) {
        if (isCompressed) {
            this.sendBytesData(Utils.compressBitmap2PrinterBytes(bitmap, alignType, left));
        } else {
            this.sendBytesData(Utils.bitmap2PrinterBytes(bitmap, alignType, left));
        }
    }

    public void printImage(Bitmap bitmap, PrinterConstants.PAlign alignType, int left, int level) {
        XLog.d(TAG, "yxz at PrinterInstance.java printImage(Bitmap bitmap, PAlign alignType, int left, int level) ----begin");
        this.sendBytesData(Utils.originalBmpToPrintByte(bitmap, alignType, left, level));
        XLog.d(TAG, "yxz at PrinterInstance.java printImage(Bitmap bitmap, PAlign alignType, int left, int level) ----end");
    }

    public void printColorImg2Gray(Bitmap bitmap, PrinterConstants.PAlign alignType, int left, boolean isCompressed) {
        this.sendBytesData(Utils.convertGreyImg(bitmap, alignType, left, isCompressed));
    }

    public void printImageStylus(Bitmap bitmap, int multiple) {
        this.sendBytesData(Utils.bitmap2PrinterBytes_stylus(bitmap, multiple, 0));
    }

    public void printImageStylus(Bitmap bitmap, int multiple, int pointNum) {
        this.sendBytesData(Utils.bitmap2PrinterBytes_stylus(bitmap, multiple, pointNum));
    }

    public void printTable(Table table) {
        this.printText(table.getTableText());
    }

    public int printBarCode(Barcode barcode) {
        return this.sendBytesData(barcode.getBarcodeData());
    }

    public int printhorizontalLine(int lineLength, int lineWith, boolean isSolidline, int interval) {
        int i;
        int byteConuts = 0;
        int count = 0;
        int b1 = 0;
        int b2 = 0;
        int b3 = 0;
        if (lineLength % 8 != 0) {
            lineLength = lineLength / 8 * 8;
        }
        XLog.i(TAG, "lineLength:" + lineLength);
        byteConuts = lineLength / 8;
        XLog.i(TAG, "byteConuts:" + byteConuts);
        byte[] lineBytes = new byte[byteConuts + 4];
        byte[] totalBytes = new byte[lineBytes.length * lineWith];
        lineBytes[count++] = 22;
        lineBytes[count++] = (byte)byteConuts;
        if (isSolidline) {
            b3 = -1;
            b2 = -1;
            b1 = -1;
        } else {
            b1 = -16;
            b2 = 0;
            b3 = -1;
        }
        switch (interval) {
            case 4: {
                for (i = 0; i < byteConuts; ++i) {
                    lineBytes[count++] = b1;
                }
                break;
            }
            case 8: {
                if (byteConuts % 2 == 0) {
                    for (i = 0; i < byteConuts / 2; ++i) {
                        lineBytes[count++] = b3;
                        lineBytes[count++] = b2;
                    }
                    break;
                }
                for (i = 0; i < byteConuts / 2; ++i) {
                    lineBytes[count++] = b3;
                    lineBytes[count++] = b2;
                }
                lineBytes[count++] = b3;
                break;
            }
        }
        lineBytes[count++] = 21;
        lineBytes[count++] = 1;
        for (i = 0; i < lineWith; ++i) {
            System.arraycopy(lineBytes, 0, totalBytes, i * lineBytes.length, lineBytes.length);
        }
        XLog.w(TAG, Utils.bytesToHexString(totalBytes, totalBytes.length));
        Utils.write2File(totalBytes, "/sdcard/Logs", "b.txt", true);
        return this.sendBytesData(totalBytes);
    }

    public int getPaperWidth() {
        return this.paperWidth;
    }

    public void setPaperWidth(int paperWidth) {
        this.paperWidth = paperWidth;
    }

    public void pageSetup(PrinterConstants.LablePaperType paperWidth, int pageWidth, int pageHeight) {
        switch (paperWidth) {
            case Size_58mm: {
                this.setPaperWidth(384);
                break;
            }
            case Size_80mm: {
                this.setPaperWidth(576);
                break;
            }
            case Size_100mm: {
                this.setPaperWidth(724);
                break;
            }
        }
        this.printText(LabelPrint.label_set_page(pageWidth, pageHeight, 0));
    }

    public void drawLine(int lineWidth, int startX, int startY, int endX, int endY, boolean isSolidLine) {
        if (endX + lineWidth > this.paperWidth) {
            endX = this.paperWidth - lineWidth;
        }
        if (lineWidth > 5) {
            lineWidth = 1;
        }
        this.printText(LabelPrint.label_put_lines(lineWidth, startX, startY, endX, endY, isSolidLine));
    }

    public void drawBorder(int lineWidth, int top_left_x, int top_left_y, int bottom_right_x, int bottom_right_y) {
        if (bottom_right_x + lineWidth > this.paperWidth) {
            bottom_right_x = this.paperWidth - lineWidth;
        }
        if (lineWidth > 5) {
            lineWidth = 1;
        }
        this.mLineWidth = lineWidth;
        this.printText(LabelPrint.label_put_box(lineWidth, top_left_x, top_left_y, bottom_right_x, bottom_right_y));
    }

    public void drawText(int text_x, int text_y, String text, PrinterConstants.LableFontSize fontSize, PrinterConstants.PRotate rotate, int bold, int reverse, int underline) {
        LabelPrint.FontSize FS = new LabelPrint.FontSize();
        FS.getFontAndSize(fontSize);
        int font = FS.getFont();
        int size = FS.getSize();
        if (underline < 0 || underline > 2) {
            underline = 0;
        }
        this.printText(LabelPrint.label_put_text(text_x, text_y, text, font, size, rotate, bold, underline, reverse));
    }

    public void drawText(int area_start_x, int area_start_y, int area_end_x, int area_end_y, PrinterConstants.PAlign xAlign, PrinterConstants.PAlign yAlign, String text, PrinterConstants.LableFontSize fontSize, int bold, int reverse, int underline, int deleteline, PrinterConstants.PRotate rotate) {
        if (area_end_x + this.mLineWidth > this.paperWidth) {
            area_end_x = this.paperWidth - this.mLineWidth;
        }
        int areaWidth = area_end_x - area_start_x;
        int areaHeight = area_end_y - area_start_y;
        int nowY = 0;
        int text_x = 0;
        int text_y = 0;
        int fontRealSize = 0;
        switch (fontSize) {
            case Size_16: {
                fontRealSize = 16;
                break;
            }
            case Size_24: {
                fontRealSize = 24;
                break;
            }
            case Size_32: {
                fontRealSize = 32;
                break;
            }
            case Size_48: {
                fontRealSize = 48;
                break;
            }
            case Size_64: {
                fontRealSize = 64;
                break;
            }
            case Size_72: {
                fontRealSize = 72;
                break;
            }
            case Size_96: {
                fontRealSize = 96;
                break;
            }
            default: {
                fontRealSize = 24;
            }
        }
        Map<Integer, String[]> content = Utils.dealContent(text, areaWidth, areaHeight, fontSize);
        for (int i = 0; i < content.size(); ++i) {
            text_x = xAlign == PrinterConstants.PAlign.CENTER ? area_start_x + (areaWidth - Integer.parseInt(content.get(i)[0])) / 2 : (xAlign == PrinterConstants.PAlign.END ? area_start_x + (areaWidth - Integer.parseInt(content.get(i)[0])) : area_start_x);
            text_y = yAlign == PrinterConstants.PAlign.CENTER ? area_start_y + (areaHeight - content.size() * fontRealSize) / 2 : (yAlign == PrinterConstants.PAlign.END ? area_end_y - content.size() * fontRealSize : area_start_y);
            XLog.i(TAG, "area_start_x:" + area_start_x + "area_end_x" + area_end_x + "areaWidth:" + areaWidth + "text_x:" + text_x + "sss:" + Integer.parseInt(content.get(i)[0]));
            nowY = i == 0 ? text_y + i * fontRealSize : text_y + i * fontRealSize + i * 3;
            String rowContent = content.get(i)[1];
            if (underline < 0 || underline > 2) {
                underline = 0;
            }
            this.drawText(text_x, nowY, rowContent, fontSize, rotate, bold, 0, underline);
            if (reverse != 1) continue;
            if (area_end_x + this.mLineWidth > 576) {
                area_end_x = 576 - this.mLineWidth;
            }
            String cmd = "INVERSE-LINE " + area_start_x + " " + (area_start_y += this.mLineWidth) + " " + (area_end_x -= this.mLineWidth) + " " + area_start_y + " " + (area_end_y - area_start_y) + "\r\n";
            this.printText(cmd);
            XLog.i(TAG, cmd);
        }
    }

    public void drawBarCode(int start_x, int start_y, String text, PrinterConstants.PBarcodeType type, int linewidth, int height, PrinterConstants.PRotate rotate) {
        if (start_x < 0 || start_y < 0 || text == null || text == "" || linewidth < 0 || height <= 0) {
            XLog.e(TAG, "yxz at PrinterInstance.java drawBarCode()\u53c2\u6570\u5f02\u5e38");
            return;
        }
        String codeType = "128";
        switch (type) {
            case CODE128: {
                codeType = "128";
                break;
            }
            case UPC_A: {
                codeType = "UPCA";
                break;
            }
            case JAN3_EAN13: {
                codeType = "EAN13";
                break;
            }
            case JAN8_EAN8: {
                codeType = "EAN8";
                break;
            }
            case CODE39: {
                codeType = "39";
                break;
            }
            case CODE93: {
                codeType = "93";
                break;
            }
            case CODABAR: {
                codeType = "CODABAR";
                break;
            }
            default: {
                codeType = "128";
            }
        }
        int rotate1 = rotate == PrinterConstants.PRotate.Rotate_0 ? 0 : 1;
        this.printText(LabelPrint.label_put_barcode(start_x, start_y, text, codeType, rotate1, linewidth, height));
    }

    public void drawBarCode(int area_start_x, int area_start_y, int area_end_x, int area_end_y, PrinterConstants.PAlign xAlign, PrinterConstants.PAlign yAlign, int start_x, int start_y, String text, PrinterConstants.PBarcodeType type, int linewidth, int height, PrinterConstants.PRotate rotate) {
        int xa = 0;
        xa = xAlign == PrinterConstants.PAlign.CENTER ? 1 : (xAlign == PrinterConstants.PAlign.END ? 2 : 0);
        start_y = yAlign == PrinterConstants.PAlign.CENTER ? area_start_y + (area_end_y - area_start_y - height) / 2 : (yAlign == PrinterConstants.PAlign.END ? area_end_y - height : area_start_y);
        String barcodeType = "128";
        if (type == PrinterConstants.PBarcodeType.CODABAR) {
            barcodeType = "CODABAR";
        } else if (type == PrinterConstants.PBarcodeType.CODE128) {
            barcodeType = "128";
        } else if (type == PrinterConstants.PBarcodeType.CODE39) {
            barcodeType = "39";
        } else if (type == PrinterConstants.PBarcodeType.CODE93) {
            barcodeType = "93";
        } else if (type == PrinterConstants.PBarcodeType.JAN8_EAN8) {
            barcodeType = "EAN8";
        } else if (type == PrinterConstants.PBarcodeType.JAN3_EAN13) {
            barcodeType = "EAN13";
        } else if (type == PrinterConstants.PBarcodeType.UPC_A) {
            barcodeType = "UPCA";
        } else if (type == PrinterConstants.PBarcodeType.UPC_E) {
            barcodeType = "UPCE";
        }
        String str = "BA " + area_start_x + " " + area_start_y + " " + area_end_x + " " + area_end_y + " " + xa + "\r\n";
        XLog.d(TAG, "yxz at PrinterInstance.java drawBarCode() \u533a\u57df\u5185\u6253\u5370\u6761\u7801\uff1astr:" + str);
        this.printText(str);
        String st1 = "B";
        if (rotate != PrinterConstants.PRotate.Rotate_0) {
            st1 = "VB";
        }
        String str2 = st1 + " " + barcodeType + " " + linewidth + " 2 " + height + " " + area_start_x + " " + start_y + " " + text + "\r\n";
        this.printText(str2);
        XLog.d(TAG, "yxz at PrinterInstance.java drawBarCode() \u533a\u57df\u5185\u6253\u5370\u6761\u7801\uff1astr2:" + str2);
        String str3 = "BA 0 0 0 0 3\r\n";
        this.printText(str3);
        XLog.d(TAG, "yxz at PrinterInstance.java drawBarCode() \u533a\u57df\u5185\u6253\u5370\u6761\u7801\uff1astr3:" + str3);
    }

    public void drawQrCode(int start_x, int start_y, String text, PrinterConstants.PRotate rotate, int ver, int lel) {
        String level = "M";
        if (lel == 0) {
            level = "L";
        } else if (lel == 1) {
            level = "M";
        } else if (lel == 2) {
            level = "Q";
        } else if (lel == 3) {
            level = "H";
        }
        String rot = "B";
        if (rotate != PrinterConstants.PRotate.Rotate_0) {
            rot = "VB";
        }
        String cmd = rot + " QR " + start_x + " " + start_y + " M 2 U " + ver + "\r\n" + level + "A," + text + "\r\nENDQR\r\n";
        this.printText(cmd);
        XLog.i(TAG, cmd);
    }

    @Deprecated
    public void drawGraphic(int start_x, int start_y, int bmp_size_x, int bmp_size_y, Bitmap bmp) {
        int width = 0;
        width = bmp.getWidth() % 8 == 0 ? bmp.getWidth() / 8 : bmp.getWidth() / 8 + 1;
        String cmd = "EG " + width + " " + bmp.getHeight() + " " + start_x + " " + start_y + " " + LabelPrint.bmp2str(bmp);
        this.printText(cmd);
        XLog.i(TAG, cmd);
    }

    public void drawGraphic(int start_x, int start_y, Bitmap bmp) {
        int width = 0;
        width = bmp.getWidth() % 8 == 0 ? bmp.getWidth() / 8 : bmp.getWidth() / 8 + 1;
        String cmd = "CG " + width + " " + bmp.getHeight() + " " + start_x + " " + start_y + " ";
        byte[] bytes = null;
        try {
            bytes = cmd.getBytes("gbk");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        byte[] bmp2bytes = LabelPrint.bmp2bytes(bmp);
        byte[] cmdbyte = new byte[bytes.length + bmp2bytes.length];
        System.arraycopy(bytes, 0, cmdbyte, 0, bytes.length);
        System.arraycopy(bmp2bytes, 0, cmdbyte, bytes.length, bmp2bytes.length);
        this.sendBytesData(cmdbyte);
    }

    public void drawGraphic(int area_start_x, int area_start_y, int area_end_x, int area_end_y, PrinterConstants.PAlign xAlign, PrinterConstants.PAlign yAlign, int bmp_size_x, int bmp_size_y, Bitmap bmp) {
        int start_x = 0;
        int start_y = 0;
        Bitmap tmpbmp = Bitmap.createScaledBitmap((Bitmap)bmp, (int)bmp_size_x, (int)bmp_size_y, (boolean)true);
        int imageHeight = tmpbmp.getHeight();
        int imageWidth = tmpbmp.getWidth();
        start_x = xAlign == PrinterConstants.PAlign.CENTER ? (start_x += (area_end_x - area_start_x - imageWidth) / 2) : (xAlign == PrinterConstants.PAlign.END ? area_end_x - imageWidth : area_start_x);
        start_y = yAlign == PrinterConstants.PAlign.CENTER ? (start_y += (area_end_y - area_start_y - imageHeight) / 2) : (xAlign == PrinterConstants.PAlign.END ? area_end_y - imageHeight : area_start_y);
        this.drawGraphic(start_x, start_y, tmpbmp.getWidth(), tmpbmp.getHeight(), tmpbmp);
    }

    public void print(PrinterConstants.PRotate rotate, int skip) {
        this.printText(LabelPrint.label_print(rotate, skip));
    }

    public int getPaperWidthTSPL() {
        return this.paperWidthTSPL;
    }

    public int getPaperHeithtTSPL() {
        return this.paperHeightTSPL;
    }

    public void setPaperWidthTSPL(int paperWidth) {
        this.paperWidthTSPL = paperWidth;
    }

    public void setPaperHeightTSPL(int paperHeight) {
        this.paperHeightTSPL = paperHeight;
    }

    public void pageSetupTSPL(int paperSizeType, int pageWidth, int pageHeight) throws WriteException, PrinterPortNullException, ParameterErrorException {
        if (paperSizeType < 0 || paperSizeType > 2 || pageWidth < 0 || pageWidth == 0 || pageHeight < 0 || pageHeight == 0) {
            throw new ParameterErrorException("\u4f20\u5165\u53c2\u6570\u5f02\u5e38");
        }
        switch (paperSizeType) {
            case 0: {
                if (pageWidth > 448) {
                    throw new ParameterErrorException("\u4f20\u5165\u53c2\u6570\u5f02\u5e38\uff0c\u7eb8\u5bbd\u8bbe\u7f6e\u8d85\u51fa\u8303\u56f4");
                }
                this.setPaperWidthTSPL(448);
                break;
            }
            case 1: {
                if (pageWidth > 640) {
                    throw new ParameterErrorException("\u4f20\u5165\u53c2\u6570\u5f02\u5e38\uff0c\u7eb8\u5bbd\u8bbe\u7f6e\u8d85\u51fa\u8303\u56f4");
                }
                this.setPaperWidthTSPL(640);
                break;
            }
            case 2: {
                if (pageWidth > 816) {
                    throw new ParameterErrorException("\u4f20\u5165\u53c2\u6570\u5f02\u5e38\uff0c\u7eb8\u5bbd\u8bbe\u7f6e\u8d85\u51fa\u8303\u56f4");
                }
                this.setPaperWidthTSPL(800);
                break;
            }
        }
        int result = this.printText(LabelPrint.label_set_pageTSPL(pageWidth, pageHeight));
        if (result == -1) {
            throw new PrinterPortNullException("\u6253\u5370\u673a\u7aef\u53e3\u4e3a\u7a7a\u5f02\u5e38");
        }
        if (result == -3) {
            throw new WriteException("\u5411\u6253\u5370\u673a\u5199\u5165\u6570\u636e\u5f02\u5e38");
        }
    }

    public void drawLineTSPL(int startX, int startY, int lineLength, int lineHeight) throws WriteException, PrinterPortNullException, ParameterErrorException, Exception {
        if (startX < 0 || startY < 0 || lineLength < 0 || lineLength == 0 || lineHeight < 0 || lineHeight == 0 || startX > this.paperWidthTSPL || startX == this.paperWidthTSPL || startY == this.paperHeightTSPL || startY > this.paperHeightTSPL || lineHeight > this.paperHeightTSPL || lineLength > this.paperWidthTSPL) {
            throw new ParameterErrorException("\u8f93\u5165\u53c2\u6570\u5f02\u5e38");
        }
        if (lineLength > 5 && lineHeight > 5) {
            throw new ParameterErrorException("\u8f93\u5165\u53c2\u6570\u5f02\u5e38");
        }
        int result = this.printText(LabelPrint.label_put_linesTSPL(startX, startY, lineLength, lineHeight));
        if (result == -1) {
            throw new PrinterPortNullException("\u6253\u5370\u673a\u7aef\u53e3\u4e3a\u7a7a\u5f02\u5e38");
        }
        if (result == -3) {
            throw new WriteException("\u5411\u6253\u5370\u673a\u5199\u5165\u6570\u636e\u5f02\u5e38");
        }
    }

    public void drawBorderTSPL(int lineWidth, int top_left_x, int top_left_y, int bottom_right_x, int bottom_right_y) throws WriteException, PrinterPortNullException, ParameterErrorException {
        if (top_left_x < 0 || top_left_y < 0 || bottom_right_x < 0 || bottom_right_y < 0 || top_left_x >= this.paperWidthTSPL || top_left_y >= this.paperHeightTSPL || bottom_right_x > this.paperWidthTSPL || bottom_right_y > this.paperHeightTSPL || bottom_right_x == 0 || bottom_right_y == 0 || lineWidth <= 0 || lineWidth > 5) {
            throw new ParameterErrorException("\u8f93\u5165\u53c2\u6570\u5f02\u5e38");
        }
        this.mLineWidth = lineWidth;
        int result = this.printText(LabelPrint.label_put_boxTSPL(lineWidth, top_left_x, top_left_y, bottom_right_x, bottom_right_y));
        if (result == -1) {
            throw new PrinterPortNullException("\u6253\u5370\u673a\u7aef\u53e3\u4e3a\u7a7a\u5f02\u5e38");
        }
        if (result == -3) {
            throw new WriteException("\u5411\u6253\u5370\u673a\u5199\u5165\u6570\u636e\u5f02\u5e38");
        }
    }

    public void drawTextTSPL(int start_x, int start_y, boolean isSimplifiedChinese, int xMultiplication, int yMultiplication, PrinterConstants.PRotate rotate, String content) throws WriteException, PrinterPortNullException, ParameterErrorException {
        if (start_x < 0 || start_y < 0 || xMultiplication < 1 || yMultiplication < 1 || start_x > this.paperWidthTSPL || start_x == this.paperWidthTSPL || start_y > this.paperHeightTSPL || start_y == this.paperHeightTSPL || xMultiplication > 4 || yMultiplication > 4) {
            throw new ParameterErrorException("\u8f93\u5165\u53c2\u6570\u5f02\u5e38");
        }
        int result = this.printText(LabelPrint.label_put_textTSPL(start_x, start_y, isSimplifiedChinese, xMultiplication, yMultiplication, rotate, content));
        if (result == -1) {
            throw new PrinterPortNullException("\u6253\u5370\u673a\u7aef\u53e3\u4e3a\u7a7a\u5f02\u5e38");
        }
        if (result == -3) {
            throw new WriteException("\u5411\u6253\u5370\u673a\u5199\u5165\u6570\u636e\u5f02\u5e38");
        }
    }

    public void drawTextTSPL(int area_start_x, int area_start_y, int area_end_x, int area_end_y, PrinterConstants.PAlign xAlign, PrinterConstants.PAlign yAlign, boolean isSimplifiedChinese, int xMultiplication, int yMultiplication, PrinterConstants.PRotate rotate, String content) throws WriteException, PrinterPortNullException, ParameterErrorException {
        if (area_start_x < 0 || area_start_y < 0 || area_end_x < 0 || area_end_x == 0 || area_end_y < 0 || area_end_y == 0 || area_start_x > this.paperWidthTSPL || area_start_x == this.paperWidthTSPL || area_start_y == this.paperHeightTSPL || area_start_y > this.paperHeightTSPL || area_end_x > this.paperWidthTSPL || area_end_y > this.paperHeightTSPL || xMultiplication < 1 || xMultiplication > 4 || yMultiplication < 1 || yMultiplication > 4 || content.equals("") || content == null) {
            throw new ParameterErrorException("\u8f93\u5165\u53c2\u6570\u5f02\u5e38");
        }
        if (area_end_x + this.mLineWidth > this.paperWidthTSPL) {
            area_end_x = this.paperWidthTSPL - this.mLineWidth;
        }
        int areaWidth = area_end_x - area_start_x;
        int areaHeight = area_end_y - area_start_y;
        int nowY = 0;
        int text_x = 0;
        int text_y = 0;
        Map<Integer, String[]> content1 = Utils.dealContentTL(content, areaWidth, areaHeight, xMultiplication);
        for (int i = 0; i < content1.size(); ++i) {
            text_x = xAlign == PrinterConstants.PAlign.CENTER ? area_start_x + (areaWidth - Integer.parseInt(content1.get(i)[0])) / 2 : (xAlign == PrinterConstants.PAlign.END ? area_start_x + (areaWidth - Integer.parseInt(content1.get(i)[0])) : area_start_x);
            int fontRealSize = 0;
            switch (yMultiplication) {
                case 1: {
                    fontRealSize = 24;
                    break;
                }
                case 2: {
                    fontRealSize = 48;
                    break;
                }
                case 3: {
                    fontRealSize = 72;
                    break;
                }
                case 4: {
                    fontRealSize = 96;
                    break;
                }
                default: {
                    fontRealSize = 24;
                }
            }
            text_y = yAlign == PrinterConstants.PAlign.CENTER ? area_start_y + (areaHeight - content1.size() * fontRealSize) / 2 : (yAlign == PrinterConstants.PAlign.END ? area_end_y - content1.size() * fontRealSize : area_start_y);
            XLog.i(TAG, "area_start_x:" + area_start_x + "area_end_x" + area_end_x + "areaWidth:" + areaWidth + "text_x:" + text_x + "sss:" + Integer.parseInt(content1.get(i)[0]));
            nowY = i == 0 ? text_y + i * fontRealSize : text_y + i * fontRealSize + i * 3;
            String rowContent = content1.get(i)[1];
            this.drawTextTSPL(text_x, nowY, isSimplifiedChinese, xMultiplication, yMultiplication, rotate, rowContent);
        }
    }

    public void drawBarCodeTSPL(int start_x, int start_y, PrinterConstants.PBarcodeType type, int height, boolean isReadable, PrinterConstants.PRotate rotate, int narrowWidth, int wideWidth, String content) throws WriteException, PrinterPortNullException, ParameterErrorException {
        if (start_x < 0 || start_y < 0 || start_x > this.paperWidthTSPL || start_x == this.paperWidthTSPL || start_y > this.paperHeightTSPL || start_y == this.paperHeightTSPL || height < 0 || height == 0 || height > this.paperHeightTSPL || content == null || content.equals("")) {
            throw new ParameterErrorException("\u8f93\u5165\u53c2\u6570\u5f02\u5e38");
        }
        String codeType = "128";
        switch (type) {
            case CODE128: {
                codeType = "128";
                break;
            }
            case UPC_A: {
                codeType = "UPCA";
                break;
            }
            case UPC_E: {
                codeType = "UPCE+5";
                break;
            }
            case JAN3_EAN13: {
                codeType = "EAN13";
                break;
            }
            case JAN8_EAN8: {
                codeType = "EAN8";
                break;
            }
            case JAN128: {
                codeType = "EAN128";
                break;
            }
            case CODE39: {
                codeType = "39";
                break;
            }
            case CODE93: {
                codeType = "93";
                break;
            }
            case CODABAR: {
                codeType = "CODA";
                break;
            }
            default: {
                codeType = "128";
            }
        }
        int readable = 0;
        if (isReadable) {
            readable = 1;
        }
        int rotate1 = 0;
        if (rotate == PrinterConstants.PRotate.Rotate_90) {
            rotate1 = 90;
        } else if (rotate == PrinterConstants.PRotate.Rotate_180) {
            rotate1 = 180;
        } else if (rotate == PrinterConstants.PRotate.Rotate_270) {
            rotate1 = 270;
        }
        int result = this.printText(LabelPrint.label_put_drawBarcodeTSPL(start_x, start_y, codeType, height, readable, rotate1, narrowWidth, wideWidth, content));
        if (result == -1) {
            throw new PrinterPortNullException("\u6253\u5370\u673a\u7aef\u53e3\u4e3a\u7a7a\u5f02\u5e38");
        }
        if (result == -3) {
            throw new WriteException("\u5411\u6253\u5370\u673a\u5199\u5165\u6570\u636e\u5f02\u5e38");
        }
    }

    public void draw2DBarCodeTSPL(int start_x, int start_y, PrinterConstants.TwoDarCodeType type, int lel, int width, PrinterConstants.PRotate rotate, String content) throws WriteException, PrinterPortNullException, ParameterErrorException {
        if (start_x < 0 || start_x > this.paperWidthTSPL || start_x == this.paperWidthTSPL || start_y < 0 || start_y > this.paperHeightTSPL || start_y == this.paperHeightTSPL) {
            throw new ParameterErrorException("\u8f93\u5165\u53c2\u6570\u5f02\u5e38");
        }
        int rotate1 = 0;
        if (rotate == PrinterConstants.PRotate.Rotate_90) {
            rotate1 = 90;
        } else if (rotate == PrinterConstants.PRotate.Rotate_180) {
            rotate1 = 180;
        } else if (rotate == PrinterConstants.PRotate.Rotate_270) {
            rotate1 = 270;
        }
        if (type == PrinterConstants.TwoDarCodeType.QR) {
            if (lel < 0 || lel > 3 || width < 1 || width > 6) {
                throw new ParameterErrorException("\u8f93\u5165\u53c2\u6570\u5f02\u5e38");
            }
            String level = "M";
            if (lel == 0) {
                level = "L";
            } else if (lel == 1) {
                level = "M";
            } else if (lel == 2) {
                level = "Q";
            } else if (lel == 3) {
                level = "H";
            }
            this.printText(LabelPrint.label_put_drawQrcodeTSPL(start_x, start_y, level, width, rotate1, content));
        } else if (type == PrinterConstants.TwoDarCodeType.DMATRIX) {
            if (lel < 0 || lel > this.paperHeightTSPL || width < 0 || width > this.paperWidthTSPL) {
                throw new ParameterErrorException("\u8f93\u5165\u53c2\u6570\u5f02\u5e38");
            }
            this.printText(LabelPrint.label_put_drawDataMatrixTSPL(start_x, start_y, width, lel, content));
        }
    }

    public void drawBitmapTSPL(int start_x, int start_y, int mode, Bitmap bmp) throws WriteException, PrinterPortNullException, ParameterErrorException {
        if (start_x < 0 || start_x > this.paperWidthTSPL || start_x == this.paperWidthTSPL || start_y < 0 || start_y > this.paperHeightTSPL || start_y == this.paperHeightTSPL || mode < 0 || mode > 2) {
            throw new ParameterErrorException("\u8f93\u5165\u53c2\u6570\u5f02\u5e38");
        }
        int result1 = this.printText(LabelPrint.label_put_drawGraphicTSPL(start_x, start_y, bmp.getWidth() / 8, bmp.getHeight(), mode));
        if (result1 == -1) {
            throw new PrinterPortNullException("\u6253\u5370\u673a\u7aef\u53e3\u4e3a\u7a7a\u5f02\u5e38");
        }
        if (result1 == -3) {
            throw new WriteException("\u5411\u6253\u5370\u673a\u5199\u5165\u6570\u636e\u5f02\u5e38");
        }
        int result2 = this.sendBytesData(LabelPrint.bitmap2PrinterBytes(bmp, bmp.getWidth() / 8, bmp.getHeight(), 2));
        if (result2 == -1) {
            throw new PrinterPortNullException("\u6253\u5370\u673a\u7aef\u53e3\u4e3a\u7a7a\u5f02\u5e38");
        }
        if (result2 == -3) {
            throw new WriteException("\u5411\u6253\u5370\u673a\u5199\u5165\u6570\u636e\u5f02\u5e38");
        }
        int result3 = this.printText("\r\n");
        if (result3 == -1) {
            throw new PrinterPortNullException("\u6253\u5370\u673a\u7aef\u53e3\u4e3a\u7a7a\u5f02\u5e38");
        }
        if (result3 == -3) {
            throw new WriteException("\u5411\u6253\u5370\u673a\u5199\u5165\u6570\u636e\u5f02\u5e38");
        }
    }

    public void drawBitmapTSPL(int area_start_x, int area_start_y, int area_end_x, int area_end_y, PrinterConstants.PAlign xAlign, PrinterConstants.PAlign yAlign, int mode, Bitmap bmp) throws WriteException, PrinterPortNullException, ParameterErrorException {
        if (area_start_x < 0 || area_start_x > this.paperWidthTSPL || area_start_x == this.paperWidthTSPL || area_start_y < 0 || area_start_y > this.paperHeightTSPL || area_start_y == this.paperHeightTSPL || area_end_x < 0 || area_end_x == 0 || area_end_x > this.paperWidthTSPL || area_end_y < 0 || area_end_y == 0 || area_end_y > this.paperHeightTSPL || mode < 0 || mode > 2) {
            throw new ParameterErrorException("\u8f93\u5165\u53c2\u6570\u5f02\u5e38");
        }
        int start_x = 0;
        int start_y = 0;
        Bitmap tmpbmp = Bitmap.createScaledBitmap((Bitmap)bmp, (int)bmp.getWidth(), (int)bmp.getHeight(), (boolean)true);
        int imageHeight = tmpbmp.getHeight();
        int imageWidth = tmpbmp.getWidth();
        if (xAlign == PrinterConstants.PAlign.CENTER) {
            start_x = area_start_x + 5 + (area_end_x - area_start_x - imageWidth) / 2;
            XLog.i(TAG, "\u533a\u57df\u5f00\u59cbx" + area_start_x);
            XLog.i(TAG, "\u533a\u57df\u7ed3\u675fx   " + area_end_x);
            XLog.i(TAG, "\u533a\u57df\u5f00\u59cby   " + area_start_y);
            XLog.i(TAG, "\u533a\u57df\u7ed3\u675fy   " + area_end_y);
            XLog.i(TAG, "\u56fe\u7247\u7684\u5bbd\u5ea6   " + imageWidth);
            XLog.i(TAG, "\u8ba1\u7b97\u5b8c\u540e\u7684start_x:  " + start_x);
        } else {
            start_x = xAlign == PrinterConstants.PAlign.END ? area_end_x - imageWidth + 5 : area_start_x + 5;
        }
        if (yAlign == PrinterConstants.PAlign.CENTER) {
            start_y = area_start_y + (area_end_y - area_start_y - imageHeight) / 2;
            XLog.i(TAG, start_y + "yyy");
        } else {
            start_y = yAlign == PrinterConstants.PAlign.END ? area_end_y - imageHeight : area_start_y;
        }
        this.drawBitmapTSPL(start_x, start_y, mode, tmpbmp);
    }

    public void printTSPL(int mSets, int mCopys) throws WriteException, PrinterPortNullException, ParameterErrorException {
        if (mSets < 1 || mCopys < 0 || mSets > 65535) {
            throw new ParameterErrorException("\u8f93\u5165\u53c2\u6570\u5f02\u5e38");
        }
        int result = this.printText(LabelPrint.label_printTSPL(mSets, mCopys));
        if (result == -1) {
            throw new PrinterPortNullException("\u6253\u5370\u673a\u7aef\u53e3\u4e3a\u7a7a\u5f02\u5e38");
        }
        if (result == -3) {
            throw new WriteException("\u5411\u6253\u5370\u673a\u5199\u5165\u6570\u636e\u5f02\u5e38");
        }
    }

    public int getPrinterStatusTSPL() throws WriteException, ReadException, PrinterPortNullException {
        int status = 0;
        int readLen = -1;
        byte retByte = -1;
        String hex = null;
        byte[] clear = new byte[20];
        this.read(clear);
        byte[] data = new byte[]{27, 33, 63};
        int result1 = this.sendBytesData(data);
        XLog.i(TAG, "\u5411\u6253\u5370\u673a\u5199\u5165\u6570\u636e\u7684\u957f\u5ea6\uff1a" + result1);
        if (result1 == -1) {
            throw new PrinterPortNullException("\u6253\u5370\u673a\u7aef\u53e3\u4e3a\u7a7a\u5f02\u5e38");
        }
        if (result1 == -3) {
            throw new WriteException("\u5411\u6253\u5370\u673a\u5199\u5165\u6570\u636e\u5f02\u5e38");
        }
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e1) {
            e1.printStackTrace();
        }
        byte[] buffer = new byte[16];
        for (int i = 0; i < 3 && (readLen = this.read(buffer)) != 1; ++i) {
        }
        if (readLen == -1) {
            throw new ReadException("\u4ece\u6253\u5370\u673a\u8bfb\u53d6\u6570\u636e\u5f02\u5e38");
        }
        retByte = buffer[0];
        byte[] last = new byte[]{retByte};
        hex = Utils.bytesToHexString(last, last.length);
        XLog.i(TAG, "retByte16\u8fdb\u5236\u5b57\u7b26\u4e32--------------------++" + hex);
        XLog.i(TAG, "\u67e5\u8be2\u5230\u7684byte\u503c---------------------------------------------------------------------------++" + retByte);
        XLog.i(TAG, "16\u8fdb\u5236\u5b57\u7b26\u4e32--------------------++" + Utils.bytesToHexString(buffer, buffer.length));
        status = retByte == 0 ? 0 : (retByte == -63 ? -2 : (retByte == -124 ? -1 : -3));
        return status;
    }

    public void setCharsetNameTSPL(String charsetName) throws ParameterErrorException {
        if (!(charsetName.equals("gbk") || charsetName.equals("GBK") || charsetName.equals("big5") || charsetName.equals("BIG5"))) {
            throw new ParameterErrorException("\u8f93\u5165\u53c2\u6570\u5f02\u5e38");
        }
        this.charsetName = charsetName;
    }

    public void setPaperbackOrPaperFeedTSPL(boolean isFeedBack, int mDot) throws PrinterPortNullException, WriteException, ParameterErrorException {
        if (mDot > 1000 || mDot < 1) {
            throw new ParameterErrorException("\u8f93\u5165\u53c2\u6570\u5f02\u5e38");
        }
        if (isFeedBack) {
            int result = this.printText("BACKFEED " + mDot + "\r\n");
            if (result == -1) {
                throw new PrinterPortNullException("\u6253\u5370\u673a\u7aef\u53e3\u4e3a\u7a7a\u5f02\u5e38");
            }
            if (result == -3) {
                throw new WriteException("\u5411\u6253\u5370\u673a\u5199\u5165\u6570\u636e\u5f02\u5e38");
            }
        } else {
            int result = this.printText("FORMFEED\r\n");
            if (result == -1) {
                throw new PrinterPortNullException("\u6253\u5370\u673a\u7aef\u53e3\u4e3a\u7a7a\u5f02\u5e38");
            }
            if (result == -3) {
                throw new WriteException("\u5411\u6253\u5370\u673a\u5199\u5165\u6570\u636e\u5f02\u5e38");
            }
        }
    }

    public void reverseAreaTSPL(int start_x, int start_y, int width, int height) throws PrinterPortNullException, WriteException, ParameterErrorException {
        if (start_x < 0 || start_x > this.paperWidthTSPL || start_x == this.paperWidthTSPL || start_y < 0 || start_y > this.paperHeightTSPL || start_y == this.paperHeightTSPL || width < 0 || width == 0 || width > this.paperWidthTSPL || height < 0 || height > this.paperHeightTSPL || height == 0) {
            throw new ParameterErrorException("\u8f93\u5165\u53c2\u6570\u5f02\u5e38");
        }
        int result = this.printText("REVERSE " + start_x + "," + start_y + "," + width + "," + height + "\r\n");
        if (result == -1) {
            throw new PrinterPortNullException("\u6253\u5370\u673a\u7aef\u53e3\u4e3a\u7a7a\u5f02\u5e38");
        }
        if (result == -3) {
            throw new WriteException("\u5411\u6253\u5370\u673a\u5199\u5165\u6570\u636e\u5f02\u5e38");
        }
    }

    public void eraseAreaTSPL(int start_x, int start_y, int width, int height) throws PrinterPortNullException, WriteException, ParameterErrorException {
        if (start_x < 0 || start_x > this.paperWidthTSPL || start_x == this.paperWidthTSPL || start_y < 0 || start_y > this.paperHeightTSPL || start_y == this.paperHeightTSPL || width < 0 || width == 0 || width > this.paperWidthTSPL || height < 0 || height > this.paperHeightTSPL || height == 0) {
            throw new ParameterErrorException("\u8f93\u5165\u53c2\u6570\u5f02\u5e38");
        }
        int result = this.printText("ERASE " + start_x + "," + start_y + "," + width + "," + height + "\r\n");
        if (result == -1) {
            throw new PrinterPortNullException("\u6253\u5370\u673a\u7aef\u53e3\u4e3a\u7a7a\u5f02\u5e38");
        }
        if (result == -3) {
            throw new WriteException("\u5411\u6253\u5370\u673a\u5199\u5165\u6570\u636e\u5f02\u5e38");
        }
    }

    public void setPrinterTSPL(int command, int value) throws PrinterPortNullException, WriteException, ParameterErrorException {
        if (command < 0 || command > 13) {
            throw new ParameterErrorException("\u8f93\u5165\u53c2\u6570\u5f02\u5e38");
        }
        switch (command) {
            case 0: {
                if (value != 0 && value != 1) {
                    throw new ParameterErrorException("\u8f93\u5165\u53c2\u6570\u5f02\u5e38");
                }
                int result = this.printText("DIRECTION " + value + "\r\n");
                if (result == -1) {
                    throw new PrinterPortNullException("\u6253\u5370\u673a\u7aef\u53e3\u4e3a\u7a7a\u5f02\u5e38");
                }
                if (result != -3) break;
                throw new WriteException("\u5411\u6253\u5370\u673a\u5199\u5165\u6570\u636e\u5f02\u5e38");
            }
            case 1: {
                if (value < 0 || value > 1000) {
                    throw new ParameterErrorException("\u8f93\u5165\u53c2\u6570\u5f02\u5e38");
                }
                int result1 = this.printText("FEED " + value + "\r\n");
                if (result1 == -1) {
                    throw new PrinterPortNullException("\u6253\u5370\u673a\u7aef\u53e3\u4e3a\u7a7a\u5f02\u5e38");
                }
                if (result1 != -3) break;
                throw new WriteException("\u5411\u6253\u5370\u673a\u5199\u5165\u6570\u636e\u5f02\u5e38");
            }
            case 2: {
                if (value != 0 && value != 1) {
                    throw new ParameterErrorException("\u8f93\u5165\u53c2\u6570\u5f02\u5e38");
                }
                if (value == 0) {
                    int result2 = this.printText("SET REPRINT OFF\r\n");
                    if (result2 == -1) {
                        throw new PrinterPortNullException("\u6253\u5370\u673a\u7aef\u53e3\u4e3a\u7a7a\u5f02\u5e38");
                    }
                    if (result2 != -3) break;
                    throw new WriteException("\u5411\u6253\u5370\u673a\u5199\u5165\u6570\u636e\u5f02\u5e38");
                }
                if (value != 1) break;
                int result2 = this.printText("SET REPRINT ON\r\n");
                if (result2 == -1) {
                    throw new PrinterPortNullException("\u6253\u5370\u673a\u7aef\u53e3\u4e3a\u7a7a\u5f02\u5e38");
                }
                if (result2 != -3) break;
                throw new WriteException("\u5411\u6253\u5370\u673a\u5199\u5165\u6570\u636e\u5f02\u5e38");
            }
            case 3: {
                if (value < 0) {
                    throw new ParameterErrorException("\u8f93\u5165\u53c2\u6570\u5f02\u5e38");
                }
                int result3 = this.printText("SPEED " + value + "\r\n");
                if (result3 == -1) {
                    throw new PrinterPortNullException("\u6253\u5370\u673a\u7aef\u53e3\u4e3a\u7a7a\u5f02\u5e38");
                }
                if (result3 == -3) {
                    throw new WriteException("\u5411\u6253\u5370\u673a\u5199\u5165\u6570\u636e\u5f02\u5e38");
                }
                XLog.i(TAG, "PrinterInstance----------------------\u8bbe\u7f6e\u6253\u5370\u673a\u6253\u5370\u901f\u5ea6\u4e3a\uff1a" + value);
                break;
            }
            case 4: {
                if (value < 0 || value > 15) {
                    throw new ParameterErrorException("\u8f93\u5165\u53c2\u6570\u5f02\u5e38");
                }
                int result4 = this.printText("DENSITY " + value + "\r\n");
                if (result4 == -1) {
                    throw new PrinterPortNullException("\u6253\u5370\u673a\u7aef\u53e3\u4e3a\u7a7a\u5f02\u5e38");
                }
                if (result4 == -3) {
                    throw new WriteException("\u5411\u6253\u5370\u673a\u5199\u5165\u6570\u636e\u5f02\u5e38");
                }
                XLog.i(TAG, "PrinterInstance----------------------\u8bbe\u7f6e\u6253\u5370\u673a\u6d53\u5ea6\u4e3a\uff1a" + value);
                break;
            }
            case 5: {
                if (value < -203 || value > 203) {
                    throw new ParameterErrorException("\u8f93\u5165\u53c2\u6570\u5f02\u5e38");
                }
                int result5 = this.printText("SHIFT " + value + "\r\n");
                if (result5 == -1) {
                    throw new PrinterPortNullException("\u6253\u5370\u673a\u7aef\u53e3\u4e3a\u7a7a\u5f02\u5e38");
                }
                if (result5 == -3) {
                    throw new WriteException("\u5411\u6253\u5370\u673a\u5199\u5165\u6570\u636e\u5f02\u5e38");
                }
                XLog.i(TAG, "PrinterInstance--------------------\u8bbe\u7f6e\u6253\u5370\u673a\u6807\u7b7e\u504f\u79fb\u91cf" + value);
                break;
            }
            case 7: {
                int result7 = this.printText("FORMFEED\r\n");
                if (result7 == -1) {
                    throw new PrinterPortNullException("\u6253\u5370\u673a\u7aef\u53e3\u4e3a\u7a7a\u5f02\u5e38");
                }
                if (result7 != -3) break;
                throw new WriteException("\u5411\u6253\u5370\u673a\u5199\u5165\u6570\u636e\u5f02\u5e38");
            }
            case 8: {
                int result8 = this.printText("HOME\r\n");
                if (result8 == -1) {
                    throw new PrinterPortNullException("\u6253\u5370\u673a\u7aef\u53e3\u4e3a\u7a7a\u5f02\u5e38");
                }
                if (result8 != -3) break;
                throw new WriteException("\u5411\u6253\u5370\u673a\u5199\u5165\u6570\u636e\u5f02\u5e38");
            }
            case 9: {
                if (value != 0 && value != 1) {
                    throw new ParameterErrorException("\u8f93\u5165\u53c2\u6570\u5f02\u5e38");
                }
                if (value == 0) {
                    int result9 = this.printText("SET PRINTKEY OFF\r\n");
                    if (result9 == -1) {
                        throw new PrinterPortNullException("\u6253\u5370\u673a\u7aef\u53e3\u4e3a\u7a7a\u5f02\u5e38");
                    }
                    if (result9 != -3) break;
                    throw new WriteException("\u5411\u6253\u5370\u673a\u5199\u5165\u6570\u636e\u5f02\u5e38");
                }
                if (value != 1) break;
                int result9 = this.printText("SET PRINTKEY ON\r\n");
                if (result9 == -1) {
                    throw new PrinterPortNullException("\u6253\u5370\u673a\u7aef\u53e3\u4e3a\u7a7a\u5f02\u5e38");
                }
                if (result9 != -3) break;
                throw new WriteException("\u5411\u6253\u5370\u673a\u5199\u5165\u6570\u636e\u5f02\u5e38");
            }
            case 10: {
                if (value != 0 && value != 1) {
                    throw new ParameterErrorException("\u8f93\u5165\u53c2\u6570\u5f02\u5e38");
                }
                if (value == 0) {
                    int result10 = this.printText("SET KEY1 OFF\r\n");
                    if (result10 == -1) {
                        throw new PrinterPortNullException("\u6253\u5370\u673a\u7aef\u53e3\u4e3a\u7a7a\u5f02\u5e38");
                    }
                    if (result10 != -3) break;
                    throw new WriteException("\u5411\u6253\u5370\u673a\u5199\u5165\u6570\u636e\u5f02\u5e38");
                }
                if (value != 1) break;
                int result10 = this.printText("SET KEY1 ON\r\n");
                if (result10 == -1) {
                    throw new PrinterPortNullException("\u6253\u5370\u673a\u7aef\u53e3\u4e3a\u7a7a\u5f02\u5e38");
                }
                if (result10 != -3) break;
                throw new WriteException("\u5411\u6253\u5370\u673a\u5199\u5165\u6570\u636e\u5f02\u5e38");
            }
            case 11: {
                if (value != 0 && value != 1) {
                    throw new ParameterErrorException("\u8f93\u5165\u53c2\u6570\u5f02\u5e38");
                }
                if (value == 0) {
                    int result11 = this.printText("SET KEY2 OFF\r\n");
                    if (result11 == -1) {
                        throw new PrinterPortNullException("\u6253\u5370\u673a\u7aef\u53e3\u4e3a\u7a7a\u5f02\u5e38");
                    }
                    if (result11 != -3) break;
                    throw new WriteException("\u5411\u6253\u5370\u673a\u5199\u5165\u6570\u636e\u5f02\u5e38");
                }
                if (value != 1) break;
                int result11 = this.printText("SET KEY2 ON\r\n");
                if (result11 == -1) {
                    throw new PrinterPortNullException("\u6253\u5370\u673a\u7aef\u53e3\u4e3a\u7a7a\u5f02\u5e38");
                }
                if (result11 != -3) break;
                throw new WriteException("\u5411\u6253\u5370\u673a\u5199\u5165\u6570\u636e\u5f02\u5e38");
            }
            case 12: {
                if (value != 0 && value != 1) {
                    throw new ParameterErrorException("\u8f93\u5165\u53c2\u6570\u5f02\u5e38");
                }
                if (value == 0) {
                    int result12 = this.printText("SET TEAR OFF\r\n");
                    if (result12 == -1) {
                        throw new PrinterPortNullException("\u6253\u5370\u673a\u7aef\u53e3\u4e3a\u7a7a\u5f02\u5e38");
                    }
                    if (result12 == -3) {
                        throw new WriteException("\u5411\u6253\u5370\u673a\u5199\u5165\u6570\u636e\u5f02\u5e38");
                    }
                } else if (value == 1) {
                    int result13 = this.printText("SET TEAR ON\r\n");
                    if (result13 == -1) {
                        throw new PrinterPortNullException("\u6253\u5370\u673a\u7aef\u53e3\u4e3a\u7a7a\u5f02\u5e38");
                    }
                    if (result13 == -3) {
                        throw new WriteException("\u5411\u6253\u5370\u673a\u5199\u5165\u6570\u636e\u5f02\u5e38");
                    }
                }
                XLog.i(TAG, "PrinterInstance-----------------Tear---------" + value);
                break;
            }
            case 13: {
                if (value != 0 && value != 1) {
                    throw new ParameterErrorException("\u8f93\u5165\u53c2\u6570\u5f02\u5e38");
                }
                if (value == 1) {
                    int result14 = this.printText("SET PEEL OFF\r\n");
                    if (result14 == -1) {
                        throw new PrinterPortNullException("\u6253\u5370\u673a\u7aef\u53e3\u4e3a\u7a7a\u5f02\u5e38");
                    }
                    if (result14 == -3) {
                        throw new WriteException("\u5411\u6253\u5370\u673a\u5199\u5165\u6570\u636e\u5f02\u5e38");
                    }
                } else if (value == 0) {
                    int result15 = this.printText("SET PEEL ON\r\n");
                    if (result15 == -1) {
                        throw new PrinterPortNullException("\u6253\u5370\u673a\u7aef\u53e3\u4e3a\u7a7a\u5f02\u5e38");
                    }
                    if (result15 == -3) {
                        throw new WriteException("\u5411\u6253\u5370\u673a\u5199\u5165\u6570\u636e\u5f02\u5e38");
                    }
                }
                XLog.i(TAG, "PrinterInstance-----------------PEEL----------" + value);
            }
        }
    }

    public void openCashBoxTSPL(int t1, int t2) throws PrinterPortNullException, WriteException, ParameterErrorException {
        if (t1 < 0 || t1 > 255 || t2 < 0 || t2 > 255) {
            throw new ParameterErrorException("\u8f93\u5165\u53c2\u6570\u5f02\u5e38");
        }
        int result = this.printText("CASHDRAWER 0," + t1 + "," + t2 + "\r\n");
        if (result == -1) {
            throw new PrinterPortNullException("\u6253\u5370\u673a\u7aef\u53e3\u4e3a\u7a7a\u5f02\u5e38");
        }
        if (result == -3) {
            throw new WriteException("\u5411\u6253\u5370\u673a\u5199\u5165\u6570\u636e\u5f02\u5e38");
        }
    }

    public String getPrinterNameTSPL() throws ReadException, PrinterPortNullException, WriteException {
        String str = null;
        int readLen = -1;
        byte[] clear = new byte[20];
        this.read(clear);
        int result1 = this.printText("~!T\r\n");
        if (result1 == -1) {
            throw new PrinterPortNullException("\u6253\u5370\u673a\u7aef\u53e3\u4e3a\u7a7a\u5f02\u5e38");
        }
        if (result1 == -3) {
            throw new WriteException("\u5411\u6253\u5370\u673a\u5199\u5165\u6570\u636e\u5f02\u5e38");
        }
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e1) {
            e1.printStackTrace();
        }
        byte[] buffer = new byte[16];
        for (int i = 0; i < 3 && (readLen = this.read(buffer)) <= 0; ++i) {
        }
        if (readLen == -1) {
            throw new ReadException("\u4ece\u6253\u5370\u673a\u8bfb\u53d6\u6570\u636e\u5f02\u5e38");
        }
        try {
            byte[] bytes = new String(buffer).getBytes("utf-8");
            str = new String(bytes, "ascii");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            XLog.i(TAG, "\u8fd4\u56de\u7684\u6253\u5370\u673a\u7684\u578b\u53f7\u7684\u5b57\u7b26\u4e32----------------------------------\uff1a" + str);
        }
        return str;
    }

    public void setGAPTSPL(int value, int offset) throws PrinterPortNullException, WriteException, ParameterErrorException {
        if (value < 0 || value > 25 || offset < 0 || offset > this.paperHeightTSPL / 8) {
            throw new ParameterErrorException("\u8f93\u5165\u53c2\u6570\u5f02\u5e38");
        }
        int result = this.printText("GAP " + value + "mm," + offset + "mm\r\n");
        if (result == -1) {
            throw new PrinterPortNullException("\u6253\u5370\u673a\u7aef\u53e3\u4e3a\u7a7a\u5f02\u5e38");
        }
        if (result == -3) {
            throw new WriteException("\u5411\u6253\u5370\u673a\u5199\u5165\u6570\u636e\u5f02\u5e38");
        }
        XLog.i(TAG, "PrinteInstance----------------\u8bbe\u7f6e\u6807\u7b7e\u5782\u76f4\u95f4\u8ddd" + value + "------------------\u8bbe\u7f6e\u95f4\u9699\u504f\u79fb" + offset);
    }

    public void selectCodePageTSPL(int value) throws PrinterPortNullException, WriteException, ParameterErrorException {
        if (value < 0) {
            throw new ParameterErrorException("\u8f93\u5165\u53c2\u6570\u5f02\u5e38");
        }
        switch (value) {
            case 437: {
                break;
            }
            case 850: {
                break;
            }
            case 852: {
                break;
            }
            case 860: {
                break;
            }
            case 863: {
                break;
            }
            case 865: {
                break;
            }
            case 1250: {
                break;
            }
            case 1252: {
                break;
            }
            case 1253: {
                break;
            }
            case 1254: {
                break;
            }
            default: {
                value = 437;
            }
        }
        int result = this.printText("CODEPAGE " + value + "\r\n");
        if (result == -1) {
            throw new PrinterPortNullException("\u6253\u5370\u673a\u7aef\u53e3\u4e3a\u7a7a\u5f02\u5e38");
        }
        if (result == -3) {
            throw new WriteException("\u5411\u6253\u5370\u673a\u5199\u5165\u6570\u636e\u5f02\u5e38");
        }
    }

    public void selectCountryTSPL(int value) throws PrinterPortNullException, WriteException, ParameterErrorException {
        if (value < 0) {
            throw new ParameterErrorException("\u8f93\u5165\u53c2\u6570\u5f02\u5e38");
        }
        String value1 = "001";
        switch (value) {
            case 1: {
                value1 = "001";
                break;
            }
            case 2: {
                value1 = "002";
                break;
            }
            case 3: {
                value1 = "003";
                break;
            }
            case 33: {
                value1 = "033";
                break;
            }
            case 34: {
                value1 = "034";
                break;
            }
            case 39: {
                value1 = "039";
                break;
            }
            case 42: {
                value1 = "042";
                break;
            }
            case 44: {
                value1 = "044";
                break;
            }
            case 45: {
                value1 = "045";
                break;
            }
            case 46: {
                value1 = "046";
                break;
            }
            case 47: {
                value1 = "047";
                break;
            }
            case 49: {
                value1 = "049";
                break;
            }
            case 61: {
                value1 = "061";
                break;
            }
            default: {
                value1 = "001";
            }
        }
        int result = this.printText("COUNTRY " + value1 + "\r\n");
        if (result == -1) {
            throw new PrinterPortNullException("\u6253\u5370\u673a\u7aef\u53e3\u4e3a\u7a7a\u5f02\u5e38");
        }
        if (result == -3) {
            throw new WriteException("\u5411\u6253\u5370\u673a\u5199\u5165\u6570\u636e\u5f02\u5e38");
        }
    }

    public void beepTSPL(int level, int interval) throws PrinterPortNullException, WriteException, ParameterErrorException {
        if (level < 1 || level > 9 || interval < 1 || interval > 4095) {
            throw new ParameterErrorException("\u8f93\u5165\u53c2\u6570\u5f02\u5e38");
        }
        int result = this.printText("SOUND " + level + "," + interval + "\r\nBEEP\r\n");
        if (result == -1) {
            throw new PrinterPortNullException("\u6253\u5370\u673a\u7aef\u53e3\u4e3a\u7a7a\u5f02\u5e38");
        }
        if (result == -3) {
            throw new WriteException("\u5411\u6253\u5370\u673a\u5199\u5165\u6570\u636e\u5f02\u5e38");
        }
    }

    @SuppressLint(value={"NewApi"})
    public void downloadBitmap2PrinterTSPL(boolean isMove2Flash, InputStream in, String fileName, Context mContext) throws PrinterPortNullException, WriteException, ParameterErrorException {
        XLog.d(TAG, "yxz at PrinterInstan.java downloadBitmap2PrinterTSPL() ----begin");
        if (fileName == null || fileName.equals("") || in == null || mContext == null) {
            throw new ParameterErrorException("\u8f93\u5165\u53c2\u6570\u5f02\u5e38");
        }
        String isMovetoFlash = "";
        if (isMove2Flash) {
            isMovetoFlash = "F,";
        }
        try {
            String cmd = "DOWNLOAD " + isMovetoFlash + "\"" + fileName + ".BMP\"," + in.available() + ",";
            XLog.d(TAG, "yxz at PrinterInstan.java downloadBitmap2PrinterTSPL() cmd\uff1a" + cmd);
            int result = this.printText(cmd);
            if (result == -1) {
                throw new PrinterPortNullException("\u6253\u5370\u673a\u7aef\u53e3\u4e3a\u7a7a\u5f02\u5e38");
            }
            if (result == -3) {
                throw new WriteException("\u5411\u6253\u5370\u673a\u5199\u5165\u6570\u636e\u5f02\u5e38");
            }
            int data = this.sendBytesData(LabelPrint.readFromRaw(mContext, in));
            if (data == -1) {
                throw new PrinterPortNullException("\u6253\u5370\u673a\u7aef\u53e3\u4e3a\u7a7a\u5f02\u5e38");
            }
            if (result == -3) {
                throw new WriteException("\u5411\u6253\u5370\u673a\u5199\u5165\u6570\u636e\u5f02\u5e38");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        XLog.d(TAG, "yxz at PrinterInstan.java downloadBitmap2PrinterTSPL() ----end");
    }

    public void putBitmapTSPL(String fileName, int start_x, int start_y) throws PrinterPortNullException, WriteException, ParameterErrorException {
        XLog.d(TAG, "yxz at PrinterInstan.java putBitmapTSPL() ----start");
        if (start_x < 0 || start_x >= this.paperWidthTSPL || start_y < 0 || start_y >= this.paperHeightTSPL || fileName.equals("") || fileName == null) {
            throw new ParameterErrorException("\u8f93\u5165\u53c2\u6570\u5f02\u5e38");
        }
        String cmd = "PUTBMP " + start_x + "," + start_y + ",\"" + fileName + ".BMP\"\r\n";
        int result = this.printText(cmd);
        XLog.d(TAG, "yxz at PrinterInstan.java putBitmapTSPL() cmd:" + cmd);
        if (result == -1) {
            throw new PrinterPortNullException("\u6253\u5370\u673a\u7aef\u53e3\u4e3a\u7a7a\u5f02\u5e38");
        }
        if (result == -3) {
            throw new WriteException("\u5411\u6253\u5370\u673a\u5199\u5165\u6570\u636e\u5f02\u5e38");
        }
        XLog.d(TAG, "yxz at PrinterInstan.java putBitmapTSPL() ----end");
    }

    public void sendStrToPrinterTSPL(String str) throws PrinterPortNullException, WriteException, ParameterErrorException {
        if (str.equals("") || str == null) {
            throw new ParameterErrorException("\u8f93\u5165\u53c2\u6570\u5f02\u5e38");
        }
        int result = this.printText(str);
        if (result == -1) {
            throw new PrinterPortNullException("\u6253\u5370\u673a\u7aef\u53e3\u4e3a\u7a7a\u5f02\u5e38");
        }
        if (result == -3) {
            throw new WriteException("\u5411\u6253\u5370\u673a\u5199\u5165\u6570\u636e\u5f02\u6837");
        }
    }

    public void printSelfTestTSPL() throws WriteException, PrinterPortNullException {
        int result = this.printText("SELFTEST\r\n");
        if (result == -1) {
            throw new PrinterPortNullException("\u6253\u5370\u673a\u7aef\u53e3\u4e3a\u7a7a\u5f02\u5e38");
        }
        if (result == -3) {
            throw new WriteException("\u5411\u6253\u5370\u673a\u5199\u5165\u6570\u636e\u5f02\u6837");
        }
    }

    public void setLabelReferenceTSPL(int left, int top) throws WriteException, PrinterPortNullException, ParameterErrorException {
        if (left < 0 || left > this.paperWidthTSPL / 8 || left == this.paperWidthTSPL / 8 || top < 0 || top > this.paperHeightTSPL / 8 || top == this.paperHeightTSPL / 8) {
            throw new ParameterErrorException("\u8f93\u5165\u53c2\u6570\u5f02\u5e38");
        }
        int result = this.printText("REFERENCE " + left * 8 + "," + top * 8 + "\r\n");
        if (result == -1) {
            throw new PrinterPortNullException("\u6253\u5370\u673a\u7aef\u53e3\u4e3a\u7a7a\u5f02\u5e38");
        }
        if (result == -3) {
            throw new WriteException("\u5411\u6253\u5370\u673a\u5199\u5165\u6570\u636e\u5f02\u6837");
        }
    }

    public void initPrinter() {
        this.sendBytesData(new byte[]{27, 64});
    }

    public void setLeftMargin(int inchs) {
        byte nL = (byte)(inchs % 256);
        byte nH = (byte)(inchs / 256);
        this.sendBytesData(new byte[]{29, 76, nL, nH});
    }

    public void setFont(int mCharacterType, int mWidth, int mHeight, int mBold, int mUnderline) {
        byte mFontSize = 0;
        byte mFontMode = 0;
        if (mBold != 0 && mBold != 1) {
            mBold = 0;
        }
        mFontMode = (byte)(mFontMode | mBold << 3);
        if (mUnderline != 0 && mUnderline != 1) {
            mUnderline = 0;
        }
        mFontMode = (byte)(mFontMode | mUnderline << 7);
        if (mCharacterType != 0 && mCharacterType != 1) {
            mCharacterType = 0;
        }
        mFontMode = (byte)(mFontMode | mCharacterType << 0);
        this.sendBytesData(new byte[]{27, 33, mFontMode});
        if (mWidth < 0 || mWidth > 7) {
            mWidth = 0;
        }
        mFontSize = (byte)(mFontSize | mWidth << 4);
        if (mHeight < 0 | mHeight > 7) {
            mHeight = 0;
        }
        mFontSize = (byte)(mFontSize | mHeight);
        this.sendBytesData(new byte[]{29, 33, mFontSize});
    }

    public void setPrinter(int command, int value) {
        byte[] arrayOfByte = new byte[3];
        switch (command) {
            case 0: {
                arrayOfByte[0] = 27;
                arrayOfByte[1] = 74;
                break;
            }
            case 1: {
                arrayOfByte[0] = 27;
                arrayOfByte[1] = 100;
                break;
            }
            case 4: {
                arrayOfByte[0] = 27;
                arrayOfByte[1] = 86;
                break;
            }
            case 11: {
                arrayOfByte[0] = 27;
                arrayOfByte[1] = 32;
                break;
            }
            case 13: {
                arrayOfByte[0] = 27;
                arrayOfByte[1] = 97;
                if (value <= 2 && value >= 0) break;
                value = 0;
            }
        }
        arrayOfByte[2] = (byte)value;
        this.sendBytesData(arrayOfByte);
    }

    public String getCharsetName() {
        return this.charsetName;
    }

    public void setCharsetName(String charsetName) {
        this.charsetName = charsetName;
    }

    public void openCashbox(boolean cashbox1, boolean cashbox2) {
        byte[] drawCommand;
        if (cashbox1) {
            drawCommand = new byte[]{27, 112, 0, 50, 50};
            this.sendBytesData(drawCommand);
        }
        if (cashbox2) {
            drawCommand = new byte[]{27, 112, 1, 50, 50};
            this.sendBytesData(drawCommand);
        }
    }

    public void cutPaper(int cutterType, int n) {
        byte[] cutCommand = new byte[4];
        if (cutterType == 48 || cutterType == 49) {
            n = 0;
        }
        cutCommand[0] = 29;
        cutCommand[1] = 86;
        cutCommand[2] = (byte)cutterType;
        cutCommand[3] = (byte)n;
        XLog.e(TAG, "yxz at PrinterInstance.java cutPaper() \u53d1\u9001\u5207\u5200\u6570\u636e");
        this.sendBytesData(cutCommand);
    }

    public void ringBuzzer(int time) {
        this.sendBytesData(new byte[]{29, 105, (byte)time});
    }

    public void blackLableFind() {
        this.sendBytesData(new byte[]{12});
    }

    public boolean isPaperOut() {
        return this.getCurrentStatus() == -2;
    }

    public boolean isPaperWillOut() {
        return this.getCurrentStatus() == -3;
    }

    public int getCurrentStatus() {
        XLog.d(TAG, "yxz at PrinterInstance.java getCurrentStatus() ----begin");
        byte paperData = 0;
        byte uncapData = 0;
        uncapData = this.getDatas(2);
        XLog.d(TAG, "yxz at PrinterInstance.java getCurrentStatus() 10 04 02 \u67e5\u8be2\u6253\u5370\u673a\u5f00\u76d6\u72b6\u6001\u7684\u8fd4\u56de\u503c uncapData:" + uncapData);
        if (uncapData == -1) {
            XLog.e(TAG, "yxz at PrinterInstance.java getCurrentStatus() \u67e5\u8be2\u6253\u5370\u673a\u5f00\u76d6\u72b6\u6001\uff1a\u5199\u5165\u6570\u636e\u5931\u8d25");
            return -1;
        }
        if (uncapData == -2) {
            XLog.e(TAG, "yxz at PrinterInstance.java getCurrentStatus() \u67e5\u8be2\u6253\u5370\u673a\u5f00\u76d6\u72b6\u6001\uff1a\u8bfb\u6570\u636e\u5931\u8d25");
            return -5;
        }
        if ((uncapData & 4) != 0) {
            XLog.d(TAG, "yxz at PrinterInstance.java getCurrentStatus() \u67e5\u8be2\u6253\u5370\u673a\u5f00\u76d6\u72b6\u6001\uff1a\u5f00\u76d6");
            return -4;
        }
        paperData = this.getDatas(4);
        XLog.d(TAG, "yxz at PrinterInstance.java getCurrentStatus() 10 04 04 \u67e5\u8be2\u6253\u5370\u673a\u7eb8\u72b6\u6001\u7684\u8fd4\u56de\u503c paperData" + paperData);
        if (paperData == -1) {
            XLog.e(TAG, "yxz at PrinterInstance.java getCurrentStatus() \u67e5\u8be2\u6253\u5370\u673a\u7eb8\u72b6\u6001\uff1a\u5199\u5165\u6570\u636e\u5931\u8d25");
            return -1;
        }
        if (paperData == -2) {
            XLog.e(TAG, "yxz at PrinterInstance.java getCurrentStatus() \u67e5\u8be2\u6253\u5370\u673a\u7eb8\u72b6\u6001\uff1a\u8bfb\u6570\u636e\u5931\u8d25");
            return -5;
        }
        if ((paperData & 0x60) == 96) {
            XLog.e(TAG, "yxz at PrinterInstance.java getCurrentStatus() \u67e5\u8be2\u6253\u5370\u673a\u7eb8\u72b6\u6001\uff1a\u7f3a\u7eb8");
            return -2;
        }
        if ((paperData & 0xC) == 12) {
            XLog.e(TAG, "yxz at PrinterInstance.java getCurrentStatus() \u67e5\u8be2\u6253\u5370\u673a\u7eb8\u72b6\u6001\uff1a\u7eb8\u5c06\u5c3d");
            return -3;
        }
        XLog.d(TAG, "yxz at PrinterInstance.java getCurrentStatus() ----end");
        return 0;
    }

    public int resetFeedDistance() {
        int isSendSuccess = 0;
        byte[] data = new byte[]{29, 103, 48, 0, 20, 0};
        for (int i = 0; i < 3; ++i) {
            isSendSuccess = this.sendBytesData(data);
            if (isSendSuccess <= 0) continue;
            XLog.d(TAG, "yxz at PrinterInstance.java resetFeedDistance() write ok!");
            return 0;
        }
        return -1;
    }

    public int getFeedDistance() {
        int i;
        int isSendSuccess = 0;
        byte[] tempReadBytes = new byte[512];
        int oldDateReadLen = this.read(tempReadBytes);
        if (oldDateReadLen != 0) {
            XLog.e(TAG, "yxz at PrinterInstance.java getFeedDistance() old data this.tempReadBytes!=null");
        }
        byte[] data = new byte[]{29, 103, 50, 0, 20, 0};
        for (i = 0; i < 3; ++i) {
            isSendSuccess = this.sendBytesData(data);
            if (isSendSuccess <= 0) continue;
            XLog.d(TAG, "yxz at PrinterInstance.java getFeedDistance() write ok!");
            break;
        }
        if (isSendSuccess < 0) {
            return -1;
        }
        for (i = 0; i < 10; ++i) {
            byte[] buffer = new byte[1024];
            int readLength = this.read(buffer);
            XLog.d("yxz ", "yxz at PrinterInstance.java getFeedDistance() \u7b2c" + i + "\u6b21\u8bfb\u53d6\u5230\u7684\u6570\u636e\u957f\u5ea6\uff1a" + readLength);
            if (readLength <= 0) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                continue;
            }
            byte[] retData = new byte[readLength];
            System.arraycopy(buffer, 0, retData, 0, readLength);
            XLog.d("yxz ", "yxz at PrinterInstance.java getFeedDistance() \u8bfb\u53d6\u5230\u6253\u5370\u673a\u8fd4\u56de\uff1a" + Utils.bytesToHexString(retData, readLength));
            for (int j = 0; j < readLength; ++j) {
                if (95 != retData[j]) continue;
                byte[] ret = new byte[readLength - j - 1];
                System.arraycopy(retData, j + 1, ret, 0, ret.length);
                String retStr = new String(ret);
                return 2 * Integer.parseInt(retStr.substring(i, retStr.length() - 1));
            }
            return -3;
        }
        return -2;
    }

    public byte getDatas(int statusType) {
        XLog.d(TAG, "yxz at PrinterInstance.java getData() ----begin");
        int sendLength = -1;
        int readLength = -1;
        byte[] retStatus = null;
        byte[] command = new byte[3];
        command[0] = 16;
        command[1] = 4;
        try {
            switch (statusType) {
                case 4: {
                    command[2] = 4;
                    break;
                }
                case 3: {
                    command[2] = 3;
                    break;
                }
                case 2: {
                    command[2] = 2;
                }
            }
            for (int m = 0; m < 3; ++m) {
                sendLength = this.sendBytesData(command);
                if (sendLength <= 0) {
                    if (m == 2) {
                        XLog.e(TAG, "yxz at PrinterInstance.java getData()\u591a\u6b21\u53d1\u9001\u5931\u8d25\uff0csendLength<=0");
                        return -2;
                    }
                    XLog.e(TAG, "yxz at PrinterInstance.java getData() \u7b2c" + m + "\u6b21\u53d1\u900110 04 0" + statusType + "\u5931\u8d25\uff0c\u91cd\u65b0\u53d1\u9001");
                    Thread.sleep(50L);
                    continue;
                }
                for (int i = 0; i < 10; ++i) {
                    byte[] buffer = new byte[1024];
                    readLength = this.read(buffer);
                    XLog.d("yxz ", "yxz at PrinterInstance.java getData() \u7b2c" + i + "\u6b21\u8bfb\u53d6\u5230\u7684\u6570\u636e\u957f\u5ea6\uff1a" + readLength);
                    if (readLength > 0) {
                        retStatus = new byte[readLength];
                        System.arraycopy(buffer, 0, retStatus, 0, readLength);
                        XLog.d("yxz ", "yxz at PrinterInstance.java getData() \u8bfb\u53d6\u5230\u6253\u5370\u673a\u8fd4\u56de\uff1a" + retStatus[readLength - 1]);
                        return retStatus[readLength - 1];
                    }
                    Thread.sleep(50L);
                }
                if (readLength > 0) continue;
                if (m == 2) {
                    XLog.e(TAG, "yxz at PrinterInstance.java getData() \u591a\u6b21\u53d1\u9001\u6210\u529f\uff0c\u4f46\u672a\u6b63\u5e38\u8bfb\u53d6\u5230\u8fd4\u56de\uff0c\u901a\u4fe1\u5f02\u5e38");
                    return -1;
                }
                XLog.e(TAG, "yxz at PrinterInstance.java getData() \u7b2c" + m + "\u6b21\u53d1\u9001\u6210\u529f\u540e\uff0c10\u6b21\u90fd\u672a\u63a5\u6536\u5230\u6253\u5370\u673a\u8fd4\u56de\uff0creadLength<=0\uff0c\u91cd\u65b0\u53d1\u9001");
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            XLog.e(TAG, "yxz at PrinterInstance.java getDatas() Exception! e.getMessage()=" + e.getMessage());
            return -1;
        }
        XLog.d(TAG, "yxz at PrinterInstance.java getData() ----begin");
        return -1;
    }

    public int getPrintingStatus(int timeout) {
        XLog.d(TAG, "yxz at PrinterInstance.java getPrintingStatus() ----begin");
        if (myPrinterPort instanceof USBPort) {
            timeout += 1000;
        }
        int timeDiff = 500;
        int isSendSuccess = 0;
        int printerStatus = 0;
        try {
            int count;
            byte[] tempReadBytes = new byte[512];
            int oldDateReadLen = this.read(tempReadBytes);
            if (oldDateReadLen != 0) {
                XLog.e(TAG, "yxz at PrinterInstance.java getPrintingStatus() old data this.tempReadBytes!=null");
            }
            XLog.d(TAG, "yxz at PrinterInstance.java getPrintingStatus() \u5f00\u59cb\u67e5\u8be2\uff01");
            for (int i = 0; i < 3; ++i) {
                isSendSuccess = this.sendBytesData(new byte[]{29, 40, 72, 6, 0, 48, 48, 49, 50, 51, 52});
                if (isSendSuccess <= 0) continue;
                XLog.d(TAG, "yxz at PrinterInstance.java getPrintingStatus() write ok!");
                break;
            }
            if (isSendSuccess < 0) {
                printerStatus = this.getCurrentStatus();
                XLog.e(TAG, "yxz at PrinterInstance.java getPrintingStatus() write failed! getPrinterStatus is:" + printerStatus);
                if (printerStatus != -1) {
                    XLog.e(TAG, "yxz at PrinterInstance.java getPrintingStatus() write failed! \u672a\u77e5\u5f02\u5e38");
                    return -1;
                }
                XLog.e(TAG, "yxz at PrinterInstance.java getPrintingStatus() write failed! \u67e5\u8be2\u6307\u4ee4\u53d1\u9001\u5931\u8d25\uff0c\u901a\u4fe1\u5f02\u5e38\uff01");
                return -6;
            }
            Thread.sleep(100L);
            byte[] pReadBytes = new byte[16];
            XLog.d(TAG, "yxz at PrinterInstance.java getPrintingStatus() read count=" + count + "\u6b21");
            int readLen = 0;
            for (count = (timeout - 100 + 200) / timeDiff; count > 0; --count) {
                readLen = this.read(pReadBytes);
                if (readLen != 0) {
                    XLog.d(TAG, "yxz at PrinterInstance.java getPrintingStatus() readLen is not null!");
                    break;
                }
                XLog.d(TAG, "yxz at PrinterInstance.java getPrintingStatus() sleep(500)...");
                Thread.sleep(timeDiff);
                XLog.d(TAG, "yxz at PrinterInstance.java getPrintingStatus() \u7b2c" + (timeout / timeDiff - count) + "\u6b21\u8bfb\u53d6\u662f\u5426\u6253\u5370\u5b8c\u6210\u8fd4\u56de");
            }
            XLog.d(TAG, "yxz at PrinterInstance.java getPrintingStatus() readLen:" + readLen);
            XLog.d(TAG, "yxz at PrinterInstance.java getPrintingStatus() \u6253\u5370\u673a\u8fd4\u56de\u7684\u6570\u636e\uff1a" + Utils.bytesToHexString(pReadBytes, readLen));
            if (readLen == 0) {
                XLog.d(TAG, "yxz at PrinterInstance.java getPrintingStatus() timeout and read pReadBytes is null!");
                printerStatus = this.getCurrentStatus();
                XLog.d(TAG, "yxz at PrinterInstance.java getPrintingStatus() read failed! and getPrinterStatus is:" + printerStatus);
                if (printerStatus == 0) {
                    XLog.d(TAG, "yxz at PrinterInstance.java getPrintingStatus() read failed! for: \u672a\u6253\u5370\u5b8c\u6210\uff0c\u6b63\u5728\u6253\u5370\u4e2d\uff01");
                    return -2;
                }
                if (printerStatus == -2) {
                    XLog.d(TAG, "yxz at PrinterInstance.java getPrintingStatus() read failed! for: \u672a\u6253\u5370\u5b8c\u6210\uff0c\u56e0\u4e3a\u7f3a\u7eb8\uff01");
                    return -3;
                }
                if (printerStatus == -4) {
                    XLog.d(TAG, "yxz at PrinterInstance.java getPrintingStatus() read failed! for: \u6253\u5370\u672a\u5b8c\u6210\uff0c\u7eb8\u8231\u76d6\u5f00\u76d6\uff01");
                    return -4;
                }
                if (printerStatus == -1) {
                    XLog.d(TAG, "yxz at PrinterInstance.java getPrintingStatus() read failed! for: \u6253\u5370\u672a\u5b8c\u6210\uff0c\u4e0e\u6253\u5370\u673a\u901a\u4fe1\u5931\u8d25!");
                    return -5;
                }
            }
            if (readLen < 7) {
                XLog.e(TAG, "yxz at PrinterInstance.java getPrintingStatus() pReadBytes.length!=7 pReadBytes.length=" + pReadBytes.length);
                return 0;
            }
            XLog.i(TAG, "yxz at PrinterInstance.java getPrintingStatus() \u8bfb\u52307\u4e2a\u4ee5\u4e0a\u6570\u636e\u662f:" + Utils.bytesToHexString(pReadBytes, readLen));
            if (pReadBytes[0] == 55 && pReadBytes[1] == 34 && pReadBytes[2] == 49 && pReadBytes[3] == 50 && pReadBytes[4] == 51 && pReadBytes[5] == 52 && pReadBytes[6] == 0) {
                XLog.d(TAG, "yxz at PrinterInstance.java getPrintingStatus() \u5f53\u524d\u6253\u5370\u5df2\u7ecf\u5b8c\u6210\uff01");
                XLog.d(TAG, "yxz at PrinterInstance.java getPrintingStatus() ----end");
                return 0;
            }
            XLog.e(TAG, "yxz at PrinterInstance.java getPrintingStatus() \u63a5\u6536\u6570\u636e\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
            return -7;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            XLog.e(TAG, "yxz at PrinterInstance.java getPrintingStatus() Exception! ex.getMessage()=" + ex.getMessage());
            return -1;
        }
    }

    public int printSelfCheckingPage() {
        byte[] data = new byte[]{29, 40, 65, 2, 0, 0, 2};
        int result = this.sendBytesData(data);
        return result;
    }

    public void isSetAble(boolean isSetable) {
        if (myPrinterPort == null) {
            return;
        }
        if (myPrinterPort instanceof AIDLPort) {
            ((AIDLPort)myPrinterPort).isSetAble(isSetable);
        }
    }

    public boolean getSetable() {
        if (myPrinterPort == null) {
            return false;
        }
        if (myPrinterPort instanceof AIDLPort) {
            return ((AIDLPort)myPrinterPort).getSetAble();
        }
        return false;
    }

    public void setOnPrintListener(OnPrintListener listener) {
        if (myPrinterPort == null) {
            return;
        }
        if (myPrinterPort instanceof AIDLPort) {
            ((AIDLPort)myPrinterPort).setOnPrintListener(listener);
        }
    }

    public void doBeforePrint() {
        if (myPrinterPort == null) {
            return;
        }
        if (myPrinterPort instanceof AIDLPort && ((AIDLPort)myPrinterPort).doBeforePrint()) {
            mPrinter.closeConnection();
        }
    }

    public void doAfterPrint() {
        if (myPrinterPort == null) {
            return;
        }
        if (myPrinterPort instanceof AIDLPort && ((AIDLPort)myPrinterPort).doAfterPrint()) {
            mPrinter.closeConnection();
        }
    }

    public void doOnReceiveParserdata(int type, byte[] data) {
        if (myPrinterPort == null) {
            return;
        }
        if (myPrinterPort instanceof AIDLPort && ((AIDLPort)myPrinterPort).doOnReceiveParserdata(type, data)) {
            mPrinter.closeConnection();
        }
    }

    static {
        mPrinter = null;
    }
}

