/*
 * Decompiled with CFR 0.152.
 */
package com.printer.sdk;

import android.content.Context;
import android.graphics.Bitmap;
import com.printer.sdk.PrinterConstants;
import com.printer.sdk.utils.Utils;
import com.printer.sdk.utils.XLog;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;

public class LabelPrint {
    private static final String TAG = "LabelPrint";
    public static byte[] LabelBuf = new byte[8192];
    public static int LabelDataSize = 0;

    public static void buf_write(byte[] buf, int len, int timeout) {
        if (LabelDataSize > 8192) {
            return;
        }
        for (int i = 0; i < len; ++i) {
            LabelPrint.LabelBuf[LabelPrint.LabelDataSize + i] = buf[i];
        }
        LabelDataSize += len;
    }

    public static String label_set_page(int width, int height, int rotate) {
        String str = "! 0 200 200 " + height + " 1\r\nPW " + width + "\r\n";
        XLog.d("fdh", str);
        return str;
    }

    public static String label_put_box(int lineWidth, int top_left_x, int top_left_y, int bottom_right_x, int bottom_right_y) {
        String str = "BOX " + top_left_x + " " + top_left_y + " " + bottom_right_x + " " + bottom_right_y + " " + lineWidth + "\r\n";
        XLog.d("fdh", str);
        return str;
    }

    public static String label_print(PrinterConstants.PRotate rotate, int skip) {
        String str = null;
        int horizontal = 0;
        switch (rotate) {
            case Rotate_0: {
                horizontal = 0;
                break;
            }
            case Rotate_90: {
                horizontal = 1;
                break;
            }
            case Rotate_270: {
                horizontal = 2;
                break;
            }
            default: {
                horizontal = 0;
            }
        }
        str = skip == 1 ? "PR " + horizontal + "\r\nFORM\r\nPRINT\r\n" : "PR " + horizontal + "\r\nPRINT\r\n";
        XLog.d("fdh", str);
        return str;
    }

    public static String label_put_lines(int width, int x0, int y0, int x1, int y1, boolean isSolidLine) {
        String str = null;
        str = isSolidLine ? "LINE " + x0 + " " + y0 + " " + x1 + " " + y1 + " " + width + "\r\n" : "DL " + x0 + " " + y0 + " " + x1 + " " + y1 + " " + width + " 1 1\r\n";
        XLog.d("fdh", str);
        return str;
    }

    public static String label_put_barcode(int x, int y, String text, String barcodetype, int rotate, int linewidth, int height) {
        String st1 = "B";
        if (rotate != 0) {
            st1 = "VB";
        }
        String str = st1 + " " + barcodetype + " " + linewidth + " 2 " + height + " " + x + " " + y + " " + text + "\r\n";
        XLog.d("yxz", "yxz at LabelPrint.java label_put_barcode() str:" + str);
        return str;
    }

    public static String label_put_drawBarCode(int x, int y, String text, int barcodeType, int linewidth, int height, int rotate) {
        String str1 = "B";
        if (rotate != 0) {
            str1 = "VB";
        }
        String str = str1 + " 128 " + linewidth + " 2 " + height + " " + x + " " + y + " " + text + "\r\n";
        XLog.d("yxz", str);
        return str;
    }

    public static String label_put_drawQrCode(int x, int y, String text, int rotate) {
        String str1 = "B";
        if (rotate != 0) {
            str1 = "VB";
        }
        String str = str1 + " QR " + x + " " + y + " M 2 U 6 \r\nMA," + text + "\r\nENDQR\r\n";
        XLog.d("fdh", str);
        return str;
    }

    public static String label_put_text(int x, int y, String text, int fontNaID, int fontSzID, PrinterConstants.PRotate rotate, int bold, int underline, int reverse) {
        String st1 = "TEXT";
        if (rotate == PrinterConstants.PRotate.Rotate_90) {
            st1 = "T90";
        } else if (rotate == PrinterConstants.PRotate.Rotate_180) {
            st1 = "T180";
        } else if (rotate == PrinterConstants.PRotate.Rotate_270) {
            st1 = "T270";
        }
        String str = "UT " + underline + "\r\nSETBOLD " + bold + "\r\nIT " + reverse + "\r\n" + st1 + " " + fontNaID + " " + fontSzID + " " + x + " " + y + " " + text + "\r\n";
        XLog.d("fdh", str);
        return str;
    }

    protected static Map<Integer, String[]> dealContent(String text, int RowWidth, int FontRealSize, int areaHeight) {
        HashMap<Integer, String[]> contentList = new HashMap<Integer, String[]>();
        int tNum = RowWidth / FontRealSize * 2;
        int nNum = 0;
        int fNum = 0;
        int fLen = 0;
        int rCount = 0;
        while (!text.equals("") && text != null && areaHeight > FontRealSize) {
            char[] testArrays = text.toCharArray();
            char[] retArry = new char[100];
            for (int i = 0; i < testArrays.length; ++i) {
                nNum = LabelPrint.isChinese(testArrays[i]) ? (nNum += 2) : ++nNum;
                if (nNum > tNum) break;
                fNum = i;
                fLen = nNum;
                retArry[i] = testArrays[i];
            }
            String tempText = String.valueOf(retArry).trim();
            contentList.put(rCount, new String[]{fLen + "", tempText});
            text = text.substring(fNum + 1);
            ++rCount;
            fNum = 0;
            nNum = 0;
            fLen = 0;
            areaHeight -= FontRealSize;
        }
        return contentList;
    }

    protected static boolean isChinese(char c) {
        Character.UnicodeBlock ub = Character.UnicodeBlock.of(c);
        return ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS || ub == Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS || ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A || ub == Character.UnicodeBlock.GENERAL_PUNCTUATION || ub == Character.UnicodeBlock.CJK_SYMBOLS_AND_PUNCTUATION || ub == Character.UnicodeBlock.HALFWIDTH_AND_FULLWIDTH_FORMS;
    }

    public static String bmp2str(Bitmap bmp) {
        String ret = "";
        for (int i = 0; i < bmp.getHeight(); ++i) {
            int k = bmp.getWidth() % 8;
            for (int j = 0; j < bmp.getWidth() - k; j += 8) {
                int n1 = bmp.getPixel(j + 0, i) == -1 ? 0 : 128;
                int n2 = bmp.getPixel(j + 1, i) == -1 ? 0 : 64;
                int n3 = bmp.getPixel(j + 2, i) == -1 ? 0 : 32;
                int n4 = bmp.getPixel(j + 3, i) == -1 ? 0 : 16;
                int n5 = bmp.getPixel(j + 4, i) == -1 ? 0 : 8;
                int n6 = bmp.getPixel(j + 5, i) == -1 ? 0 : 4;
                int n7 = bmp.getPixel(j + 6, i) == -1 ? 0 : 2;
                int n8 = bmp.getPixel(j + 7, i) == -1 ? 0 : 1;
                int num = n1 + n2 + n3 + n4 + n5 + n6 + n7 + n8;
                byte ret1 = (byte)num;
                ret = ret + LabelPrint.int2String(ret1);
            }
            if (k <= 0) continue;
            int tmp = 0;
            for (int m = 0; m < k; ++m) {
                tmp = (int)((double)tmp + (bmp.getPixel(bmp.getWidth() - m - 1, i) == -1 ? 0.0 : Math.pow(2.0, 7 - m)));
            }
            byte ret1 = (byte)tmp;
            ret = ret + LabelPrint.int2String(ret1);
        }
        return ret;
    }

    public static String int2String(byte num) {
        byte b1 = (byte)((num & 0xF0) >> 4);
        byte b2 = (byte)(num & 0xF);
        if (b1 >= 0 && b1 <= 9) {
            b1 = (byte)(b1 | 0x30);
        }
        if (b1 >= 10 && b1 <= 15) {
            b1 = (byte)(65 + b1 - 10);
        }
        if (b2 >= 0 && b2 <= 9) {
            b2 = (byte)(b2 | 0x30);
        }
        if (b2 >= 10 && b2 <= 15) {
            b2 = (byte)(65 + b2 - 10);
        }
        byte[] bb = new byte[]{b1, b2};
        String retStr = "";
        try {
            retStr = new String(bb, "GBK");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return retStr;
    }

    public static String label_set_pageTSPL(int width, int height) {
        width = width % 8 != 0 ? width / 8 + 1 : (width /= 8);
        height = height % 8 != 0 ? height / 8 + 1 : (height /= 8);
        XLog.d("yxz", "SIZE " + width + " mm," + height + " mm");
        return "SIZE " + width + " mm," + height + " mm\r\n";
    }

    public static String label_put_linesTSPL(int x, int y, int lineLength, int lineHeight) {
        String str = null;
        str = "BAR " + x + "," + y + "," + lineLength + "," + lineHeight + "\r\n";
        XLog.d("yxz", str);
        return str;
    }

    public static String label_put_boxTSPL(int lineWidth, int top_left_x, int top_left_y, int bottom_right_x, int bottom_right_y) {
        String str = "BOX " + top_left_x + "," + top_left_y + "," + bottom_right_x + "," + bottom_right_y + "," + lineWidth + "\r\n";
        XLog.d("yxz", str);
        return str;
    }

    public static String label_put_circleTSPL(int start_x, int start_y, int diameter, int thickness) {
        String str = "CIRCLE " + start_x + "," + start_y + "," + diameter + "," + thickness + "\r\n";
        XLog.d("yxz", str);
        return str;
    }

    public static String label_put_textTSPL(int x, int y, boolean isSimplifiedChinese, int xMultiplication, int yMultiplication, PrinterConstants.PRotate rotate, String content) {
        String st1 = "TEXT ";
        String str2 = "\"TST24.BF2\"";
        int rotate1 = 0;
        if (rotate == PrinterConstants.PRotate.Rotate_90) {
            rotate1 = 90;
        } else if (rotate == PrinterConstants.PRotate.Rotate_180) {
            rotate1 = 180;
        } else if (rotate == PrinterConstants.PRotate.Rotate_270) {
            rotate1 = 270;
        }
        if (isSimplifiedChinese) {
            str2 = "\"TSS24.BF2\"";
        }
        String str = st1 + x + "," + y + "," + str2 + "," + rotate1 + "," + xMultiplication + "," + yMultiplication + ",\"" + content + "\"\r\n";
        XLog.d("yxz", str);
        return str;
    }

    public static String label_put_drawBarcodeTSPL(int start_x, int start_y, String codeType, int height, int readable, int rotate, int narrow, int wide, String content) {
        String str = null;
        str = "BARCODE " + start_x + "," + start_y + ",\"" + codeType + "\"," + height + "," + readable + "," + rotate + "," + narrow + "," + wide + ",\"" + content + "\"\r\n";
        XLog.d("yxz", "------------" + str);
        return str;
    }

    public static String label_put_drawQrcodeTSPL(int start_x, int start_y, String level, int width, int rotate, String content) {
        String str = "QRCODE " + start_x + "," + start_y + "," + level + "," + width + ",A," + rotate + ",\"" + content + "\"\r\n";
        XLog.d("yxz", str);
        return str;
    }

    public static String label_put_drawDataMatrixTSPL(int start_x, int start_y, int width, int lel, String content) {
        String str = "DMATRIX " + start_x + "," + start_y + "," + width + "," + lel + ",x" + width + ",0,0,\"" + content + "\"\r\n";
        XLog.d("yxz", str);
        return str;
    }

    public static String label_put_drawPDF417TSPL(int start_x, int start_y, int width, int lel, PrinterConstants.PRotate rotate, String content) {
        int rotate1 = 0;
        if (rotate == PrinterConstants.PRotate.Rotate_90) {
            rotate1 = 90;
        } else if (rotate == PrinterConstants.PRotate.Rotate_180) {
            rotate1 = 180;
        } else if (rotate == PrinterConstants.PRotate.Rotate_270) {
            rotate1 = 270;
        }
        String str = "PDF417 " + start_x + "," + start_y + "," + width + "," + lel + "," + rotate1 + ",\"" + content + "\"\r\n";
        XLog.d("yxz", str);
        return str;
    }

    public static String label_put_drawGraphicTSPL(int start_x, int start_y, int bmp_size_x, int bmp_size_y, int mode) {
        String str = null;
        str = "BITMAP " + start_x + "," + start_y + "," + bmp_size_x + "," + bmp_size_y + "," + mode + ",";
        XLog.d("yxz", str);
        return str;
    }

    public static String label_printTSPL(int numbers, int mCopys) {
        String str = null;
        str = "PRINT " + numbers + "," + mCopys + "\r\n";
        XLog.d("yxz", str);
        return str;
    }

    public static String label_reverseTL(int startX, int startY, int endX, int endY) {
        return "REVERSE " + startX + "," + startY + "," + endX + "," + endY + "\r\n";
    }

    public static byte[] readFromRaw(Context mContext, InputStream in) {
        XLog.d(TAG, "yxz at LabelPrint.java readFromRaw()  ----begin");
        byte[] buffer = null;
        try {
            int length = in.available();
            buffer = new byte[length];
            in.read(buffer);
            in.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (buffer != null) {
            XLog.d(TAG, "yxz at LabelPrint.java readFromRaw() \u4eceraw\u4e0b\u8bfb\u5230\u7684\u56fe\u7247byte\u6570\u7ec4\u957f\u5ea6\u4e3a:" + buffer.length);
            XLog.d(TAG, "yxz at LabelPrint.java readFromRaw() \u4eceraw\u4e0b\u8bfb\u5230\u7684\u56fe\u7247byte\u6570\u7ec4\u6570\u636e\u4e3a:" + Utils.bytesToHexString(buffer, buffer.length));
        }
        XLog.d(TAG, "yxz at LabelPrint.java readFromRaw()  ----end");
        return buffer;
    }

    public static byte[] bmp2bytes(Bitmap bmp) {
        int height = bmp.getHeight();
        int width = bmp.getWidth();
        int[] p = new int[8];
        int w = 0;
        boolean flag = false;
        if (bmp.getWidth() % 8 != 0) {
            w = width / 8 + 1;
            flag = true;
        } else {
            flag = false;
            w = width / 8;
        }
        byte[] imagbuf = new byte[height * w];
        byte[] linebuf = null;
        int k = bmp.getWidth() % 8;
        for (int i = 0; i < bmp.getHeight(); ++i) {
            int m;
            linebuf = new byte[w];
            for (int j = 0; j < width / 8; ++j) {
                for (m = 0; m < 8; ++m) {
                    p[m] = bmp.getPixel(j * 8 + m, i) == -1 ? 0 : 1;
                }
                int value = p[0] * 128 + p[1] * 64 + p[2] * 32 + p[3] * 16 + p[4] * 8 + p[5] * 4 + p[6] * 2 + p[7];
                linebuf[j] = (byte)value;
            }
            if (k > 0) {
                int tmp = 0;
                for (m = 0; m < k; ++m) {
                    tmp = (int)((double)tmp + (bmp.getPixel(bmp.getWidth() - m - 1, i) == -1 ? 0.0 : Math.pow(2.0, 7 - m)));
                }
                linebuf[w - 1] = (byte)tmp;
            }
            System.arraycopy(linebuf, 0, imagbuf, i * w, w);
        }
        return imagbuf;
    }

    public static byte[] bitmap2PrinterBytes(Bitmap bmp, int bmp_size_x, int bmp_size_y, int left) {
        StringBuffer sb = new StringBuffer("");
        byte[] imgbuf = new byte[bmp_size_x * bmp_size_y];
        byte[] bitbuf = new byte[bmp_size_x];
        int[] p = new int[8];
        int s = 0;
        for (int y = 0; y < bmp_size_y; ++y) {
            for (int x = 0; x < bmp_size_x; ++x) {
                for (int m = 0; m < 8; ++m) {
                    p[m] = bmp.getPixel(x * 8 + m, y) == -1 ? 1 : 0;
                }
                int value = p[0] * 128 + p[1] * 64 + p[2] * 32 + p[3] * 16 + p[4] * 8 + p[5] * 4 + p[6] * 2 + p[7];
                bitbuf[x] = (byte)value;
            }
            for (int n = 0; n < bmp_size_x; ++n) {
                imgbuf[s] = bitbuf[n];
                sb.append(imgbuf[s]);
                ++s;
            }
        }
        XLog.d("yxz", Utils.bytesToHexString(imgbuf, imgbuf.length));
        XLog.d("yxz", "imgbuf\u7684\u957f\u5ea6\u4e3a\uff1a----------------------------" + imgbuf.length);
        return imgbuf;
    }

    public static byte[] bitmap2PrinterBytesTL(Bitmap bitmap) {
        int width = bitmap.getWidth();
        int height = bitmap.getHeight();
        byte[] imgbuf = new byte[width / 8 * height];
        byte[] bitbuf = new byte[width / 8];
        int[] p = new int[8];
        int s = 0;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width / 8; ++x) {
                for (int m = 0; m < 8; ++m) {
                    p[m] = bitmap.getPixel(x * 8 + m, y) == -1 ? 0 : 1;
                }
                int value = p[0] * 128 + p[1] * 64 + p[2] * 32 + p[3] * 16 + p[4] * 8 + p[5] * 4 + p[6] * 2 + p[7];
                bitbuf[x] = (byte)value;
            }
            for (int n = 0; n < width / 8; ++n) {
                imgbuf[s] = bitbuf[n];
                ++s;
            }
        }
        return imgbuf;
    }

    public static String bmp2strTL(Bitmap bmp) {
        String ret = "";
        for (int i = 0; i < bmp.getHeight(); ++i) {
            int k = bmp.getWidth() % 8;
            for (int j = 0; j < bmp.getWidth() - k; j += 8) {
                int n1 = bmp.getPixel(j + 0, i) == -1 ? 128 : 0;
                int n2 = bmp.getPixel(j + 1, i) == -1 ? 64 : 0;
                int n3 = bmp.getPixel(j + 2, i) == -1 ? 32 : 0;
                int n4 = bmp.getPixel(j + 3, i) == -1 ? 16 : 0;
                int n5 = bmp.getPixel(j + 4, i) == -1 ? 8 : 0;
                int n6 = bmp.getPixel(j + 5, i) == -1 ? 4 : 0;
                int n7 = bmp.getPixel(j + 6, i) == -1 ? 2 : 0;
                int n8 = bmp.getPixel(j + 7, i) == -1 ? 1 : 0;
                int num = n1 + n2 + n3 + n4 + n5 + n6 + n7 + n8;
                byte ret1 = (byte)num;
                ret = ret + LabelPrint.int2StringTL(ret1);
            }
            if (k <= 0) continue;
            int tmp = 0;
            for (int m = 0; m < k; ++m) {
                tmp = (int)((double)tmp + (bmp.getPixel(bmp.getWidth() - m - 1, i) == -1 ? Math.pow(2.0, 7 - m) : 0.0));
            }
            byte ret1 = (byte)tmp;
            ret = ret + LabelPrint.int2StringTL(ret1);
        }
        return ret;
    }

    public static String int2StringTL(byte num) {
        byte b1 = (byte)((num & 0xF0) >> 4);
        byte b2 = (byte)(num & 0xF);
        if (b1 >= 0 && b1 <= 9) {
            b1 = (byte)(b1 | 0x30);
        }
        if (b1 >= 10 && b1 <= 15) {
            b1 = (byte)(65 + b1 - 10);
        }
        if (b2 >= 0 && b2 <= 9) {
            b2 = (byte)(b2 | 0x30);
        }
        if (b2 >= 10 && b2 <= 15) {
            b2 = (byte)(65 + b2 - 10);
        }
        byte[] bb = new byte[]{b1, b2};
        String retStr = "";
        try {
            retStr = new String(bb, "GBK");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return retStr;
    }

    public static class FontSize {
        public int font;
        public int size;

        public void getFontAndSize(PrinterConstants.LableFontSize fontSize) {
            switch (fontSize) {
                case Size_24: {
                    this.font = 24;
                    this.size = 0;
                    break;
                }
                case Size_48: {
                    this.font = 24;
                    this.size = 11;
                    break;
                }
                case Size_72: {
                    this.font = 24;
                    this.size = 22;
                    break;
                }
                case Size_16: {
                    this.font = 55;
                    this.size = 0;
                    break;
                }
                case Size_32: {
                    this.font = 55;
                    this.size = 11;
                    break;
                }
                case Size_64: {
                    this.font = 55;
                    this.size = 33;
                    break;
                }
                case Size_96: {
                    this.font = 24;
                    this.size = 33;
                    break;
                }
                default: {
                    this.font = 24;
                    this.size = 0;
                }
            }
        }

        public int getSize() {
            return this.size;
        }

        public int getFont() {
            return this.font;
        }
    }
}

