/*
 * Decompiled with CFR 0.152.
 */
package com.printer.sdk;

import android.os.Build;
import com.printer.sdk.PrinterInstance;
import com.printer.sdk.utils.Utils;
import com.printer.sdk.utils.XLog;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.HashMap;

public class CodePagePrinter {
    private PrinterInstance mprinter;

    public CodePagePrinter(PrinterInstance mprinter) {
        this.mprinter = mprinter;
    }

    public int getIntegerNum(byte num1, byte num2) throws UnsupportedEncodingException {
        int IntegerNum;
        int temp1 = num1 & 0xFF;
        int temp2 = num2 & 0xFF;
        if (Build.VERSION.SDK_INT >= 28) {
            IntegerNum = temp1 * 256 + temp2;
            XLog.d("yxz", "API>=28,num1=" + temp1 + ",num2=" + temp2 + ",IntegerNum=" + IntegerNum + ",\u5b57\u7b26\uff1a" + new String(new byte[]{num1, num2}, "UNICODE"));
        } else {
            IntegerNum = temp1 + temp2 * 256;
            XLog.d("yxz", "API<28,num1=" + temp1 + ",num2=" + temp2 + ",IntegerNum=" + IntegerNum + ",\u5b57\u7b26\uff1a" + new String(new byte[]{num2, num1}, "UNICODE"));
        }
        return IntegerNum;
    }

    public byte[] printTextinWeiYu(String content) {
        byte[] item1 = new byte[]{-128, -127, -128, -128};
        byte[] item2 = new byte[]{-126, -126, -126, -126};
        byte[] item3 = new byte[]{-124, -123, -122, -121};
        byte[] item4 = new byte[]{-120, -119, -118, -117};
        byte[] item5 = new byte[]{-116, -115, -114, -113};
        byte[] item6 = new byte[]{-112, -15, -111, -110};
        byte[] item7 = new byte[]{-109, -14, -10, -108};
        byte[] item8 = new byte[]{-107, -13, -9, -106};
        byte[] item9 = new byte[]{-105, -104, -105, -105};
        byte[] item10 = new byte[]{-103, -102, -103, -103};
        byte[] item11 = new byte[]{-101, -100, -101, -101};
        byte[] item12 = new byte[]{-99, -98, -99, -99};
        byte[] item13 = new byte[]{-97, -12, -96, -95};
        byte[] item14 = new byte[]{-94, -11, -93, -92};
        byte[] item15 = new byte[]{-91, -90, -89, -88};
        byte[] item16 = new byte[]{-87, -86, -85, -84};
        byte[] item17 = new byte[]{-83, -82, -81, -80};
        byte[] item18 = new byte[]{-79, -78, -77, -76};
        byte[] item19 = new byte[]{-75, -74, -73, -72};
        byte[] item20 = new byte[]{-71, -70, -69, -68};
        byte[] item21 = new byte[]{-67, -66, -65, -64};
        byte[] item22 = new byte[]{-63, -62, -61, -60};
        byte[] item23 = new byte[]{-59, -58, -57, -56};
        byte[] item24 = new byte[]{-55, -55, -54, -53};
        byte[] item25 = new byte[]{-52, -51, -52, -52};
        byte[] item26 = new byte[]{-50, -49, -50, -50};
        byte[] item27 = new byte[]{-48, -47, -48, -48};
        byte[] item28 = new byte[]{-46, -45, -46, -46};
        byte[] item29 = new byte[]{-44, -43, -44, -44};
        byte[] item30 = new byte[]{-42, -41, -40, -39};
        byte[] item31 = new byte[]{-38, -37, -36, -35};
        byte[] item32 = new byte[]{-34, -33, -32, -31};
        HashMap<Integer, byte[]> mapWeiYu = new HashMap<Integer, byte[]>();
        mapWeiYu.put(1575, item1);
        mapWeiYu.put(1749, item2);
        mapWeiYu.put(1576, item3);
        mapWeiYu.put(1662, item4);
        mapWeiYu.put(1578, item5);
        mapWeiYu.put(1580, item6);
        mapWeiYu.put(1670, item7);
        mapWeiYu.put(1582, item8);
        mapWeiYu.put(1583, item9);
        mapWeiYu.put(1585, item10);
        mapWeiYu.put(1586, item11);
        mapWeiYu.put(1688, item12);
        mapWeiYu.put(1587, item13);
        mapWeiYu.put(1588, item14);
        mapWeiYu.put(1594, item15);
        mapWeiYu.put(1601, item16);
        mapWeiYu.put(1602, item17);
        mapWeiYu.put(1603, item18);
        mapWeiYu.put(1711, item19);
        mapWeiYu.put(1709, item20);
        mapWeiYu.put(1604, item21);
        mapWeiYu.put(1605, item22);
        mapWeiYu.put(1606, item23);
        mapWeiYu.put(1726, item24);
        mapWeiYu.put(1608, item25);
        mapWeiYu.put(1735, item26);
        mapWeiYu.put(1734, item27);
        mapWeiYu.put(1736, item28);
        mapWeiYu.put(1739, item29);
        mapWeiYu.put(1744, item30);
        mapWeiYu.put(1609, item31);
        mapWeiYu.put(1610, item32);
        int length = Utils.getStringCharacterLength(content);
        byte[] realData = new byte[length];
        try {
            byte[] data = content.getBytes("UNICODE");
            String str = null;
            try {
                str = new String(data, "UNICODE");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            XLog.d("yxz", "str:" + str);
            XLog.d("yxz", "data.length:" + data.length + ",data:" + Utils.bytesToHexString(data, data.length));
            int k = 3;
            realData[0] = 27;
            realData[1] = 116;
            realData[2] = 12;
            boolean hasBefore = false;
            boolean hasAfter = true;
            for (int i = 2; i < data.length; i += 2) {
                byte[] gb2312Data;
                int IntegerNum2;
                int IntegerNum = this.getIntegerNum(data[i], data[i + 1]);
                if (IntegerNum == 1574) continue;
                hasAfter = i == data.length - 2 ? false : (IntegerNum2 = this.getIntegerNum(data[i + 2], data[i + 3])) == 1574 || mapWeiYu.get(IntegerNum2) != null;
                byte[] temp = (byte[])mapWeiYu.get(IntegerNum);
                if (temp != null) {
                    XLog.d("yxz", "WeiYu\u4ee3\u7801\u9875\u627e\u5230\u8be5\u5b57\u7b26");
                    if (hasBefore) {
                        if (hasAfter) {
                            XLog.d("yxz", "\u8be5\u5b57\u4f53\u662f\u524d\u540e\u8fde\u4e66\u4f53");
                            realData[k] = temp[2];
                        } else {
                            XLog.d("yxz", "\u8be5\u5b57\u4f53\u662f\u524d\u8fde\u4e66\u4f53");
                            realData[k] = temp[1];
                        }
                    } else if (hasAfter) {
                        XLog.d("yxz", "\u8be5\u5b57\u4f53\u662f\u540e\u8fde\u4e66\u4f53");
                        realData[k] = temp[3];
                    } else {
                        XLog.d("yxz", "\u8be5\u5b57\u4f53\u662f\u72ec\u7acb\u4e66\u4f53");
                        realData[k] = temp[0];
                    }
                    ++k;
                    hasBefore = true;
                    continue;
                }
                hasBefore = false;
                if (Build.VERSION.SDK_INT >= 28) {
                    gb2312Data = new String(new byte[]{data[i], data[i + 1]}, "UNICODE").getBytes("gb2312");
                    XLog.d("yxz", "API>=28,\u6ca1\u6709\u627e\u5230\u8be5\u5b57\u7b26\uff1a" + new String(new byte[]{data[i], data[i + 1]}, "UNICODE") + ",data:" + Utils.bytesToHexString(gb2312Data, gb2312Data.length));
                    realData[k] = data[i + 1];
                    ++k;
                    continue;
                }
                gb2312Data = new String(new byte[]{data[i + 1], data[i]}, "UNICODE").getBytes("gb2312");
                XLog.d("yxz", "API<28,\u6ca1\u6709\u627e\u5230\u8be5\u5b57\u7b26\uff1a" + new String(new byte[]{data[i + 1], data[i]}, "UNICODE") + ",data:" + Utils.bytesToHexString(gb2312Data, gb2312Data.length));
                realData[k] = data[i];
                ++k;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        XLog.d("yxz", "realData:" + Utils.bytesToHexString(realData, realData.length));
        return realData;
    }

    public int printTextinThai(String content, int codePageType) {
        HashMap<Integer, Byte> map = new HashMap<Integer, Byte>();
        map.put(3584, (byte)-96);
        map.put(3585, (byte)-95);
        map.put(3586, (byte)-94);
        map.put(3587, (byte)-93);
        map.put(3588, (byte)-92);
        map.put(3589, (byte)-91);
        map.put(3590, (byte)-90);
        map.put(3591, (byte)-89);
        map.put(3592, (byte)-88);
        map.put(3593, (byte)-87);
        map.put(3594, (byte)-86);
        map.put(3595, (byte)-85);
        map.put(3596, (byte)-84);
        map.put(3597, (byte)-83);
        map.put(3598, (byte)-82);
        map.put(3599, (byte)-81);
        map.put(3600, (byte)-80);
        map.put(3601, (byte)-79);
        map.put(3602, (byte)-78);
        map.put(3603, (byte)-77);
        map.put(3604, (byte)-76);
        map.put(3605, (byte)-75);
        map.put(3606, (byte)-74);
        map.put(3607, (byte)-73);
        map.put(3608, (byte)-72);
        map.put(3609, (byte)-71);
        map.put(3610, (byte)-70);
        map.put(3611, (byte)-69);
        map.put(3612, (byte)-68);
        map.put(3613, (byte)-67);
        map.put(3614, (byte)-66);
        map.put(3615, (byte)-65);
        map.put(3616, (byte)-64);
        map.put(3617, (byte)-63);
        map.put(3618, (byte)-62);
        map.put(3619, (byte)-61);
        map.put(3620, (byte)-60);
        map.put(3621, (byte)-59);
        map.put(3622, (byte)-58);
        map.put(3623, (byte)-57);
        map.put(3624, (byte)-56);
        map.put(3625, (byte)-55);
        map.put(3626, (byte)-54);
        map.put(3627, (byte)-53);
        map.put(3628, (byte)-52);
        map.put(3629, (byte)-51);
        map.put(3630, (byte)-50);
        map.put(3631, (byte)-49);
        map.put(3632, (byte)-48);
        map.put(3633, (byte)-47);
        map.put(3634, (byte)-46);
        map.put(3635, (byte)-45);
        map.put(3636, (byte)-44);
        map.put(3637, (byte)-43);
        map.put(3638, (byte)-42);
        map.put(3639, (byte)-41);
        map.put(3640, (byte)-40);
        map.put(3641, (byte)-39);
        map.put(3642, (byte)-38);
        map.put(3643, (byte)-37);
        map.put(3644, (byte)-36);
        map.put(3645, (byte)-35);
        map.put(3646, (byte)-34);
        map.put(3647, (byte)-33);
        map.put(3648, (byte)-32);
        map.put(3649, (byte)-31);
        map.put(3650, (byte)-30);
        map.put(3651, (byte)-29);
        map.put(3652, (byte)-28);
        map.put(3653, (byte)-27);
        map.put(3654, (byte)-26);
        map.put(3655, (byte)-25);
        map.put(3656, (byte)-24);
        map.put(3657, (byte)-23);
        map.put(3658, (byte)-22);
        map.put(3659, (byte)-21);
        map.put(3660, (byte)-20);
        map.put(3661, (byte)-19);
        map.put(3662, (byte)-18);
        map.put(3663, (byte)-17);
        map.put(3664, (byte)-16);
        map.put(3665, (byte)-15);
        map.put(3666, (byte)-14);
        map.put(3667, (byte)-13);
        map.put(3668, (byte)-12);
        map.put(3669, (byte)-11);
        map.put(3670, (byte)-10);
        map.put(3671, (byte)-9);
        map.put(3672, (byte)-8);
        map.put(3673, (byte)-7);
        map.put(3674, (byte)-6);
        map.put(3675, (byte)-5);
        map.put(3676, (byte)-4);
        map.put(3677, (byte)-3);
        map.put(3678, (byte)-2);
        map.put(3679, (byte)-1);
        map.put(3680, (byte)-128);
        map.put(3681, (byte)-127);
        map.put(3682, (byte)-126);
        map.put(3683, (byte)-125);
        map.put(3684, (byte)-124);
        map.put(3685, (byte)-123);
        map.put(3686, (byte)-122);
        map.put(3687, (byte)-121);
        map.put(3688, (byte)-120);
        map.put(3689, (byte)-119);
        map.put(3690, (byte)-118);
        map.put(3691, (byte)-117);
        map.put(3692, (byte)-116);
        map.put(3693, (byte)-115);
        map.put(3694, (byte)-114);
        map.put(3695, (byte)-113);
        map.put(3696, (byte)-112);
        map.put(3697, (byte)-111);
        map.put(3698, (byte)-110);
        map.put(3699, (byte)-109);
        map.put(3700, (byte)-108);
        map.put(3701, (byte)-107);
        map.put(3702, (byte)-106);
        map.put(3703, (byte)-105);
        map.put(3704, (byte)-104);
        map.put(3705, (byte)-103);
        map.put(3706, (byte)-102);
        map.put(3707, (byte)-101);
        map.put(3708, (byte)-100);
        map.put(3709, (byte)-99);
        map.put(3710, (byte)-98);
        map.put(3711, (byte)-97);
        byte[] realData = new byte[5000];
        try {
            byte[] data = content.getBytes("UNICODE");
            String str = null;
            try {
                str = new String(data, "UNICODE");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            XLog.d("yxz", "str:" + str);
            XLog.d("yxz", "data:" + Utils.bytesToHexString(data, data.length));
            int k = 3;
            realData[0] = 27;
            realData[1] = 116;
            realData[2] = 45;
            if (codePageType == 2) {
                realData[2] = 45;
            }
            if (codePageType == 1) {
                realData[2] = 26;
            }
            for (int i = 2; i < data.length; i += 2) {
                int m;
                int j;
                byte[] changeData;
                byte[] gb2312Data;
                int c = Build.VERSION.SDK_INT >= 28 ? data[i + 1] + data[i] * 256 : data[i + 1] * 256 + data[i];
                if (map.get(c) != null) {
                    realData[k] = (Byte)map.get(c);
                    ++k;
                    continue;
                }
                if (Build.VERSION.SDK_INT >= 28) {
                    if (data[i] == 0) {
                        realData[k] = data[i + 1];
                        ++k;
                        continue;
                    }
                    gb2312Data = new String(new byte[]{data[i], data[i + 1]}, "UNICODE").getBytes("gb2312");
                    XLog.d("yxz", new String(new byte[]{data[i], data[i + 1]}, "UNICODE"));
                    XLog.d("yxz", Utils.bytesToHexString(gb2312Data, gb2312Data.length));
                    changeData = new byte[gb2312Data.length + 7];
                    changeData[0] = 28;
                    changeData[1] = 38;
                    for (j = 0; j < gb2312Data.length; ++j) {
                        changeData[j + 2] = gb2312Data[j];
                    }
                    changeData[changeData.length - 5] = 28;
                    changeData[changeData.length - 4] = 46;
                    changeData[changeData.length - 3] = 27;
                    changeData[changeData.length - 2] = 116;
                    if (codePageType == 2) {
                        changeData[changeData.length - 1] = 45;
                    }
                    if (codePageType == 1) {
                        changeData[changeData.length - 1] = 26;
                    }
                    XLog.d("yxz", "changeData:" + Utils.bytesToHexString(changeData, changeData.length));
                    for (m = 0; m < changeData.length; ++m) {
                        realData[k] = changeData[m];
                        ++k;
                    }
                    continue;
                }
                if (data[i + 1] == 0) {
                    realData[k] = data[i];
                    ++k;
                    continue;
                }
                gb2312Data = new String(new byte[]{data[i + 1], data[i]}, "UNICODE").getBytes("gb2312");
                XLog.d("yxz", new String(new byte[]{data[i + 1], data[i]}, "UNICODE"));
                XLog.d("yxz", Utils.bytesToHexString(gb2312Data, gb2312Data.length));
                changeData = new byte[gb2312Data.length + 7];
                changeData[0] = 28;
                changeData[1] = 38;
                for (j = 0; j < gb2312Data.length; ++j) {
                    changeData[j + 2] = gb2312Data[j];
                }
                changeData[changeData.length - 5] = 28;
                changeData[changeData.length - 4] = 46;
                changeData[changeData.length - 3] = 27;
                changeData[changeData.length - 2] = 116;
                if (codePageType == 2) {
                    changeData[changeData.length - 1] = 45;
                }
                if (codePageType == 1) {
                    changeData[changeData.length - 1] = 26;
                }
                XLog.d("yxz", "changeData:" + Utils.bytesToHexString(changeData, changeData.length));
                for (m = 0; m < changeData.length; ++m) {
                    realData[k] = changeData[m];
                    ++k;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        XLog.d("yxz", "realData:" + Utils.bytesToHexString(realData, realData.length));
        return this.mprinter.sendBytesData(realData);
    }

    public int printTextInCP437(String content) {
        HashMap<Integer, Byte> map = new HashMap<Integer, Byte>();
        map.put(8364, (byte)-128);
        map.put(252, (byte)-127);
        map.put(233, (byte)-126);
        map.put(226, (byte)-125);
        map.put(228, (byte)-124);
        map.put(224, (byte)-123);
        map.put(229, (byte)-122);
        map.put(231, (byte)-121);
        map.put(234, (byte)-120);
        map.put(235, (byte)-119);
        map.put(232, (byte)-118);
        map.put(239, (byte)-117);
        map.put(238, (byte)-116);
        map.put(236, (byte)-115);
        map.put(196, (byte)-114);
        map.put(197, (byte)-113);
        map.put(201, (byte)-112);
        map.put(230, (byte)-111);
        map.put(198, (byte)-110);
        map.put(244, (byte)-109);
        map.put(246, (byte)-108);
        map.put(242, (byte)-107);
        map.put(251, (byte)-106);
        map.put(249, (byte)-105);
        map.put(255, (byte)-104);
        map.put(214, (byte)-103);
        map.put(220, (byte)-102);
        map.put(162, (byte)-101);
        map.put(163, (byte)-100);
        map.put(165, (byte)-99);
        map.put(8359, (byte)-98);
        map.put(402, (byte)-97);
        map.put(225, (byte)-96);
        map.put(237, (byte)-95);
        map.put(243, (byte)-94);
        map.put(250, (byte)-93);
        map.put(241, (byte)-92);
        map.put(209, (byte)-91);
        map.put(170, (byte)-90);
        map.put(186, (byte)-89);
        map.put(191, (byte)-88);
        map.put(8976, (byte)-87);
        map.put(172, (byte)-86);
        map.put(189, (byte)-85);
        map.put(188, (byte)-84);
        map.put(161, (byte)-83);
        map.put(171, (byte)-82);
        map.put(187, (byte)-81);
        map.put(9617, (byte)-80);
        map.put(9618, (byte)-79);
        map.put(9619, (byte)-78);
        map.put(9474, (byte)-77);
        map.put(9508, (byte)-76);
        map.put(9569, (byte)-75);
        map.put(9570, (byte)-74);
        map.put(9558, (byte)-73);
        map.put(9557, (byte)-72);
        map.put(9571, (byte)-71);
        map.put(9553, (byte)-70);
        map.put(9557, (byte)-69);
        map.put(9565, (byte)-68);
        map.put(9564, (byte)-67);
        map.put(9563, (byte)-66);
        map.put(9488, (byte)-65);
        map.put(9492, (byte)-64);
        map.put(9524, (byte)-63);
        map.put(9516, (byte)-62);
        map.put(9500, (byte)-61);
        map.put(9472, (byte)-60);
        map.put(9532, (byte)-59);
        map.put(9566, (byte)-58);
        map.put(9567, (byte)-57);
        map.put(9562, (byte)-56);
        map.put(9556, (byte)-55);
        map.put(9577, (byte)-54);
        map.put(9574, (byte)-53);
        map.put(9568, (byte)-52);
        map.put(9552, (byte)-51);
        map.put(9580, (byte)-50);
        map.put(9575, (byte)-49);
        map.put(9576, (byte)-48);
        map.put(9572, (byte)-47);
        map.put(9573, (byte)-46);
        map.put(9561, (byte)-45);
        map.put(9560, (byte)-44);
        map.put(9554, (byte)-43);
        map.put(9555, (byte)-42);
        map.put(9579, (byte)-41);
        map.put(9578, (byte)-40);
        map.put(9496, (byte)-39);
        map.put(9484, (byte)-38);
        map.put(9608, (byte)-37);
        map.put(9604, (byte)-36);
        map.put(9612, (byte)-35);
        map.put(9616, (byte)-34);
        map.put(9600, (byte)-33);
        map.put(945, (byte)-32);
        map.put(223, (byte)-31);
        map.put(915, (byte)-30);
        map.put(960, (byte)-29);
        map.put(931, (byte)-28);
        map.put(963, (byte)-27);
        map.put(181, (byte)-26);
        map.put(964, (byte)-25);
        map.put(934, (byte)-24);
        map.put(920, (byte)-23);
        map.put(937, (byte)-22);
        map.put(948, (byte)-21);
        map.put(8734, (byte)-20);
        map.put(966, (byte)-19);
        map.put(949, (byte)-18);
        map.put(8745, (byte)-17);
        map.put(8801, (byte)-16);
        map.put(177, (byte)-15);
        map.put(8805, (byte)-14);
        map.put(8804, (byte)-13);
        map.put(8992, (byte)-12);
        map.put(8993, (byte)-11);
        map.put(247, (byte)-10);
        map.put(8776, (byte)-9);
        map.put(176, (byte)-8);
        map.put(8729, (byte)-7);
        map.put(183, (byte)-6);
        map.put(8730, (byte)-5);
        map.put(8319, (byte)-4);
        map.put(178, (byte)-3);
        map.put(9632, (byte)-2);
        map.put(160, (byte)-1);
        byte[] realData = new byte[5000];
        try {
            byte[] data = content.getBytes("UNICODE");
            int k = 3;
            realData[0] = 27;
            realData[1] = 116;
            realData[2] = 0;
            for (int i = 2; i < data.length; i += 2) {
                int c = (data[i + 1] & 0xFF) * 256 + (data[i] & 0xFF);
                if (map.get(c) != null) {
                    realData[k] = (Byte)map.get(c);
                    ++k;
                    continue;
                }
                realData[k] = (byte)c;
                ++k;
            }
            realData[k] = 10;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.mprinter.sendBytesData(realData);
    }

    public int printTextinRussian(String content) {
        HashMap<Integer, Byte> map = new HashMap<Integer, Byte>();
        map.put(1040, (byte)-128);
        map.put(1041, (byte)-127);
        map.put(1042, (byte)-126);
        map.put(1043, (byte)-125);
        map.put(1044, (byte)-124);
        map.put(1045, (byte)-123);
        map.put(1046, (byte)-122);
        map.put(1047, (byte)-121);
        map.put(1048, (byte)-120);
        map.put(1049, (byte)-119);
        map.put(1050, (byte)-118);
        map.put(1051, (byte)-117);
        map.put(1052, (byte)-116);
        map.put(1053, (byte)-115);
        map.put(1054, (byte)-114);
        map.put(1055, (byte)-113);
        map.put(1056, (byte)-112);
        map.put(1057, (byte)-111);
        map.put(1058, (byte)-110);
        map.put(1059, (byte)-109);
        map.put(1060, (byte)-108);
        map.put(1061, (byte)-107);
        map.put(1062, (byte)-106);
        map.put(1063, (byte)-105);
        map.put(1064, (byte)-104);
        map.put(1065, (byte)-103);
        map.put(1066, (byte)-102);
        map.put(1067, (byte)-101);
        map.put(1068, (byte)-100);
        map.put(1069, (byte)-99);
        map.put(1070, (byte)-98);
        map.put(1071, (byte)-97);
        map.put(1072, (byte)-96);
        map.put(1073, (byte)-95);
        map.put(1074, (byte)-94);
        map.put(1075, (byte)-93);
        map.put(1076, (byte)-92);
        map.put(1077, (byte)-91);
        map.put(1078, (byte)-90);
        map.put(1079, (byte)-89);
        map.put(1080, (byte)-88);
        map.put(1081, (byte)-87);
        map.put(1082, (byte)-86);
        map.put(1083, (byte)-85);
        map.put(1084, (byte)-84);
        map.put(1085, (byte)-83);
        map.put(1086, (byte)-82);
        map.put(1087, (byte)-81);
        map.put(9617, (byte)-80);
        map.put(9618, (byte)-79);
        map.put(9619, (byte)-78);
        map.put(9474, (byte)-77);
        map.put(9508, (byte)-76);
        map.put(9569, (byte)-75);
        map.put(9670, (byte)-74);
        map.put(9558, (byte)-73);
        map.put(9557, (byte)-72);
        map.put(9571, (byte)-71);
        map.put(9553, (byte)-70);
        map.put(9559, (byte)-69);
        map.put(9565, (byte)-68);
        map.put(9564, (byte)-67);
        map.put(9553, (byte)-66);
        map.put(9488, (byte)-65);
        map.put(9492, (byte)-64);
        map.put(9524, (byte)-63);
        map.put(9516, (byte)-62);
        map.put(9500, (byte)-61);
        map.put(9472, (byte)-60);
        map.put(9532, (byte)-59);
        map.put(9566, (byte)-58);
        map.put(9557, (byte)-57);
        map.put(9562, (byte)-56);
        map.put(9556, (byte)-55);
        map.put(9577, (byte)-54);
        map.put(9574, (byte)-53);
        map.put(9568, (byte)-52);
        map.put(9552, (byte)-51);
        map.put(9580, (byte)-50);
        map.put(9575, (byte)-49);
        map.put(9576, (byte)-48);
        map.put(9572, (byte)-47);
        map.put(9573, (byte)-46);
        map.put(9561, (byte)-45);
        map.put(9560, (byte)-44);
        map.put(9554, (byte)-43);
        map.put(9555, (byte)-42);
        map.put(9579, (byte)-41);
        map.put(9578, (byte)-40);
        map.put(9496, (byte)-39);
        map.put(9484, (byte)-38);
        map.put(9608, (byte)-37);
        map.put(9604, (byte)-36);
        map.put(9612, (byte)-35);
        map.put(9616, (byte)-34);
        map.put(9600, (byte)-33);
        map.put(1088, (byte)-32);
        map.put(1089, (byte)-31);
        map.put(1090, (byte)-30);
        map.put(1091, (byte)-29);
        map.put(1092, (byte)-28);
        map.put(1093, (byte)-27);
        map.put(1094, (byte)-26);
        map.put(1095, (byte)-25);
        map.put(1096, (byte)-24);
        map.put(1097, (byte)-23);
        map.put(1098, (byte)-22);
        map.put(1099, (byte)-21);
        map.put(1100, (byte)-20);
        map.put(1101, (byte)-19);
        map.put(1102, (byte)-18);
        map.put(1103, (byte)-17);
        map.put(1025, (byte)-16);
        map.put(1105, (byte)-15);
        map.put(1028, (byte)-14);
        map.put(1108, (byte)-13);
        map.put(1031, (byte)-12);
        map.put(1111, (byte)-11);
        map.put(1038, (byte)-10);
        map.put(1118, (byte)-9);
        map.put(176, (byte)-8);
        map.put(8729, (byte)-7);
        map.put(183, (byte)-6);
        map.put(8730, (byte)-5);
        map.put(8470, (byte)-4);
        map.put(164, (byte)-3);
        map.put(9632, (byte)-2);
        map.put(160, (byte)-1);
        byte[] realData = new byte[5000];
        try {
            byte[] data = content.getBytes("UNICODE");
            int k = 3;
            realData[0] = 27;
            realData[1] = 116;
            realData[2] = 7;
            for (int i = 2; i < data.length; i += 2) {
                int c = data[i + 1] * 256 + data[i];
                if (map.get(c) != null) {
                    realData[k] = (Byte)map.get(c);
                    ++k;
                    continue;
                }
                realData[k] = data[i];
                ++k;
            }
            realData[k] = 10;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.mprinter.sendBytesData(realData);
    }

    public int printTextInCP850(String content) {
        HashMap<Integer, Byte> map = new HashMap<Integer, Byte>();
        map.put(199, (byte)-128);
        map.put(252, (byte)-127);
        map.put(233, (byte)-126);
        map.put(226, (byte)-125);
        map.put(228, (byte)-124);
        map.put(224, (byte)-123);
        map.put(229, (byte)-122);
        map.put(231, (byte)-121);
        map.put(234, (byte)-120);
        map.put(235, (byte)-119);
        map.put(232, (byte)-118);
        map.put(239, (byte)-117);
        map.put(238, (byte)-116);
        map.put(236, (byte)-115);
        map.put(196, (byte)-114);
        map.put(197, (byte)-113);
        map.put(201, (byte)-112);
        map.put(230, (byte)-111);
        map.put(198, (byte)-110);
        map.put(244, (byte)-109);
        map.put(246, (byte)-108);
        map.put(242, (byte)-107);
        map.put(251, (byte)-106);
        map.put(249, (byte)-105);
        map.put(255, (byte)-104);
        map.put(214, (byte)-103);
        map.put(220, (byte)-102);
        map.put(248, (byte)-101);
        map.put(163, (byte)-100);
        map.put(216, (byte)-99);
        map.put(215, (byte)-98);
        map.put(402, (byte)-97);
        map.put(225, (byte)-96);
        map.put(237, (byte)-95);
        map.put(243, (byte)-94);
        map.put(250, (byte)-93);
        map.put(241, (byte)-92);
        map.put(209, (byte)-91);
        map.put(170, (byte)-90);
        map.put(186, (byte)-89);
        map.put(191, (byte)-88);
        map.put(174, (byte)-87);
        map.put(172, (byte)-86);
        map.put(189, (byte)-85);
        map.put(188, (byte)-84);
        map.put(161, (byte)-83);
        map.put(171, (byte)-82);
        map.put(187, (byte)-81);
        map.put(9617, (byte)-80);
        map.put(9618, (byte)-79);
        map.put(9619, (byte)-78);
        map.put(9474, (byte)-77);
        map.put(9508, (byte)-76);
        map.put(193, (byte)-75);
        map.put(194, (byte)-74);
        map.put(192, (byte)-73);
        map.put(169, (byte)-72);
        map.put(9571, (byte)-71);
        map.put(9553, (byte)-70);
        map.put(9559, (byte)-69);
        map.put(9565, (byte)-68);
        map.put(162, (byte)-67);
        map.put(165, (byte)-66);
        map.put(9488, (byte)-65);
        map.put(9492, (byte)-64);
        map.put(9524, (byte)-63);
        map.put(9516, (byte)-62);
        map.put(9500, (byte)-61);
        map.put(9472, (byte)-60);
        map.put(9532, (byte)-59);
        map.put(227, (byte)-58);
        map.put(195, (byte)-57);
        map.put(9562, (byte)-56);
        map.put(9556, (byte)-55);
        map.put(9577, (byte)-54);
        map.put(9574, (byte)-53);
        map.put(9568, (byte)-52);
        map.put(9552, (byte)-51);
        map.put(9580, (byte)-50);
        map.put(164, (byte)-49);
        map.put(240, (byte)-48);
        map.put(208, (byte)-47);
        map.put(202, (byte)-46);
        map.put(203, (byte)-45);
        map.put(200, (byte)-44);
        map.put(305, (byte)-43);
        map.put(205, (byte)-42);
        map.put(206, (byte)-41);
        map.put(207, (byte)-40);
        map.put(9496, (byte)-39);
        map.put(9484, (byte)-38);
        map.put(9608, (byte)-37);
        map.put(9604, (byte)-36);
        map.put(166, (byte)-35);
        map.put(204, (byte)-34);
        map.put(9600, (byte)-33);
        map.put(211, (byte)-32);
        map.put(223, (byte)-31);
        map.put(212, (byte)-30);
        map.put(210, (byte)-29);
        map.put(245, (byte)-28);
        map.put(213, (byte)-27);
        map.put(181, (byte)-26);
        map.put(254, (byte)-25);
        map.put(222, (byte)-24);
        map.put(218, (byte)-23);
        map.put(219, (byte)-22);
        map.put(217, (byte)-21);
        map.put(253, (byte)-20);
        map.put(221, (byte)-19);
        map.put(175, (byte)-18);
        map.put(180, (byte)-17);
        map.put(173, (byte)-16);
        map.put(177, (byte)-15);
        map.put(8215, (byte)-14);
        map.put(190, (byte)-13);
        map.put(182, (byte)-12);
        map.put(167, (byte)-11);
        map.put(247, (byte)-10);
        map.put(184, (byte)-9);
        map.put(176, (byte)-8);
        map.put(168, (byte)-7);
        map.put(183, (byte)-6);
        map.put(185, (byte)-5);
        map.put(179, (byte)-4);
        map.put(178, (byte)-3);
        map.put(9632, (byte)-2);
        map.put(160, (byte)-1);
        byte[] realData = new byte[5000];
        try {
            byte[] data = content.getBytes("UNICODE");
            System.out.println(Arrays.toString(data));
            int k = 3;
            realData[0] = 27;
            realData[1] = 116;
            realData[2] = 2;
            for (int i = 2; i < data.length; i += 2) {
                int c = (data[i + 1] & 0xFF) * 256 + (data[i] & 0xFF);
                if (map.get(c) != null) {
                    realData[k] = (Byte)map.get(c);
                    ++k;
                    continue;
                }
                realData[k] = data[i];
                ++k;
            }
            realData[k] = 10;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.mprinter.sendBytesData(realData);
    }

    public int printTextInCP932(String content) {
        HashMap<Integer, Byte> map = new HashMap<Integer, Byte>();
        map.put(65377, (byte)-95);
        map.put(65378, (byte)-94);
        map.put(65379, (byte)-93);
        map.put(65380, (byte)-92);
        map.put(65381, (byte)-91);
        map.put(65382, (byte)-90);
        map.put(65383, (byte)-89);
        map.put(65384, (byte)-88);
        map.put(65385, (byte)-87);
        map.put(65386, (byte)-86);
        map.put(65387, (byte)-85);
        map.put(65388, (byte)-84);
        map.put(65389, (byte)-83);
        map.put(65390, (byte)-82);
        map.put(65391, (byte)-81);
        map.put(65392, (byte)-80);
        map.put(65393, (byte)-79);
        map.put(65394, (byte)-78);
        map.put(65395, (byte)-77);
        map.put(65396, (byte)-76);
        map.put(65397, (byte)-75);
        map.put(65398, (byte)-74);
        map.put(65399, (byte)-73);
        map.put(65400, (byte)-72);
        map.put(65401, (byte)-71);
        map.put(65402, (byte)-70);
        map.put(65403, (byte)-69);
        map.put(65404, (byte)-68);
        map.put(65405, (byte)-67);
        map.put(65406, (byte)-66);
        map.put(65407, (byte)-65);
        map.put(65408, (byte)-64);
        map.put(65409, (byte)-63);
        map.put(65410, (byte)-62);
        map.put(65411, (byte)-61);
        map.put(65412, (byte)-60);
        map.put(65413, (byte)-59);
        map.put(65414, (byte)-58);
        map.put(65415, (byte)-57);
        map.put(65416, (byte)-56);
        map.put(65417, (byte)-55);
        map.put(65418, (byte)-54);
        map.put(65419, (byte)-53);
        map.put(65420, (byte)-52);
        map.put(65421, (byte)-51);
        map.put(65422, (byte)-50);
        map.put(65423, (byte)-49);
        map.put(65424, (byte)-48);
        map.put(65425, (byte)-47);
        map.put(65426, (byte)-46);
        map.put(65427, (byte)-45);
        map.put(65428, (byte)-44);
        map.put(65429, (byte)-43);
        map.put(65430, (byte)-42);
        map.put(65431, (byte)-41);
        map.put(65432, (byte)-40);
        map.put(65433, (byte)-39);
        map.put(65434, (byte)-38);
        map.put(65435, (byte)-37);
        map.put(65436, (byte)-36);
        map.put(65437, (byte)-35);
        map.put(65438, (byte)-34);
        map.put(65439, (byte)-33);
        byte[] realData = new byte[5000];
        try {
            byte[] data = content.getBytes("UNICODE");
            for (int i = 0; i < data.length; ++i) {
                System.out.println("bytes[" + i + "]=" + Integer.toHexString(data[i] & 0xFF));
            }
            int k = 3;
            realData[0] = 27;
            realData[1] = 116;
            realData[2] = 1;
            for (int i = 2; i < data.length; i += 2) {
                int c = (data[i + 1] & 0xFF) * 256 + (data[i] & 0xFF);
                if (map.get(c) != null) {
                    realData[k] = (Byte)map.get(c);
                    ++k;
                    continue;
                }
                realData[k] = data[i];
                ++k;
            }
            realData[k] = 10;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.mprinter.sendBytesData(realData);
    }

    public int printTextInCP860(String content) {
        HashMap<Integer, Byte> map = new HashMap<Integer, Byte>();
        map.put(199, (byte)-128);
        map.put(252, (byte)-127);
        map.put(233, (byte)-126);
        map.put(226, (byte)-125);
        map.put(227, (byte)-124);
        map.put(224, (byte)-123);
        map.put(193, (byte)-122);
        map.put(231, (byte)-121);
        map.put(234, (byte)-120);
        map.put(202, (byte)-119);
        map.put(232, (byte)-118);
        map.put(205, (byte)-117);
        map.put(212, (byte)-116);
        map.put(236, (byte)-115);
        map.put(195, (byte)-114);
        map.put(194, (byte)-113);
        map.put(201, (byte)-112);
        map.put(192, (byte)-111);
        map.put(200, (byte)-110);
        map.put(244, (byte)-109);
        map.put(245, (byte)-108);
        map.put(242, (byte)-107);
        map.put(218, (byte)-106);
        map.put(249, (byte)-105);
        map.put(204, (byte)-104);
        map.put(213, (byte)-103);
        map.put(220, (byte)-102);
        map.put(162, (byte)-101);
        map.put(163, (byte)-100);
        map.put(217, (byte)-99);
        map.put(8359, (byte)-98);
        map.put(211, (byte)-97);
        map.put(225, (byte)-96);
        map.put(237, (byte)-95);
        map.put(243, (byte)-94);
        map.put(250, (byte)-93);
        map.put(241, (byte)-92);
        map.put(209, (byte)-91);
        map.put(170, (byte)-90);
        map.put(186, (byte)-89);
        map.put(191, (byte)-88);
        map.put(210, (byte)-87);
        map.put(172, (byte)-86);
        map.put(189, (byte)-85);
        map.put(188, (byte)-84);
        map.put(161, (byte)-83);
        map.put(171, (byte)-82);
        map.put(187, (byte)-81);
        map.put(9617, (byte)-80);
        map.put(9618, (byte)-79);
        map.put(9619, (byte)-78);
        map.put(9474, (byte)-77);
        map.put(9508, (byte)-76);
        map.put(9569, (byte)-75);
        map.put(9570, (byte)-74);
        map.put(9558, (byte)-73);
        map.put(9557, (byte)-72);
        map.put(9571, (byte)-71);
        map.put(9553, (byte)-70);
        map.put(9559, (byte)-69);
        map.put(9565, (byte)-68);
        map.put(9564, (byte)-67);
        map.put(9563, (byte)-66);
        map.put(9488, (byte)-65);
        map.put(9492, (byte)-64);
        map.put(9534, (byte)-63);
        map.put(9516, (byte)-62);
        map.put(9500, (byte)-61);
        map.put(9472, (byte)-60);
        map.put(9532, (byte)-59);
        map.put(9566, (byte)-58);
        map.put(9567, (byte)-57);
        map.put(9562, (byte)-56);
        map.put(9556, (byte)-55);
        map.put(9577, (byte)-54);
        map.put(9574, (byte)-53);
        map.put(9568, (byte)-52);
        map.put(9552, (byte)-51);
        map.put(9580, (byte)-50);
        map.put(9575, (byte)-49);
        map.put(9576, (byte)-48);
        map.put(9572, (byte)-47);
        map.put(9573, (byte)-46);
        map.put(9561, (byte)-45);
        map.put(9560, (byte)-44);
        map.put(9554, (byte)-43);
        map.put(9555, (byte)-42);
        map.put(9579, (byte)-41);
        map.put(9578, (byte)-40);
        map.put(9496, (byte)-39);
        map.put(9484, (byte)-38);
        map.put(9608, (byte)-37);
        map.put(9604, (byte)-36);
        map.put(9612, (byte)-35);
        map.put(9616, (byte)-34);
        map.put(9600, (byte)-33);
        map.put(945, (byte)-32);
        map.put(223, (byte)-31);
        map.put(915, (byte)-30);
        map.put(960, (byte)-29);
        map.put(931, (byte)-28);
        map.put(963, (byte)-27);
        map.put(181, (byte)-26);
        map.put(964, (byte)-25);
        map.put(934, (byte)-24);
        map.put(920, (byte)-23);
        map.put(937, (byte)-22);
        map.put(948, (byte)-21);
        map.put(8734, (byte)-20);
        map.put(966, (byte)-19);
        map.put(949, (byte)-18);
        map.put(8745, (byte)-17);
        map.put(8801, (byte)-16);
        map.put(177, (byte)-15);
        map.put(8805, (byte)-14);
        map.put(8804, (byte)-13);
        map.put(8992, (byte)-12);
        map.put(8993, (byte)-11);
        map.put(247, (byte)-10);
        map.put(8776, (byte)-9);
        map.put(176, (byte)-8);
        map.put(8729, (byte)-7);
        map.put(183, (byte)-6);
        map.put(8730, (byte)-5);
        map.put(8319, (byte)-4);
        map.put(178, (byte)-3);
        map.put(9632, (byte)-2);
        map.put(160, (byte)-1);
        byte[] realData = new byte[5000];
        try {
            byte[] data = content.getBytes("UNICODE");
            int k = 3;
            realData[0] = 27;
            realData[1] = 116;
            realData[2] = 3;
            for (int i = 2; i < data.length; i += 2) {
                int c = (data[i + 1] & 0xFF) * 256 + (data[i] & 0xFF);
                if (map.get(c) != null) {
                    realData[k] = (Byte)map.get(c);
                    ++k;
                    continue;
                }
                realData[k] = (byte)c;
                ++k;
            }
            realData[k] = 10;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.mprinter.sendBytesData(realData);
    }

    public int printTextInCP863(String content) {
        HashMap<Integer, Byte> map = new HashMap<Integer, Byte>();
        map.put(199, (byte)-128);
        map.put(252, (byte)-127);
        map.put(233, (byte)-126);
        map.put(226, (byte)-125);
        map.put(194, (byte)-124);
        map.put(224, (byte)-123);
        map.put(182, (byte)-122);
        map.put(231, (byte)-121);
        map.put(234, (byte)-120);
        map.put(235, (byte)-119);
        map.put(232, (byte)-118);
        map.put(239, (byte)-117);
        map.put(238, (byte)-116);
        map.put(8215, (byte)-115);
        map.put(192, (byte)-114);
        map.put(167, (byte)-113);
        map.put(201, (byte)-112);
        map.put(200, (byte)-111);
        map.put(202, (byte)-110);
        map.put(244, (byte)-109);
        map.put(203, (byte)-108);
        map.put(207, (byte)-107);
        map.put(251, (byte)-106);
        map.put(249, (byte)-105);
        map.put(164, (byte)-104);
        map.put(212, (byte)-103);
        map.put(220, (byte)-102);
        map.put(162, (byte)-101);
        map.put(163, (byte)-100);
        map.put(217, (byte)-99);
        map.put(219, (byte)-98);
        map.put(402, (byte)-97);
        map.put(166, (byte)-96);
        map.put(180, (byte)-95);
        map.put(243, (byte)-94);
        map.put(250, (byte)-93);
        map.put(168, (byte)-92);
        map.put(184, (byte)-91);
        map.put(179, (byte)-90);
        map.put(175, (byte)-89);
        map.put(206, (byte)-88);
        map.put(8976, (byte)-87);
        map.put(172, (byte)-86);
        map.put(189, (byte)-85);
        map.put(188, (byte)-84);
        map.put(190, (byte)-83);
        map.put(171, (byte)-82);
        map.put(187, (byte)-81);
        map.put(9617, (byte)-80);
        map.put(9618, (byte)-79);
        map.put(9619, (byte)-78);
        map.put(9474, (byte)-77);
        map.put(9508, (byte)-76);
        map.put(9569, (byte)-75);
        map.put(9570, (byte)-74);
        map.put(9558, (byte)-73);
        map.put(9557, (byte)-72);
        map.put(9571, (byte)-71);
        map.put(9553, (byte)-70);
        map.put(9559, (byte)-69);
        map.put(9565, (byte)-68);
        map.put(9564, (byte)-67);
        map.put(9563, (byte)-66);
        map.put(9488, (byte)-65);
        map.put(9492, (byte)-64);
        map.put(9534, (byte)-63);
        map.put(9516, (byte)-62);
        map.put(9500, (byte)-61);
        map.put(9472, (byte)-60);
        map.put(9532, (byte)-59);
        map.put(9566, (byte)-58);
        map.put(9567, (byte)-57);
        map.put(9562, (byte)-56);
        map.put(9556, (byte)-55);
        map.put(9577, (byte)-54);
        map.put(9574, (byte)-53);
        map.put(9568, (byte)-52);
        map.put(9552, (byte)-51);
        map.put(9580, (byte)-50);
        map.put(9575, (byte)-49);
        map.put(9576, (byte)-48);
        map.put(9572, (byte)-47);
        map.put(9573, (byte)-46);
        map.put(9561, (byte)-45);
        map.put(9560, (byte)-44);
        map.put(9554, (byte)-43);
        map.put(9555, (byte)-42);
        map.put(9579, (byte)-41);
        map.put(9578, (byte)-40);
        map.put(9496, (byte)-39);
        map.put(9484, (byte)-38);
        map.put(9608, (byte)-37);
        map.put(9604, (byte)-36);
        map.put(9612, (byte)-35);
        map.put(9616, (byte)-34);
        map.put(9600, (byte)-33);
        map.put(945, (byte)-32);
        map.put(223, (byte)-31);
        map.put(915, (byte)-30);
        map.put(960, (byte)-29);
        map.put(931, (byte)-28);
        map.put(963, (byte)-27);
        map.put(181, (byte)-26);
        map.put(964, (byte)-25);
        map.put(934, (byte)-24);
        map.put(920, (byte)-23);
        map.put(937, (byte)-22);
        map.put(948, (byte)-21);
        map.put(8734, (byte)-20);
        map.put(966, (byte)-19);
        map.put(949, (byte)-18);
        map.put(8745, (byte)-17);
        map.put(8801, (byte)-16);
        map.put(177, (byte)-15);
        map.put(8805, (byte)-14);
        map.put(8804, (byte)-13);
        map.put(8992, (byte)-12);
        map.put(8993, (byte)-11);
        map.put(247, (byte)-10);
        map.put(8776, (byte)-9);
        map.put(176, (byte)-8);
        map.put(8729, (byte)-7);
        map.put(183, (byte)-6);
        map.put(8730, (byte)-5);
        map.put(8319, (byte)-4);
        map.put(178, (byte)-3);
        map.put(9632, (byte)-2);
        map.put(160, (byte)-1);
        byte[] realData = new byte[5000];
        try {
            byte[] data = content.getBytes("UNICODE");
            int k = 3;
            realData[0] = 27;
            realData[1] = 116;
            realData[2] = 4;
            for (int i = 2; i < data.length; i += 2) {
                int c = (data[i + 1] & 0xFF) * 256 + (data[i] & 0xFF);
                if (map.get(c) != null) {
                    realData[k] = (Byte)map.get(c);
                    ++k;
                    continue;
                }
                realData[k] = data[i];
                ++k;
            }
            realData[k] = 10;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.mprinter.sendBytesData(realData);
    }

    public int printTextInCP865(String content) {
        HashMap<Integer, Byte> map = new HashMap<Integer, Byte>();
        map.put(199, (byte)-128);
        map.put(252, (byte)-127);
        map.put(233, (byte)-126);
        map.put(226, (byte)-125);
        map.put(228, (byte)-124);
        map.put(224, (byte)-123);
        map.put(229, (byte)-122);
        map.put(231, (byte)-121);
        map.put(234, (byte)-120);
        map.put(235, (byte)-119);
        map.put(232, (byte)-118);
        map.put(239, (byte)-117);
        map.put(238, (byte)-116);
        map.put(236, (byte)-115);
        map.put(196, (byte)-114);
        map.put(197, (byte)-113);
        map.put(201, (byte)-112);
        map.put(230, (byte)-111);
        map.put(198, (byte)-110);
        map.put(244, (byte)-109);
        map.put(246, (byte)-108);
        map.put(242, (byte)-107);
        map.put(251, (byte)-106);
        map.put(249, (byte)-105);
        map.put(255, (byte)-104);
        map.put(214, (byte)-103);
        map.put(220, (byte)-102);
        map.put(248, (byte)-101);
        map.put(163, (byte)-100);
        map.put(216, (byte)-99);
        map.put(8359, (byte)-98);
        map.put(402, (byte)-97);
        map.put(225, (byte)-96);
        map.put(237, (byte)-95);
        map.put(243, (byte)-94);
        map.put(250, (byte)-93);
        map.put(241, (byte)-92);
        map.put(209, (byte)-91);
        map.put(170, (byte)-90);
        map.put(186, (byte)-89);
        map.put(191, (byte)-88);
        map.put(8976, (byte)-87);
        map.put(172, (byte)-86);
        map.put(189, (byte)-85);
        map.put(188, (byte)-84);
        map.put(161, (byte)-83);
        map.put(171, (byte)-82);
        map.put(164, (byte)-81);
        map.put(9617, (byte)-80);
        map.put(9618, (byte)-79);
        map.put(9619, (byte)-78);
        map.put(9474, (byte)-77);
        map.put(9508, (byte)-76);
        map.put(9569, (byte)-75);
        map.put(9570, (byte)-74);
        map.put(9558, (byte)-73);
        map.put(9557, (byte)-72);
        map.put(9571, (byte)-71);
        map.put(9553, (byte)-70);
        map.put(9559, (byte)-69);
        map.put(9565, (byte)-68);
        map.put(9564, (byte)-67);
        map.put(9563, (byte)-66);
        map.put(9488, (byte)-65);
        map.put(9492, (byte)-64);
        map.put(9524, (byte)-63);
        map.put(9516, (byte)-62);
        map.put(9500, (byte)-61);
        map.put(9472, (byte)-60);
        map.put(9532, (byte)-59);
        map.put(9566, (byte)-58);
        map.put(9567, (byte)-57);
        map.put(9562, (byte)-56);
        map.put(9556, (byte)-55);
        map.put(9577, (byte)-54);
        map.put(9574, (byte)-53);
        map.put(9568, (byte)-52);
        map.put(9552, (byte)-51);
        map.put(9580, (byte)-50);
        map.put(9575, (byte)-49);
        map.put(9576, (byte)-48);
        map.put(9572, (byte)-47);
        map.put(9573, (byte)-46);
        map.put(9561, (byte)-45);
        map.put(9560, (byte)-44);
        map.put(9554, (byte)-43);
        map.put(9555, (byte)-42);
        map.put(9579, (byte)-41);
        map.put(9578, (byte)-40);
        map.put(9496, (byte)-39);
        map.put(9484, (byte)-38);
        map.put(9608, (byte)-37);
        map.put(9604, (byte)-36);
        map.put(9612, (byte)-35);
        map.put(9616, (byte)-34);
        map.put(9600, (byte)-33);
        map.put(945, (byte)-32);
        map.put(223, (byte)-31);
        map.put(915, (byte)-30);
        map.put(960, (byte)-29);
        map.put(931, (byte)-28);
        map.put(963, (byte)-27);
        map.put(181, (byte)-26);
        map.put(964, (byte)-25);
        map.put(934, (byte)-24);
        map.put(920, (byte)-23);
        map.put(937, (byte)-22);
        map.put(948, (byte)-21);
        map.put(8734, (byte)-20);
        map.put(966, (byte)-19);
        map.put(949, (byte)-18);
        map.put(8745, (byte)-17);
        map.put(8801, (byte)-16);
        map.put(177, (byte)-15);
        map.put(8805, (byte)-14);
        map.put(8804, (byte)-13);
        map.put(8992, (byte)-12);
        map.put(8993, (byte)-11);
        map.put(247, (byte)-10);
        map.put(8776, (byte)-9);
        map.put(176, (byte)-8);
        map.put(8729, (byte)-7);
        map.put(183, (byte)-6);
        map.put(8730, (byte)-5);
        map.put(8319, (byte)-4);
        map.put(178, (byte)-3);
        map.put(9632, (byte)-2);
        map.put(160, (byte)-1);
        byte[] realData = new byte[5000];
        try {
            byte[] data = content.getBytes("UNICODE");
            int k = 3;
            realData[0] = 27;
            realData[1] = 116;
            realData[2] = 5;
            for (int i = 2; i < data.length; i += 2) {
                int c = (data[i + 1] & 0xFF) * 256 + (data[i] & 0xFF);
                if (map.get(c) != null) {
                    realData[k] = (Byte)map.get(c);
                    ++k;
                    continue;
                }
                realData[k] = data[i];
                ++k;
            }
            realData[k] = 10;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.mprinter.sendBytesData(realData);
    }

    public int printTextInWCP1251(String content) {
        HashMap<Integer, Byte> map = new HashMap<Integer, Byte>();
        map.put(1026, (byte)-128);
        map.put(1027, (byte)-127);
        map.put(8218, (byte)-126);
        map.put(1107, (byte)-125);
        map.put(8222, (byte)-124);
        map.put(8230, (byte)-123);
        map.put(8224, (byte)-122);
        map.put(8225, (byte)-121);
        map.put(8364, (byte)-120);
        map.put(8240, (byte)-119);
        map.put(1033, (byte)-118);
        map.put(8249, (byte)-117);
        map.put(1034, (byte)-116);
        map.put(1036, (byte)-115);
        map.put(1035, (byte)-114);
        map.put(1039, (byte)-113);
        map.put(1106, (byte)-112);
        map.put(8216, (byte)-111);
        map.put(8217, (byte)-110);
        map.put(8220, (byte)-109);
        map.put(8221, (byte)-108);
        map.put(8226, (byte)-107);
        map.put(8211, (byte)-106);
        map.put(8212, (byte)-105);
        map.put(8482, (byte)-103);
        map.put(1113, (byte)-102);
        map.put(8250, (byte)-101);
        map.put(1114, (byte)-100);
        map.put(1116, (byte)-99);
        map.put(1115, (byte)-98);
        map.put(1119, (byte)-97);
        map.put(160, (byte)-96);
        map.put(1038, (byte)-95);
        map.put(1118, (byte)-94);
        map.put(1032, (byte)-93);
        map.put(164, (byte)-92);
        map.put(1168, (byte)-91);
        map.put(166, (byte)-90);
        map.put(167, (byte)-89);
        map.put(1025, (byte)-88);
        map.put(169, (byte)-87);
        map.put(1028, (byte)-86);
        map.put(171, (byte)-85);
        map.put(172, (byte)-84);
        map.put(173, (byte)-83);
        map.put(174, (byte)-82);
        map.put(1031, (byte)-81);
        map.put(176, (byte)-80);
        map.put(177, (byte)-79);
        map.put(1030, (byte)-78);
        map.put(1110, (byte)-77);
        map.put(1169, (byte)-76);
        map.put(181, (byte)-75);
        map.put(182, (byte)-74);
        map.put(183, (byte)-73);
        map.put(1105, (byte)-72);
        map.put(8470, (byte)-71);
        map.put(1108, (byte)-70);
        map.put(187, (byte)-69);
        map.put(1112, (byte)-68);
        map.put(1029, (byte)-67);
        map.put(1109, (byte)-66);
        map.put(1111, (byte)-65);
        map.put(1040, (byte)-64);
        map.put(1041, (byte)-63);
        map.put(1042, (byte)-62);
        map.put(1043, (byte)-61);
        map.put(1044, (byte)-60);
        map.put(1045, (byte)-59);
        map.put(1046, (byte)-58);
        map.put(1047, (byte)-57);
        map.put(1048, (byte)-56);
        map.put(1049, (byte)-55);
        map.put(1050, (byte)-54);
        map.put(1051, (byte)-53);
        map.put(1052, (byte)-52);
        map.put(1053, (byte)-51);
        map.put(1054, (byte)-50);
        map.put(1055, (byte)-49);
        map.put(1056, (byte)-48);
        map.put(1057, (byte)-47);
        map.put(1058, (byte)-46);
        map.put(1059, (byte)-45);
        map.put(1060, (byte)-44);
        map.put(1061, (byte)-43);
        map.put(1062, (byte)-42);
        map.put(1063, (byte)-41);
        map.put(1064, (byte)-40);
        map.put(1065, (byte)-39);
        map.put(1066, (byte)-38);
        map.put(1067, (byte)-37);
        map.put(1068, (byte)-36);
        map.put(1069, (byte)-35);
        map.put(1070, (byte)-34);
        map.put(1071, (byte)-33);
        map.put(1072, (byte)-32);
        map.put(1073, (byte)-31);
        map.put(1074, (byte)-30);
        map.put(1075, (byte)-29);
        map.put(1076, (byte)-28);
        map.put(1077, (byte)-27);
        map.put(1078, (byte)-26);
        map.put(1079, (byte)-25);
        map.put(1080, (byte)-24);
        map.put(1081, (byte)-23);
        map.put(1082, (byte)-22);
        map.put(1083, (byte)-21);
        map.put(1084, (byte)-20);
        map.put(1085, (byte)-19);
        map.put(1086, (byte)-18);
        map.put(1087, (byte)-17);
        map.put(1088, (byte)-16);
        map.put(1089, (byte)-15);
        map.put(1090, (byte)-14);
        map.put(1091, (byte)-13);
        map.put(1092, (byte)-12);
        map.put(1093, (byte)-11);
        map.put(1094, (byte)-10);
        map.put(1095, (byte)-9);
        map.put(1096, (byte)-8);
        map.put(1097, (byte)-7);
        map.put(1098, (byte)-6);
        map.put(1099, (byte)-5);
        map.put(1100, (byte)-4);
        map.put(1101, (byte)-3);
        map.put(1102, (byte)-2);
        map.put(1103, (byte)-1);
        byte[] realData = new byte[5000];
        try {
            byte[] data = content.getBytes("UNICODE");
            int k = 3;
            realData[0] = 27;
            realData[1] = 116;
            realData[2] = 6;
            for (int i = 2; i < data.length; i += 2) {
                int c = (data[i + 1] & 0xFF) * 256 + (data[i] & 0xFF);
                if (map.get(c) != null) {
                    realData[k] = (Byte)map.get(c);
                    ++k;
                    continue;
                }
                realData[k] = data[i];
                ++k;
            }
            realData[k] = 10;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.mprinter.sendBytesData(realData);
    }

    public int printTextInMIK(String content) {
        HashMap<Integer, Byte> map = new HashMap<Integer, Byte>();
        map.put(1040, (byte)-128);
        map.put(1041, (byte)-127);
        map.put(1042, (byte)-126);
        map.put(1043, (byte)-125);
        map.put(1044, (byte)-124);
        map.put(1045, (byte)-123);
        map.put(1046, (byte)-122);
        map.put(1047, (byte)-121);
        map.put(1048, (byte)-120);
        map.put(1049, (byte)-119);
        map.put(1050, (byte)-118);
        map.put(1051, (byte)-117);
        map.put(1052, (byte)-116);
        map.put(1053, (byte)-115);
        map.put(1054, (byte)-114);
        map.put(1055, (byte)-113);
        map.put(1056, (byte)-112);
        map.put(1057, (byte)-111);
        map.put(1058, (byte)-110);
        map.put(1059, (byte)-109);
        map.put(1060, (byte)-108);
        map.put(1061, (byte)-107);
        map.put(1062, (byte)-106);
        map.put(1063, (byte)-105);
        map.put(1064, (byte)-104);
        map.put(1065, (byte)-103);
        map.put(1066, (byte)-102);
        map.put(1067, (byte)-101);
        map.put(1068, (byte)-100);
        map.put(1069, (byte)-99);
        map.put(1070, (byte)-98);
        map.put(1071, (byte)-97);
        map.put(1072, (byte)-96);
        map.put(1073, (byte)-95);
        map.put(1074, (byte)-94);
        map.put(1075, (byte)-93);
        map.put(1076, (byte)-92);
        map.put(1077, (byte)-91);
        map.put(1078, (byte)-90);
        map.put(1079, (byte)-89);
        map.put(1080, (byte)-88);
        map.put(1081, (byte)-87);
        map.put(1082, (byte)-86);
        map.put(1083, (byte)-85);
        map.put(1084, (byte)-84);
        map.put(1085, (byte)-83);
        map.put(1086, (byte)-82);
        map.put(1087, (byte)-81);
        map.put(1088, (byte)-80);
        map.put(1089, (byte)-79);
        map.put(1090, (byte)-78);
        map.put(1091, (byte)-77);
        map.put(1092, (byte)-76);
        map.put(1093, (byte)-75);
        map.put(1094, (byte)-74);
        map.put(1095, (byte)-73);
        map.put(1096, (byte)-72);
        map.put(1097, (byte)-71);
        map.put(1098, (byte)-70);
        map.put(1099, (byte)-69);
        map.put(1100, (byte)-68);
        map.put(1101, (byte)-67);
        map.put(1102, (byte)-66);
        map.put(1103, (byte)-65);
        map.put(9492, (byte)-64);
        map.put(9524, (byte)-63);
        map.put(9516, (byte)-62);
        map.put(9500, (byte)-61);
        map.put(9472, (byte)-60);
        map.put(9532, (byte)-59);
        map.put(9571, (byte)-58);
        map.put(9553, (byte)-57);
        map.put(9562, (byte)-56);
        map.put(9556, (byte)-55);
        map.put(9577, (byte)-54);
        map.put(9574, (byte)-53);
        map.put(9568, (byte)-52);
        map.put(9552, (byte)-51);
        map.put(9580, (byte)-50);
        map.put(9488, (byte)-49);
        map.put(9617, (byte)-48);
        map.put(9618, (byte)-47);
        map.put(9619, (byte)-46);
        map.put(9474, (byte)-45);
        map.put(9508, (byte)-44);
        map.put(8470, (byte)-43);
        map.put(167, (byte)-42);
        map.put(9559, (byte)-41);
        map.put(9565, (byte)-40);
        map.put(9496, (byte)-39);
        map.put(9484, (byte)-38);
        map.put(9608, (byte)-37);
        map.put(9604, (byte)-36);
        map.put(9612, (byte)-35);
        map.put(9616, (byte)-34);
        map.put(9600, (byte)-33);
        map.put(945, (byte)-32);
        map.put(223, (byte)-31);
        map.put(915, (byte)-30);
        map.put(960, (byte)-29);
        map.put(931, (byte)-28);
        map.put(963, (byte)-27);
        map.put(181, (byte)-26);
        map.put(964, (byte)-25);
        map.put(934, (byte)-24);
        map.put(920, (byte)-23);
        map.put(937, (byte)-22);
        map.put(948, (byte)-21);
        map.put(8734, (byte)-20);
        map.put(966, (byte)-19);
        map.put(949, (byte)-18);
        map.put(8745, (byte)-17);
        map.put(8801, (byte)-16);
        map.put(177, (byte)-15);
        map.put(8805, (byte)-14);
        map.put(8804, (byte)-13);
        map.put(8992, (byte)-12);
        map.put(8993, (byte)-11);
        map.put(247, (byte)-10);
        map.put(8776, (byte)-9);
        map.put(176, (byte)-8);
        map.put(8729, (byte)-7);
        map.put(183, (byte)-6);
        map.put(8730, (byte)-5);
        map.put(8319, (byte)-4);
        map.put(178, (byte)-3);
        map.put(9632, (byte)-2);
        map.put(160, (byte)-1);
        byte[] realData = new byte[5000];
        try {
            byte[] data = content.getBytes("UNICODE");
            int k = 3;
            realData[0] = 27;
            realData[1] = 116;
            realData[2] = 8;
            for (int i = 2; i < data.length; i += 2) {
                int c = (data[i + 1] & 0xFF) * 256 + (data[i] & 0xFF);
                if (map.get(c) != null) {
                    realData[k] = (Byte)map.get(c);
                    ++k;
                    continue;
                }
                realData[k] = data[i];
                ++k;
            }
            realData[k] = 10;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.mprinter.sendBytesData(realData);
    }

    public int printTextInCP862(String content) {
        HashMap<Integer, Byte> map = new HashMap<Integer, Byte>();
        map.put(1488, (byte)-128);
        map.put(1489, (byte)-127);
        map.put(1490, (byte)-126);
        map.put(1491, (byte)-125);
        map.put(1492, (byte)-124);
        map.put(1493, (byte)-123);
        map.put(1494, (byte)-122);
        map.put(1495, (byte)-121);
        map.put(1496, (byte)-120);
        map.put(1497, (byte)-119);
        map.put(1498, (byte)-118);
        map.put(1499, (byte)-117);
        map.put(1500, (byte)-116);
        map.put(1501, (byte)-115);
        map.put(1502, (byte)-114);
        map.put(1503, (byte)-113);
        map.put(1504, (byte)-112);
        map.put(1505, (byte)-111);
        map.put(1506, (byte)-110);
        map.put(1507, (byte)-109);
        map.put(1508, (byte)-108);
        map.put(1509, (byte)-107);
        map.put(1510, (byte)-106);
        map.put(1511, (byte)-105);
        map.put(1512, (byte)-104);
        map.put(1513, (byte)-103);
        map.put(1514, (byte)-102);
        map.put(1515, (byte)-101);
        map.put(1516, (byte)-100);
        map.put(1517, (byte)-99);
        map.put(1518, (byte)-98);
        map.put(1519, (byte)-97);
        map.put(225, (byte)-96);
        map.put(237, (byte)-95);
        map.put(243, (byte)-94);
        map.put(250, (byte)-93);
        map.put(241, (byte)-92);
        map.put(209, (byte)-91);
        map.put(170, (byte)-90);
        map.put(186, (byte)-89);
        map.put(191, (byte)-88);
        map.put(8976, (byte)-87);
        map.put(172, (byte)-86);
        map.put(189, (byte)-85);
        map.put(188, (byte)-84);
        map.put(161, (byte)-83);
        map.put(171, (byte)-82);
        map.put(187, (byte)-81);
        map.put(9617, (byte)-80);
        map.put(9618, (byte)-79);
        map.put(9619, (byte)-78);
        map.put(9474, (byte)-77);
        map.put(9508, (byte)-76);
        map.put(9569, (byte)-75);
        map.put(9570, (byte)-74);
        map.put(9558, (byte)-73);
        map.put(9557, (byte)-72);
        map.put(9571, (byte)-71);
        map.put(9553, (byte)-70);
        map.put(9559, (byte)-69);
        map.put(9565, (byte)-68);
        map.put(9564, (byte)-67);
        map.put(9563, (byte)-66);
        map.put(9488, (byte)-65);
        map.put(9492, (byte)-64);
        map.put(9524, (byte)-63);
        map.put(9516, (byte)-62);
        map.put(9500, (byte)-61);
        map.put(9472, (byte)-60);
        map.put(9532, (byte)-59);
        map.put(9566, (byte)-58);
        map.put(9567, (byte)-57);
        map.put(9562, (byte)-56);
        map.put(9556, (byte)-55);
        map.put(9577, (byte)-54);
        map.put(9574, (byte)-53);
        map.put(9568, (byte)-52);
        map.put(9552, (byte)-51);
        map.put(9580, (byte)-50);
        map.put(9575, (byte)-49);
        map.put(9576, (byte)-48);
        map.put(9572, (byte)-47);
        map.put(9573, (byte)-46);
        map.put(9561, (byte)-45);
        map.put(9560, (byte)-44);
        map.put(9554, (byte)-43);
        map.put(9555, (byte)-42);
        map.put(9579, (byte)-41);
        map.put(9578, (byte)-40);
        map.put(9496, (byte)-39);
        map.put(9484, (byte)-38);
        map.put(9608, (byte)-37);
        map.put(9604, (byte)-36);
        map.put(9612, (byte)-35);
        map.put(9616, (byte)-34);
        map.put(9600, (byte)-33);
        map.put(945, (byte)-32);
        map.put(223, (byte)-31);
        map.put(915, (byte)-30);
        map.put(960, (byte)-29);
        map.put(931, (byte)-28);
        map.put(963, (byte)-27);
        map.put(181, (byte)-26);
        map.put(964, (byte)-25);
        map.put(934, (byte)-24);
        map.put(920, (byte)-23);
        map.put(937, (byte)-22);
        map.put(948, (byte)-21);
        map.put(8734, (byte)-20);
        map.put(966, (byte)-19);
        map.put(949, (byte)-18);
        map.put(8745, (byte)-17);
        map.put(8801, (byte)-16);
        map.put(177, (byte)-15);
        map.put(8805, (byte)-14);
        map.put(8804, (byte)-13);
        map.put(8992, (byte)-12);
        map.put(8993, (byte)-11);
        map.put(247, (byte)-10);
        map.put(8776, (byte)-9);
        map.put(176, (byte)-8);
        map.put(8729, (byte)-7);
        map.put(183, (byte)-6);
        map.put(8730, (byte)-5);
        map.put(8319, (byte)-4);
        map.put(178, (byte)-3);
        map.put(9632, (byte)-2);
        map.put(160, (byte)-1);
        byte[] realData = new byte[5000];
        try {
            byte[] data = content.getBytes("UNICODE");
            int k = 3;
            realData[0] = 27;
            realData[1] = 116;
            realData[2] = 15;
            for (int i = 2; i < data.length; i += 2) {
                int c = (data[i + 1] & 0xFF) * 256 + (data[i] & 0xFF);
                if (map.get(c) != null) {
                    realData[k] = (Byte)map.get(c);
                    ++k;
                    continue;
                }
                realData[k] = data[i];
                ++k;
            }
            realData[k] = 10;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.mprinter.sendBytesData(realData);
    }

    public int printTextInWCP1252(String content) {
        HashMap<Integer, Byte> map = new HashMap<Integer, Byte>();
        map.put(8364, (byte)-128);
        map.put(8218, (byte)-126);
        map.put(402, (byte)-125);
        map.put(8222, (byte)-124);
        map.put(8230, (byte)-123);
        map.put(8224, (byte)-122);
        map.put(8225, (byte)-121);
        map.put(710, (byte)-120);
        map.put(8240, (byte)-119);
        map.put(352, (byte)-118);
        map.put(8249, (byte)-117);
        map.put(338, (byte)-116);
        map.put(381, (byte)-114);
        map.put(8216, (byte)-111);
        map.put(8217, (byte)-110);
        map.put(8220, (byte)-109);
        map.put(8221, (byte)-108);
        map.put(8226, (byte)-107);
        map.put(8211, (byte)-106);
        map.put(8212, (byte)-105);
        map.put(732, (byte)-104);
        map.put(8482, (byte)-103);
        map.put(353, (byte)-102);
        map.put(8250, (byte)-101);
        map.put(339, (byte)-100);
        map.put(382, (byte)-98);
        map.put(376, (byte)-97);
        map.put(160, (byte)-96);
        map.put(161, (byte)-95);
        map.put(162, (byte)-94);
        map.put(163, (byte)-93);
        map.put(164, (byte)-92);
        map.put(165, (byte)-91);
        map.put(166, (byte)-90);
        map.put(167, (byte)-89);
        map.put(168, (byte)-88);
        map.put(169, (byte)-87);
        map.put(170, (byte)-86);
        map.put(171, (byte)-85);
        map.put(172, (byte)-84);
        map.put(173, (byte)-83);
        map.put(174, (byte)-82);
        map.put(175, (byte)-81);
        map.put(176, (byte)-80);
        map.put(177, (byte)-79);
        map.put(178, (byte)-78);
        map.put(179, (byte)-77);
        map.put(180, (byte)-76);
        map.put(181, (byte)-75);
        map.put(182, (byte)-74);
        map.put(183, (byte)-73);
        map.put(184, (byte)-72);
        map.put(185, (byte)-71);
        map.put(186, (byte)-70);
        map.put(187, (byte)-69);
        map.put(188, (byte)-68);
        map.put(189, (byte)-67);
        map.put(190, (byte)-66);
        map.put(191, (byte)-65);
        map.put(192, (byte)-64);
        map.put(193, (byte)-63);
        map.put(194, (byte)-62);
        map.put(195, (byte)-61);
        map.put(196, (byte)-60);
        map.put(197, (byte)-59);
        map.put(198, (byte)-58);
        map.put(199, (byte)-57);
        map.put(200, (byte)-56);
        map.put(201, (byte)-55);
        map.put(202, (byte)-54);
        map.put(203, (byte)-53);
        map.put(204, (byte)-52);
        map.put(205, (byte)-51);
        map.put(206, (byte)-50);
        map.put(207, (byte)-49);
        map.put(208, (byte)-48);
        map.put(209, (byte)-47);
        map.put(210, (byte)-46);
        map.put(211, (byte)-45);
        map.put(212, (byte)-44);
        map.put(213, (byte)-43);
        map.put(214, (byte)-42);
        map.put(215, (byte)-41);
        map.put(216, (byte)-40);
        map.put(217, (byte)-39);
        map.put(218, (byte)-38);
        map.put(219, (byte)-37);
        map.put(220, (byte)-36);
        map.put(221, (byte)-35);
        map.put(222, (byte)-34);
        map.put(223, (byte)-33);
        map.put(224, (byte)-32);
        map.put(225, (byte)-31);
        map.put(226, (byte)-30);
        map.put(227, (byte)-29);
        map.put(228, (byte)-28);
        map.put(229, (byte)-27);
        map.put(230, (byte)-26);
        map.put(231, (byte)-25);
        map.put(232, (byte)-24);
        map.put(233, (byte)-23);
        map.put(234, (byte)-22);
        map.put(235, (byte)-21);
        map.put(236, (byte)-20);
        map.put(237, (byte)-19);
        map.put(238, (byte)-18);
        map.put(239, (byte)-17);
        map.put(240, (byte)-16);
        map.put(241, (byte)-15);
        map.put(242, (byte)-14);
        map.put(243, (byte)-13);
        map.put(244, (byte)-12);
        map.put(245, (byte)-11);
        map.put(246, (byte)-10);
        map.put(247, (byte)-9);
        map.put(248, (byte)-8);
        map.put(249, (byte)-7);
        map.put(250, (byte)-6);
        map.put(251, (byte)-5);
        map.put(252, (byte)-4);
        map.put(253, (byte)-3);
        map.put(254, (byte)-2);
        map.put(255, (byte)-1);
        byte[] realData = new byte[5000];
        try {
            byte[] data = content.getBytes("UNICODE");
            int k = 3;
            realData[0] = 27;
            realData[1] = 116;
            realData[2] = 16;
            for (int i = 2; i < data.length; i += 2) {
                int c = (data[i + 1] & 0xFF) * 256 + (data[i] & 0xFF);
                if (map.get(c) != null) {
                    realData[k] = (Byte)map.get(c);
                    ++k;
                    continue;
                }
                realData[k] = data[i];
                ++k;
            }
            realData[k] = 10;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.mprinter.sendBytesData(realData);
    }

    public int printTextInWCP1253(String content) {
        HashMap<Integer, Byte> map = new HashMap<Integer, Byte>();
        map.put(8364, (byte)-128);
        map.put(8218, (byte)-126);
        map.put(402, (byte)-125);
        map.put(8222, (byte)-124);
        map.put(8230, (byte)-123);
        map.put(8224, (byte)-122);
        map.put(8225, (byte)-121);
        map.put(8240, (byte)-119);
        map.put(8249, (byte)-117);
        map.put(8216, (byte)-111);
        map.put(8217, (byte)-110);
        map.put(8220, (byte)-109);
        map.put(8221, (byte)-108);
        map.put(8226, (byte)-107);
        map.put(8211, (byte)-106);
        map.put(8212, (byte)-105);
        map.put(8482, (byte)-103);
        map.put(8250, (byte)-101);
        map.put(160, (byte)-96);
        map.put(901, (byte)-95);
        map.put(902, (byte)-94);
        map.put(163, (byte)-93);
        map.put(164, (byte)-92);
        map.put(165, (byte)-91);
        map.put(166, (byte)-90);
        map.put(167, (byte)-89);
        map.put(168, (byte)-88);
        map.put(169, (byte)-87);
        map.put(171, (byte)-85);
        map.put(172, (byte)-84);
        map.put(173, (byte)-83);
        map.put(174, (byte)-82);
        map.put(8213, (byte)-81);
        map.put(176, (byte)-80);
        map.put(177, (byte)-79);
        map.put(178, (byte)-78);
        map.put(179, (byte)-77);
        map.put(900, (byte)-76);
        map.put(181, (byte)-75);
        map.put(182, (byte)-74);
        map.put(183, (byte)-73);
        map.put(904, (byte)-72);
        map.put(905, (byte)-71);
        map.put(906, (byte)-70);
        map.put(187, (byte)-69);
        map.put(908, (byte)-68);
        map.put(189, (byte)-67);
        map.put(910, (byte)-66);
        map.put(911, (byte)-65);
        map.put(912, (byte)-64);
        map.put(913, (byte)-63);
        map.put(914, (byte)-62);
        map.put(915, (byte)-61);
        map.put(916, (byte)-60);
        map.put(917, (byte)-59);
        map.put(918, (byte)-58);
        map.put(919, (byte)-57);
        map.put(920, (byte)-56);
        map.put(921, (byte)-55);
        map.put(922, (byte)-54);
        map.put(923, (byte)-53);
        map.put(924, (byte)-52);
        map.put(925, (byte)-51);
        map.put(926, (byte)-50);
        map.put(927, (byte)-49);
        map.put(928, (byte)-48);
        map.put(929, (byte)-47);
        map.put(931, (byte)-45);
        map.put(932, (byte)-44);
        map.put(933, (byte)-43);
        map.put(934, (byte)-42);
        map.put(935, (byte)-41);
        map.put(936, (byte)-40);
        map.put(937, (byte)-39);
        map.put(938, (byte)-38);
        map.put(939, (byte)-37);
        map.put(940, (byte)-36);
        map.put(941, (byte)-35);
        map.put(942, (byte)-34);
        map.put(943, (byte)-33);
        map.put(944, (byte)-32);
        map.put(945, (byte)-31);
        map.put(946, (byte)-30);
        map.put(947, (byte)-29);
        map.put(948, (byte)-28);
        map.put(949, (byte)-27);
        map.put(950, (byte)-26);
        map.put(951, (byte)-25);
        map.put(952, (byte)-24);
        map.put(953, (byte)-23);
        map.put(954, (byte)-22);
        map.put(955, (byte)-21);
        map.put(956, (byte)-20);
        map.put(957, (byte)-19);
        map.put(958, (byte)-18);
        map.put(959, (byte)-17);
        map.put(960, (byte)-16);
        map.put(961, (byte)-15);
        map.put(962, (byte)-14);
        map.put(963, (byte)-13);
        map.put(964, (byte)-12);
        map.put(965, (byte)-11);
        map.put(966, (byte)-10);
        map.put(967, (byte)-9);
        map.put(968, (byte)-8);
        map.put(969, (byte)-7);
        map.put(970, (byte)-6);
        map.put(971, (byte)-5);
        map.put(972, (byte)-4);
        map.put(973, (byte)-3);
        map.put(974, (byte)-2);
        byte[] realData = new byte[5000];
        try {
            byte[] data = content.getBytes("UNICODE");
            int k = 3;
            realData[0] = 27;
            realData[1] = 116;
            realData[2] = 17;
            for (int i = 2; i < data.length; i += 2) {
                int c = (data[i + 1] & 0xFF) * 256 + (data[i] & 0xFF);
                if (map.get(c) != null) {
                    realData[k] = (Byte)map.get(c);
                    ++k;
                    continue;
                }
                realData[k] = data[i];
                ++k;
            }
            realData[k] = 10;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.mprinter.sendBytesData(realData);
    }

    public int printTextInCP852(String content) {
        HashMap<Integer, Byte> map = new HashMap<Integer, Byte>();
        map.put(199, (byte)-128);
        map.put(252, (byte)-127);
        map.put(233, (byte)-126);
        map.put(226, (byte)-125);
        map.put(228, (byte)-124);
        map.put(367, (byte)-123);
        map.put(263, (byte)-122);
        map.put(231, (byte)-121);
        map.put(322, (byte)-120);
        map.put(235, (byte)-119);
        map.put(336, (byte)-118);
        map.put(337, (byte)-117);
        map.put(238, (byte)-116);
        map.put(377, (byte)-115);
        map.put(196, (byte)-114);
        map.put(262, (byte)-113);
        map.put(201, (byte)-112);
        map.put(313, (byte)-111);
        map.put(314, (byte)-110);
        map.put(244, (byte)-109);
        map.put(246, (byte)-108);
        map.put(317, (byte)-107);
        map.put(318, (byte)-106);
        map.put(346, (byte)-105);
        map.put(347, (byte)-104);
        map.put(214, (byte)-103);
        map.put(220, (byte)-102);
        map.put(356, (byte)-101);
        map.put(357, (byte)-100);
        map.put(321, (byte)-99);
        map.put(215, (byte)-98);
        map.put(269, (byte)-97);
        map.put(225, (byte)-96);
        map.put(237, (byte)-95);
        map.put(243, (byte)-94);
        map.put(250, (byte)-93);
        map.put(260, (byte)-92);
        map.put(261, (byte)-91);
        map.put(381, (byte)-90);
        map.put(382, (byte)-89);
        map.put(280, (byte)-88);
        map.put(281, (byte)-87);
        map.put(172, (byte)-86);
        map.put(378, (byte)-85);
        map.put(268, (byte)-84);
        map.put(351, (byte)-83);
        map.put(171, (byte)-82);
        map.put(187, (byte)-81);
        map.put(9617, (byte)-80);
        map.put(9618, (byte)-79);
        map.put(9619, (byte)-78);
        map.put(9474, (byte)-77);
        map.put(9508, (byte)-76);
        map.put(193, (byte)-75);
        map.put(194, (byte)-74);
        map.put(282, (byte)-73);
        map.put(350, (byte)-72);
        map.put(9571, (byte)-71);
        map.put(9553, (byte)-70);
        map.put(9559, (byte)-69);
        map.put(9565, (byte)-68);
        map.put(379, (byte)-67);
        map.put(380, (byte)-66);
        map.put(9488, (byte)-65);
        map.put(9492, (byte)-64);
        map.put(9524, (byte)-63);
        map.put(9516, (byte)-62);
        map.put(9500, (byte)-61);
        map.put(9472, (byte)-60);
        map.put(9532, (byte)-59);
        map.put(258, (byte)-58);
        map.put(259, (byte)-57);
        map.put(9562, (byte)-56);
        map.put(9556, (byte)-55);
        map.put(9577, (byte)-54);
        map.put(9574, (byte)-53);
        map.put(9568, (byte)-52);
        map.put(9552, (byte)-51);
        map.put(9580, (byte)-50);
        map.put(164, (byte)-49);
        map.put(273, (byte)-48);
        map.put(272, (byte)-47);
        map.put(270, (byte)-46);
        map.put(203, (byte)-45);
        map.put(271, (byte)-44);
        map.put(327, (byte)-43);
        map.put(205, (byte)-42);
        map.put(206, (byte)-41);
        map.put(283, (byte)-40);
        map.put(9496, (byte)-39);
        map.put(9484, (byte)-38);
        map.put(9608, (byte)-37);
        map.put(9604, (byte)-36);
        map.put(354, (byte)-35);
        map.put(366, (byte)-34);
        map.put(9600, (byte)-33);
        map.put(211, (byte)-32);
        map.put(223, (byte)-31);
        map.put(212, (byte)-30);
        map.put(323, (byte)-29);
        map.put(324, (byte)-28);
        map.put(328, (byte)-27);
        map.put(352, (byte)-26);
        map.put(353, (byte)-25);
        map.put(340, (byte)-24);
        map.put(218, (byte)-23);
        map.put(341, (byte)-22);
        map.put(368, (byte)-21);
        map.put(253, (byte)-20);
        map.put(221, (byte)-19);
        map.put(355, (byte)-18);
        map.put(180, (byte)-17);
        map.put(173, (byte)-16);
        map.put(733, (byte)-15);
        map.put(731, (byte)-14);
        map.put(711, (byte)-13);
        map.put(728, (byte)-12);
        map.put(167, (byte)-11);
        map.put(247, (byte)-10);
        map.put(184, (byte)-9);
        map.put(176, (byte)-8);
        map.put(168, (byte)-7);
        map.put(729, (byte)-6);
        map.put(369, (byte)-5);
        map.put(344, (byte)-4);
        map.put(345, (byte)-3);
        map.put(9632, (byte)-2);
        map.put(160, (byte)-1);
        byte[] realData = new byte[5000];
        try {
            byte[] data = content.getBytes("UNICODE");
            int k = 3;
            realData[0] = 27;
            realData[1] = 116;
            realData[2] = 18;
            for (int i = 2; i < data.length; i += 2) {
                int c = (data[i + 1] & 0xFF) * 256 + (data[i] & 0xFF);
                if (map.get(c) != null) {
                    realData[k] = (Byte)map.get(c);
                    ++k;
                    continue;
                }
                realData[k] = data[i];
                ++k;
            }
            realData[k] = 10;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.mprinter.sendBytesData(realData);
    }

    public int printTextInCP858(String content) {
        HashMap<Integer, Byte> map = new HashMap<Integer, Byte>();
        map.put(199, (byte)-128);
        map.put(252, (byte)-127);
        map.put(233, (byte)-126);
        map.put(226, (byte)-125);
        map.put(228, (byte)-124);
        map.put(224, (byte)-123);
        map.put(229, (byte)-122);
        map.put(231, (byte)-121);
        map.put(234, (byte)-120);
        map.put(235, (byte)-119);
        map.put(231, (byte)-118);
        map.put(239, (byte)-117);
        map.put(238, (byte)-116);
        map.put(236, (byte)-115);
        map.put(196, (byte)-114);
        map.put(197, (byte)-113);
        map.put(201, (byte)-112);
        map.put(230, (byte)-111);
        map.put(198, (byte)-110);
        map.put(244, (byte)-109);
        map.put(246, (byte)-108);
        map.put(242, (byte)-107);
        map.put(251, (byte)-106);
        map.put(249, (byte)-105);
        map.put(255, (byte)-104);
        map.put(214, (byte)-103);
        map.put(220, (byte)-102);
        map.put(248, (byte)-101);
        map.put(163, (byte)-100);
        map.put(216, (byte)-99);
        map.put(215, (byte)-98);
        map.put(402, (byte)-97);
        map.put(225, (byte)-96);
        map.put(237, (byte)-95);
        map.put(243, (byte)-94);
        map.put(250, (byte)-93);
        map.put(241, (byte)-92);
        map.put(209, (byte)-91);
        map.put(170, (byte)-90);
        map.put(186, (byte)-89);
        map.put(191, (byte)-88);
        map.put(174, (byte)-87);
        map.put(172, (byte)-86);
        map.put(189, (byte)-85);
        map.put(188, (byte)-84);
        map.put(161, (byte)-83);
        map.put(171, (byte)-82);
        map.put(187, (byte)-81);
        map.put(9617, (byte)-80);
        map.put(9618, (byte)-79);
        map.put(9619, (byte)-78);
        map.put(9474, (byte)-77);
        map.put(9508, (byte)-76);
        map.put(193, (byte)-75);
        map.put(194, (byte)-74);
        map.put(192, (byte)-73);
        map.put(169, (byte)-72);
        map.put(9571, (byte)-71);
        map.put(9553, (byte)-70);
        map.put(9559, (byte)-69);
        map.put(9565, (byte)-68);
        map.put(162, (byte)-67);
        map.put(165, (byte)-66);
        map.put(9488, (byte)-65);
        map.put(9492, (byte)-64);
        map.put(9524, (byte)-63);
        map.put(9516, (byte)-62);
        map.put(9500, (byte)-61);
        map.put(9472, (byte)-60);
        map.put(9532, (byte)-59);
        map.put(227, (byte)-58);
        map.put(195, (byte)-57);
        map.put(9562, (byte)-56);
        map.put(9556, (byte)-55);
        map.put(9577, (byte)-54);
        map.put(9574, (byte)-53);
        map.put(9568, (byte)-52);
        map.put(9552, (byte)-51);
        map.put(9580, (byte)-50);
        map.put(164, (byte)-49);
        map.put(240, (byte)-48);
        map.put(208, (byte)-47);
        map.put(202, (byte)-46);
        map.put(203, (byte)-45);
        map.put(200, (byte)-44);
        map.put(8364, (byte)-43);
        map.put(205, (byte)-42);
        map.put(206, (byte)-41);
        map.put(207, (byte)-40);
        map.put(9496, (byte)-39);
        map.put(9484, (byte)-38);
        map.put(9608, (byte)-37);
        map.put(9604, (byte)-36);
        map.put(166, (byte)-35);
        map.put(204, (byte)-34);
        map.put(9600, (byte)-33);
        map.put(211, (byte)-32);
        map.put(223, (byte)-31);
        map.put(212, (byte)-30);
        map.put(210, (byte)-29);
        map.put(245, (byte)-28);
        map.put(213, (byte)-27);
        map.put(181, (byte)-26);
        map.put(254, (byte)-25);
        map.put(222, (byte)-24);
        map.put(218, (byte)-23);
        map.put(219, (byte)-22);
        map.put(217, (byte)-21);
        map.put(253, (byte)-20);
        map.put(221, (byte)-19);
        map.put(175, (byte)-18);
        map.put(180, (byte)-17);
        map.put(173, (byte)-16);
        map.put(177, (byte)-15);
        map.put(8215, (byte)-14);
        map.put(190, (byte)-13);
        map.put(182, (byte)-12);
        map.put(167, (byte)-11);
        map.put(247, (byte)-10);
        map.put(184, (byte)-9);
        map.put(176, (byte)-8);
        map.put(168, (byte)-7);
        map.put(183, (byte)-6);
        map.put(185, (byte)-5);
        map.put(179, (byte)-4);
        map.put(178, (byte)-3);
        map.put(9632, (byte)-2);
        map.put(160, (byte)-1);
        byte[] realData = new byte[5000];
        try {
            byte[] data = content.getBytes("UNICODE");
            int k = 3;
            realData[0] = 27;
            realData[1] = 116;
            realData[2] = 19;
            for (int i = 2; i < data.length; i += 2) {
                int c = (data[i + 1] & 0xFF) * 256 + (data[i] & 0xFF);
                if (map.get(c) != null) {
                    realData[k] = (Byte)map.get(c);
                    ++k;
                    continue;
                }
                realData[k] = data[i];
                ++k;
            }
            realData[k] = 10;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.mprinter.sendBytesData(realData);
    }

    public int printTextInCP864(String content) {
        HashMap<Integer, Byte> map = new HashMap<Integer, Byte>();
        map.put(176, (byte)-128);
        map.put(183, (byte)-127);
        map.put(8729, (byte)-126);
        map.put(8730, (byte)-125);
        map.put(9618, (byte)-124);
        map.put(9472, (byte)-123);
        map.put(9474, (byte)-122);
        map.put(9532, (byte)-121);
        map.put(9508, (byte)-120);
        map.put(9516, (byte)-119);
        map.put(9500, (byte)-118);
        map.put(9524, (byte)-117);
        map.put(9488, (byte)-116);
        map.put(9484, (byte)-115);
        map.put(9492, (byte)-114);
        map.put(9496, (byte)-113);
        map.put(946, (byte)-112);
        map.put(8734, (byte)-111);
        map.put(966, (byte)-110);
        map.put(177, (byte)-109);
        map.put(189, (byte)-108);
        map.put(188, (byte)-107);
        map.put(8776, (byte)-106);
        map.put(171, (byte)-105);
        map.put(187, (byte)-104);
        map.put(65271, (byte)-103);
        map.put(65272, (byte)-102);
        map.put(65275, (byte)-99);
        map.put(65276, (byte)-98);
        map.put(160, (byte)-96);
        map.put(173, (byte)-95);
        map.put(65154, (byte)-94);
        map.put(163, (byte)-93);
        map.put(164, (byte)-92);
        map.put(65204, (byte)-91);
        map.put(9364, (byte)-89);
        map.put(65166, (byte)-88);
        map.put(65167, (byte)-87);
        map.put(65173, (byte)-86);
        map.put(65177, (byte)-85);
        map.put(1548, (byte)-84);
        map.put(65181, (byte)-83);
        map.put(65185, (byte)-82);
        map.put(65189, (byte)-81);
        map.put(1632, (byte)-80);
        map.put(1633, (byte)-79);
        map.put(1634, (byte)-78);
        map.put(1635, (byte)-77);
        map.put(1636, (byte)-76);
        map.put(1637, (byte)-75);
        map.put(1638, (byte)-74);
        map.put(1639, (byte)-73);
        map.put(1640, (byte)-72);
        map.put(1641, (byte)-71);
        map.put(65233, (byte)-70);
        map.put(1563, (byte)-69);
        map.put(65201, (byte)-68);
        map.put(65205, (byte)-67);
        map.put(65209, (byte)-66);
        map.put(1567, (byte)-65);
        map.put(162, (byte)-64);
        map.put(65152, (byte)-63);
        map.put(65153, (byte)-62);
        map.put(65155, (byte)-61);
        map.put(65157, (byte)-60);
        map.put(65226, (byte)-59);
        map.put(65163, (byte)-58);
        map.put(65165, (byte)-57);
        map.put(65169, (byte)-56);
        map.put(65171, (byte)-55);
        map.put(65175, (byte)-54);
        map.put(65179, (byte)-53);
        map.put(65183, (byte)-52);
        map.put(65187, (byte)-51);
        map.put(65191, (byte)-50);
        map.put(65193, (byte)-49);
        map.put(65195, (byte)-48);
        map.put(65197, (byte)-47);
        map.put(65199, (byte)-46);
        map.put(65203, (byte)-45);
        map.put(65207, (byte)-44);
        map.put(65211, (byte)-43);
        map.put(65215, (byte)-42);
        map.put(65217, (byte)-41);
        map.put(65221, (byte)-40);
        map.put(65227, (byte)-39);
        map.put(65231, (byte)-38);
        map.put(166, (byte)-37);
        map.put(172, (byte)-36);
        map.put(247, (byte)-35);
        map.put(215, (byte)-34);
        map.put(65225, (byte)-33);
        map.put(1600, (byte)-32);
        map.put(65235, (byte)-31);
        map.put(65239, (byte)-30);
        map.put(65243, (byte)-29);
        map.put(65247, (byte)-28);
        map.put(65251, (byte)-27);
        map.put(65255, (byte)-26);
        map.put(65259, (byte)-25);
        map.put(65260, (byte)-24);
        map.put(65261, (byte)-23);
        map.put(65267, (byte)-22);
        map.put(65213, (byte)-21);
        map.put(65228, (byte)-20);
        map.put(65230, (byte)-19);
        map.put(65229, (byte)-18);
        map.put(65249, (byte)-17);
        map.put(65149, (byte)-16);
        map.put(1617, (byte)-15);
        map.put(65253, (byte)-14);
        map.put(65257, (byte)-13);
        map.put(65260, (byte)-12);
        map.put(65264, (byte)-11);
        map.put(65266, (byte)-10);
        map.put(65232, (byte)-9);
        map.put(65237, (byte)-8);
        map.put(65269, (byte)-7);
        map.put(65270, (byte)-6);
        map.put(65245, (byte)-5);
        map.put(65241, (byte)-4);
        map.put(65265, (byte)-3);
        map.put(9632, (byte)-2);
        byte[] realData = new byte[5000];
        try {
            byte[] data = content.getBytes("UNICODE");
            int k = 3;
            realData[0] = 27;
            realData[1] = 116;
            realData[2] = 22;
            for (int i = 2; i < data.length; i += 2) {
                int c = (data[i + 1] & 0xFF) * 256 + (data[i] & 0xFF);
                if (map.get(c) != null) {
                    realData[k] = (Byte)map.get(c);
                    ++k;
                    continue;
                }
                realData[k] = data[i];
                ++k;
            }
            realData[k] = 10;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.mprinter.sendBytesData(realData);
    }

    public int printTextInISO_8859_1(String content) {
        HashMap<Integer, Byte> map = new HashMap<Integer, Byte>();
        map.put(160, (byte)-96);
        map.put(161, (byte)-95);
        map.put(162, (byte)-94);
        map.put(163, (byte)-93);
        map.put(164, (byte)-92);
        map.put(165, (byte)-91);
        map.put(166, (byte)-90);
        map.put(167, (byte)-89);
        map.put(168, (byte)-88);
        map.put(169, (byte)-87);
        map.put(170, (byte)-86);
        map.put(171, (byte)-85);
        map.put(172, (byte)-84);
        map.put(173, (byte)-83);
        map.put(174, (byte)-82);
        map.put(175, (byte)-81);
        map.put(176, (byte)-80);
        map.put(177, (byte)-79);
        map.put(178, (byte)-78);
        map.put(179, (byte)-77);
        map.put(180, (byte)-76);
        map.put(181, (byte)-75);
        map.put(182, (byte)-74);
        map.put(183, (byte)-73);
        map.put(184, (byte)-72);
        map.put(185, (byte)-71);
        map.put(186, (byte)-70);
        map.put(187, (byte)-69);
        map.put(188, (byte)-68);
        map.put(189, (byte)-67);
        map.put(190, (byte)-66);
        map.put(191, (byte)-65);
        map.put(192, (byte)-64);
        map.put(193, (byte)-63);
        map.put(194, (byte)-62);
        map.put(195, (byte)-61);
        map.put(196, (byte)-60);
        map.put(197, (byte)-59);
        map.put(198, (byte)-58);
        map.put(199, (byte)-57);
        map.put(200, (byte)-56);
        map.put(201, (byte)-55);
        map.put(202, (byte)-54);
        map.put(203, (byte)-53);
        map.put(204, (byte)-52);
        map.put(205, (byte)-51);
        map.put(206, (byte)-50);
        map.put(207, (byte)-49);
        map.put(208, (byte)-48);
        map.put(209, (byte)-47);
        map.put(210, (byte)-46);
        map.put(211, (byte)-45);
        map.put(212, (byte)-44);
        map.put(213, (byte)-43);
        map.put(214, (byte)-42);
        map.put(215, (byte)-41);
        map.put(216, (byte)-40);
        map.put(217, (byte)-39);
        map.put(218, (byte)-38);
        map.put(219, (byte)-37);
        map.put(220, (byte)-36);
        map.put(221, (byte)-35);
        map.put(222, (byte)-34);
        map.put(223, (byte)-33);
        map.put(224, (byte)-32);
        map.put(225, (byte)-31);
        map.put(226, (byte)-30);
        map.put(227, (byte)-29);
        map.put(228, (byte)-28);
        map.put(229, (byte)-27);
        map.put(230, (byte)-26);
        map.put(231, (byte)-25);
        map.put(232, (byte)-24);
        map.put(233, (byte)-23);
        map.put(234, (byte)-22);
        map.put(235, (byte)-21);
        map.put(236, (byte)-20);
        map.put(237, (byte)-19);
        map.put(238, (byte)-18);
        map.put(239, (byte)-17);
        map.put(240, (byte)-16);
        map.put(241, (byte)-15);
        map.put(242, (byte)-14);
        map.put(243, (byte)-13);
        map.put(244, (byte)-12);
        map.put(245, (byte)-11);
        map.put(246, (byte)-10);
        map.put(247, (byte)-9);
        map.put(248, (byte)-8);
        map.put(249, (byte)-7);
        map.put(250, (byte)-6);
        map.put(251, (byte)-5);
        map.put(252, (byte)-4);
        map.put(253, (byte)-3);
        map.put(254, (byte)-2);
        map.put(255, (byte)-1);
        byte[] realData = new byte[5000];
        try {
            byte[] data = content.getBytes("UNICODE");
            int k = 3;
            realData[0] = 27;
            realData[1] = 116;
            realData[2] = 23;
            for (int i = 2; i < data.length; i += 2) {
                int c = (data[i + 1] & 0xFF) * 256 + (data[i] & 0xFF);
                if (map.get(c) != null) {
                    realData[k] = (Byte)map.get(c);
                    ++k;
                    continue;
                }
                realData[k] = data[i];
                ++k;
            }
            realData[k] = 10;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.mprinter.sendBytesData(realData);
    }

    public int printTextInCP737(String content) {
        HashMap<Integer, Byte> map = new HashMap<Integer, Byte>();
        map.put(913, (byte)-128);
        map.put(914, (byte)-127);
        map.put(915, (byte)-126);
        map.put(916, (byte)-125);
        map.put(917, (byte)-124);
        map.put(918, (byte)-123);
        map.put(919, (byte)-122);
        map.put(920, (byte)-121);
        map.put(921, (byte)-120);
        map.put(922, (byte)-119);
        map.put(923, (byte)-118);
        map.put(924, (byte)-117);
        map.put(925, (byte)-116);
        map.put(926, (byte)-115);
        map.put(927, (byte)-114);
        map.put(928, (byte)-113);
        map.put(929, (byte)-112);
        map.put(931, (byte)-111);
        map.put(932, (byte)-110);
        map.put(933, (byte)-109);
        map.put(934, (byte)-108);
        map.put(935, (byte)-107);
        map.put(936, (byte)-106);
        map.put(937, (byte)-105);
        map.put(945, (byte)-104);
        map.put(946, (byte)-103);
        map.put(947, (byte)-102);
        map.put(948, (byte)-101);
        map.put(949, (byte)-100);
        map.put(950, (byte)-99);
        map.put(951, (byte)-98);
        map.put(952, (byte)-97);
        map.put(953, (byte)-96);
        map.put(954, (byte)-95);
        map.put(955, (byte)-94);
        map.put(956, (byte)-93);
        map.put(957, (byte)-92);
        map.put(958, (byte)-91);
        map.put(959, (byte)-90);
        map.put(960, (byte)-89);
        map.put(961, (byte)-88);
        map.put(962, (byte)-87);
        map.put(963, (byte)-86);
        map.put(964, (byte)-85);
        map.put(965, (byte)-84);
        map.put(966, (byte)-83);
        map.put(967, (byte)-82);
        map.put(968, (byte)-81);
        map.put(9617, (byte)-80);
        map.put(9618, (byte)-79);
        map.put(9619, (byte)-78);
        map.put(9474, (byte)-77);
        map.put(9508, (byte)-76);
        map.put(9569, (byte)-75);
        map.put(9570, (byte)-74);
        map.put(9558, (byte)-73);
        map.put(9557, (byte)-72);
        map.put(9571, (byte)-71);
        map.put(9553, (byte)-70);
        map.put(9559, (byte)-69);
        map.put(9565, (byte)-68);
        map.put(9564, (byte)-67);
        map.put(9563, (byte)-66);
        map.put(9488, (byte)-65);
        map.put(9492, (byte)-64);
        map.put(9524, (byte)-63);
        map.put(9516, (byte)-62);
        map.put(9500, (byte)-61);
        map.put(9472, (byte)-60);
        map.put(9532, (byte)-59);
        map.put(9566, (byte)-58);
        map.put(9567, (byte)-57);
        map.put(9562, (byte)-56);
        map.put(9556, (byte)-55);
        map.put(9577, (byte)-54);
        map.put(9574, (byte)-53);
        map.put(9568, (byte)-52);
        map.put(9552, (byte)-51);
        map.put(9580, (byte)-50);
        map.put(9575, (byte)-49);
        map.put(9576, (byte)-48);
        map.put(9572, (byte)-47);
        map.put(9573, (byte)-46);
        map.put(9561, (byte)-45);
        map.put(9560, (byte)-44);
        map.put(9554, (byte)-43);
        map.put(9555, (byte)-42);
        map.put(9579, (byte)-41);
        map.put(9578, (byte)-40);
        map.put(9496, (byte)-39);
        map.put(9484, (byte)-38);
        map.put(9608, (byte)-37);
        map.put(9604, (byte)-36);
        map.put(9612, (byte)-35);
        map.put(9616, (byte)-34);
        map.put(9600, (byte)-33);
        map.put(969, (byte)-32);
        map.put(940, (byte)-31);
        map.put(941, (byte)-30);
        map.put(942, (byte)-29);
        map.put(970, (byte)-28);
        map.put(943, (byte)-27);
        map.put(972, (byte)-26);
        map.put(973, (byte)-25);
        map.put(971, (byte)-24);
        map.put(974, (byte)-23);
        map.put(902, (byte)-22);
        map.put(904, (byte)-21);
        map.put(905, (byte)-20);
        map.put(906, (byte)-19);
        map.put(908, (byte)-18);
        map.put(910, (byte)-17);
        map.put(911, (byte)-16);
        map.put(177, (byte)-15);
        map.put(8805, (byte)-14);
        map.put(8804, (byte)-13);
        map.put(938, (byte)-12);
        map.put(939, (byte)-11);
        map.put(247, (byte)-10);
        map.put(8776, (byte)-9);
        map.put(176, (byte)-8);
        map.put(8729, (byte)-7);
        map.put(183, (byte)-6);
        map.put(8730, (byte)-5);
        map.put(8319, (byte)-4);
        map.put(178, (byte)-3);
        map.put(9632, (byte)-2);
        map.put(160, (byte)-1);
        byte[] realData = new byte[5000];
        try {
            byte[] data = content.getBytes("UNICODE");
            int k = 3;
            realData[0] = 27;
            realData[1] = 116;
            realData[2] = 24;
            for (int i = 2; i < data.length; i += 2) {
                int c = (data[i + 1] & 0xFF) * 256 + (data[i] & 0xFF);
                if (map.get(c) != null) {
                    realData[k] = (Byte)map.get(c);
                    ++k;
                    continue;
                }
                realData[k] = data[i];
                ++k;
            }
            realData[k] = 10;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.mprinter.sendBytesData(realData);
    }

    public int printTextInWCP1257(String content) {
        HashMap<Integer, Byte> map = new HashMap<Integer, Byte>();
        map.put(8364, (byte)-128);
        map.put(8218, (byte)-126);
        map.put(8222, (byte)-124);
        map.put(8230, (byte)-123);
        map.put(8224, (byte)-122);
        map.put(8225, (byte)-121);
        map.put(8240, (byte)-119);
        map.put(8249, (byte)-117);
        map.put(168, (byte)-115);
        map.put(711, (byte)-114);
        map.put(184, (byte)-113);
        map.put(8216, (byte)-111);
        map.put(8217, (byte)-110);
        map.put(8220, (byte)-109);
        map.put(8221, (byte)-108);
        map.put(8226, (byte)-107);
        map.put(8211, (byte)-106);
        map.put(8212, (byte)-105);
        map.put(8482, (byte)-103);
        map.put(8250, (byte)-101);
        map.put(175, (byte)-99);
        map.put(731, (byte)-98);
        map.put(160, (byte)-96);
        map.put(162, (byte)-94);
        map.put(163, (byte)-93);
        map.put(164, (byte)-92);
        map.put(166, (byte)-90);
        map.put(167, (byte)-89);
        map.put(216, (byte)-88);
        map.put(169, (byte)-87);
        map.put(342, (byte)-86);
        map.put(171, (byte)-85);
        map.put(172, (byte)-84);
        map.put(173, (byte)-83);
        map.put(174, (byte)-82);
        map.put(198, (byte)-81);
        map.put(176, (byte)-80);
        map.put(177, (byte)-79);
        map.put(178, (byte)-78);
        map.put(179, (byte)-77);
        map.put(180, (byte)-76);
        map.put(181, (byte)-75);
        map.put(182, (byte)-74);
        map.put(183, (byte)-73);
        map.put(248, (byte)-72);
        map.put(185, (byte)-71);
        map.put(343, (byte)-70);
        map.put(187, (byte)-69);
        map.put(188, (byte)-68);
        map.put(189, (byte)-67);
        map.put(190, (byte)-66);
        map.put(230, (byte)-65);
        map.put(260, (byte)-64);
        map.put(302, (byte)-63);
        map.put(256, (byte)-62);
        map.put(262, (byte)-61);
        map.put(196, (byte)-60);
        map.put(197, (byte)-59);
        map.put(280, (byte)-58);
        map.put(274, (byte)-57);
        map.put(268, (byte)-56);
        map.put(201, (byte)-55);
        map.put(377, (byte)-54);
        map.put(278, (byte)-53);
        map.put(290, (byte)-52);
        map.put(310, (byte)-51);
        map.put(298, (byte)-50);
        map.put(315, (byte)-49);
        map.put(352, (byte)-48);
        map.put(323, (byte)-47);
        map.put(325, (byte)-46);
        map.put(211, (byte)-45);
        map.put(332, (byte)-44);
        map.put(213, (byte)-43);
        map.put(214, (byte)-42);
        map.put(215, (byte)-41);
        map.put(370, (byte)-40);
        map.put(321, (byte)-39);
        map.put(346, (byte)-38);
        map.put(362, (byte)-37);
        map.put(220, (byte)-36);
        map.put(379, (byte)-35);
        map.put(381, (byte)-34);
        map.put(223, (byte)-33);
        map.put(261, (byte)-32);
        map.put(303, (byte)-31);
        map.put(257, (byte)-30);
        map.put(263, (byte)-29);
        map.put(228, (byte)-28);
        map.put(229, (byte)-27);
        map.put(281, (byte)-26);
        map.put(275, (byte)-25);
        map.put(269, (byte)-24);
        map.put(233, (byte)-23);
        map.put(378, (byte)-22);
        map.put(279, (byte)-21);
        map.put(291, (byte)-20);
        map.put(311, (byte)-19);
        map.put(299, (byte)-18);
        map.put(316, (byte)-17);
        map.put(353, (byte)-16);
        map.put(324, (byte)-15);
        map.put(326, (byte)-14);
        map.put(243, (byte)-13);
        map.put(333, (byte)-12);
        map.put(245, (byte)-11);
        map.put(246, (byte)-10);
        map.put(247, (byte)-9);
        map.put(371, (byte)-8);
        map.put(322, (byte)-7);
        map.put(347, (byte)-6);
        map.put(363, (byte)-5);
        map.put(252, (byte)-4);
        map.put(380, (byte)-3);
        map.put(382, (byte)-2);
        map.put(729, (byte)-1);
        byte[] realData = new byte[5000];
        try {
            byte[] data = content.getBytes("UNICODE");
            int k = 3;
            realData[0] = 27;
            realData[1] = 116;
            realData[2] = 25;
            for (int i = 2; i < data.length; i += 2) {
                int c = (data[i + 1] & 0xFF) * 256 + (data[i] & 0xFF);
                if (map.get(c) != null) {
                    realData[k] = (Byte)map.get(c);
                    ++k;
                    continue;
                }
                realData[k] = data[i];
                ++k;
            }
            realData[k] = 10;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.mprinter.sendBytesData(realData);
    }

    public int printTextInCP720(String content) {
        HashMap<Integer, Byte> map = new HashMap<Integer, Byte>();
        map.put(233, (byte)-126);
        map.put(226, (byte)-125);
        map.put(224, (byte)-123);
        map.put(231, (byte)-121);
        map.put(234, (byte)-120);
        map.put(235, (byte)-119);
        map.put(232, (byte)-118);
        map.put(239, (byte)-117);
        map.put(238, (byte)-116);
        map.put(1617, (byte)-111);
        map.put(1618, (byte)-110);
        map.put(244, (byte)-109);
        map.put(164, (byte)-108);
        map.put(1600, (byte)-107);
        map.put(251, (byte)-106);
        map.put(249, (byte)-105);
        map.put(1569, (byte)-104);
        map.put(1570, (byte)-103);
        map.put(1571, (byte)-102);
        map.put(1572, (byte)-101);
        map.put(163, (byte)-100);
        map.put(1573, (byte)-99);
        map.put(1574, (byte)-98);
        map.put(1575, (byte)-97);
        map.put(1576, (byte)-96);
        map.put(1577, (byte)-95);
        map.put(1578, (byte)-94);
        map.put(1579, (byte)-93);
        map.put(1580, (byte)-92);
        map.put(1581, (byte)-91);
        map.put(1582, (byte)-90);
        map.put(1583, (byte)-89);
        map.put(1584, (byte)-88);
        map.put(1585, (byte)-87);
        map.put(1586, (byte)-86);
        map.put(1587, (byte)-85);
        map.put(1588, (byte)-84);
        map.put(1589, (byte)-83);
        map.put(171, (byte)-82);
        map.put(187, (byte)-81);
        map.put(9617, (byte)-80);
        map.put(9618, (byte)-79);
        map.put(9619, (byte)-78);
        map.put(9474, (byte)-77);
        map.put(9508, (byte)-76);
        map.put(9569, (byte)-75);
        map.put(9570, (byte)-74);
        map.put(9558, (byte)-73);
        map.put(9557, (byte)-72);
        map.put(9571, (byte)-71);
        map.put(9553, (byte)-70);
        map.put(9557, (byte)-69);
        map.put(9565, (byte)-68);
        map.put(9564, (byte)-67);
        map.put(9563, (byte)-66);
        map.put(9488, (byte)-65);
        map.put(9492, (byte)-64);
        map.put(9524, (byte)-63);
        map.put(9516, (byte)-62);
        map.put(9500, (byte)-61);
        map.put(9472, (byte)-60);
        map.put(9532, (byte)-59);
        map.put(9566, (byte)-58);
        map.put(9567, (byte)-57);
        map.put(9562, (byte)-56);
        map.put(9556, (byte)-55);
        map.put(9577, (byte)-54);
        map.put(9574, (byte)-53);
        map.put(9568, (byte)-52);
        map.put(9552, (byte)-51);
        map.put(9580, (byte)-50);
        map.put(9575, (byte)-49);
        map.put(9576, (byte)-48);
        map.put(9572, (byte)-47);
        map.put(9573, (byte)-46);
        map.put(9561, (byte)-45);
        map.put(9560, (byte)-44);
        map.put(9554, (byte)-43);
        map.put(9555, (byte)-42);
        map.put(9579, (byte)-41);
        map.put(9578, (byte)-40);
        map.put(9496, (byte)-39);
        map.put(9484, (byte)-38);
        map.put(9608, (byte)-37);
        map.put(9604, (byte)-36);
        map.put(9612, (byte)-35);
        map.put(9616, (byte)-34);
        map.put(9600, (byte)-33);
        map.put(1590, (byte)-32);
        map.put(1591, (byte)-31);
        map.put(1592, (byte)-30);
        map.put(1593, (byte)-29);
        map.put(1594, (byte)-28);
        map.put(1601, (byte)-27);
        map.put(181, (byte)-26);
        map.put(1602, (byte)-25);
        map.put(1603, (byte)-24);
        map.put(1604, (byte)-23);
        map.put(1605, (byte)-22);
        map.put(1606, (byte)-21);
        map.put(1607, (byte)-20);
        map.put(1608, (byte)-19);
        map.put(1609, (byte)-18);
        map.put(1610, (byte)-17);
        map.put(8801, (byte)-16);
        map.put(1611, (byte)-15);
        map.put(1612, (byte)-14);
        map.put(1613, (byte)-13);
        map.put(1614, (byte)-12);
        map.put(1615, (byte)-11);
        map.put(1616, (byte)-10);
        map.put(8776, (byte)-9);
        map.put(176, (byte)-8);
        map.put(8729, (byte)-7);
        map.put(183, (byte)-6);
        map.put(8730, (byte)-5);
        map.put(8319, (byte)-4);
        map.put(178, (byte)-3);
        map.put(9632, (byte)-2);
        map.put(160, (byte)-1);
        byte[] realData = new byte[5000];
        try {
            byte[] data = content.getBytes("UNICODE");
            int k = 3;
            realData[0] = 27;
            realData[1] = 116;
            realData[2] = 27;
            for (int i = 2; i < data.length; i += 2) {
                int c = (data[i + 1] & 0xFF) * 256 + (data[i] & 0xFF);
                if (map.get(c) != null) {
                    realData[k] = (Byte)map.get(c);
                    ++k;
                    continue;
                }
                realData[k] = data[i];
                ++k;
            }
            realData[k] = 10;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.mprinter.sendBytesData(realData);
    }

    public int printTextInCP855(String content) {
        HashMap<Integer, Byte> map = new HashMap<Integer, Byte>();
        map.put(1106, (byte)-128);
        map.put(1026, (byte)-127);
        map.put(1107, (byte)-126);
        map.put(1127, (byte)-125);
        map.put(1105, (byte)-124);
        map.put(1125, (byte)-123);
        map.put(1108, (byte)-122);
        map.put(1028, (byte)-121);
        map.put(1109, (byte)-120);
        map.put(1029, (byte)-119);
        map.put(1110, (byte)-118);
        map.put(1030, (byte)-117);
        map.put(1111, (byte)-116);
        map.put(1031, (byte)-115);
        map.put(1112, (byte)-114);
        map.put(1032, (byte)-113);
        map.put(1113, (byte)-112);
        map.put(1033, (byte)-111);
        map.put(1114, (byte)-110);
        map.put(1034, (byte)-109);
        map.put(1115, (byte)-108);
        map.put(1035, (byte)-107);
        map.put(1116, (byte)-106);
        map.put(1036, (byte)-105);
        map.put(1118, (byte)-104);
        map.put(1038, (byte)-103);
        map.put(1119, (byte)-102);
        map.put(1039, (byte)-101);
        map.put(1102, (byte)-100);
        map.put(1070, (byte)-99);
        map.put(1098, (byte)-98);
        map.put(1066, (byte)-97);
        map.put(1072, (byte)-96);
        map.put(1040, (byte)-95);
        map.put(1073, (byte)-94);
        map.put(1041, (byte)-93);
        map.put(1094, (byte)-92);
        map.put(1062, (byte)-91);
        map.put(1076, (byte)-90);
        map.put(1044, (byte)-89);
        map.put(1077, (byte)-88);
        map.put(1045, (byte)-87);
        map.put(1092, (byte)-86);
        map.put(1060, (byte)-85);
        map.put(1075, (byte)-84);
        map.put(1043, (byte)-83);
        map.put(171, (byte)-82);
        map.put(187, (byte)-81);
        map.put(9617, (byte)-80);
        map.put(9618, (byte)-79);
        map.put(9619, (byte)-78);
        map.put(9474, (byte)-77);
        map.put(9508, (byte)-76);
        map.put(1093, (byte)-75);
        map.put(1061, (byte)-74);
        map.put(1080, (byte)-73);
        map.put(1048, (byte)-72);
        map.put(9571, (byte)-71);
        map.put(9553, (byte)-70);
        map.put(9559, (byte)-69);
        map.put(9565, (byte)-68);
        map.put(1081, (byte)-67);
        map.put(1049, (byte)-66);
        map.put(9488, (byte)-65);
        map.put(9492, (byte)-64);
        map.put(9524, (byte)-63);
        map.put(9516, (byte)-62);
        map.put(9500, (byte)-61);
        map.put(9472, (byte)-60);
        map.put(9532, (byte)-59);
        map.put(1082, (byte)-58);
        map.put(1050, (byte)-57);
        map.put(9562, (byte)-56);
        map.put(9556, (byte)-55);
        map.put(9577, (byte)-54);
        map.put(9574, (byte)-53);
        map.put(9568, (byte)-52);
        map.put(9552, (byte)-51);
        map.put(9580, (byte)-50);
        map.put(164, (byte)-49);
        map.put(1083, (byte)-48);
        map.put(1051, (byte)-47);
        map.put(1084, (byte)-46);
        map.put(1052, (byte)-45);
        map.put(1085, (byte)-44);
        map.put(1053, (byte)-43);
        map.put(1086, (byte)-42);
        map.put(1054, (byte)-41);
        map.put(1087, (byte)-40);
        map.put(9496, (byte)-39);
        map.put(9484, (byte)-38);
        map.put(9608, (byte)-37);
        map.put(9604, (byte)-36);
        map.put(1055, (byte)-35);
        map.put(1103, (byte)-34);
        map.put(9600, (byte)-33);
        map.put(1071, (byte)-32);
        map.put(1088, (byte)-31);
        map.put(1056, (byte)-30);
        map.put(1089, (byte)-29);
        map.put(1057, (byte)-28);
        map.put(1090, (byte)-27);
        map.put(1058, (byte)-26);
        map.put(1091, (byte)-25);
        map.put(1059, (byte)-24);
        map.put(1078, (byte)-23);
        map.put(1046, (byte)-22);
        map.put(1074, (byte)-21);
        map.put(1042, (byte)-20);
        map.put(1100, (byte)-19);
        map.put(1068, (byte)-18);
        map.put(9470, (byte)-17);
        map.put(173, (byte)-16);
        map.put(1099, (byte)-15);
        map.put(1067, (byte)-14);
        map.put(1079, (byte)-13);
        map.put(1047, (byte)-12);
        map.put(1096, (byte)-11);
        map.put(1064, (byte)-10);
        map.put(1101, (byte)-9);
        map.put(1069, (byte)-8);
        map.put(1097, (byte)-7);
        map.put(1065, (byte)-6);
        map.put(1095, (byte)-5);
        map.put(1063, (byte)-4);
        map.put(167, (byte)-3);
        map.put(9632, (byte)-2);
        map.put(160, (byte)-1);
        byte[] realData = new byte[5000];
        try {
            byte[] data = content.getBytes("UNICODE");
            int k = 3;
            realData[0] = 27;
            realData[1] = 116;
            realData[2] = 28;
            for (int i = 2; i < data.length; i += 2) {
                int c = (data[i + 1] & 0xFF) * 256 + (data[i] & 0xFF);
                if (map.get(c) != null) {
                    realData[k] = (Byte)map.get(c);
                    ++k;
                    continue;
                }
                realData[k] = data[i];
                ++k;
            }
            realData[k] = 10;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.mprinter.sendBytesData(realData);
    }

    public int printTextInCP857(String content) {
        HashMap<Integer, Byte> map = new HashMap<Integer, Byte>();
        map.put(199, (byte)-128);
        map.put(252, (byte)-127);
        map.put(233, (byte)-126);
        map.put(226, (byte)-125);
        map.put(228, (byte)-124);
        map.put(224, (byte)-123);
        map.put(229, (byte)-122);
        map.put(231, (byte)-121);
        map.put(234, (byte)-120);
        map.put(235, (byte)-119);
        map.put(232, (byte)-118);
        map.put(239, (byte)-117);
        map.put(238, (byte)-116);
        map.put(305, (byte)-115);
        map.put(196, (byte)-114);
        map.put(197, (byte)-113);
        map.put(201, (byte)-112);
        map.put(230, (byte)-111);
        map.put(198, (byte)-110);
        map.put(244, (byte)-109);
        map.put(246, (byte)-108);
        map.put(242, (byte)-107);
        map.put(251, (byte)-106);
        map.put(249, (byte)-105);
        map.put(304, (byte)-104);
        map.put(214, (byte)-103);
        map.put(220, (byte)-102);
        map.put(248, (byte)-101);
        map.put(163, (byte)-100);
        map.put(216, (byte)-99);
        map.put(350, (byte)-98);
        map.put(351, (byte)-97);
        map.put(225, (byte)-96);
        map.put(237, (byte)-95);
        map.put(243, (byte)-94);
        map.put(250, (byte)-93);
        map.put(241, (byte)-92);
        map.put(209, (byte)-91);
        map.put(286, (byte)-90);
        map.put(287, (byte)-89);
        map.put(191, (byte)-88);
        map.put(174, (byte)-87);
        map.put(172, (byte)-86);
        map.put(189, (byte)-85);
        map.put(188, (byte)-84);
        map.put(161, (byte)-83);
        map.put(171, (byte)-82);
        map.put(187, (byte)-81);
        map.put(9617, (byte)-80);
        map.put(9618, (byte)-79);
        map.put(9619, (byte)-78);
        map.put(9474, (byte)-77);
        map.put(9508, (byte)-76);
        map.put(193, (byte)-75);
        map.put(194, (byte)-74);
        map.put(192, (byte)-73);
        map.put(169, (byte)-72);
        map.put(9571, (byte)-71);
        map.put(9553, (byte)-70);
        map.put(9559, (byte)-69);
        map.put(9565, (byte)-68);
        map.put(162, (byte)-67);
        map.put(165, (byte)-66);
        map.put(9488, (byte)-65);
        map.put(9492, (byte)-64);
        map.put(9524, (byte)-63);
        map.put(9516, (byte)-62);
        map.put(9500, (byte)-61);
        map.put(9472, (byte)-60);
        map.put(9532, (byte)-59);
        map.put(227, (byte)-58);
        map.put(195, (byte)-57);
        map.put(9562, (byte)-56);
        map.put(9556, (byte)-55);
        map.put(9577, (byte)-54);
        map.put(9574, (byte)-53);
        map.put(9568, (byte)-52);
        map.put(9552, (byte)-51);
        map.put(9580, (byte)-50);
        map.put(164, (byte)-49);
        map.put(186, (byte)-48);
        map.put(170, (byte)-47);
        map.put(202, (byte)-46);
        map.put(203, (byte)-45);
        map.put(200, (byte)-44);
        map.put(205, (byte)-42);
        map.put(206, (byte)-41);
        map.put(207, (byte)-40);
        map.put(9496, (byte)-39);
        map.put(9484, (byte)-38);
        map.put(9608, (byte)-37);
        map.put(9604, (byte)-36);
        map.put(166, (byte)-35);
        map.put(204, (byte)-34);
        map.put(9600, (byte)-33);
        map.put(211, (byte)-32);
        map.put(223, (byte)-31);
        map.put(212, (byte)-30);
        map.put(210, (byte)-29);
        map.put(245, (byte)-28);
        map.put(213, (byte)-27);
        map.put(181, (byte)-26);
        map.put(215, (byte)-24);
        map.put(218, (byte)-23);
        map.put(219, (byte)-22);
        map.put(217, (byte)-21);
        map.put(236, (byte)-20);
        map.put(255, (byte)-19);
        map.put(175, (byte)-18);
        map.put(180, (byte)-17);
        map.put(173, (byte)-16);
        map.put(177, (byte)-15);
        map.put(190, (byte)-13);
        map.put(182, (byte)-12);
        map.put(167, (byte)-11);
        map.put(247, (byte)-10);
        map.put(184, (byte)-9);
        map.put(176, (byte)-8);
        map.put(168, (byte)-7);
        map.put(183, (byte)-6);
        map.put(185, (byte)-5);
        map.put(179, (byte)-4);
        map.put(178, (byte)-3);
        map.put(9632, (byte)-2);
        map.put(160, (byte)-1);
        byte[] realData = new byte[5000];
        try {
            byte[] data = content.getBytes("UNICODE");
            int k = 3;
            realData[0] = 27;
            realData[1] = 116;
            realData[2] = 29;
            for (int i = 2; i < data.length; i += 2) {
                int c = (data[i + 1] & 0xFF) * 256 + (data[i] & 0xFF);
                if (map.get(c) != null) {
                    realData[k] = (Byte)map.get(c);
                    ++k;
                    continue;
                }
                realData[k] = data[i];
                ++k;
            }
            realData[k] = 10;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.mprinter.sendBytesData(realData);
    }

    public int printTextInWCP1250(String content) {
        HashMap<Integer, Byte> map = new HashMap<Integer, Byte>();
        map.put(8364, (byte)-128);
        map.put(8212, (byte)-126);
        map.put(8222, (byte)-124);
        map.put(8230, (byte)-123);
        map.put(8224, (byte)-122);
        map.put(8225, (byte)-121);
        map.put(8240, (byte)-119);
        map.put(352, (byte)-118);
        map.put(8249, (byte)-117);
        map.put(346, (byte)-116);
        map.put(356, (byte)-115);
        map.put(381, (byte)-114);
        map.put(377, (byte)-113);
        map.put(8216, (byte)-111);
        map.put(8217, (byte)-110);
        map.put(8220, (byte)-109);
        map.put(8221, (byte)-108);
        map.put(8226, (byte)-107);
        map.put(8211, (byte)-106);
        map.put(8212, (byte)-105);
        map.put(9492, (byte)-103);
        map.put(353, (byte)-102);
        map.put(8250, (byte)-101);
        map.put(347, (byte)-100);
        map.put(357, (byte)-99);
        map.put(382, (byte)-98);
        map.put(378, (byte)-97);
        map.put(160, (byte)-96);
        map.put(711, (byte)-95);
        map.put(728, (byte)-94);
        map.put(321, (byte)-93);
        map.put(164, (byte)-92);
        map.put(260, (byte)-91);
        map.put(166, (byte)-90);
        map.put(167, (byte)-89);
        map.put(168, (byte)-88);
        map.put(169, (byte)-87);
        map.put(350, (byte)-86);
        map.put(171, (byte)-85);
        map.put(172, (byte)-84);
        map.put(173, (byte)-83);
        map.put(174, (byte)-82);
        map.put(379, (byte)-81);
        map.put(176, (byte)-80);
        map.put(177, (byte)-79);
        map.put(731, (byte)-78);
        map.put(322, (byte)-77);
        map.put(180, (byte)-76);
        map.put(181, (byte)-75);
        map.put(182, (byte)-74);
        map.put(183, (byte)-73);
        map.put(184, (byte)-72);
        map.put(261, (byte)-71);
        map.put(351, (byte)-70);
        map.put(187, (byte)-69);
        map.put(317, (byte)-68);
        map.put(733, (byte)-67);
        map.put(318, (byte)-66);
        map.put(380, (byte)-65);
        map.put(340, (byte)-64);
        map.put(193, (byte)-63);
        map.put(194, (byte)-62);
        map.put(258, (byte)-61);
        map.put(196, (byte)-60);
        map.put(313, (byte)-59);
        map.put(262, (byte)-58);
        map.put(199, (byte)-57);
        map.put(268, (byte)-56);
        map.put(201, (byte)-55);
        map.put(280, (byte)-54);
        map.put(203, (byte)-53);
        map.put(282, (byte)-52);
        map.put(205, (byte)-51);
        map.put(206, (byte)-50);
        map.put(270, (byte)-49);
        map.put(272, (byte)-48);
        map.put(323, (byte)-47);
        map.put(327, (byte)-46);
        map.put(211, (byte)-45);
        map.put(212, (byte)-44);
        map.put(336, (byte)-43);
        map.put(214, (byte)-42);
        map.put(215, (byte)-41);
        map.put(344, (byte)-40);
        map.put(366, (byte)-39);
        map.put(218, (byte)-38);
        map.put(368, (byte)-37);
        map.put(220, (byte)-36);
        map.put(221, (byte)-35);
        map.put(354, (byte)-34);
        map.put(223, (byte)-33);
        map.put(341, (byte)-32);
        map.put(225, (byte)-31);
        map.put(226, (byte)-30);
        map.put(259, (byte)-29);
        map.put(228, (byte)-28);
        map.put(314, (byte)-27);
        map.put(263, (byte)-26);
        map.put(231, (byte)-25);
        map.put(269, (byte)-24);
        map.put(233, (byte)-23);
        map.put(281, (byte)-22);
        map.put(235, (byte)-21);
        map.put(283, (byte)-20);
        map.put(237, (byte)-19);
        map.put(238, (byte)-18);
        map.put(271, (byte)-17);
        map.put(273, (byte)-16);
        map.put(324, (byte)-15);
        map.put(328, (byte)-14);
        map.put(243, (byte)-13);
        map.put(244, (byte)-12);
        map.put(337, (byte)-11);
        map.put(246, (byte)-10);
        map.put(247, (byte)-9);
        map.put(345, (byte)-8);
        map.put(367, (byte)-7);
        map.put(250, (byte)-6);
        map.put(369, (byte)-5);
        map.put(252, (byte)-4);
        map.put(253, (byte)-3);
        map.put(355, (byte)-2);
        map.put(729, (byte)-1);
        byte[] realData = new byte[5000];
        try {
            byte[] data = content.getBytes("UNICODE");
            int k = 3;
            realData[0] = 27;
            realData[1] = 116;
            realData[2] = 30;
            for (int i = 2; i < data.length; i += 2) {
                int c = (data[i + 1] & 0xFF) * 256 + (data[i] & 0xFF);
                if (map.get(c) != null) {
                    realData[k] = (Byte)map.get(c);
                    ++k;
                    continue;
                }
                realData[k] = data[i];
                ++k;
            }
            realData[k] = 10;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.mprinter.sendBytesData(realData);
    }

    public int printTextInCP775(String content) {
        HashMap<Integer, Byte> map = new HashMap<Integer, Byte>();
        map.put(262, (byte)-128);
        map.put(252, (byte)-127);
        map.put(233, (byte)-126);
        map.put(257, (byte)-125);
        map.put(228, (byte)-124);
        map.put(291, (byte)-123);
        map.put(229, (byte)-122);
        map.put(263, (byte)-121);
        map.put(322, (byte)-120);
        map.put(275, (byte)-119);
        map.put(342, (byte)-118);
        map.put(343, (byte)-117);
        map.put(299, (byte)-116);
        map.put(377, (byte)-115);
        map.put(196, (byte)-114);
        map.put(197, (byte)-113);
        map.put(201, (byte)-112);
        map.put(230, (byte)-111);
        map.put(198, (byte)-110);
        map.put(333, (byte)-109);
        map.put(246, (byte)-108);
        map.put(290, (byte)-107);
        map.put(162, (byte)-106);
        map.put(346, (byte)-105);
        map.put(347, (byte)-104);
        map.put(214, (byte)-103);
        map.put(220, (byte)-102);
        map.put(248, (byte)-101);
        map.put(163, (byte)-100);
        map.put(216, (byte)-99);
        map.put(215, (byte)-98);
        map.put(164, (byte)-97);
        map.put(256, (byte)-96);
        map.put(298, (byte)-95);
        map.put(243, (byte)-94);
        map.put(379, (byte)-93);
        map.put(380, (byte)-92);
        map.put(378, (byte)-91);
        map.put(8221, (byte)-90);
        map.put(166, (byte)-89);
        map.put(169, (byte)-88);
        map.put(174, (byte)-87);
        map.put(172, (byte)-86);
        map.put(189, (byte)-85);
        map.put(188, (byte)-84);
        map.put(321, (byte)-83);
        map.put(171, (byte)-82);
        map.put(187, (byte)-81);
        map.put(9617, (byte)-80);
        map.put(9618, (byte)-79);
        map.put(9619, (byte)-78);
        map.put(9474, (byte)-77);
        map.put(9508, (byte)-76);
        map.put(260, (byte)-75);
        map.put(268, (byte)-74);
        map.put(280, (byte)-73);
        map.put(278, (byte)-72);
        map.put(9571, (byte)-71);
        map.put(9553, (byte)-70);
        map.put(9559, (byte)-69);
        map.put(9565, (byte)-68);
        map.put(302, (byte)-67);
        map.put(352, (byte)-66);
        map.put(9488, (byte)-65);
        map.put(9492, (byte)-64);
        map.put(9524, (byte)-63);
        map.put(9516, (byte)-62);
        map.put(9500, (byte)-61);
        map.put(9472, (byte)-60);
        map.put(9532, (byte)-59);
        map.put(370, (byte)-58);
        map.put(362, (byte)-57);
        map.put(9562, (byte)-56);
        map.put(9556, (byte)-55);
        map.put(9577, (byte)-54);
        map.put(9574, (byte)-53);
        map.put(9568, (byte)-52);
        map.put(9552, (byte)-51);
        map.put(9580, (byte)-50);
        map.put(381, (byte)-49);
        map.put(261, (byte)-48);
        map.put(269, (byte)-47);
        map.put(281, (byte)-46);
        map.put(279, (byte)-45);
        map.put(303, (byte)-44);
        map.put(353, (byte)-43);
        map.put(371, (byte)-42);
        map.put(363, (byte)-41);
        map.put(382, (byte)-40);
        map.put(9496, (byte)-39);
        map.put(9484, (byte)-38);
        map.put(9608, (byte)-37);
        map.put(9604, (byte)-36);
        map.put(9612, (byte)-35);
        map.put(9616, (byte)-34);
        map.put(9600, (byte)-33);
        map.put(211, (byte)-32);
        map.put(223, (byte)-31);
        map.put(332, (byte)-30);
        map.put(323, (byte)-29);
        map.put(245, (byte)-28);
        map.put(213, (byte)-27);
        map.put(181, (byte)-26);
        map.put(324, (byte)-25);
        map.put(310, (byte)-24);
        map.put(311, (byte)-23);
        map.put(315, (byte)-22);
        map.put(316, (byte)-21);
        map.put(326, (byte)-20);
        map.put(274, (byte)-19);
        map.put(325, (byte)-18);
        map.put(8217, (byte)-17);
        map.put(173, (byte)-16);
        map.put(177, (byte)-15);
        map.put(8220, (byte)-14);
        map.put(190, (byte)-13);
        map.put(182, (byte)-12);
        map.put(167, (byte)-11);
        map.put(247, (byte)-10);
        map.put(8222, (byte)-9);
        map.put(176, (byte)-8);
        map.put(8729, (byte)-7);
        map.put(183, (byte)-6);
        map.put(185, (byte)-5);
        map.put(179, (byte)-4);
        map.put(178, (byte)-3);
        map.put(9632, (byte)-2);
        map.put(160, (byte)-1);
        byte[] realData = new byte[5000];
        try {
            byte[] data = content.getBytes("UNICODE");
            int k = 3;
            realData[0] = 27;
            realData[1] = 116;
            realData[2] = 31;
            for (int i = 2; i < data.length; i += 2) {
                int c = (data[i + 1] & 0xFF) * 256 + (data[i] & 0xFF);
                if (map.get(c) != null) {
                    realData[k] = (Byte)map.get(c);
                    ++k;
                    continue;
                }
                realData[k] = data[i];
                ++k;
            }
            realData[k] = 10;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.mprinter.sendBytesData(realData);
    }

    public int printTextInWCP1254(String content) {
        HashMap<Integer, Byte> map = new HashMap<Integer, Byte>();
        map.put(8364, (byte)-128);
        map.put(8218, (byte)-126);
        map.put(402, (byte)-125);
        map.put(8222, (byte)-124);
        map.put(8230, (byte)-123);
        map.put(8224, (byte)-122);
        map.put(8225, (byte)-121);
        map.put(710, (byte)-120);
        map.put(8240, (byte)-119);
        map.put(352, (byte)-118);
        map.put(8249, (byte)-117);
        map.put(338, (byte)-116);
        map.put(8216, (byte)-111);
        map.put(8217, (byte)-110);
        map.put(8220, (byte)-109);
        map.put(8221, (byte)-108);
        map.put(8226, (byte)-107);
        map.put(8211, (byte)-106);
        map.put(8212, (byte)-105);
        map.put(732, (byte)-104);
        map.put(8482, (byte)-103);
        map.put(353, (byte)-102);
        map.put(8250, (byte)-101);
        map.put(339, (byte)-100);
        map.put(376, (byte)-97);
        map.put(160, (byte)-96);
        map.put(161, (byte)-95);
        map.put(162, (byte)-94);
        map.put(163, (byte)-93);
        map.put(164, (byte)-92);
        map.put(165, (byte)-91);
        map.put(166, (byte)-90);
        map.put(167, (byte)-89);
        map.put(168, (byte)-88);
        map.put(169, (byte)-87);
        map.put(170, (byte)-86);
        map.put(171, (byte)-85);
        map.put(172, (byte)-84);
        map.put(173, (byte)-83);
        map.put(174, (byte)-82);
        map.put(175, (byte)-81);
        map.put(176, (byte)-80);
        map.put(177, (byte)-79);
        map.put(178, (byte)-78);
        map.put(179, (byte)-77);
        map.put(180, (byte)-76);
        map.put(181, (byte)-75);
        map.put(182, (byte)-74);
        map.put(183, (byte)-73);
        map.put(184, (byte)-72);
        map.put(185, (byte)-71);
        map.put(186, (byte)-70);
        map.put(187, (byte)-69);
        map.put(188, (byte)-68);
        map.put(189, (byte)-67);
        map.put(190, (byte)-66);
        map.put(191, (byte)-65);
        map.put(192, (byte)-64);
        map.put(193, (byte)-63);
        map.put(194, (byte)-62);
        map.put(195, (byte)-61);
        map.put(196, (byte)-60);
        map.put(197, (byte)-59);
        map.put(198, (byte)-58);
        map.put(199, (byte)-57);
        map.put(200, (byte)-56);
        map.put(201, (byte)-55);
        map.put(202, (byte)-54);
        map.put(203, (byte)-53);
        map.put(204, (byte)-52);
        map.put(205, (byte)-51);
        map.put(206, (byte)-50);
        map.put(207, (byte)-49);
        map.put(286, (byte)-48);
        map.put(209, (byte)-47);
        map.put(210, (byte)-46);
        map.put(211, (byte)-45);
        map.put(212, (byte)-44);
        map.put(213, (byte)-43);
        map.put(214, (byte)-42);
        map.put(215, (byte)-41);
        map.put(216, (byte)-40);
        map.put(217, (byte)-39);
        map.put(218, (byte)-38);
        map.put(219, (byte)-37);
        map.put(220, (byte)-36);
        map.put(304, (byte)-35);
        map.put(350, (byte)-34);
        map.put(223, (byte)-33);
        map.put(224, (byte)-32);
        map.put(225, (byte)-31);
        map.put(226, (byte)-30);
        map.put(227, (byte)-29);
        map.put(228, (byte)-28);
        map.put(229, (byte)-27);
        map.put(230, (byte)-26);
        map.put(231, (byte)-25);
        map.put(232, (byte)-24);
        map.put(233, (byte)-23);
        map.put(234, (byte)-22);
        map.put(235, (byte)-21);
        map.put(236, (byte)-20);
        map.put(237, (byte)-19);
        map.put(238, (byte)-18);
        map.put(239, (byte)-17);
        map.put(187, (byte)-16);
        map.put(241, (byte)-15);
        map.put(242, (byte)-14);
        map.put(243, (byte)-13);
        map.put(244, (byte)-12);
        map.put(245, (byte)-11);
        map.put(246, (byte)-10);
        map.put(247, (byte)-9);
        map.put(248, (byte)-8);
        map.put(249, (byte)-7);
        map.put(250, (byte)-6);
        map.put(251, (byte)-5);
        map.put(252, (byte)-4);
        map.put(305, (byte)-3);
        map.put(351, (byte)-2);
        map.put(255, (byte)-1);
        byte[] realData = new byte[5000];
        try {
            byte[] data = content.getBytes("UNICODE");
            int k = 3;
            realData[0] = 27;
            realData[1] = 116;
            realData[2] = 32;
            for (int i = 2; i < data.length; i += 2) {
                int c = (data[i + 1] & 0xFF) * 256 + (data[i] & 0xFF);
                if (map.get(c) != null) {
                    realData[k] = (Byte)map.get(c);
                    ++k;
                    continue;
                }
                realData[k] = data[i];
                ++k;
            }
            realData[k] = 10;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.mprinter.sendBytesData(realData);
    }

    public int printTextInWCP1255(String content) {
        HashMap<Integer, Byte> map = new HashMap<Integer, Byte>();
        map.put(8364, (byte)-128);
        map.put(8218, (byte)-126);
        map.put(402, (byte)-125);
        map.put(8222, (byte)-124);
        map.put(8230, (byte)-123);
        map.put(8224, (byte)-122);
        map.put(8225, (byte)-121);
        map.put(710, (byte)-120);
        map.put(8240, (byte)-119);
        map.put(8249, (byte)-117);
        map.put(8216, (byte)-111);
        map.put(8217, (byte)-110);
        map.put(8220, (byte)-109);
        map.put(8221, (byte)-108);
        map.put(8226, (byte)-107);
        map.put(8211, (byte)-106);
        map.put(8212, (byte)-105);
        map.put(732, (byte)-104);
        map.put(8482, (byte)-103);
        map.put(8250, (byte)-101);
        map.put(160, (byte)-96);
        map.put(161, (byte)-95);
        map.put(162, (byte)-94);
        map.put(163, (byte)-93);
        map.put(8362, (byte)-92);
        map.put(165, (byte)-91);
        map.put(166, (byte)-90);
        map.put(167, (byte)-89);
        map.put(168, (byte)-88);
        map.put(169, (byte)-87);
        map.put(215, (byte)-86);
        map.put(171, (byte)-85);
        map.put(172, (byte)-84);
        map.put(173, (byte)-83);
        map.put(174, (byte)-82);
        map.put(175, (byte)-81);
        map.put(176, (byte)-80);
        map.put(177, (byte)-79);
        map.put(178, (byte)-78);
        map.put(179, (byte)-77);
        map.put(180, (byte)-76);
        map.put(181, (byte)-75);
        map.put(182, (byte)-74);
        map.put(183, (byte)-73);
        map.put(184, (byte)-72);
        map.put(185, (byte)-71);
        map.put(247, (byte)-70);
        map.put(187, (byte)-69);
        map.put(188, (byte)-68);
        map.put(189, (byte)-67);
        map.put(190, (byte)-66);
        map.put(191, (byte)-65);
        map.put(1456, (byte)-64);
        map.put(1457, (byte)-63);
        map.put(1458, (byte)-62);
        map.put(1459, (byte)-61);
        map.put(1460, (byte)-60);
        map.put(1461, (byte)-59);
        map.put(1462, (byte)-58);
        map.put(1463, (byte)-57);
        map.put(1464, (byte)-56);
        map.put(1465, (byte)-55);
        map.put(1467, (byte)-53);
        map.put(1468, (byte)-52);
        map.put(1469, (byte)-51);
        map.put(1470, (byte)-50);
        map.put(1471, (byte)-49);
        map.put(1472, (byte)-48);
        map.put(1473, (byte)-47);
        map.put(1474, (byte)-46);
        map.put(1475, (byte)-45);
        map.put(1520, (byte)-44);
        map.put(1521, (byte)-43);
        map.put(1522, (byte)-42);
        map.put(1523, (byte)-41);
        map.put(1524, (byte)-40);
        map.put(1488, (byte)-32);
        map.put(1489, (byte)-31);
        map.put(1490, (byte)-30);
        map.put(1491, (byte)-29);
        map.put(1492, (byte)-28);
        map.put(1493, (byte)-27);
        map.put(1494, (byte)-26);
        map.put(1495, (byte)-25);
        map.put(1496, (byte)-24);
        map.put(1497, (byte)-23);
        map.put(1498, (byte)-22);
        map.put(1499, (byte)-21);
        map.put(1500, (byte)-20);
        map.put(1501, (byte)-19);
        map.put(1502, (byte)-18);
        map.put(1503, (byte)-17);
        map.put(1504, (byte)-16);
        map.put(1505, (byte)-15);
        map.put(1506, (byte)-14);
        map.put(1507, (byte)-13);
        map.put(1508, (byte)-12);
        map.put(1509, (byte)-11);
        map.put(1510, (byte)-10);
        map.put(1511, (byte)-9);
        map.put(1512, (byte)-8);
        map.put(1513, (byte)-7);
        map.put(1514, (byte)-6);
        map.put(8206, (byte)-3);
        map.put(8207, (byte)-2);
        byte[] realData = new byte[5000];
        try {
            byte[] data = content.getBytes("UNICODE");
            int k = 3;
            realData[0] = 27;
            realData[1] = 116;
            realData[2] = 33;
            for (int i = 2; i < data.length; i += 2) {
                int c = (data[i + 1] & 0xFF) * 256 + (data[i] & 0xFF);
                if (map.get(c) != null) {
                    realData[k] = (Byte)map.get(c);
                    ++k;
                    continue;
                }
                realData[k] = data[i];
                ++k;
            }
            realData[k] = 10;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.mprinter.sendBytesData(realData);
    }

    public int printTextInWCP1256(String content) {
        HashMap<Integer, Byte> map = new HashMap<Integer, Byte>();
        map.put(8364, (byte)-128);
        map.put(1662, (byte)-127);
        map.put(8218, (byte)-126);
        map.put(402, (byte)-125);
        map.put(8222, (byte)-124);
        map.put(8230, (byte)-123);
        map.put(8224, (byte)-122);
        map.put(8225, (byte)-121);
        map.put(710, (byte)-120);
        map.put(8240, (byte)-119);
        map.put(1657, (byte)-118);
        map.put(8249, (byte)-117);
        map.put(338, (byte)-116);
        map.put(1670, (byte)-115);
        map.put(1688, (byte)-114);
        map.put(1672, (byte)-113);
        map.put(1711, (byte)-112);
        map.put(8216, (byte)-111);
        map.put(8217, (byte)-110);
        map.put(8220, (byte)-109);
        map.put(8221, (byte)-108);
        map.put(8226, (byte)-107);
        map.put(8211, (byte)-106);
        map.put(8212, (byte)-105);
        map.put(1705, (byte)-104);
        map.put(8482, (byte)-103);
        map.put(1681, (byte)-102);
        map.put(8250, (byte)-101);
        map.put(339, (byte)-100);
        map.put(8204, (byte)-99);
        map.put(8205, (byte)-98);
        map.put(1722, (byte)-97);
        map.put(160, (byte)-96);
        map.put(1548, (byte)-95);
        map.put(162, (byte)-94);
        map.put(163, (byte)-93);
        map.put(164, (byte)-92);
        map.put(165, (byte)-91);
        map.put(166, (byte)-90);
        map.put(167, (byte)-89);
        map.put(168, (byte)-88);
        map.put(169, (byte)-87);
        map.put(1726, (byte)-86);
        map.put(171, (byte)-85);
        map.put(172, (byte)-84);
        map.put(173, (byte)-83);
        map.put(174, (byte)-82);
        map.put(175, (byte)-81);
        map.put(176, (byte)-80);
        map.put(177, (byte)-79);
        map.put(178, (byte)-78);
        map.put(179, (byte)-77);
        map.put(180, (byte)-76);
        map.put(181, (byte)-75);
        map.put(182, (byte)-74);
        map.put(183, (byte)-73);
        map.put(184, (byte)-72);
        map.put(185, (byte)-71);
        map.put(1563, (byte)-70);
        map.put(187, (byte)-69);
        map.put(188, (byte)-68);
        map.put(189, (byte)-67);
        map.put(190, (byte)-66);
        map.put(1567, (byte)-65);
        map.put(1729, (byte)-64);
        map.put(1569, (byte)-63);
        map.put(1570, (byte)-62);
        map.put(1571, (byte)-61);
        map.put(1572, (byte)-60);
        map.put(1573, (byte)-59);
        map.put(1574, (byte)-58);
        map.put(1575, (byte)-57);
        map.put(1576, (byte)-56);
        map.put(1577, (byte)-55);
        map.put(1578, (byte)-54);
        map.put(1579, (byte)-53);
        map.put(1580, (byte)-52);
        map.put(1581, (byte)-51);
        map.put(1582, (byte)-50);
        map.put(1583, (byte)-49);
        map.put(1584, (byte)-48);
        map.put(1585, (byte)-47);
        map.put(1586, (byte)-46);
        map.put(1587, (byte)-45);
        map.put(1588, (byte)-44);
        map.put(1589, (byte)-43);
        map.put(1590, (byte)-42);
        map.put(215, (byte)-41);
        map.put(1591, (byte)-40);
        map.put(1592, (byte)-39);
        map.put(1593, (byte)-38);
        map.put(1594, (byte)-37);
        map.put(1600, (byte)-36);
        map.put(1601, (byte)-35);
        map.put(1602, (byte)-34);
        map.put(1603, (byte)-33);
        map.put(224, (byte)-32);
        map.put(1604, (byte)-31);
        map.put(226, (byte)-30);
        map.put(1605, (byte)-29);
        map.put(1606, (byte)-28);
        map.put(1607, (byte)-27);
        map.put(1608, (byte)-26);
        map.put(231, (byte)-25);
        map.put(232, (byte)-24);
        map.put(233, (byte)-23);
        map.put(234, (byte)-22);
        map.put(235, (byte)-21);
        map.put(1609, (byte)-20);
        map.put(1610, (byte)-19);
        map.put(238, (byte)-18);
        map.put(239, (byte)-17);
        map.put(1611, (byte)-16);
        map.put(1612, (byte)-15);
        map.put(1613, (byte)-14);
        map.put(1614, (byte)-13);
        map.put(244, (byte)-12);
        map.put(1615, (byte)-11);
        map.put(1616, (byte)-10);
        map.put(247, (byte)-9);
        map.put(1617, (byte)-8);
        map.put(249, (byte)-7);
        map.put(1618, (byte)-6);
        map.put(251, (byte)-5);
        map.put(252, (byte)-4);
        map.put(8206, (byte)-3);
        map.put(8207, (byte)-2);
        map.put(1746, (byte)-1);
        byte[] realData = new byte[5000];
        try {
            byte[] data = content.getBytes("UNICODE");
            int k = 3;
            realData[0] = 27;
            realData[1] = 116;
            realData[2] = 34;
            for (int i = 2; i < data.length; i += 2) {
                int c = (data[i + 1] & 0xFF) * 256 + (data[i] & 0xFF);
                if (map.get(c) != null) {
                    realData[k] = (Byte)map.get(c);
                    ++k;
                    continue;
                }
                realData[k] = data[i];
                ++k;
            }
            realData[k] = 10;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.mprinter.sendBytesData(realData);
    }

    public int printTextInWCP1258(String content) {
        HashMap<Integer, Byte> map = new HashMap<Integer, Byte>();
        map.put(8364, (byte)-128);
        map.put(8218, (byte)-126);
        map.put(402, (byte)-125);
        map.put(8222, (byte)-124);
        map.put(8230, (byte)-123);
        map.put(8224, (byte)-122);
        map.put(8225, (byte)-121);
        map.put(710, (byte)-120);
        map.put(8240, (byte)-119);
        map.put(8249, (byte)-117);
        map.put(338, (byte)-116);
        map.put(8216, (byte)-111);
        map.put(8217, (byte)-110);
        map.put(8220, (byte)-109);
        map.put(8221, (byte)-108);
        map.put(8226, (byte)-107);
        map.put(8211, (byte)-106);
        map.put(8212, (byte)-105);
        map.put(732, (byte)-104);
        map.put(8482, (byte)-103);
        map.put(8250, (byte)-101);
        map.put(339, (byte)-100);
        map.put(376, (byte)-97);
        map.put(160, (byte)-96);
        map.put(161, (byte)-95);
        map.put(162, (byte)-94);
        map.put(163, (byte)-93);
        map.put(164, (byte)-92);
        map.put(165, (byte)-91);
        map.put(166, (byte)-90);
        map.put(167, (byte)-89);
        map.put(168, (byte)-88);
        map.put(169, (byte)-87);
        map.put(170, (byte)-86);
        map.put(171, (byte)-85);
        map.put(172, (byte)-84);
        map.put(173, (byte)-83);
        map.put(174, (byte)-82);
        map.put(175, (byte)-81);
        map.put(176, (byte)-80);
        map.put(177, (byte)-79);
        map.put(178, (byte)-78);
        map.put(179, (byte)-77);
        map.put(180, (byte)-76);
        map.put(181, (byte)-75);
        map.put(182, (byte)-74);
        map.put(183, (byte)-73);
        map.put(184, (byte)-72);
        map.put(185, (byte)-71);
        map.put(186, (byte)-70);
        map.put(187, (byte)-69);
        map.put(188, (byte)-68);
        map.put(189, (byte)-67);
        map.put(190, (byte)-66);
        map.put(191, (byte)-65);
        map.put(192, (byte)-64);
        map.put(193, (byte)-63);
        map.put(194, (byte)-62);
        map.put(195, (byte)-61);
        map.put(196, (byte)-60);
        map.put(197, (byte)-59);
        map.put(198, (byte)-58);
        map.put(199, (byte)-57);
        map.put(200, (byte)-56);
        map.put(201, (byte)-55);
        map.put(202, (byte)-54);
        map.put(203, (byte)-53);
        map.put(768, (byte)-52);
        map.put(205, (byte)-51);
        map.put(206, (byte)-50);
        map.put(207, (byte)-49);
        map.put(272, (byte)-48);
        map.put(209, (byte)-47);
        map.put(777, (byte)-46);
        map.put(211, (byte)-45);
        map.put(212, (byte)-44);
        map.put(416, (byte)-43);
        map.put(214, (byte)-42);
        map.put(215, (byte)-41);
        map.put(216, (byte)-40);
        map.put(217, (byte)-39);
        map.put(218, (byte)-38);
        map.put(219, (byte)-37);
        map.put(220, (byte)-36);
        map.put(431, (byte)-35);
        map.put(771, (byte)-34);
        map.put(223, (byte)-33);
        map.put(224, (byte)-32);
        map.put(225, (byte)-31);
        map.put(226, (byte)-30);
        map.put(259, (byte)-29);
        map.put(228, (byte)-28);
        map.put(229, (byte)-27);
        map.put(230, (byte)-26);
        map.put(231, (byte)-25);
        map.put(232, (byte)-24);
        map.put(233, (byte)-23);
        map.put(234, (byte)-22);
        map.put(235, (byte)-21);
        map.put(769, (byte)-20);
        map.put(237, (byte)-19);
        map.put(238, (byte)-18);
        map.put(239, (byte)-17);
        map.put(273, (byte)-16);
        map.put(241, (byte)-15);
        map.put(803, (byte)-14);
        map.put(243, (byte)-13);
        map.put(244, (byte)-12);
        map.put(417, (byte)-11);
        map.put(246, (byte)-10);
        map.put(247, (byte)-9);
        map.put(248, (byte)-8);
        map.put(249, (byte)-7);
        map.put(250, (byte)-6);
        map.put(251, (byte)-5);
        map.put(252, (byte)-4);
        map.put(432, (byte)-3);
        map.put(8363, (byte)-2);
        map.put(255, (byte)-1);
        byte[] realData = new byte[5000];
        try {
            byte[] data = content.getBytes("UNICODE");
            int k = 3;
            realData[0] = 27;
            realData[1] = 116;
            realData[2] = 35;
            for (int i = 2; i < data.length; i += 2) {
                int c = (data[i + 1] & 0xFF) * 256 + (data[i] & 0xFF);
                if (map.get(c) != null) {
                    realData[k] = (Byte)map.get(c);
                    ++k;
                    continue;
                }
                realData[k] = data[i];
                ++k;
            }
            realData[k] = 10;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.mprinter.sendBytesData(realData);
    }

    public int printTextInISO_8859_2(String content) {
        HashMap<Integer, Byte> map = new HashMap<Integer, Byte>();
        map.put(160, (byte)-96);
        map.put(260, (byte)-95);
        map.put(728, (byte)-94);
        map.put(321, (byte)-93);
        map.put(164, (byte)-92);
        map.put(317, (byte)-91);
        map.put(346, (byte)-90);
        map.put(167, (byte)-89);
        map.put(168, (byte)-88);
        map.put(352, (byte)-87);
        map.put(350, (byte)-86);
        map.put(356, (byte)-85);
        map.put(377, (byte)-84);
        map.put(173, (byte)-83);
        map.put(381, (byte)-82);
        map.put(379, (byte)-81);
        map.put(176, (byte)-80);
        map.put(261, (byte)-79);
        map.put(731, (byte)-78);
        map.put(322, (byte)-77);
        map.put(180, (byte)-76);
        map.put(318, (byte)-75);
        map.put(347, (byte)-74);
        map.put(711, (byte)-73);
        map.put(184, (byte)-72);
        map.put(353, (byte)-71);
        map.put(351, (byte)-70);
        map.put(357, (byte)-69);
        map.put(378, (byte)-68);
        map.put(733, (byte)-67);
        map.put(382, (byte)-66);
        map.put(380, (byte)-65);
        map.put(340, (byte)-64);
        map.put(193, (byte)-63);
        map.put(194, (byte)-62);
        map.put(258, (byte)-61);
        map.put(196, (byte)-60);
        map.put(313, (byte)-59);
        map.put(262, (byte)-58);
        map.put(199, (byte)-57);
        map.put(268, (byte)-56);
        map.put(201, (byte)-55);
        map.put(280, (byte)-54);
        map.put(203, (byte)-53);
        map.put(282, (byte)-52);
        map.put(205, (byte)-51);
        map.put(206, (byte)-50);
        map.put(270, (byte)-49);
        map.put(272, (byte)-48);
        map.put(323, (byte)-47);
        map.put(327, (byte)-46);
        map.put(211, (byte)-45);
        map.put(212, (byte)-44);
        map.put(336, (byte)-43);
        map.put(214, (byte)-42);
        map.put(215, (byte)-41);
        map.put(344, (byte)-40);
        map.put(366, (byte)-39);
        map.put(218, (byte)-38);
        map.put(368, (byte)-37);
        map.put(220, (byte)-36);
        map.put(221, (byte)-35);
        map.put(354, (byte)-34);
        map.put(223, (byte)-33);
        map.put(341, (byte)-32);
        map.put(225, (byte)-31);
        map.put(226, (byte)-30);
        map.put(259, (byte)-29);
        map.put(228, (byte)-28);
        map.put(314, (byte)-27);
        map.put(263, (byte)-26);
        map.put(231, (byte)-25);
        map.put(269, (byte)-24);
        map.put(233, (byte)-23);
        map.put(281, (byte)-22);
        map.put(235, (byte)-21);
        map.put(283, (byte)-20);
        map.put(237, (byte)-19);
        map.put(238, (byte)-18);
        map.put(271, (byte)-17);
        map.put(273, (byte)-16);
        map.put(324, (byte)-15);
        map.put(328, (byte)-14);
        map.put(243, (byte)-13);
        map.put(244, (byte)-12);
        map.put(337, (byte)-11);
        map.put(246, (byte)-10);
        map.put(247, (byte)-9);
        map.put(345, (byte)-8);
        map.put(367, (byte)-7);
        map.put(250, (byte)-6);
        map.put(369, (byte)-5);
        map.put(252, (byte)-4);
        map.put(253, (byte)-3);
        map.put(355, (byte)-2);
        map.put(729, (byte)-1);
        byte[] realData = new byte[5000];
        try {
            byte[] data = content.getBytes("UNICODE");
            int k = 3;
            realData[0] = 27;
            realData[1] = 116;
            realData[2] = 36;
            for (int i = 2; i < data.length; i += 2) {
                int c = (data[i + 1] & 0xFF) * 256 + (data[i] & 0xFF);
                if (map.get(c) != null) {
                    realData[k] = (Byte)map.get(c);
                    ++k;
                    continue;
                }
                realData[k] = data[i];
                ++k;
            }
            realData[k] = 10;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.mprinter.sendBytesData(realData);
    }

    public int printTextInISO_8859_3(String content) {
        HashMap<Integer, Byte> map = new HashMap<Integer, Byte>();
        map.put(160, (byte)-96);
        map.put(294, (byte)-95);
        map.put(728, (byte)-94);
        map.put(163, (byte)-93);
        map.put(164, (byte)-92);
        map.put(292, (byte)-90);
        map.put(167, (byte)-89);
        map.put(168, (byte)-88);
        map.put(304, (byte)-87);
        map.put(350, (byte)-86);
        map.put(286, (byte)-85);
        map.put(308, (byte)-84);
        map.put(173, (byte)-83);
        map.put(379, (byte)-81);
        map.put(176, (byte)-80);
        map.put(295, (byte)-79);
        map.put(178, (byte)-78);
        map.put(179, (byte)-77);
        map.put(180, (byte)-76);
        map.put(181, (byte)-75);
        map.put(293, (byte)-74);
        map.put(183, (byte)-73);
        map.put(184, (byte)-72);
        map.put(305, (byte)-71);
        map.put(351, (byte)-70);
        map.put(287, (byte)-69);
        map.put(309, (byte)-68);
        map.put(189, (byte)-67);
        map.put(380, (byte)-65);
        map.put(192, (byte)-64);
        map.put(193, (byte)-63);
        map.put(194, (byte)-62);
        map.put(196, (byte)-60);
        map.put(266, (byte)-59);
        map.put(264, (byte)-58);
        map.put(199, (byte)-57);
        map.put(200, (byte)-56);
        map.put(201, (byte)-55);
        map.put(202, (byte)-54);
        map.put(203, (byte)-53);
        map.put(204, (byte)-52);
        map.put(205, (byte)-51);
        map.put(206, (byte)-50);
        map.put(207, (byte)-49);
        map.put(209, (byte)-47);
        map.put(210, (byte)-46);
        map.put(211, (byte)-45);
        map.put(212, (byte)-44);
        map.put(288, (byte)-43);
        map.put(214, (byte)-42);
        map.put(215, (byte)-41);
        map.put(284, (byte)-40);
        map.put(217, (byte)-39);
        map.put(218, (byte)-38);
        map.put(219, (byte)-37);
        map.put(220, (byte)-36);
        map.put(364, (byte)-35);
        map.put(348, (byte)-34);
        map.put(223, (byte)-33);
        map.put(224, (byte)-32);
        map.put(225, (byte)-31);
        map.put(226, (byte)-30);
        map.put(228, (byte)-28);
        map.put(267, (byte)-27);
        map.put(265, (byte)-26);
        map.put(231, (byte)-25);
        map.put(232, (byte)-24);
        map.put(233, (byte)-23);
        map.put(234, (byte)-22);
        map.put(235, (byte)-21);
        map.put(236, (byte)-20);
        map.put(237, (byte)-19);
        map.put(238, (byte)-18);
        map.put(239, (byte)-17);
        map.put(241, (byte)-15);
        map.put(242, (byte)-14);
        map.put(243, (byte)-13);
        map.put(244, (byte)-12);
        map.put(289, (byte)-11);
        map.put(246, (byte)-10);
        map.put(247, (byte)-9);
        map.put(285, (byte)-8);
        map.put(249, (byte)-7);
        map.put(250, (byte)-6);
        map.put(251, (byte)-5);
        map.put(252, (byte)-4);
        map.put(365, (byte)-3);
        map.put(349, (byte)-2);
        map.put(729, (byte)-1);
        byte[] realData = new byte[5000];
        try {
            byte[] data = content.getBytes("UNICODE");
            int k = 3;
            realData[0] = 27;
            realData[1] = 116;
            realData[2] = 37;
            for (int i = 2; i < data.length; i += 2) {
                int c = (data[i + 1] & 0xFF) * 256 + (data[i] & 0xFF);
                if (map.get(c) != null) {
                    realData[k] = (Byte)map.get(c);
                    ++k;
                    continue;
                }
                realData[k] = data[i];
                ++k;
            }
            realData[k] = 10;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.mprinter.sendBytesData(realData);
    }

    public int printTextInISO_8859_4(String content) {
        HashMap<Integer, Byte> map = new HashMap<Integer, Byte>();
        map.put(160, (byte)-96);
        map.put(260, (byte)-95);
        map.put(312, (byte)-94);
        map.put(342, (byte)-93);
        map.put(164, (byte)-92);
        map.put(296, (byte)-91);
        map.put(315, (byte)-90);
        map.put(167, (byte)-89);
        map.put(168, (byte)-88);
        map.put(352, (byte)-87);
        map.put(274, (byte)-86);
        map.put(290, (byte)-85);
        map.put(358, (byte)-84);
        map.put(173, (byte)-83);
        map.put(381, (byte)-82);
        map.put(175, (byte)-81);
        map.put(176, (byte)-80);
        map.put(261, (byte)-79);
        map.put(731, (byte)-78);
        map.put(343, (byte)-77);
        map.put(180, (byte)-76);
        map.put(297, (byte)-75);
        map.put(316, (byte)-74);
        map.put(711, (byte)-73);
        map.put(184, (byte)-72);
        map.put(353, (byte)-71);
        map.put(275, (byte)-70);
        map.put(291, (byte)-69);
        map.put(359, (byte)-68);
        map.put(330, (byte)-67);
        map.put(382, (byte)-66);
        map.put(331, (byte)-65);
        map.put(256, (byte)-64);
        map.put(193, (byte)-63);
        map.put(194, (byte)-62);
        map.put(195, (byte)-61);
        map.put(196, (byte)-60);
        map.put(197, (byte)-59);
        map.put(198, (byte)-58);
        map.put(302, (byte)-57);
        map.put(268, (byte)-56);
        map.put(201, (byte)-55);
        map.put(280, (byte)-54);
        map.put(203, (byte)-53);
        map.put(278, (byte)-52);
        map.put(205, (byte)-51);
        map.put(206, (byte)-50);
        map.put(298, (byte)-49);
        map.put(272, (byte)-48);
        map.put(325, (byte)-47);
        map.put(332, (byte)-46);
        map.put(310, (byte)-45);
        map.put(212, (byte)-44);
        map.put(213, (byte)-43);
        map.put(214, (byte)-42);
        map.put(215, (byte)-41);
        map.put(216, (byte)-40);
        map.put(370, (byte)-39);
        map.put(218, (byte)-38);
        map.put(219, (byte)-37);
        map.put(220, (byte)-36);
        map.put(360, (byte)-35);
        map.put(362, (byte)-34);
        map.put(223, (byte)-33);
        map.put(257, (byte)-32);
        map.put(225, (byte)-31);
        map.put(226, (byte)-30);
        map.put(227, (byte)-29);
        map.put(228, (byte)-28);
        map.put(229, (byte)-27);
        map.put(230, (byte)-26);
        map.put(303, (byte)-25);
        map.put(269, (byte)-24);
        map.put(233, (byte)-23);
        map.put(281, (byte)-22);
        map.put(235, (byte)-21);
        map.put(279, (byte)-20);
        map.put(237, (byte)-19);
        map.put(238, (byte)-18);
        map.put(299, (byte)-17);
        map.put(273, (byte)-16);
        map.put(326, (byte)-15);
        map.put(333, (byte)-14);
        map.put(311, (byte)-13);
        map.put(244, (byte)-12);
        map.put(245, (byte)-11);
        map.put(246, (byte)-10);
        map.put(247, (byte)-9);
        map.put(248, (byte)-8);
        map.put(371, (byte)-7);
        map.put(250, (byte)-6);
        map.put(251, (byte)-5);
        map.put(252, (byte)-4);
        map.put(361, (byte)-3);
        map.put(363, (byte)-2);
        map.put(729, (byte)-1);
        byte[] realData = new byte[5000];
        try {
            byte[] data = content.getBytes("UNICODE");
            int k = 3;
            realData[0] = 27;
            realData[1] = 116;
            realData[2] = 38;
            for (int i = 2; i < data.length; i += 2) {
                int c = (data[i + 1] & 0xFF) * 256 + (data[i] & 0xFF);
                if (map.get(c) != null) {
                    realData[k] = (Byte)map.get(c);
                    ++k;
                    continue;
                }
                realData[k] = data[i];
                ++k;
            }
            realData[k] = 10;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.mprinter.sendBytesData(realData);
    }

    public int printTextInISO_8859_5(String content) {
        HashMap<Integer, Byte> map = new HashMap<Integer, Byte>();
        map.put(160, (byte)-96);
        map.put(1025, (byte)-95);
        map.put(1026, (byte)-94);
        map.put(1027, (byte)-93);
        map.put(1028, (byte)-92);
        map.put(1029, (byte)-91);
        map.put(1030, (byte)-90);
        map.put(1031, (byte)-89);
        map.put(1032, (byte)-88);
        map.put(1033, (byte)-87);
        map.put(1034, (byte)-86);
        map.put(1035, (byte)-85);
        map.put(1036, (byte)-84);
        map.put(1037, (byte)-83);
        map.put(1038, (byte)-82);
        map.put(1039, (byte)-81);
        map.put(1040, (byte)-80);
        map.put(1041, (byte)-79);
        map.put(1042, (byte)-78);
        map.put(1043, (byte)-77);
        map.put(1044, (byte)-76);
        map.put(1045, (byte)-75);
        map.put(1046, (byte)-74);
        map.put(1047, (byte)-73);
        map.put(1048, (byte)-72);
        map.put(1049, (byte)-71);
        map.put(1050, (byte)-70);
        map.put(1051, (byte)-69);
        map.put(1052, (byte)-68);
        map.put(1053, (byte)-67);
        map.put(1054, (byte)-66);
        map.put(1055, (byte)-65);
        map.put(1056, (byte)-64);
        map.put(1057, (byte)-63);
        map.put(1058, (byte)-62);
        map.put(1059, (byte)-61);
        map.put(1060, (byte)-60);
        map.put(1061, (byte)-59);
        map.put(1062, (byte)-58);
        map.put(1063, (byte)-57);
        map.put(1064, (byte)-56);
        map.put(1065, (byte)-55);
        map.put(1066, (byte)-54);
        map.put(1067, (byte)-53);
        map.put(1068, (byte)-52);
        map.put(1069, (byte)-51);
        map.put(1070, (byte)-50);
        map.put(1071, (byte)-49);
        map.put(1072, (byte)-48);
        map.put(1073, (byte)-47);
        map.put(1074, (byte)-46);
        map.put(1075, (byte)-45);
        map.put(1076, (byte)-44);
        map.put(1077, (byte)-43);
        map.put(1078, (byte)-42);
        map.put(1079, (byte)-41);
        map.put(1080, (byte)-40);
        map.put(1081, (byte)-39);
        map.put(1082, (byte)-38);
        map.put(1083, (byte)-37);
        map.put(1084, (byte)-36);
        map.put(1085, (byte)-35);
        map.put(1086, (byte)-34);
        map.put(1087, (byte)-33);
        map.put(1088, (byte)-32);
        map.put(1089, (byte)-31);
        map.put(1090, (byte)-30);
        map.put(1091, (byte)-29);
        map.put(1092, (byte)-28);
        map.put(1093, (byte)-27);
        map.put(1094, (byte)-26);
        map.put(1095, (byte)-25);
        map.put(1096, (byte)-24);
        map.put(1097, (byte)-23);
        map.put(1098, (byte)-22);
        map.put(1099, (byte)-21);
        map.put(1100, (byte)-20);
        map.put(1101, (byte)-19);
        map.put(1102, (byte)-18);
        map.put(1103, (byte)-17);
        map.put(8470, (byte)-16);
        map.put(1105, (byte)-15);
        map.put(1106, (byte)-14);
        map.put(1107, (byte)-13);
        map.put(1108, (byte)-12);
        map.put(1109, (byte)-11);
        map.put(1110, (byte)-10);
        map.put(1111, (byte)-9);
        map.put(1112, (byte)-8);
        map.put(1113, (byte)-7);
        map.put(1114, (byte)-6);
        map.put(1115, (byte)-5);
        map.put(1116, (byte)-4);
        map.put(1117, (byte)-3);
        map.put(1118, (byte)-2);
        map.put(1119, (byte)-1);
        byte[] realData = new byte[5000];
        try {
            byte[] data = content.getBytes("UNICODE");
            int k = 3;
            realData[0] = 27;
            realData[1] = 116;
            realData[2] = 39;
            for (int i = 2; i < data.length; i += 2) {
                int c = (data[i + 1] & 0xFF) * 256 + (data[i] & 0xFF);
                if (map.get(c) != null) {
                    realData[k] = (Byte)map.get(c);
                    ++k;
                    continue;
                }
                realData[k] = data[i];
                ++k;
            }
            realData[k] = 10;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.mprinter.sendBytesData(realData);
    }

    public int printTextInISO_8859_6(String content) {
        HashMap<Integer, Byte> map = new HashMap<Integer, Byte>();
        map.put(160, (byte)-96);
        map.put(164, (byte)-92);
        map.put(1548, (byte)-84);
        map.put(173, (byte)-83);
        map.put(1563, (byte)-69);
        map.put(1567, (byte)-65);
        map.put(1569, (byte)-63);
        map.put(1570, (byte)-62);
        map.put(1571, (byte)-61);
        map.put(1572, (byte)-60);
        map.put(1573, (byte)-59);
        map.put(1574, (byte)-58);
        map.put(1575, (byte)-57);
        map.put(1576, (byte)-56);
        map.put(1577, (byte)-55);
        map.put(1578, (byte)-54);
        map.put(1579, (byte)-53);
        map.put(1580, (byte)-52);
        map.put(1581, (byte)-51);
        map.put(1582, (byte)-50);
        map.put(1583, (byte)-49);
        map.put(1584, (byte)-48);
        map.put(1585, (byte)-47);
        map.put(1586, (byte)-46);
        map.put(1587, (byte)-45);
        map.put(1588, (byte)-44);
        map.put(1589, (byte)-43);
        map.put(1590, (byte)-42);
        map.put(1591, (byte)-41);
        map.put(1592, (byte)-40);
        map.put(1593, (byte)-39);
        map.put(1594, (byte)-38);
        map.put(1600, (byte)-32);
        map.put(1601, (byte)-31);
        map.put(1602, (byte)-30);
        map.put(1603, (byte)-29);
        map.put(1604, (byte)-28);
        map.put(1605, (byte)-27);
        map.put(1606, (byte)-26);
        map.put(1607, (byte)-25);
        map.put(1608, (byte)-24);
        map.put(1609, (byte)-23);
        map.put(1610, (byte)-22);
        map.put(1611, (byte)-21);
        map.put(1612, (byte)-20);
        map.put(1613, (byte)-19);
        map.put(1614, (byte)-18);
        map.put(1615, (byte)-17);
        map.put(1616, (byte)-16);
        map.put(1617, (byte)-15);
        map.put(1618, (byte)-14);
        byte[] realData = new byte[5000];
        try {
            byte[] data = content.getBytes("UNICODE");
            int k = 3;
            realData[0] = 27;
            realData[1] = 116;
            realData[2] = 40;
            for (int i = 2; i < data.length; i += 2) {
                int c = (data[i + 1] & 0xFF) * 256 + (data[i] & 0xFF);
                if (map.get(c) != null) {
                    realData[k] = (Byte)map.get(c);
                    ++k;
                    continue;
                }
                realData[k] = data[i];
                ++k;
            }
            realData[k] = 10;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.mprinter.sendBytesData(realData);
    }

    public int printTextInISO_8859_7(String content) {
        HashMap<Integer, Byte> map = new HashMap<Integer, Byte>();
        map.put(160, (byte)-96);
        map.put(8216, (byte)-95);
        map.put(8217, (byte)-94);
        map.put(163, (byte)-93);
        map.put(8364, (byte)-92);
        map.put(8367, (byte)-91);
        map.put(166, (byte)-90);
        map.put(167, (byte)-89);
        map.put(168, (byte)-88);
        map.put(169, (byte)-87);
        map.put(890, (byte)-86);
        map.put(171, (byte)-85);
        map.put(172, (byte)-84);
        map.put(173, (byte)-83);
        map.put(8213, (byte)-81);
        map.put(176, (byte)-80);
        map.put(177, (byte)-79);
        map.put(178, (byte)-78);
        map.put(179, (byte)-77);
        map.put(900, (byte)-76);
        map.put(901, (byte)-75);
        map.put(902, (byte)-74);
        map.put(183, (byte)-73);
        map.put(904, (byte)-72);
        map.put(905, (byte)-71);
        map.put(906, (byte)-70);
        map.put(187, (byte)-69);
        map.put(908, (byte)-68);
        map.put(189, (byte)-67);
        map.put(910, (byte)-66);
        map.put(911, (byte)-65);
        map.put(912, (byte)-64);
        map.put(913, (byte)-63);
        map.put(914, (byte)-62);
        map.put(915, (byte)-61);
        map.put(916, (byte)-60);
        map.put(917, (byte)-59);
        map.put(918, (byte)-58);
        map.put(919, (byte)-57);
        map.put(920, (byte)-56);
        map.put(921, (byte)-55);
        map.put(922, (byte)-54);
        map.put(923, (byte)-53);
        map.put(924, (byte)-52);
        map.put(925, (byte)-51);
        map.put(926, (byte)-50);
        map.put(927, (byte)-49);
        map.put(928, (byte)-48);
        map.put(929, (byte)-47);
        map.put(931, (byte)-45);
        map.put(932, (byte)-44);
        map.put(933, (byte)-43);
        map.put(934, (byte)-42);
        map.put(935, (byte)-41);
        map.put(936, (byte)-40);
        map.put(937, (byte)-39);
        map.put(938, (byte)-38);
        map.put(939, (byte)-37);
        map.put(940, (byte)-36);
        map.put(941, (byte)-35);
        map.put(942, (byte)-34);
        map.put(943, (byte)-33);
        map.put(944, (byte)-32);
        map.put(945, (byte)-31);
        map.put(946, (byte)-30);
        map.put(947, (byte)-29);
        map.put(948, (byte)-28);
        map.put(949, (byte)-27);
        map.put(950, (byte)-26);
        map.put(951, (byte)-25);
        map.put(952, (byte)-24);
        map.put(953, (byte)-23);
        map.put(954, (byte)-22);
        map.put(955, (byte)-21);
        map.put(956, (byte)-20);
        map.put(957, (byte)-19);
        map.put(958, (byte)-18);
        map.put(959, (byte)-17);
        map.put(960, (byte)-16);
        map.put(961, (byte)-15);
        map.put(962, (byte)-14);
        map.put(963, (byte)-13);
        map.put(964, (byte)-12);
        map.put(965, (byte)-11);
        map.put(966, (byte)-10);
        map.put(967, (byte)-9);
        map.put(968, (byte)-8);
        map.put(969, (byte)-7);
        map.put(970, (byte)-6);
        map.put(971, (byte)-5);
        map.put(972, (byte)-4);
        map.put(973, (byte)-3);
        map.put(974, (byte)-2);
        byte[] realData = new byte[5000];
        try {
            byte[] data = content.getBytes("UNICODE");
            int k = 3;
            realData[0] = 27;
            realData[1] = 116;
            realData[2] = 41;
            for (int i = 2; i < data.length; i += 2) {
                int c = (data[i + 1] & 0xFF) * 256 + (data[i] & 0xFF);
                if (map.get(c) != null) {
                    realData[k] = (Byte)map.get(c);
                    ++k;
                    continue;
                }
                realData[k] = data[i];
                ++k;
            }
            realData[k] = 10;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.mprinter.sendBytesData(realData);
    }

    public int printTextInISO_8859_8(String content) {
        HashMap<Integer, Byte> map = new HashMap<Integer, Byte>();
        map.put(160, (byte)-96);
        map.put(162, (byte)-94);
        map.put(163, (byte)-93);
        map.put(164, (byte)-92);
        map.put(165, (byte)-91);
        map.put(166, (byte)-90);
        map.put(167, (byte)-89);
        map.put(168, (byte)-88);
        map.put(169, (byte)-87);
        map.put(215, (byte)-86);
        map.put(171, (byte)-85);
        map.put(172, (byte)-84);
        map.put(173, (byte)-83);
        map.put(174, (byte)-82);
        map.put(8254, (byte)-81);
        map.put(176, (byte)-80);
        map.put(177, (byte)-79);
        map.put(178, (byte)-78);
        map.put(179, (byte)-77);
        map.put(180, (byte)-76);
        map.put(181, (byte)-75);
        map.put(182, (byte)-74);
        map.put(183, (byte)-73);
        map.put(184, (byte)-72);
        map.put(185, (byte)-71);
        map.put(247, (byte)-70);
        map.put(187, (byte)-69);
        map.put(188, (byte)-68);
        map.put(189, (byte)-67);
        map.put(190, (byte)-66);
        map.put(8215, (byte)-33);
        map.put(1488, (byte)-32);
        map.put(1489, (byte)-31);
        map.put(1490, (byte)-30);
        map.put(1491, (byte)-29);
        map.put(1492, (byte)-28);
        map.put(1493, (byte)-27);
        map.put(1494, (byte)-26);
        map.put(1495, (byte)-25);
        map.put(1496, (byte)-24);
        map.put(1497, (byte)-23);
        map.put(1498, (byte)-22);
        map.put(1499, (byte)-21);
        map.put(1500, (byte)-20);
        map.put(1501, (byte)-19);
        map.put(1502, (byte)-18);
        map.put(1503, (byte)-17);
        map.put(1504, (byte)-16);
        map.put(1505, (byte)-15);
        map.put(1506, (byte)-14);
        map.put(1507, (byte)-13);
        map.put(1508, (byte)-12);
        map.put(1509, (byte)-11);
        map.put(1510, (byte)-10);
        map.put(1511, (byte)-9);
        map.put(1512, (byte)-8);
        map.put(1513, (byte)-7);
        map.put(1514, (byte)-6);
        byte[] realData = new byte[5000];
        try {
            byte[] data = content.getBytes("UNICODE");
            int k = 3;
            realData[0] = 27;
            realData[1] = 116;
            realData[2] = 42;
            for (int i = 2; i < data.length; i += 2) {
                int c = (data[i + 1] & 0xFF) * 256 + (data[i] & 0xFF);
                if (map.get(c) != null) {
                    realData[k] = (Byte)map.get(c);
                    ++k;
                    continue;
                }
                realData[k] = data[i];
                ++k;
            }
            realData[k] = 10;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.mprinter.sendBytesData(realData);
    }

    public int printTextInISO_8859_9(String content) {
        HashMap<Integer, Byte> map = new HashMap<Integer, Byte>();
        map.put(160, (byte)-96);
        map.put(161, (byte)-95);
        map.put(162, (byte)-94);
        map.put(163, (byte)-93);
        map.put(164, (byte)-92);
        map.put(165, (byte)-91);
        map.put(166, (byte)-90);
        map.put(167, (byte)-89);
        map.put(168, (byte)-88);
        map.put(169, (byte)-87);
        map.put(170, (byte)-86);
        map.put(171, (byte)-85);
        map.put(172, (byte)-84);
        map.put(173, (byte)-83);
        map.put(174, (byte)-82);
        map.put(175, (byte)-81);
        map.put(176, (byte)-80);
        map.put(177, (byte)-79);
        map.put(178, (byte)-78);
        map.put(179, (byte)-77);
        map.put(180, (byte)-76);
        map.put(181, (byte)-75);
        map.put(182, (byte)-74);
        map.put(183, (byte)-73);
        map.put(184, (byte)-72);
        map.put(185, (byte)-71);
        map.put(186, (byte)-70);
        map.put(187, (byte)-69);
        map.put(188, (byte)-68);
        map.put(189, (byte)-67);
        map.put(190, (byte)-66);
        map.put(191, (byte)-65);
        map.put(192, (byte)-64);
        map.put(193, (byte)-63);
        map.put(194, (byte)-62);
        map.put(195, (byte)-61);
        map.put(196, (byte)-60);
        map.put(197, (byte)-59);
        map.put(198, (byte)-58);
        map.put(199, (byte)-57);
        map.put(200, (byte)-56);
        map.put(201, (byte)-55);
        map.put(202, (byte)-54);
        map.put(203, (byte)-53);
        map.put(204, (byte)-52);
        map.put(205, (byte)-51);
        map.put(206, (byte)-50);
        map.put(207, (byte)-49);
        map.put(286, (byte)-48);
        map.put(209, (byte)-47);
        map.put(210, (byte)-46);
        map.put(211, (byte)-45);
        map.put(212, (byte)-44);
        map.put(213, (byte)-43);
        map.put(214, (byte)-42);
        map.put(215, (byte)-41);
        map.put(216, (byte)-40);
        map.put(217, (byte)-39);
        map.put(218, (byte)-38);
        map.put(219, (byte)-37);
        map.put(220, (byte)-36);
        map.put(221, (byte)-35);
        map.put(222, (byte)-34);
        map.put(223, (byte)-33);
        map.put(224, (byte)-32);
        map.put(225, (byte)-31);
        map.put(226, (byte)-30);
        map.put(227, (byte)-29);
        map.put(228, (byte)-28);
        map.put(229, (byte)-27);
        map.put(230, (byte)-26);
        map.put(231, (byte)-25);
        map.put(232, (byte)-24);
        map.put(233, (byte)-23);
        map.put(234, (byte)-22);
        map.put(235, (byte)-21);
        map.put(236, (byte)-20);
        map.put(237, (byte)-19);
        map.put(238, (byte)-18);
        map.put(239, (byte)-17);
        map.put(287, (byte)-16);
        map.put(241, (byte)-15);
        map.put(242, (byte)-14);
        map.put(243, (byte)-13);
        map.put(244, (byte)-12);
        map.put(245, (byte)-11);
        map.put(246, (byte)-10);
        map.put(247, (byte)-9);
        map.put(248, (byte)-8);
        map.put(249, (byte)-7);
        map.put(250, (byte)-6);
        map.put(251, (byte)-5);
        map.put(252, (byte)-4);
        map.put(305, (byte)-3);
        map.put(351, (byte)-2);
        map.put(255, (byte)-1);
        byte[] realData = new byte[5000];
        try {
            byte[] data = content.getBytes("UNICODE");
            int k = 3;
            realData[0] = 27;
            realData[1] = 116;
            realData[2] = 43;
            for (int i = 2; i < data.length; i += 2) {
                int c = (data[i + 1] & 0xFF) * 256 + (data[i] & 0xFF);
                if (map.get(c) != null) {
                    realData[k] = (Byte)map.get(c);
                    ++k;
                    continue;
                }
                realData[k] = data[i];
                ++k;
            }
            realData[k] = 10;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.mprinter.sendBytesData(realData);
    }

    public int printTextInISO_8859_15(String content) {
        HashMap<Integer, Byte> map = new HashMap<Integer, Byte>();
        map.put(160, (byte)-96);
        map.put(161, (byte)-95);
        map.put(162, (byte)-94);
        map.put(163, (byte)-93);
        map.put(8364, (byte)-92);
        map.put(165, (byte)-91);
        map.put(352, (byte)-90);
        map.put(167, (byte)-89);
        map.put(353, (byte)-88);
        map.put(169, (byte)-87);
        map.put(170, (byte)-86);
        map.put(171, (byte)-85);
        map.put(172, (byte)-84);
        map.put(173, (byte)-83);
        map.put(174, (byte)-82);
        map.put(175, (byte)-81);
        map.put(176, (byte)-80);
        map.put(177, (byte)-79);
        map.put(178, (byte)-78);
        map.put(179, (byte)-77);
        map.put(381, (byte)-76);
        map.put(181, (byte)-75);
        map.put(182, (byte)-74);
        map.put(183, (byte)-73);
        map.put(382, (byte)-72);
        map.put(185, (byte)-71);
        map.put(186, (byte)-70);
        map.put(187, (byte)-69);
        map.put(338, (byte)-68);
        map.put(339, (byte)-67);
        map.put(376, (byte)-66);
        map.put(191, (byte)-65);
        map.put(192, (byte)-64);
        map.put(193, (byte)-63);
        map.put(194, (byte)-62);
        map.put(195, (byte)-61);
        map.put(196, (byte)-60);
        map.put(197, (byte)-59);
        map.put(198, (byte)-58);
        map.put(199, (byte)-57);
        map.put(200, (byte)-56);
        map.put(201, (byte)-55);
        map.put(202, (byte)-54);
        map.put(203, (byte)-53);
        map.put(204, (byte)-52);
        map.put(205, (byte)-51);
        map.put(206, (byte)-50);
        map.put(207, (byte)-49);
        map.put(208, (byte)-48);
        map.put(209, (byte)-47);
        map.put(210, (byte)-46);
        map.put(211, (byte)-45);
        map.put(212, (byte)-44);
        map.put(213, (byte)-43);
        map.put(214, (byte)-42);
        map.put(215, (byte)-41);
        map.put(216, (byte)-40);
        map.put(217, (byte)-39);
        map.put(218, (byte)-38);
        map.put(219, (byte)-37);
        map.put(220, (byte)-36);
        map.put(221, (byte)-35);
        map.put(222, (byte)-34);
        map.put(223, (byte)-33);
        map.put(224, (byte)-32);
        map.put(225, (byte)-31);
        map.put(226, (byte)-30);
        map.put(227, (byte)-29);
        map.put(228, (byte)-28);
        map.put(229, (byte)-27);
        map.put(230, (byte)-26);
        map.put(231, (byte)-25);
        map.put(232, (byte)-24);
        map.put(233, (byte)-23);
        map.put(234, (byte)-22);
        map.put(235, (byte)-21);
        map.put(236, (byte)-20);
        map.put(237, (byte)-19);
        map.put(238, (byte)-18);
        map.put(239, (byte)-17);
        map.put(240, (byte)-16);
        map.put(241, (byte)-15);
        map.put(242, (byte)-14);
        map.put(243, (byte)-13);
        map.put(244, (byte)-12);
        map.put(245, (byte)-11);
        map.put(246, (byte)-10);
        map.put(247, (byte)-9);
        map.put(248, (byte)-8);
        map.put(249, (byte)-7);
        map.put(250, (byte)-6);
        map.put(251, (byte)-5);
        map.put(252, (byte)-4);
        map.put(253, (byte)-3);
        map.put(254, (byte)-2);
        map.put(255, (byte)-1);
        byte[] realData = new byte[5000];
        try {
            byte[] data = content.getBytes("UNICODE");
            int k = 3;
            realData[0] = 27;
            realData[1] = 116;
            realData[2] = 44;
            for (int i = 2; i < data.length; i += 2) {
                int c = (data[i + 1] & 0xFF) * 256 + (data[i] & 0xFF);
                if (map.get(c) != null) {
                    realData[k] = (Byte)map.get(c);
                    ++k;
                    continue;
                }
                realData[k] = data[i];
                ++k;
            }
            realData[k] = 10;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.mprinter.sendBytesData(realData);
    }

    public int printTextInCP874(String content) {
        HashMap<Integer, Byte> map = new HashMap<Integer, Byte>();
        map.put(3584, (byte)-96);
        map.put(3585, (byte)-95);
        map.put(3586, (byte)-94);
        map.put(3587, (byte)-93);
        map.put(3588, (byte)-92);
        map.put(3589, (byte)-91);
        map.put(3590, (byte)-90);
        map.put(3591, (byte)-89);
        map.put(3592, (byte)-88);
        map.put(3593, (byte)-87);
        map.put(3594, (byte)-86);
        map.put(3595, (byte)-85);
        map.put(3596, (byte)-84);
        map.put(3597, (byte)-83);
        map.put(3598, (byte)-82);
        map.put(3599, (byte)-81);
        map.put(3600, (byte)-80);
        map.put(3601, (byte)-79);
        map.put(3602, (byte)-78);
        map.put(3603, (byte)-77);
        map.put(3604, (byte)-76);
        map.put(3605, (byte)-75);
        map.put(3606, (byte)-74);
        map.put(3607, (byte)-73);
        map.put(3608, (byte)-72);
        map.put(3609, (byte)-71);
        map.put(3610, (byte)-70);
        map.put(3611, (byte)-69);
        map.put(3612, (byte)-68);
        map.put(3613, (byte)-67);
        map.put(3614, (byte)-66);
        map.put(3615, (byte)-65);
        map.put(3616, (byte)-64);
        map.put(3617, (byte)-63);
        map.put(3618, (byte)-62);
        map.put(3619, (byte)-61);
        map.put(3620, (byte)-60);
        map.put(3621, (byte)-59);
        map.put(3622, (byte)-58);
        map.put(3623, (byte)-57);
        map.put(3624, (byte)-56);
        map.put(3625, (byte)-55);
        map.put(3626, (byte)-54);
        map.put(3627, (byte)-53);
        map.put(3628, (byte)-52);
        map.put(3629, (byte)-51);
        map.put(3630, (byte)-50);
        map.put(3631, (byte)-49);
        map.put(3632, (byte)-48);
        map.put(3633, (byte)-47);
        map.put(3634, (byte)-46);
        map.put(3635, (byte)-45);
        map.put(3636, (byte)-44);
        map.put(3637, (byte)-43);
        map.put(3638, (byte)-42);
        map.put(3639, (byte)-41);
        map.put(3640, (byte)-40);
        map.put(3641, (byte)-39);
        map.put(3642, (byte)-38);
        map.put(3647, (byte)-33);
        map.put(3648, (byte)-32);
        map.put(3649, (byte)-31);
        map.put(3650, (byte)-30);
        map.put(3651, (byte)-29);
        map.put(3652, (byte)-28);
        map.put(3653, (byte)-27);
        map.put(3654, (byte)-26);
        map.put(3655, (byte)-25);
        map.put(3656, (byte)-24);
        map.put(3657, (byte)-23);
        map.put(3658, (byte)-22);
        map.put(3659, (byte)-21);
        map.put(3660, (byte)-20);
        map.put(3661, (byte)-19);
        map.put(3662, (byte)-18);
        map.put(3663, (byte)-17);
        map.put(3664, (byte)-16);
        map.put(3665, (byte)-15);
        map.put(3666, (byte)-14);
        map.put(3667, (byte)-13);
        map.put(3668, (byte)-12);
        map.put(3669, (byte)-11);
        map.put(3670, (byte)-10);
        map.put(3671, (byte)-9);
        map.put(3672, (byte)-8);
        map.put(3673, (byte)-7);
        map.put(3674, (byte)-6);
        map.put(3675, (byte)-5);
        byte[] realData = new byte[5000];
        try {
            byte[] data = content.getBytes("UNICODE");
            int k = 3;
            realData[0] = 27;
            realData[1] = 116;
            realData[2] = 26;
            for (int i = 2; i < data.length; i += 2) {
                int c = (data[i + 1] & 0xFF) * 256 + (data[i] & 0xFF);
                if (map.get(c) != null) {
                    realData[k] = (Byte)map.get(c);
                    ++k;
                    continue;
                }
                realData[k] = data[i];
                ++k;
            }
            realData[k] = 10;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.mprinter.sendBytesData(realData);
    }
}

