/*
 * Decompiled with CFR 0.152.
 */
package com.printer.sdk;

import android.content.Context;
import android.content.res.AssetManager;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Typeface;
import android.text.TextUtils;
import com.printer.sdk.BarcodeCreater;
import com.printer.sdk.zxing.EncodeHintType;
import com.printer.sdk.zxing.pdf417.encoder.Dimensions;
import com.printer.sdk.zxing.qrcode.decoder.ErrorCorrectionLevel;
import java.util.Hashtable;

public class CanvasDrawPrint {
    public static int LINE = 1;
    public static int BOX = 2;
    public static int TEXT = 3;
    public static int PDF417_PROFESSIONAL = 4;
    public static int PDF417_ORDINARY = 5;
    public static int QRCODE_PROFESSIONAL = 6;
    public static int QRCODE_ORDINARY = 7;
    public static int ONE_DIMENSION_CODE = 8;
    public static int IMG = 9;
    private Canvas canvas;
    private Paint mPaint;
    private Bitmap bitmap;
    private int width;
    private int height;
    private boolean textExceedNewLine = true;
    private boolean useSplit;
    private String splitStr = " ";
    private boolean textAlignRight;
    private float length = 0.0f;
    private float currentY;
    private CanvasDrawBack mCanvasDrawBack;

    public void SPRTSetPageMode(int width, int height) {
        this.width = width;
        this.height = height;
        this.length = 0.0f;
        this.initCanvas();
        this.initPaint();
    }

    public void setCanvasDrawBack(CanvasDrawBack mCanvasDrawBack) {
        this.mCanvasDrawBack = mCanvasDrawBack;
    }

    private void initCanvas() {
        this.bitmap = Bitmap.createBitmap((int)this.width, (int)this.height, (Bitmap.Config)Bitmap.Config.ARGB_4444);
        this.canvas = new Canvas(this.bitmap);
        this.canvas.drawColor(-1);
    }

    private void initPaint() {
        this.mPaint = new Paint();
        this.mPaint.setAntiAlias(true);
        this.mPaint.setColor(-7829368);
    }

    public void setPaintStyle(Paint.Style style) {
        this.mPaint.setStyle(style);
    }

    private float getFontHeight() {
        Paint.FontMetrics fm = this.mPaint.getFontMetrics();
        return (float)Math.ceil(fm.bottom - fm.top);
    }

    private float getFontY(float y) {
        Paint.FontMetrics fm = this.mPaint.getFontMetrics();
        return (float)Math.ceil(fm.bottom - fm.top + y);
    }

    public void setUseSplit(boolean useSplit) {
        this.useSplit = useSplit;
    }

    public int getLength() {
        return (int)(this.length + 10.0f);
    }

    public void setTextExceedNewLine(boolean newLine) {
        this.textExceedNewLine = newLine;
    }

    public void setTextAlignRight(boolean alignRight) {
        this.textAlignRight = alignRight;
    }

    private float getTextWidth(String text) {
        return this.mPaint.measureText(text);
    }

    private int getValidStringPos(String string, int validWidth) {
        float textWidth = this.getTextWidth(string);
        while (textWidth > 0.0f && textWidth > (float)validWidth) {
            int subPos = (int)((float)(validWidth * string.length()) / textWidth);
            textWidth = this.getTextWidth(string = string.substring(0, subPos));
            if (!(textWidth <= (float)validWidth)) continue;
            if (this.useSplit && string.contains(this.splitStr) && string.lastIndexOf(this.splitStr) != 0) {
                subPos = string.lastIndexOf(this.splitStr);
            }
            return subPos;
        }
        return string.length();
    }

    public void SPRTPrintLine(int X_Start, int Y_Start, int X_End, int Y_End, int L_Width) {
        block3: {
            try {
                float max;
                this.mPaint.setStrokeWidth((float)L_Width);
                this.canvas.drawLine((float)X_Start, (float)Y_Start, (float)X_End, (float)Y_End, this.mPaint);
                float f = max = Y_Start > Y_End ? (float)Y_Start : (float)Y_End;
                if (this.length < max) {
                    this.length = max;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                if (this.mCanvasDrawBack == null) break block3;
                this.mCanvasDrawBack.resultsBack(LINE);
            }
        }
    }

    public void SPRTPrintBox(int X_Start, int Y_Start, int X_End, int Y_End, int L_Width) {
        block3: {
            try {
                this.mPaint.setStrokeWidth((float)L_Width);
                this.canvas.drawRect((float)X_Start, (float)Y_Start, (float)X_End, (float)Y_End, this.mPaint);
                float max = 0.0f;
                float f = max = Y_Start > Y_End ? (float)Y_Start : (float)Y_End;
                if (this.length < max) {
                    this.length = max;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                if (this.mCanvasDrawBack == null) break block3;
                this.mCanvasDrawBack.resultsBack(BOX);
            }
        }
    }

    public void SPRTPrintText(int xPos, int yPos, String font, int font_size, boolean bold, boolean underline, float italic, String content, Context mContext) {
        block11: {
            try {
                float textWidth;
                Typeface typeface = Typeface.DEFAULT;
                if (!TextUtils.isEmpty((CharSequence)font)) {
                    typeface = Typeface.createFromAsset((AssetManager)mContext.getAssets(), (String)font);
                }
                this.mPaint.setTypeface(typeface);
                this.mPaint.setTextSize((float)font_size);
                this.mPaint.setFakeBoldText(bold);
                this.mPaint.setUnderlineText(underline);
                this.mPaint.setTextSkewX(italic);
                int validWidth = this.width - xPos;
                float tmpWidth = 0.0f;
                if (this.textExceedNewLine) {
                    int pos = 0;
                    for (textWidth = this.getTextWidth(content); (pos = this.getValidStringPos(content, validWidth)) > 0 && textWidth > 0.0f; textWidth -= (float)validWidth - tmpWidth) {
                        String printStr = content.substring(0, pos);
                        if (this.textAlignRight) {
                            tmpWidth = this.getTextWidth(printStr);
                            this.canvas.drawText(printStr, (float)xPos + ((float)validWidth - tmpWidth), this.getFontY(yPos), this.mPaint);
                        } else {
                            this.canvas.drawText(printStr, (float)xPos, this.getFontY(yPos), this.mPaint);
                        }
                        content = content.substring(pos, content.length());
                        yPos = (int)((float)yPos + this.getFontHeight());
                        this.currentY = yPos;
                    }
                } else {
                    if (this.textAlignRight) {
                        this.canvas.drawText(content, (float)xPos + ((float)validWidth - textWidth), this.getFontY(yPos), this.mPaint);
                    } else {
                        this.canvas.drawText(content, (float)xPos, this.getFontY(yPos), this.mPaint);
                    }
                    this.currentY = this.getFontHeight() + (float)yPos;
                }
                if (this.length < this.currentY) {
                    this.length = this.currentY;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                if (this.mCanvasDrawBack == null) break block11;
                this.mCanvasDrawBack.resultsBack(TEXT);
            }
        }
    }

    public void SPRTPrintPDFCode(int xPos, int yPos, int unit_width, int unit_height, int rows, int columns, int err_level, String content) {
        block2: {
            try {
                Hashtable<EncodeHintType, Object> hint = new Hashtable<EncodeHintType, Object>();
                hint.put(EncodeHintType.PDF417_DIMENSIONS, new Dimensions(columns, columns, rows, rows));
                hint.put(EncodeHintType.ERROR_CORRECTION, err_level);
                hint.put(EncodeHintType.MARGIN, 0);
                this.SPRTPrintPicture(xPos, yPos, BarcodeCreater.createCode(false, 1, content, unit_width, unit_height, 10, hint));
            }
            catch (Exception e) {
                e.printStackTrace();
                if (this.mCanvasDrawBack == null) break block2;
                this.mCanvasDrawBack.resultsBack(PDF417_PROFESSIONAL);
            }
        }
    }

    public void SPRTPrintPDFCode(int xPos, int yPos, int width, int height, String content) {
        block2: {
            try {
                Hashtable<EncodeHintType, Object> hint = new Hashtable<EncodeHintType, Object>();
                hint.put(EncodeHintType.MARGIN, 0);
                this.SPRTPrintPicture(xPos, yPos, BarcodeCreater.createCode(true, 1, content, width, height, 0, hint));
            }
            catch (Exception e) {
                e.printStackTrace();
                if (this.mCanvasDrawBack == null) break block2;
                this.mCanvasDrawBack.resultsBack(PDF417_ORDINARY);
            }
        }
    }

    public void SPRTPrintQRCode(int xPos, int yPos, int module_width, int module_height, int white_space, int version, int err_level, String content) {
        block8: {
            try {
                Hashtable<EncodeHintType, Object> hint = new Hashtable<EncodeHintType, Object>();
                if (err_level == 0) {
                    hint.put(EncodeHintType.ERROR_CORRECTION, (Object)ErrorCorrectionLevel.L);
                } else if (err_level == 1) {
                    hint.put(EncodeHintType.ERROR_CORRECTION, (Object)ErrorCorrectionLevel.M);
                } else if (err_level == 2) {
                    hint.put(EncodeHintType.ERROR_CORRECTION, (Object)ErrorCorrectionLevel.Q);
                } else {
                    hint.put(EncodeHintType.ERROR_CORRECTION, (Object)ErrorCorrectionLevel.H);
                }
                hint.put(EncodeHintType.QR_VERSION, version);
                hint.put(EncodeHintType.MARGIN, 0);
                this.SPRTPrintPicture(xPos, yPos, BarcodeCreater.createCode(false, 0, content, module_width, module_height, white_space, hint));
            }
            catch (Exception e) {
                e.printStackTrace();
                if (this.mCanvasDrawBack == null) break block8;
                this.mCanvasDrawBack.resultsBack(QRCODE_PROFESSIONAL);
            }
        }
    }

    public void SPRTPrintQRCode(int xPos, int yPos, int width, int height, String content) {
        block2: {
            try {
                Hashtable<EncodeHintType, Object> hint = new Hashtable<EncodeHintType, Object>();
                hint.put(EncodeHintType.MARGIN, 0);
                this.SPRTPrintPicture(xPos, yPos, BarcodeCreater.createCode(false, 0, content, width, height, 0, hint));
            }
            catch (Exception e) {
                e.printStackTrace();
                if (this.mCanvasDrawBack == null) break block2;
                this.mCanvasDrawBack.resultsBack(QRCODE_ORDINARY);
            }
        }
    }

    public void SPRTPrintCode(int codeType, int xPos, int yPos, int width, int height, boolean show_text, String content) {
        block2: {
            try {
                Hashtable<EncodeHintType, Object> hint = new Hashtable<EncodeHintType, Object>();
                hint.put(EncodeHintType.MARGIN, 0);
                Bitmap bitmap = show_text ? BarcodeCreater.showContent(BarcodeCreater.createCode(true, codeType, content, width, height, 0, hint), content) : BarcodeCreater.createCode(true, codeType, content, width, height, 0, hint);
                this.SPRTPrintPicture(xPos, yPos, bitmap);
            }
            catch (Exception e) {
                e.printStackTrace();
                if (this.mCanvasDrawBack == null) break block2;
                this.mCanvasDrawBack.resultsBack(ONE_DIMENSION_CODE);
            }
        }
    }

    public void SPRTPrintPicture(int xPos, int yPos, Bitmap bitmap) {
        block4: {
            try {
                if (bitmap != null) {
                    this.canvas.drawBitmap(bitmap, (float)xPos, (float)yPos, null);
                    this.currentY = bitmap.getHeight() + yPos;
                    if (this.length < this.currentY) {
                        this.length = this.currentY;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                if (this.mCanvasDrawBack == null) break block4;
                this.mCanvasDrawBack.resultsBack(IMG);
            }
        }
    }

    public Bitmap getCanvasImage() {
        return this.bitmap;
    }

    public static interface CanvasDrawBack {
        public void resultsBack(int var1);
    }
}

