/*
 * Decompiled with CFR 0.152.
 */
package com.printer.sdk;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.text.TextUtils;
import com.printer.sdk.zxing.BarcodeFormat;
import com.printer.sdk.zxing.EncodeHintType;
import com.printer.sdk.zxing.MultiFormatWriter;
import com.printer.sdk.zxing.WriterException;
import com.printer.sdk.zxing.common.BitMatrix;
import java.io.UnsupportedEncodingException;
import java.util.Hashtable;

public class BarcodeCreater {
    public static final int QR_CODE = 0;
    public static final int PDF_417 = 1;
    public static final int DATA_MATRIX = 2;
    public static final int ITF = 3;
    public static final int CODE_39 = 4;
    public static final int CODE_128 = 5;
    public static final int EAN_13 = 6;
    public static final int EAN_8 = 7;
    public static final int UPC_A = 8;
    public static final int UPC_E = 9;
    public static final int CODABAR = 10;
    public static final int CODE_93 = 11;
    private static BarcodeFormat barcodeFormat = BarcodeFormat.CODE_39;
    private static final String TAG = "BarcodeCreater";

    private static BitMatrix updateBit(BitMatrix matrix, int margin) {
        int tempM = margin * 2;
        int[] rec = matrix.getEnclosingRectangle();
        int resWidth = rec[2] + tempM;
        int resHeight = rec[3] + tempM;
        BitMatrix resMatrix = new BitMatrix(resWidth, resHeight);
        resMatrix.clear();
        for (int i = margin; i < resWidth - margin; ++i) {
            for (int j = margin; j < resHeight - margin; ++j) {
                if (!matrix.get(i - margin + rec[0], j - margin + rec[1])) continue;
                resMatrix.set(i, j);
            }
        }
        return resMatrix;
    }

    private static BitMatrix deleteWhite(BitMatrix matrix) {
        int[] rec = matrix.getEnclosingRectangle();
        int resWidth = rec[2] + 1;
        int resHeight = rec[3] + 1;
        BitMatrix resMatrix = new BitMatrix(resWidth, resHeight);
        resMatrix.clear();
        for (int i = 0; i < resWidth; ++i) {
            for (int j = 0; j < resHeight; ++j) {
                if (!matrix.get(i + rec[0], j + rec[1])) continue;
                resMatrix.set(i, j);
            }
        }
        return resMatrix;
    }

    public static Bitmap createCode(boolean isZoomBitMap, int barCodeType, String str, int cWidth, int cHeight, int spacing, Hashtable<EncodeHintType, Object> hint) throws IllegalArgumentException, UnsupportedEncodingException, WriterException {
        switch (barCodeType) {
            case 0: {
                barcodeFormat = BarcodeFormat.QR_CODE;
                break;
            }
            case 1: {
                barcodeFormat = BarcodeFormat.PDF_417;
                break;
            }
            case 2: {
                barcodeFormat = BarcodeFormat.DATA_MATRIX;
                break;
            }
            case 3: {
                barcodeFormat = BarcodeFormat.ITF;
                break;
            }
            case 4: {
                barcodeFormat = BarcodeFormat.CODE_39;
                break;
            }
            case 5: {
                barcodeFormat = BarcodeFormat.CODE_128;
                break;
            }
            case 6: {
                barcodeFormat = BarcodeFormat.EAN_13;
                break;
            }
            case 7: {
                barcodeFormat = BarcodeFormat.EAN_8;
                break;
            }
            case 8: {
                barcodeFormat = BarcodeFormat.UPC_A;
                break;
            }
            case 9: {
                barcodeFormat = BarcodeFormat.UPC_E;
                break;
            }
            case 10: {
                barcodeFormat = BarcodeFormat.CODABAR;
                break;
            }
            case 11: {
                barcodeFormat = BarcodeFormat.CODE_93;
                break;
            }
            default: {
                barcodeFormat = BarcodeFormat.QR_CODE;
            }
        }
        BitMatrix bitMatrix = new MultiFormatWriter().encode(new String(str.getBytes("UTF-8"), "ISO-8859-1"), barcodeFormat, cWidth, cHeight, hint);
        bitMatrix = BarcodeCreater.updateBit(bitMatrix, spacing);
        int width = bitMatrix.getWidth();
        int height = bitMatrix.getHeight();
        int[] pixels = new int[width * height];
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                pixels[y * width + x] = bitMatrix.get(x, y) ? -16777216 : -1;
            }
        }
        Bitmap outBitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        outBitmap.setPixels(pixels, 0, width, 0, 0, width, height);
        if (isZoomBitMap) {
            int bmpHeight;
            float hScale;
            int bmpWidth = outBitmap.getWidth();
            float wScale = (float)cWidth / (float)bmpWidth;
            float scale = wScale > (hScale = (float)cHeight / (float)(bmpHeight = outBitmap.getHeight())) ? hScale : wScale;
            Matrix matrix = new Matrix();
            matrix.postScale(scale, scale);
            return Bitmap.createBitmap((Bitmap)outBitmap, (int)0, (int)0, (int)bmpWidth, (int)bmpHeight, (Matrix)matrix, (boolean)true);
        }
        return outBitmap;
    }

    public static Bitmap showContent(Bitmap bCBitmap, String content) {
        if (TextUtils.isEmpty((CharSequence)content) || null == bCBitmap) {
            return null;
        }
        Paint paint = new Paint();
        paint.setColor(-16777216);
        paint.setAntiAlias(true);
        paint.setStyle(Paint.Style.FILL);
        paint.setTextSize(25.0f);
        int textWidth = (int)paint.measureText(content);
        Paint.FontMetrics fm = paint.getFontMetrics();
        int textHeight = (int)(fm.descent - fm.ascent);
        int baseLine = bCBitmap.getHeight() + textHeight;
        Bitmap bitmap = Bitmap.createBitmap((int)bCBitmap.getWidth(), (int)baseLine, (Bitmap.Config)Bitmap.Config.ARGB_4444);
        Canvas canvas = new Canvas();
        canvas.drawColor(-1);
        canvas.setBitmap(bitmap);
        canvas.drawBitmap(bCBitmap, 0.0f, 0.0f, null);
        canvas.drawText(content, (float)((bCBitmap.getWidth() - textWidth) / 2), (float)baseLine, paint);
        canvas.save(31);
        canvas.restore();
        return bitmap;
    }
}

