/*
 * Decompiled with CFR 0.152.
 */
package com.printer.sdk;

import java.io.UnsupportedEncodingException;

public class Barcode {
    private static final String TAG = "Barcode";
    private byte barcodeType;
    private int param1;
    private int param2;
    private int param3;
    private String content;
    private String charsetName = "gbk";

    public Barcode(byte barcodeType) {
        this.barcodeType = barcodeType;
    }

    public Barcode(byte barcodeType, int param1, int param2, int param3) {
        this.barcodeType = barcodeType;
        this.param1 = param1;
        this.param2 = param2;
        this.param3 = param3;
    }

    public Barcode(byte barcodeType, int param1, int param2, int param3, String content) {
        this.barcodeType = barcodeType;
        this.param1 = param1;
        this.param2 = param2;
        this.param3 = param3;
        this.content = content;
    }

    public void setBarcodeParam(byte param1, byte param2, byte param3) {
        this.param1 = param1;
        this.param2 = param2;
        this.param3 = param3;
    }

    public void setBarcodeContent(String content) {
        this.content = content;
    }

    public void setBarcodeContent(String content, String charsetName) {
        this.content = content;
        this.charsetName = charsetName;
    }

    public byte[] getBarcodeData() {
        byte[] realCommand;
        switch (this.barcodeType) {
            case 100: 
            case 101: 
            case 102: {
                realCommand = this.getBarcodeCommand2(this.content, this.barcodeType, this.param1, this.param2, this.param3);
                break;
            }
            case 73: {
                int strLength;
                byte[] tempCommand = new byte[1024];
                int index = 0;
                int tempLength = strLength = this.content.length();
                char[] charArray = this.content.toCharArray();
                boolean preHasCodeA = false;
                boolean preHasCodeB = false;
                boolean preHasCodeC = false;
                boolean needCodeC = false;
                for (int i = 0; i < strLength; ++i) {
                    byte a = (byte)charArray[i];
                    if (a >= 0 && a <= 31) {
                        if (i == 0 || !preHasCodeA) {
                            tempCommand[index++] = 123;
                            tempCommand[index++] = 65;
                            preHasCodeA = true;
                            preHasCodeB = false;
                            preHasCodeC = false;
                            tempLength += 2;
                        }
                        tempCommand[index++] = a;
                        continue;
                    }
                    if (a >= 48 && a <= 57) {
                        if (!preHasCodeC) {
                            for (int m = 1; m < 9; ++m) {
                                if (i + m != strLength && Barcode.isNum((byte)charArray[i + m])) {
                                    if (m != 8) continue;
                                    needCodeC = true;
                                    continue;
                                }
                                needCodeC = false;
                                break;
                            }
                        }
                        if (needCodeC) {
                            byte b;
                            if (!preHasCodeC) {
                                tempCommand[index++] = 123;
                                tempCommand[index++] = 67;
                                preHasCodeA = false;
                                preHasCodeB = false;
                                preHasCodeC = true;
                                tempLength += 2;
                            }
                            if (i != strLength - 1 && Barcode.isNum(b = (byte)charArray[i + 1])) {
                                tempCommand[index++] = (byte)((a - 48) * 10 + (b - 48));
                                --tempLength;
                                ++i;
                                continue;
                            }
                        }
                    }
                    if (!preHasCodeB) {
                        tempCommand[index++] = 123;
                        tempCommand[index++] = 66;
                        preHasCodeA = false;
                        preHasCodeB = true;
                        preHasCodeC = false;
                        tempLength += 2;
                    }
                    tempCommand[index++] = a;
                }
                realCommand = this.getBarcodeCommand1(new String(tempCommand, 0, tempLength), this.barcodeType, (byte)tempLength);
                break;
            }
            case 72: {
                realCommand = this.getBarcodeCommand1(this.content, this.barcodeType, (byte)this.content.length());
                break;
            }
            default: {
                realCommand = this.getBarcodeCommand1(this.content, this.barcodeType);
            }
        }
        return realCommand;
    }

    private byte[] getBarcodeCommand1(String content, byte ... byteArray) {
        byte[] tmpByte;
        int index = 0;
        try {
            tmpByte = this.charsetName != "" ? content.getBytes(this.charsetName) : content.getBytes();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
        byte[] command = new byte[tmpByte.length + 13];
        command[index++] = 29;
        command[index++] = 119;
        command[index++] = this.param1 >= 2 && this.param1 <= 6 ? (int)this.param1 : 2;
        command[index++] = 29;
        command[index++] = 104;
        command[index++] = this.param2 >= 1 && this.param2 <= 255 ? (int)this.param2 : -94;
        command[index++] = 29;
        command[index++] = 72;
        command[index++] = this.param3 >= 0 && this.param3 <= 3 ? (byte)this.param3 : (byte)0;
        command[index++] = 29;
        command[index++] = 107;
        for (int i = 0; i < byteArray.length; ++i) {
            command[index++] = byteArray[i];
        }
        for (int j = 0; j < tmpByte.length; ++j) {
            command[index++] = tmpByte[j];
        }
        return command;
    }

    private byte[] getBarcodeCommand2(String content, byte barcodeType, int param1, int param2, int param3) {
        byte[] tmpByte;
        try {
            tmpByte = this.charsetName != "" ? content.getBytes(this.charsetName) : content.getBytes();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
        byte[] command = new byte[tmpByte.length + 10];
        command[0] = 29;
        command[1] = 90;
        command[2] = (byte)(barcodeType - 100);
        command[3] = 27;
        command[4] = 90;
        command[5] = (byte)param1;
        command[6] = (byte)param2;
        command[7] = (byte)param3;
        command[8] = (byte)(tmpByte.length % 256);
        command[9] = (byte)(tmpByte.length / 256);
        System.arraycopy(tmpByte, 0, command, 10, tmpByte.length);
        return command;
    }

    public static boolean isNum(byte temp) {
        return temp >= 48 && temp <= 57;
    }
}

