import React, {Component} from 'react';
import {Modal, View, Text, Image} from 'react-native';
import ModalStyles from './Modal/styles';
import {font} from '../utils/common';
import {setSpText} from '../utils/screen';

const mStyles = {
  ...ModalStyles,
  innerContainer: {
    ...ModalStyles.innerContainer,
  },
  header: {
    ...ModalStyles.header,
    fontSize: font.title,
  },
};

class LoadingModal extends Component {
  render() {
    const {...props} = this.props;
    return (
      <Modal styles={mStyles} {...props}>
        <View style={styles.modalBackgroundStyle}>
          <View style={styles.modal}>
            <View style={styles.top}>
              <Image
                tintColor="white"
                source={require('../assets/Face/loading.gif')}
                style={styles.image}
              />
            </View>
            <View style={styles.bottom}>
              <Text style={styles.tips}>正在进行安全检查</Text>
            </View>
          </View>
        </View>
      </Modal>
    );
  }
}

const styles = {
  modalBackgroundStyle: {
    flex: 1,
    backgroundColor: 'rgba(0, 0, 0, 0.8)',
    // opacity: 0.8,
  },
  modal: {
    flex: 1,
    height: '100%',
    width: '100%',
    flexDirection: 'column',
    justifyContent: 'center',
  },
  top: {
    flexDirection: 'row',
    alignItems: 'center',
    justifyContent: 'center',
  },
  image: {
    // width: '80%',
    // height: '80%',
    // width: scaleSize(400),
    // height: scaleSize(400),
  },
  bottom: {
    marginTop: 30,
    flexDirection: 'row',
    alignItems: 'center',
    justifyContent: 'center',
  },
  tips: {
    fontSize: setSpText(75),
    color: 'white',
  },
};

export default LoadingModal;
