import React, {Component} from 'react';
import {connect} from 'react-redux';
import {
  View,
  Image,
  Text,
  Dimensions,
  ScrollView,
  TextInput,
} from 'react-native';
import {setSpText} from '../utils/screen';
import GoodsList from '../components/GoodsList';

const {width, height} = Dimensions.get('window');
@connect(({searchGoods}) => ({searchGoods}))
class OrderPage extends Component {
  state = {
    goodsArr: [],
  };

  componentDidMount() {
    this.getGoodsList();
  }

  getGoodsList = async () => {
    let {data} = await this.props.dispatch({
      type: 'searchGoods/getStoreGoods',
      page: 0,
      size: 10,
    });
    if (data.code === 1) {
      this.setState({
        goodsArr: data.data,
      });
    }
  };

  render() {
    let {goodsArr} = this.state;
    return (
      <View style={styles.body}>
        <View style={styles.search}>
          <View style={styles.searchInput}>
            <View style={styles.searchIcon}>
              <Image
                style={styles.img}
                source={require('../assets/Order/search.png')}
              />
            </View>
            <View style={styles.searchText}>
              <TextInput style={styles.input} />
            </View>
            <Text style={styles.searchBtn}>搜索</Text>
          </View>
        </View>
        <View style={styles.info}>
          <View style={styles.classify} />
          <ScrollView style={styles.goods}>
            <GoodsList goodsArr={goodsArr} />
          </ScrollView>
        </View>
        <View style={styles.settle}>
          <View style={styles.total}>
            <Text style={{marginLeft: 130, fontSize: setSpText(50)}}>
              总计:
              <Text style={{fontSize: setSpText(40), color: '#e21918'}}>
                ￥99.<Text style={{fontSize: setSpText(25)}}>00</Text>
              </Text>
            </Text>
          </View>
          <View style={styles.onSubmit}>
            <Text style={{color: '#fff', fontSize: setSpText(50)}}>结算</Text>
          </View>
        </View>
      </View>
    );
  }
}

const styles = {
  body: {
    width,
    height,
    backgroundColor: '#fff',
  },
  search: {
    width,
    height: height * 0.07,
    flexDirection: 'row',
    justifyContent: 'center',
    alignItems: 'center',
  },
  searchInput: {
    width: width * 0.9,
    height: height * 0.07 * 0.85,
    borderWidth: 1,
    borderColor: '#ccc',
    borderRadius: height * 0.07 * 0.85,
    flexDirection: 'row',
    alignItems: 'center',
  },
  input: {
    width: '100%',
    height: '100%',
    fontSize: setSpText(50),
  },
  searchIcon: {
    width: height * 0.07 * 0.85,
    height: height * 0.07 * 0.85,
    marginLeft: 20,
  },
  searchText: {
    width: height * 0.07 * 5.1,
    height: height * 0.07 * 0.85,
  },
  searchBtn: {
    width: height * 0.07 * 1.2,
    height: height * 0.07 * 0.7,
    borderRadius: height * 0.07 * 0.7,
    fontSize: setSpText(50),
    color: '#fff',
    backgroundColor: '#fc4000',
    textAlign: 'center',
    lineHeight: height * 0.07 * 0.7,
  },
  info: {
    width,
    height: height * 0.86,
    flexDirection: 'row',
    borderTopWidth: 1,
    borderTopColor: '#ccc',
  },
  classify: {
    width: width * 0.15,
    height: height * 0.86,
    backgroundColor: '#ccc',
  },
  goods: {
    width: width * 0.8,
    height: height * 0.86,
  },
  goodsBox: {
    width: width * 0.85,
    flexDirection: 'row',
    flexWrap: 'wrap',
  },
  goodsItem: {
    width: width * 0.85 * 0.3333,
    height: height * 0.8 * 0.31,
    alignItems: 'center',
    borderBottomWidth: 1,
    borderBottomColor: '#ccc',
    borderRightWidth: 1,
    borderRightColor: '#ccc',
  },
  goodsImg: {
    width: width * 0.85 * 0.3333 * 0.95,
    height: width * 0.85 * 0.3333 * 0.8,
    backgroundColor: 'skyblue',
    marginTop: 10,
  },
  goodsName: {
    width: width * 0.85 * 0.3333 * 0.95,
    height: 40,
    lineHeight: 50,
    fontSize: setSpText(30),
  },
  goodsPrice: {
    width: width * 0.85 * 0.3333 * 0.9,
    height: 25,
    textAlign: 'right',
    paddingRight: 20,
    marginTop: 5,
    marginBottom: 5,
    color: '#e21918',
    fontSize: setSpText(20),
  },
  goodsNum: {
    width: width * 0.85 * 0.3333 * 0.9,
    height: 50,
    flexDirection: 'row',
    justifyContent: 'space-between',
  },
  goodsSub: {
    width: 50,
    height: 50,
    borderRadius: 50,
    backgroundColor: 'pink',
  },
  img: {
    width: '100%',
    height: '100%',
  },
  goodsNums: {
    width: 50,
    height: 50,
    textAlign: 'center',
    fontSize: 40,
  },
  goodsAdd: {
    width: 50,
    height: 50,
    borderRadius: 50,
    backgroundColor: 'pink',
  },
  settle: {
    width,
    height: height * 0.07,
    flexDirection: 'row',
    alignItems: 'center',
    backgroundColor: '#ccc',
  },
  total: {
    width: width * 0.75,
    height: height * 0.07,
    justifyContent: 'center',
  },
  onSubmit: {
    width: width * 0.23,
    height: height * 0.06,
    borderRadius: height * 0.07,
    backgroundColor: '#fc4000',
    justifyContent: 'center',
    alignItems: 'center',
  },
};

export default OrderPage;
