import React, {Component} from 'react';
import {View, Text, Image, Dimensions} from 'react-native';
import AsyncStorage from '@react-native-community/async-storage';
import {connect} from 'react-redux';
// import {RtcEngineEvents} from 'react-native-agora/lib/RtcEvents';
// import RtcEngine from 'react-native-agora';
// import {RtcChannel} from 'react-native-agora';
import Touch from '../components/Touch';
import PhoneModal from '../components/PhoneModal';
import VerifyCodeModal from '../components/VerifyCodeModal';
import OrderDetailsModal from '../components/OrderDetailsModal';
import delay from '../utils/delay';
import Speech from '../utils/Speech';
import WxFacepay from '../utils/WxFacepay';
import phone from '../assets/Vertical/phone.png';
// import log from './engine.log';

const {width} = Dimensions.get('screen');

class FacePage extends Component {
  state = {
    phoneModal: false, // 显示输入电话号码弹窗
    verifyCodeModal: false, // 显示输入验证码弹窗
    orderDetailsModal: false, // 显示订单详情弹窗
    goodsArr: [],
    talkCall: 2, // 0请求通话，1通话中，2，已挂断通话
    contact: '',
    storeName: '',
    customerPhone: '',
    current: 1,
  };

  async componentWillMount() {
    this.storeKey = await AsyncStorage.getItem('KEY');
    let contact = await AsyncStorage.getItem('CONTACT');
    let storeName = await AsyncStorage.getItem('NAME');
    this.setState({
      contact,
      storeName,
    });
    if (!this.init) {
      this.init = await WxFacepay.init();
    }
  }

  async componentDidMount() {
    this.listen();
    // this.setAgoreEventListener();
  }

  onSubmit = async phone => {
    const res = await this.props.dispatch({
      type: 'store/sendsms',
      phone,
    });
    if (res.code === 1) {
      if (/^\d+$/.test(res.msg)) {
        Speech.speak(res.msg.split('').join(' '));
      } else {
        Speech.speak('请输入验证码');
      }
      this.phone = phone;
      this.setState({
        phoneModal: false,
        verifyCodeModal: true,
      });
    } else {
      Speech.speak(res.msg);
    }
  };

  onCodeSubmit = async code => {
    const res = await this.props.dispatch({
      type: 'store/verifysms',
      code,
      phone: this.phone,
      userId: this.userId,
    });
    if (res.code === 1) {
      this.setState({
        verifyCodeModal: false,
      });
      const ret = await this.props.dispatch({
        type: 'store/wxdoor',
        userId: res.data,
      });
      this.handleDoorLogin(ret);
    } else {
      Speech.speak(res.msg);
    }
  };

  handleClose = () => {
    this.setState({
      phoneModal: false,
    });
  };

  handleCodeClose = () => {
    this.setState({
      verifyCodeModal: false,
    });
  };

  handleOrderClose = () => {
    // clearInterval(this.noTalkCall);
    this.setState({
      orderDetailsModal: false,
      // talkCall: 2,
    });
  };

  listen = async () => {
    try {
      while (!window.socket) {
        await delay(1000);
      }
      if (!window.socket.hasListeners('doorLogin')) {
        // 扫码验证成功
        window.socket.on('doorLogin', this.handleDoorLogin);
      }
      if (!window.socket.hasListeners('scale')) {
        // 重力感应变化
        window.socket.on('scale', this.handleScaleChange);
      }
      // if (!window.socket.hasListeners('talkCall')) {
      //   // 语音通话中
      //   window.socket.on('talkCall', this.handleTalkCall);
      //   // window.socket.on('talkCall', ({code, id, number, channel, device}) => {
      //   //   console.log(code, id, number, channel, device);
      //   //   if (code === 1) {
      //   //     this.setState({
      //   //       talkCall: 0,
      //   //     });
      //   //   } else if (code === 2) {
      //   //     this.setState({
      //   //       talkCall: 1,
      //   //     });
      //   //   }
      //   //   console.warn(code, id, number, channel, device);
      //   // });
      // }

      // const {data} = await this.props.dispatch({
      //   type: 'store/agora',
      // });
      // console.warn(data);
      // config.appid = data.appid;
      // if (!this.engine) {
      //   this.engine = await RtcEngine.create(config);
      // }
      // console.log(data);
      // if (!this.engine) {
      //   this.engine = await RtcEngine.create(data.appid);
      // }
      // // await this.engine.setLogFile('/engine.log'); //设置日志文件
      // // await this.engine.setLogFileSize(1024); //指定 SDK 输出日志文件的内存大小，单位为 KB
      // await this.engine.disableVideo(true); // 关闭视频模块
      // await this.engine.enableLocalAudio(false); //调用 enableLocalAudio(false) 关闭本地采集后，系统会走媒体音量
      // await this.engine.muteAllRemoteAudioStreams(false); //停止/恢复接收所有音频流。
      // await this.engine.setDefaultMuteAllRemoteAudioStreams(false); // 设置是否默认接收音频流
      // await this.engine.setDefaultMuteAllRemoteVideoStreams(true); // 设置是否默认接收视频流
      // await this.engine.disableVideo(); //关闭视频模块
      // await this.engine.setAudioProfile(4, 3); //设置音频编码配置
      // await this.engine.adjustPlaybackSignalVolume(400); //调节本地播放的所有远端用户音量
      // await this.engine.adjustAudioMixingPlayoutVolume(100); //调节音乐文件的本地播放音量
      // await this.engine.setDefaultAudioRoutetoSpeakerphone(true); //默认从外放（扬声器）出声

      // this.engine.addListener('Warning', data => {
      //   console.log('Warning' + data);
      // });
      // this.engine.addListener('Error', data => {
      //   console.log('Error' + data);
      // });
      // this.engine.addListener('JoinChannelSuccess', data => {
      //   console.warn('JoinChannelSuccess');
      //   console.warn(data);
      // });
    } catch (e) {
      console.log(e);
    }
  };

  // handleTalkCall = async () => {
  //   try {
  //     // const {talkCall} = this.state;
  //     // 加入语音通话
  //     clearInterval(this.noTalkCall);
  //     const {data} = await this.props.dispatch({
  //       type: 'store/agora',
  //     });
  //     console.log(data);
  //     if (!this.engine) {
  //       this.engine = await RtcEngine.create(data.appid);
  //       // await this.engine.setLogFile('./engine.log'); //设置日志文件
  //       // await this.engine.setLogFileSize(1024); //指定 SDK 输出日志文件的内存大小，单位为 KB
  //     }
  //     this.engine.createRtcChannel(data.channel);
  //     this.engine.addListener('Warning', data => {
  //       console.log('Warning' + data);
  //     });
  //     this.engine.addListener('Error', data => {
  //       console.log('Error' + data);
  //     });
  //     this.engine.addListener('JoinChannelSuccess', data => {
  //       console.warn('JoinChannelSuccess');
  //       console.warn(data);
  //     });
  //     RtcChannel.joinChannel(data.token, null, 99, {
  //       autoSubscribeAudio: true,
  //       autoSubscribeVideo: false,
  //     }); //Join Channel
  //     RtcChannel.enableAudio();
  //     // await this.engine.disableVideo(true); // 关闭视频模块
  //     // await this.engine.enableLocalAudio(false); //调用 enableLocalAudio(false) 关闭本地采集后，系统会走媒体音量
  //     // await this.engine.muteAllRemoteAudioStreams(false); //停止/恢复接收所有音频流。
  //     // await this.engine.setDefaultMuteAllRemoteAudioStreams(false); // 设置是否默认接收音频流
  //     // await this.engine.setDefaultMuteAllRemoteVideoStreams(true); // 设置是否默认接收视频流
  //     // await this.engine.disableVideo(); //关闭视频模块
  //     // await this.engine.setAudioProfile(4, 3); //设置音频编码配置
  //     // await this.engine.adjustPlaybackSignalVolume(400); //调节本地播放的所有远端用户音量
  //     // await this.engine.adjustAudioMixingPlayoutVolume(100); //调节音乐文件的本地播放音量
  //     // await this.engine.setDefaultAudioRoutetoSpeakerphone(true); //默认从外放（扬声器）出声
  //     //
  //     // // await this.engine.addHandler();  //添加主回调事件
  //     // await this.engine.enableWebSdkInteroperability(true); //打开与webSDK的互通
  //     // await this.engine.setChannelProfile(0);
  //     // await this.engine.setClientRole(1); //设置为主播角色
  //     // // await this.engine.enableAudio();
  //     // await this.engine.joinChannel(data.token, data.channel, null, 99);
  //     // // await this.engine.setEnableSpeakerphone(true); //切换到外放
  //     // if (!(await this.engine.isSpeakerphoneEnabled())) {
  //     //   console.warn(await this.engine.setEnableSpeakerphone(true));
  //     //   await this.engine.setEnableSpeakerphone(true); //切换到外放
  //     // }
  //     // console.warn(await this.engine.getCallId());
  //     this.setState({
  //       talkCall: 1,
  //     });
  //   } catch (e) {
  //     console.log(e);
  //   }
  // };

  //设置事件监听
  // setAgoreEventListener = () => {
  //   RtcEngine.Warning();
  //   RtcEngine.Error();
  //   RtcEngine.ApiCallExecuted();
  //   RtcEngine.JoinChannelSuccess();
  //   RtcEngine.LeaveChannel();
  //   // this.engine.addListener('Error');
  //   // this.engine.addListener('JoinChannelSuccess', res => {
  //   //   console.warn('JoinChannelSuccess' + res);
  //   // });
  //   //成功加入房间
  //   // this.engine.onJoinChannelSuccess = (channel, uid, elapsed) => {
  //   //   console.warn(`成功加入房间,频道号:${channel}+uid+${uid}`);
  //   // };
  //   //
  //   // //监听是否有新用户加入
  //   // this.engine.onUserJoined = (uid, elapsed) => {
  //   //   console.warn(`新用户所加入的id为:${uid}`);
  //   // };
  //   //
  //   // //监听用户是否离开这个房间
  //   // this.engine.onUserOffline = (uid, reason) => {
  //   //   console.warn(`用户离开的id为:${uid}`);
  //   // };
  //   //
  //   // //监听用户是否离开这个频道
  //   // this.engine.onLeaveChannel = () => {
  //   //   console.warn('用户离开');
  //   // };
  // };

  // leaveC = async () => {
  //   const {data} = await this.props.dispatch({
  //     type: 'store/agora',
  //   });
  //   if (!this.engine) {
  //     this.engine = await RtcEngine.create(data.appid);
  //   }
  //   // if (this.engine) {
  //   console.warn('121212');
  //   await this.engine.leaveChannel();
  //   // }
  // };

  // device 代表当前打开的门
  handleScaleChange = ({count}) => {
    console.warn(count);
    if (count === -1) {
      // 重力感应开始识别
      this.wechatFace();
    } else if (count === 0) {
      // 重力感应归零
      // clearInterval(this.noTalkCall);
      // if (!this.engine) {
      //   this.engine.leaveChannel();
      // }
      this.setState({
        orderDetailsModal: false,
        phoneModal: false,
        verifyCodeModal: false,
        current: 1,
      });
    }
  };

  handleDoorLogin = async ret => {
    if (ret) {
      if (ret.code < 0 || ret.code === 401) {
        // 未授权，提示用户扫码验证
        let tipText = ret.msg;
        Speech.speak(tipText);
        this.userId = ret.userId;
        if (ret.code === 401) {
          // 需要验证手机号
          this.setState({phoneModal: true});
          this.handleScaleChange({count: 0});
        } else if (ret.orders) {
          let goodsArr = [];
          ret.orders.map(v1 => {
            v1.goods.map(v2 => {
              goodsArr.push(v2);
            });
          });
          this.setState({
            orderDetailsModal: true,
            goodsArr,
            customerPhone: ret.phone || '0000',
            current: 1,
          });
        }
      } else if (ret.msg) {
        let tipText = ret.msg.replace(/扫码/g, '人脸识别');
        Speech.speak(tipText);
      }
    } else {
      Speech.speak('正在重新识别，请靠中间站稳');
    }
  };

  authinfo = async () => {
    const rawdata = await WxFacepay.rawdata();
    const {data} = await this.props.dispatch({
      type: 'goods/faceinfo',
      rawdata,
    });
    return data;
  };

  // 微信人脸身份识别
  wechatFace = async () => {
    if (this.state.orderDetailsModal) {
      return;
    } // 出现订单弹窗，不做人脸识别
    const tipText = '正在人脸识别，请看向屏幕，靠中间站稳';
    Speech.speak(tipText);
    let auth = (await this.authinfo()) || {};
    console.warn(auth);
    if (
      auth.return_code === 'SUCCESS' ||
      (auth.code === 1 && auth.data.bizCode === '0000')
    ) {
      if (auth.data) {
        auth = auth.data;
      }
      const params = {
        appid: auth.appid || auth.subAppId,
        mch_id: auth.mch_id || auth.subMchId,
        store_id: this.storeKey,
        authinfo: auth.authinfo || auth.authInfo,
        face_authtype: 'FACEID-ONCE',
        ask_unionid: 1,
      };
      let res = (await WxFacepay.faceinfo(params)) || {};
      console.warn(res);
      if (window.socket) {
        window.socket.connect();
      } // 返回结果，立即重新连接socket
      if (!res.openid) {
        return;
      } // 没识别到人脸不开门
      if (res.sub_openid) {
        res.openid = res.sub_openid;
      }
      const ret = await this.props.dispatch({
        type: 'store/wxdoor',
        openid: res.openid,
        wxtoken: res.token,
        nickname: res.nickname,
      });
      this.handleDoorLogin(ret);
    }
  };

  // 语音通话请求
  // onCall = async () => {
  //   // const {data} = await this.props.dispatch({
  //   //   type: 'store/agora',
  //   // });
  //   // const engine = await RtcEngine.create(data.appid);
  //   // await engine.joinChannel(data.token, data.channel, null, 0);
  //   // this.noTalkCall = setInterval(async () => {
  //   //   await this.props.dispatch({
  //   //     type: 'store/talkCall',
  //   //   });
  //   // }, 10000);
  //   Speech.speak('正在接通中请稍候');
  //   this.talkCall();
  //   clearInterval(this.noTalkCall);
  //   this.noTalkCall = setInterval(() => this.talkCall(), 10000);
  //   this.setState({
  //     talkCall: 0,
  //   });
  // };

  talkCall = () => {
    this.props.dispatch({
      type: 'store/talkCall',
    });
  };

  dropUp = () => {
    let {current} = this.state;
    if (current > 1) {
      this.setState({
        current: --current,
      });
    }
  };

  dropDown = goodsLength => {
    let {current} = this.state;
    if (current < goodsLength) {
      this.setState({
        current: ++current,
      });
    }
  };

  render() {
    const {
      verifyCodeModal,
      phoneModal,
      orderDetailsModal,
      goodsArr,
      talkCall,
      storeName,
      contact,
      customerPhone,
      current,
    } = this.state;
    let {dispatch} = this.props;
    return (
      <View style={styles.content}>
        <PhoneModal
          visible={phoneModal}
          transparent
          // maskClosable
          onClose={this.handleClose}
          onRequestClose={this.handleClose}
          onSubmit={this.onSubmit}
        />
        <VerifyCodeModal
          visible={verifyCodeModal}
          transparent
          // maskClosable
          onClose={this.handleCodeClose}
          onRequestClose={this.handleCodeClose}
          onSubmit={this.onCodeSubmit}
        />
        <OrderDetailsModal
          visible={orderDetailsModal}
          transparent
          maskClosable
          onClose={this.handleOrderClose}
          onRequestClose={this.handleOrderClose}
          onCall={this.onCall}
          dropUp={this.dropUp}
          dropDown={this.dropDown}
          goodsArr={goodsArr}
          dispatch={dispatch}
          talkCall={talkCall}
          customerPhone={customerPhone}
          current={current}
        />
        <View style={styles.header}>
          <View style={styles.title}>
            <View style={styles.left}>
              <Image
                source={require('../assets/logo2.png')}
                style={styles.img}
              />
              <Text style={styles.text}>{storeName}</Text>
            </View>
            <View style={styles.right}>
              <Text style={styles.text}>{contact}</Text>
              <Image style={styles.phone} source={phone} />
            </View>
          </View>
          <View style={styles.headline}>
            <Text style={styles.headTitle}>刷脸开门系统</Text>
          </View>
        </View>
        <View style={styles.face}>
          <Touch
            onPress={this.wechatFace}
            style={styles.faceGif}
            feedback={false}>
            <Image
              source={require('../assets/Vertical/face.gif')}
              style={{flex: 1, width}}
            />
          </Touch>
          <Touch
            onPress={this.wechatFace}
            style={styles.btnCome}
            feedback={false}>
            <View style={styles.click}>
              <Image
                source={require('../assets/wxpay.png')}
                style={styles.wxpay}
              />
              <Text style={styles.clickText}>点击进入</Text>
              <Image source={require('../assets/up.png')} style={styles.up} />
              <Text style={styles.clickText}>刷脸开门</Text>
            </View>
          </Touch>
        </View>
        <View style={styles.onCall}>
          <Image
            source={require('../assets/call.gif')}
            style={styles.callGif}
          />
          <Text style={styles.callText}>呼叫客服</Text>
        </View>
        {/*{talkCall === 1 ? (*/}
        {/*  <Touch onPress={this.leaveC} style={styles.footer} feedback={false}>*/}
        {/*    <View style={styles.call}>*/}
        {/*      <Image*/}
        {/*        source={require('../assets/call.gif')}*/}
        {/*        style={styles.callGif}*/}
        {/*      />*/}
        {/*      <Text style={styles.onCallText}>正在语音通话中</Text>*/}
        {/*    </View>*/}
        {/*  </Touch>*/}
        {/*) : talkCall === 0 ? (*/}
        {/*  <View style={styles.onCall}>*/}
        {/*    <Image*/}
        {/*      source={require('../assets/call.gif')}*/}
        {/*      style={styles.callGif}*/}
        {/*    />*/}
        {/*    <Text style={styles.onCallText}>正在接通中请稍候...</Text>*/}
        {/*  </View>*/}
        {/*) : (*/}
        {/*  <Touch onPress={this.onCall} style={styles.footer} feedback={false}>*/}
        {/*    <View style={styles.call}>*/}
        {/*      <Image*/}
        {/*        source={require('../assets/call.gif')}*/}
        {/*        style={styles.callGif}*/}
        {/*      />*/}
        {/*      <Text style={styles.callText}>呼叫客服</Text>*/}
        {/*    </View>*/}
        {/*  </Touch>*/}
        {/*)}*/}
      </View>
    );
  }
}

const styles = {
  content: {
    flex: 1,
    alignItems: 'center',
    backgroundColor: '#fff',
  },
  header: {
    flex: 0.2,
    // backgroundColor: '#00CD66',
    backgroundColor: 'rgb(0,205,102)',
    width: '100%',
    flexDirection: 'column',
  },
  title: {
    flexDirection: 'row',
    justifyContent: 'space-between',
    marginLeft: 30,
    marginRight: 30,
    marginTop: 10,
  },
  headline: {
    flexDirection: 'row',
    justifyContent: 'center',
    alignItems: 'center',
    flex: 1,
    marginBottom: 20,
  },
  headTitle: {
    fontSize: 60,
    color: '#fff',
  },
  left: {
    flexDirection: 'row',
    alignItems: 'center',
  },
  right: {
    flexDirection: 'row-reverse',
    alignItems: 'center',
  },
  img: {
    width: 60,
    height: 60,
    marginRight: 10,
    resizeMode: 'contain',
  },
  text: {
    color: '#FFFFFF',
    fontSize: 40,
  },
  face: {
    flex: 0.6,
    width: '100%',
    flexDirection: 'column',
    alignItems: 'center',
    justifyContent: 'space-around',
  },
  faceGif: {
    flex: 0.7,
  },
  btnCome: {
    flex: 0.15,
    // backgroundColor: '#00CD66',
    backgroundColor: 'rgb(0,205,102)',
    width: '80%',
    borderRadius: 30,
    flexDirection: 'row',
    alignItems: 'center',
    justifyContent: 'center',
    elevation: 2,
  },
  click: {
    flexDirection: 'row',
  },
  clickText: {
    fontSize: 50,
    color: '#fff',
    marginTop: 25,
  },
  wxpay: {
    width: 72,
    height: 65,
    marginTop: 30,
    marginRight: 10,
  },
  up: {
    width: 100,
    height: 120,
  },
  phone: {
    width: 40,
    height: 40,
    marginRight: 10,
    resizeMode: 'contain',
  },
  footer: {
    flex: 0.2,
    width: '100%',
    // backgroundColor: '#44c571',
    backgroundColor: 'rgb(68, 197, 114)',
  },
  call: {
    felx: 1,
    flexDirection: 'row',
    alignItems: 'center',
    justifyContent: 'center',
  },
  callGif: {
    width: 350,
    height: 240,
    marginLeft: -120,
  },
  callText: {
    fontSize: 70,
    color: '#fff',
    marginLeft: -50,
  },
  onCall: {
    flex: 0.2,
    width: '100%',
    // backgroundColor: '#44c571',
    backgroundColor: 'rgb(68, 197, 114)',
    flexDirection: 'row',
    justifyContent: 'center',
    alignItems: 'center',
  },
  onCallText: {
    fontSize: 70,
    color: '#fff',
    marginLeft: -70,
  },
};

export default connect(({store}) => ({store}))(FacePage);
