import React, {Component} from 'react';
import {StyleSheet, View} from 'react-native';

class ModalView extends Component {
  render() {
    const {visible, children} = this.props;
    return visible ? (
      <View style={styles.modal} visible={visible}>
        {children}
      </View>
    ) : null;
  }
}

const styles = StyleSheet.create({
  modal: {
    position: 'absolute',
    top: 0,
    right: 0,
    bottom: 0,
    left: 0,
    justifyContent: 'center',
    alignItems: 'center',
    backgroundColor: 'rgba(0, 0, 0, 0.3)',
    // backgroundColor: 'transparent',
    zIndex: 999,
  },
});

export default ModalView;
