import {NativeModules} from 'react-native';

const timeout = ms =>
  new Promise(resolve => {
    setTimeout(() => resolve(false), ms);
  });

const init = options =>
  new Promise(resolve => {
    if (options && NativeModules.WxFacepay.initOptions)
      NativeModules.WxFacepay.initOptions(options).then(resolve);
    else NativeModules.WxFacepay.init().then(resolve);
  });

NativeModules.WxFacepay.initialize = (ms, options) => {
  return Promise.race([init(options), timeout(ms)]);
};

// delete NativeModules.WxFacepay.getUserPayScoreStatus; // 测试刷脸支付分兼容问题

export default NativeModules.WxFacepay;
