import {Dimensions} from 'react-native';
import AsyncStorage from '@react-native-community/async-storage';
import admin from './admin';
import goods from './goods';
import alipay from './alipay';
import wxpay from './wxpay';
import order from './order';
import hkvs from './hkvs';
import user from './user';
import store from './store';

const {width: _width, height: _height} = Dimensions.get('window');

let curRoute = 'home';
if (_height > _width) {
  curRoute = 'vertical';
}

const initRoute = {route: curRoute};
const app = {
  namespace: 'app',
  state: {
    current: initRoute,
    history: [initRoute],
    step: 1,
    lock: false,
  },
  reducers: {
    replace(state, {route, params}) {
      const current = {route, params};
      state.current = current;
      state.history[state.history.length - 1] = current;
      return {...state};
    },
    push(state, {route, params}) {
      const current = {route, params};
      state.current = current;
      state.history.push(current);
      return {...state};
    },
    back(state, {params}) {
      if (state.history.length === 1) {
        return {...state};
      }
      state.history.pop();
      state.current = state.history[state.history.length - 1];
      state.current.params = params;
      return {...state};
    },
    step(state, {step}) {
      state.step = step;
      return {...state};
    },
    lock(state, {lock}) {
      state.lock = lock;
      if (lock) {
        AsyncStorage.setItem('settingLock', 'true');
      } else {
        AsyncStorage.removeItem('settingLock');
      }
      return {...state};
    },
  },
};

export default [app, admin, goods, alipay, wxpay, order, hkvs, user, store];
