import axios from 'axios';
import qs from 'qs';

export function getGoods(barcode) {
  return axios.get(`/store/goods/${barcode}`);
}

export function getBags() {
  return axios.get('/store/goods/bags');
}

export function barcodepay({ids, code, facepay, noBarcode}) {
  return axios.post(
    '/store/goods/barcodepay',
    qs.stringify({ids, code, facepay, noBarcode}),
  );
}

export function barcodeUser({userId, alipayUserId, orderId}) {
  return axios.post(
    '/store/goods/barcode/user',
    qs.stringify({userId, alipayUserId, orderId}),
  );
}

export function status({orderId}) {
  return axios.post('/store/goods/status', qs.stringify({orderId}));
}

export function postOrder(ids, payType) {
  payType = payType ? `/${payType}` : '';
  return axios.post(`/api/orders${payType}`, qs.stringify({ids}));
}

export function getOrder(id) {
  return axios.get(`/api/orders/${id}`);
}

export function canOrder(orderId) {
  return axios.put('/api/orders/cancel', qs.stringify({orderId}));
}

export function faceinfo({rawdata}) {
  return axios.post('/store/goods/faceinfo', qs.stringify({rawdata}));
}

export function wxauthinfo(action) {
  return axios.post('/common/wxpay/faceAuth', action);
}
