import React, {Component} from 'react';
import {Image, Text, View} from 'react-native';

class HomeLayout extends Component {
  render() {
    return (
      <View style={styles.container}>
        <View style={styles.title}>
          <Image
            style={styles.titleImg}
            source={require('../assets/logo2.png')}
            resizeMode="contain"
          />
          <Image
            style={{marginLeft: 20}}
            source={require('../assets/Vertical/24h.png')}
          />
          <Text style={styles.titleText}>仲马购人工智能</Text>
        </View>
        {this.props.children}
      </View>
    );
  }
}

const styles = {
  title: {
    top: 0,
    paddingLeft: 30,
    flexDirection: 'row',
    height: 100,
    width: '100%',
    position: 'absolute',
    backgroundColor: 'white',
    alignItems: 'center',
    elevation: 10,
  },
  titleImg: {
    width: 80,
    height: 80,
  },
  titleText: {
    color: '#333',
    fontSize: 40,
    marginLeft: 30,
  },
  container: {
    flex: 1,
    backgroundColor: '#F5F5F5',
    justifyContent: 'center',
    alignItems: 'center',
  },
};

export default HomeLayout;
