import React, {Component} from 'react';
import {Image, Dimensions} from 'react-native';
import Touch from './Touch';

const {width} = Dimensions.get('screen');
const logoSize = width / 3;

class Screensaver extends Component {
  onPress = () => {
    const {onPress} = this.props;
    onPress && onPress();
  };

  render() {
    return (
      <Touch style={styles.page} onPress={this.onPress}>
        <Image style={styles.logo} source={require('../assets/logo4.png')} />
      </Touch>
    );
  }
}

const styles = {
  page: {
    flex: 1,
    backgroundColor: 'black',
    justifyContent: 'center',
    alignItems: 'center',
  },
  logo: {
    width: logoSize,
    height: logoSize,
    opacity: 0.1,
  },
};

export default Screensaver;
