import React, {Component} from 'react';
import {Modal, View, Text, Image, FlatList, Dimensions} from 'react-native';
import Icon from 'react-native-vector-icons/Ionicons';
import AsyncStorage from '@react-native-community/async-storage';
import ModalStyles from './Modal/styles';
import {font} from '../utils/common';
import Touch from './Touch';
import NP from '../utils/np';
import phone from '../assets/Vertical/phone.png';

let pageSize = 6; // 分页大小

const mStyles = {
  ...ModalStyles,
  innerContainer: {
    ...ModalStyles.innerContainer,
  },
  header: {
    ...ModalStyles.header,
    fontSize: font.title,
  },
};

class OrderDetailsModal extends Component {
  state = {
    conatct: '',
    storeName: '',
  };

  async componentWillMount() {
    let contact = await AsyncStorage.getItem('CONTACT');
    let storeName = await AsyncStorage.getItem('NAME');
    this.setState({
      contact,
      storeName,
    });
  }

  // 生成不重复的key
  keyExtractor = (item: any, index: number) => {
    return String(index);
  };

  renderHeader = () => {
    return (
      <View style={{flex: 1, flexDirection: 'column'}}>
        <View style={{backgroundColor: '#fff'}}>
          <View
            style={{
              flexDirection: 'row',
              alignItems: 'center',
              justifyContent: 'center',
            }}>
            <View style={styles.firstThStyle}>
              <Text style={styles.ThText}>商品名称</Text>
            </View>
            <View style={styles.ThStyle}>
              <Text style={styles.ThText}>单价</Text>
            </View>
            <View style={styles.ThStyle}>
              <Text style={styles.ThText}>数量</Text>
            </View>
            <View style={styles.ThStyle}>
              <Text style={styles.ThText}>金额</Text>
            </View>
          </View>
        </View>
        <View style={styles.line} />
      </View>
    );
  };

  // 显示数据
  renderCell = (item, index) => (
    <View style={index % 2 === 0 ? styles.oddCell : styles.evenCell}>
      <View style={styles.firstTdStyle}>
        <Text style={styles.TdText} numberOfLines={1}>
          {item.name}
        </Text>
      </View>
      <View style={styles.TdStyle}>
        {item.price ? (
          <Text style={styles.TdText}>
            {NP.round(item.price, 2).toFixed(2)}
          </Text>
        ) : (
          <Text style={styles.TdText}>
            {NP.round(item.prePrice, 2).toFixed(2)}
          </Text>
        )}
      </View>
      <View style={styles.TdStyle}>
        <Text style={styles.TdText}> {NP.round(item.num, 0).toFixed(0)} </Text>
      </View>
      <View style={styles.TdStyle}>
        {item.price ? (
          <Text style={styles.TdText}>
            {NP.round(item.price * item.num, 2).toFixed(2)}
          </Text>
        ) : (
          <Text style={styles.TdText}>
            {NP.round(item.prePrice * item.num, 2).toFixed(2)}
          </Text>
        )}
      </View>
    </View>
  );

  render() {
    const {
      onClose,
      goodsArr,
      talkCall,
      onCall,
      customerPhone,
      current,
      ...props
    } = this.props;
    const {contact, storeName} = this.state;
    let goodsLength = Math.ceil(parseFloat(goodsArr.length / pageSize));
    let gaTemp = goodsArr.slice((current - 1) * pageSize, current * pageSize);
    let total = 0; // 总数量
    let totalPrice = 0; // 总价
    let totalCount = 0; // 总优惠
    goodsArr.map(item => {
      // item.url = config.imgUrl + item.barcode + config.watermark;
      total += item.num;
      if (item.price) {
        totalPrice += item.price * item.num;
        totalCount += (item.prePrice - item.price) * item.num;
      } else {
        totalPrice += item.prePrice * item.num;
      }
    });
    this.totalPrice = totalPrice;
    this.totalCount = totalCount;
    let phoneText = '';
    if (customerPhone.length === 15) {
      phoneText = '用户号：' + customerPhone;
    } else {
      phoneText =
        '手机号：' +
        customerPhone.substring(0, 3) +
        '****' +
        customerPhone.substring(customerPhone.length - 4, customerPhone.length);
    }
    return (
      <Modal styles={mStyles} {...props}>
        <View style={styles.modal}>
          <View style={styles.header}>
            <View style={styles.title}>
              <View style={styles.left}>
                <Image
                  source={require('../assets/logo2.png')}
                  style={styles.img}
                />
                <Text style={styles.text}>{storeName}</Text>
              </View>
              <View style={styles.right}>
                <Touch onPress={() => onClose()}>
                  <Icon name="md-close" color={'#FFFFFF'} size={50} />
                </Touch>
                <Text style={styles.text}>{contact}</Text>
                <Image style={styles.phone} source={phone} />
              </View>
            </View>
            <View style={styles.headline}>
              <Text style={styles.headTitle}>核对订单页面</Text>
            </View>
            <View style={styles.customerPhone}>
              <Text style={styles.number}>{phoneText}</Text>
            </View>
          </View>
          {goodsArr && goodsArr.length > 0 ? (
            <View style={styles.container}>
              <View style={{flexDirection: 'row', flex: 1}}>
                <View style={{width: '90%'}}>
                  <FlatList
                    style={styles.goodsStyle}
                    ListHeaderComponent={this.renderHeader}
                    keyExtractor={this.keyExtractor}
                    horizontal={false}
                    data={gaTemp}
                    renderItem={({item, index}) => this.renderCell(item, index)}
                  />
                </View>
                <View
                  style={{
                    width: '10%',
                    flexDirection: 'column',
                  }}>
                  <View style={{height: 81, backgroundColor: '#fff'}} />
                  <View style={{height: 8}} />
                  <View style={styles.pagination}>
                    <Touch
                      disabled={current <= 1}
                      onPress={() => this.props.dropUp()}>
                      <Image
                        source={
                          current > 1
                            ? require('../assets/Vertical/arrowu01.png')
                            : require('../assets/Vertical/arrowu02.png')
                        }
                        style={styles.imgPagination}
                      />
                    </Touch>
                    <Text style={styles.paginationText}>
                      {goodsLength === 0 ? 0 : current}/{goodsLength}
                    </Text>
                    <Touch
                      disabled={current >= goodsLength}
                      onPress={() => this.props.dropDown(goodsLength)}>
                      <Image
                        source={
                          current < goodsLength
                            ? require('../assets/Vertical/arrowd01.png')
                            : require('../assets/Vertical/arrowd02.png')
                        }
                        style={styles.imgPagination}
                      />
                    </Touch>
                  </View>
                </View>
              </View>
              <View style={styles.line} />
              <View style={styles.amount}>
                <View style={styles.total}>
                  <Text style={styles.totalText}>合计</Text>
                  <Text style={styles.totalText}>
                    ￥{' '}
                    {NP.round(
                      Number(totalPrice) + Number(totalCount),
                      2,
                    ).toFixed(2)}
                  </Text>
                </View>
                <View style={styles.total}>
                  <Text style={styles.totalText}>数量</Text>
                  <Text style={styles.totalText}>
                    {NP.round(totalCount, 0).toFixed(0)}
                  </Text>
                </View>
                <View style={styles.total}>
                  <Text style={styles.totalText}>优惠</Text>
                  <Text style={styles.discount}>
                    -￥ {NP.round(totalCount, 2).toFixed(2)}
                  </Text>
                </View>
              </View>
              <View style={styles.line} />
              <View style={styles.realPay}>
                <View style={styles.total}>
                  <Text style={styles.totalText}>实付金额</Text>
                  <Text style={styles.totalText}>
                    ￥ {NP.round(totalPrice, 2).toFixed(2)}
                  </Text>
                </View>
                <View style={styles.tip}>
                  <Text style={styles.tips}>
                    ***请核对您的商品订单，将商品拿给买单的人***
                  </Text>
                </View>
              </View>
            </View>
          ) : (
            <View style={styles.container}>
              <View style={styles.emptyContainer}>
                <View style={styles.empty}>
                  <Image
                    source={require('../assets/empty.png')}
                    style={styles.emptyImg}
                  />
                </View>
                <View style={styles.empty}>
                  <Text style={styles.tips}>
                    您没有商品记录哦，请将商品拿给买单的人
                  </Text>
                </View>
              </View>
            </View>
          )}
          {talkCall === 1 ? (
            <View style={styles.onCall}>
              <Image
                source={require('../assets/call.gif')}
                style={styles.callGif}
              />
              <Text style={styles.onCallText}>正在语音通话中</Text>
            </View>
          ) : talkCall === 0 ? (
            <View style={styles.onCall}>
              <Image
                source={require('../assets/call.gif')}
                style={styles.callGif}
              />
              <Text style={styles.onCallText}>正在接通中请稍候...</Text>
            </View>
          ) : (
            <Touch
              onPress={() => onCall()}
              style={styles.footer}
              feedback={false}>
              <View style={styles.call}>
                <Image
                  source={require('../assets/call.gif')}
                  style={styles.callGif}
                />
                <Text style={styles.callText}>呼叫客服</Text>
              </View>
            </Touch>
          )}
        </View>
      </Modal>
    );
  }
}

const styles = {
  modal: {
    height: '100%',
    width: '100%',
    backgroundColor: '#fff',
    flexDirection: 'column',
    justifyContent: 'center',
    alignItems: 'center',
  },
  header: {
    flex: 0.2,
    // backgroundColor: '#00CD66',
    backgroundColor: 'rgb(0,205,102)',
    width: '100%',
    flexDirection: 'column',
    borderTopRightRadius: 10,
    borderTopLeftRadius: 10,
  },
  title: {
    flexDirection: 'row',
    justifyContent: 'space-between',
    marginLeft: 30,
    marginRight: 30,
    marginTop: 10,
    marginBottom: 10,
  },
  left: {
    flexDirection: 'row',
    alignItems: 'center',
  },
  right: {
    flexDirection: 'row-reverse',
    alignItems: 'center',
  },
  img: {
    width: 60,
    height: 60,
    marginRight: 10,
    resizeMode: 'contain',
  },
  text: {
    color: '#FFFFFF',
    fontSize: 35,
    marginRight: 30,
  },
  headline: {
    flexDirection: 'row',
    justifyContent: 'center',
    alignItems: 'center',
    flex: 1,
  },
  headTitle: {
    fontSize: 60,
    color: '#fff',
  },
  customerPhone: {
    backgroundColor: '#3CB371',
    flexDirection: 'row',
    justifyContent: 'center',
    alignItems: 'center',
    marginLeft: '5%',
    marginRight: '5%',
    marginBottom: '2%',
    paddingTop: 10,
    paddingBottom: 10,
    elevation: 3,
  },
  container: {
    flex: 0.6,
    width: '100%',
    flexDirection: 'column',
  },
  emptyContainer: {
    flex: 1,
    marginLeft: '5%',
    marginRight: '5%',
    backgroundColor: '#fff',
    flexDirection: 'column',
    justifyContent: 'center',
    alignItems: 'center',
  },
  tip: {
    flexDirection: 'row',
    justifyContent: 'center',
    alignItems: 'center',
    margin: 10,
  },
  empty: {
    flexDirection: 'row',
    margin: 10,
  },
  emptyImg: {
    width: 400,
    height: 400,
    resizeMode: 'contain',
  },
  tips: {
    fontSize: 30,
    // color: '#8B8989',
    color: 'red',
  },
  goodsStyle: {
    width: '100%',
  },
  pagination: {
    flex: 1,
    backgroundColor: '#fff',
    marginTop: '12%',
    flexDirection: 'column',
    alignItems: 'center',
    justifyContent: 'center',
  },
  paginationText: {
    fontSize: 40,
  },
  imgPagination: {
    width: 50,
    height: 50,
  },
  firstThStyle: {
    width: '40%',
    alignItems: 'flex-start',
    paddingTop: 14,
    paddingBottom: 14,
    paddingLeft: 10,
    paddingRight: 10,
    marginLeft: '10%',
  },
  ThStyle: {
    width: '20%',
    alignItems: 'center',
    paddingTop: 14,
    paddingBottom: 14,
    paddingLeft: 10,
    paddingRight: 10,
  },
  ThText: {
    fontSize: 30,
  },
  oddCell: {
    flexDirection: 'row',
    backgroundColor: '#fff',
  },
  evenCell: {
    flexDirection: 'row',
    backgroundColor: '#F0F0F0',
  },
  firstTdStyle: {
    width: '40%',
    justifyContent: 'center',
    alignItems: 'flex-start',
    paddingTop: 14,
    paddingBottom: 14,
    paddingLeft: 10,
    paddingRight: 10,
    marginLeft: '5%',
  },
  TdStyle: {
    flexDirection: 'row',
    width: '20%',
    alignItems: 'center',
    justifyContent: 'center',
    paddingTop: 14,
    paddingBottom: 14,
    paddingLeft: 10,
    paddingRight: 10,
  },
  TdText: {
    fontSize: 20,
  },
  amount: {
    flexDirection: 'column',
    height: '25%',
    backgroundColor: '#FFF',
    marginLeft: '2%',
    marginRight: '2%',
  },
  total: {
    flexDirection: 'row',
    justifyContent: 'space-between',
    alignItems: 'center',
    marginLeft: 30,
    marginRight: 30,
    marginTop: 15,
  },
  totalText: {
    fontSize: 30,
  },
  discount: {
    fontSize: 30,
    color: 'red',
  },
  line: {
    width: '100%',
    borderWidth: 1,
    borderColor: '#ddd',
    height: 1,
  },
  realPay: {
    flexDirection: 'column',
    height: '16%',
    backgroundColor: '#FFF',
    marginLeft: '2%',
    marginRight: '2%',
  },
  footer: {
    flex: 0.2,
    width: '100%',
    // backgroundColor: '#44c571',
    backgroundColor: 'rgb(68,197,113)',
  },
  phone: {
    width: 40,
    height: 40,
    marginRight: 10,
    resizeMode: 'contain',
  },
  number: {
    color: '#FFFFFF',
    fontSize: 30,
    marginRight: 30,
  },
  call: {
    felx: 1,
    flexDirection: 'row',
    justifyContent: 'center',
    alignItems: 'center',
  },
  callGif: {
    width: 350,
    height: 240,
    marginLeft: -120,
  },
  callText: {
    fontSize: 70,
    color: '#fff',
    marginLeft: -50,
  },
  onCall: {
    flex: 0.2,
    width: '100%',
    // backgroundColor: '#44c571',
    backgroundColor: 'rgb(68,197,113)',
    flexDirection: 'row',
    justifyContent: 'center',
    alignItems: 'center',
  },
  onCallText: {
    fontSize: 70,
    color: '#fff',
    marginLeft: -70,
  },
};

export default OrderDetailsModal;
