import React from 'react';
import {Dimensions, Image, Text, View} from 'react-native';
import {imgUrl} from '../utils/config';
// import Touch from './Touch';
import {setSpText} from '../utils/screen';

const {width, height} = Dimensions.get('window');

export default class GoodsList extends React.Component {
  state = {
    num: 0,
  };
  render() {
    let {goodsArr} = this.props;
    let {num} = this.state;
    return (
      <View style={styles.goodsBox}>
        {goodsArr.length > 0 &&
          goodsArr.map(v => {
            return (
              <View style={styles.goodsItem}>
                <View style={styles.goodsImg}>
                  <Image
                    style={styles.img}
                    source={{uri: `${imgUrl}${v.image}`}}
                  />
                </View>
                <Text style={styles.goodsName}>{v.name}</Text>
                <Text style={styles.goodsPrice}>￥{v.prePrice}</Text>
                <View style={styles.goodsNum}>
                  <View style={num > 0 ? styles.goodsSub : styles.display}>
                    <Image
                      style={styles.img}
                      source={require('../assets/Order/subtract.png')}
                    />
                  </View>
                  <Text style={num > 0 ? styles.goodsNums : styles.display}>
                    {num}
                  </Text>
                  <View style={styles.goodsAdd}>
                    <Image
                      style={styles.img}
                      source={require('../assets/Order/add.png')}
                    />
                  </View>
                </View>
              </View>
            );
          })}
      </View>
    );
  }
}

const styles = {
  goodsBox: {
    width: width * 0.85,
    flexDirection: 'row',
    flexWrap: 'wrap',
  },
  goodsItem: {
    width: width * 0.85 * 0.3333,
    height: height * 0.8 * 0.31,
    alignItems: 'center',
    borderBottomWidth: 1,
    borderBottomColor: '#ccc',
    borderRightWidth: 1,
    borderRightColor: '#ccc',
  },
  goodsImg: {
    width: width * 0.85 * 0.3333 * 0.95,
    height: width * 0.85 * 0.3333 * 0.8,
    marginTop: 10,
  },
  goodsName: {
    width: width * 0.85 * 0.3333 * 0.95,
    height: 40,
    lineHeight: 50,
    fontSize: setSpText(30),
  },
  goodsPrice: {
    width: width * 0.85 * 0.3333 * 0.9,
    height: 25,
    textAlign: 'right',
    paddingRight: 20,
    marginTop: 5,
    marginBottom: 5,
    color: '#e21918',
    fontSize: setSpText(20),
  },
  goodsNum: {
    width: width * 0.85 * 0.3333 * 0.9,
    height: 50,
    flexDirection: 'row',
    justifyContent: 'space-between',
  },
  goodsSub: {
    width: 50,
    height: 50,
    borderRadius: 50,
    backgroundColor: '#fc4000',
  },
  img: {
    width: '100%',
    height: '100%',
  },
  goodsNums: {
    width: 50,
    height: 50,
    textAlign: 'center',
    fontSize: 40,
  },
  goodsAdd: {
    width: 50,
    height: 50,
    borderRadius: 50,
    backgroundColor: '#fc4000',
  },
  display: {
    display: 'none',
  },
};
