import React from 'react';
import {Image, Modal, Text, View} from 'react-native';
import Touch from '../Touch';
import call from '../../assets/Vertical/call.png';
import {scaleSize, width} from '../../utils/screen';

class HintPhone extends React.Component {
  render() {
    let {visible, contact, closeHint} = this.props;
    return (
      <Modal visible={visible} transparent>
        <View style={{flex: 1, justifyContent: 'center', alignItems: 'center'}}>
          <Touch
            style={{
              width: '100%',
              height: '100%',
              backgroundColor: 'rgba(0, 0, 0, .5)',
              position: 'absolute',
              top: 0,
              left: 0,
            }}
            onPress={closeHint}>
            <View />
          </Touch>
          <View style={styles.HintPhone}>
            <View style={{backgroundColor: '#ccc', padding: 0}}>
              <Image
                style={{
                  width: width > 801 ? width * 0.2 : width * 0.4,
                  height: width > 801 ? width * 0.17 : width * 0.34,
                }}
                resizeMode="contain"
                source={call}
              />
            </View>
            <Text
              style={{
                fontSize: scaleSize(width > 801 ? width * 0.02 : width * 0.04),
              }}>
              正在呼叫客服
            </Text>
            <View style={{display: 'flex', marginTop: 10}}>
              <Text
                style={{
                  fontSize: scaleSize(
                    width > 801 ? width * 0.015 : width * 0.03,
                  ),
                  color: '#FC4000',
                }}>
                客服长时间未接通，可拨打电话: {contact}
              </Text>
            </View>
            <Touch onPress={closeHint}>
              <View
                style={{
                  width: scaleSize(width > 801 ? width * 0.12 : width * 0.24),
                  height: scaleSize(width > 801 ? width * 0.05 : width * 0.1),
                  borderRadius: 100,
                  backgroundColor: '#fc4000',
                  marginTop: 20,
                  display: 'flex',
                  justifyContent: 'center',
                  alignItems: 'center',
                }}>
                <Text
                  style={{
                    color: '#ffffff',
                    fontSize: scaleSize(
                      width > 801 ? width * 0.016 : width * 0.032,
                    ),
                  }}>
                  关闭弹窗
                </Text>
              </View>
            </Touch>
          </View>
        </View>
      </Modal>
    );
  }
}

const styles = {
  HintPhone: {
    width: width > 801 ? width * 0.5 : width * 0.8,
    height: width > 801 ? width * 0.35 : width * 0.55,
    backgroundColor: '#ffffff',
    display: 'flex',
    justifyContent: 'center',
    alignItems: 'center',
    opacity: 40,
  },
};

export default HintPhone;
