import React, {Component} from 'react';
import {View, Text, Image} from 'react-native';
import AsyncStorage from '@react-native-community/async-storage';
import {connect} from 'react-redux';
// import RtcEngine from 'react-native-agora';
import Touch from '../components/Touch';
import PhoneModal from '../components/PhoneModal';
import VerifyCodeModal from '../components/VerifyCodeModal';
import OrderDetailsModal from '../components/OrderDetailsModal';
import TipsModal from '../components/TipsModal';
import LoadingModal from '../components/LoadingModal';
import delay from '../utils/delay';
import Speech from '../utils/Speech';
import WxFacepay from '../utils/WxFacepay';
import Smilepay from '../utils/Smilepay';
import phone from '../assets/Vertical/phone.png';
import {onTalkCall, leaveTalkCall} from '../utils/agora';
import Toast from '../components/Toast';
import Screensaver from '../components/Screensaver';
import {width, setSpText, scaleSize} from '../utils/screen';

class FacePage extends Component {
  state = {
    phoneModal: false, // 显示输入电话号码弹窗
    verifyCodeModal: false, // 显示输入验证码弹窗
    orderDetailsModal: false, // 显示订单详情弹窗
    goodsArr: [],
    talkCall: 2, // 0请求通话，1通话中，2，已挂断通话，待机状态
    contact: '',
    storeName: '',
    customerPhone: '',
    current: 1,
    tip: '',
    tipsModal: false,
    faceType: 'wxpay',
    sleep: true,
    loadingModal: false,
  };

  async componentWillMount() {
    this.storeKey = await AsyncStorage.getItem('KEY');
    let contact = await AsyncStorage.getItem('CONTACT');
    let storeName = await AsyncStorage.getItem('NAME');
    this.setState({contact, storeName});
    if (!this.init) {
      this.init = await WxFacepay.initialize(10000);
      if (!this.init) {
        // 微信刷脸失败，启动支付宝刷脸
        this.init = true;
        this.setState({faceType: 'alipay'});
      }
    }
  }

  async componentDidMount() {
    this.listen();
  }

  onSubmit = async _phone => {
    const res = await this.props.dispatch({
      type: 'store/sendsms',
      phone: _phone,
      faceType: this.state.faceType,
    });
    if (res.code === 1) {
      if (/^\d+$/.test(res.msg)) {
        Speech.speak(res.msg.split('').join(' '));
      } else {
        Speech.speak('请输入验证码');
      }
      this.phone = _phone;
      this.setState({
        loadingModal: false,
        phoneModal: false,
        verifyCodeModal: true,
      });
    } else {
      Speech.speak(res.msg);
    }
  };

  onCodeSubmit = async code => {
    const res = await this.props.dispatch({
      type: 'store/verifysms',
      code,
      phone: this.phone,
      userId: this.userId,
      faceType: this.state.faceType,
    });
    if (res.code === 1) {
      this.setState({
        verifyCodeModal: false,
      });
      this.loading(true);
      const ret = await this.props.dispatch({
        type: 'store/wxdoor',
        userId: res.data,
      });
      this.loading(false);
      this.handleDoorLogin(ret);
    } else {
      Speech.speak(res.msg);
    }
  };

  handleOrderClose = () => {
    this.setState({
      orderDetailsModal: false,
    });
  };

  listen = async () => {
    try {
      while (!window.socket) {
        await delay(1000);
      }
      if (!window.socket.hasListeners('doorLogin')) {
        // 扫码验证成功
        window.socket.on('doorLogin', this.handleDoorLogin);
      }
      if (!window.socket.hasListeners('doorOpen')) {
        // 按钮开门事件
        window.socket.on('doorOpen', this.doorOpen);
      }
      if (!window.socket.hasListeners('scale')) {
        // 重力感应变化
        window.socket.on('scale', this.handleScaleChange);
      }
      if (!window.socket.hasListeners('talkCall')) {
        // 语音通话中
        window.socket.on('talkCall', this.handleTalkCall);
      }
      if (!window.socket.hasListeners('talkLeave')) {
        // 断开语音通话
        window.socket.on('talkLeave', this.leaveC);
      }
    } catch (e) {
      console.log(e);
    }
  };

  doorOpen = () => {
    this.loading(false);
    this.wakeUp();
  };

  handleTalkCall = async () => {
    try {
      // 加入语音通话
      clearInterval(this.noTalkCall);
      clearInterval(this.callTimeout);
      const {data} = await this.props.dispatch({
        type: 'agora/agora',
      });
      await onTalkCall(data);
      await this.setState({
        talkCall: 1,
      });
    } catch (e) {
      console.log(e);
    }
  };

  leaveC = async () => {
    try {
      clearInterval(this.noTalkCall);
      clearInterval(this.callTimeout);
      await leaveTalkCall();
      // if (this.engine) {
      //   await this.engine.leaveChannel();
      // }
      await this.props.dispatch({
        type: 'agora/talkLeave',
      });
      this.setState({
        talkCall: 2,
      });
    } catch (e) {
      console.log(e);
    }
  };

  face = () => {
    this.state.faceType === 'wxpay' ? this.wechatFace() : this.smileFace();
  };

  // device 代表当前打开的门
  handleScaleChange = async ({count}) => {
    if (count === -1) {
      // 重力感应开始识别
      this.face();
      clearTimeout(this.wakeUpTimeout);
      this.setState({sleep: false});
    } else if (count === 0) {
      // 重力感应归零
      this.leaveC();
      this.setState({
        orderDetailsModal: false,
        phoneModal: false,
        verifyCodeModal: false,
        current: 1,
        tipsModal: false,
        loadingModal: false,
        sleep: true,
        tip: '',
      });
    }
  };

  handleDoorLogin = async ret => {
    if (ret) {
      if (ret.code < 0 || ret.code === 401) {
        // 未授权，提示用户扫码验证
        let tipText = ret.msg;
        Speech.speak(tipText);
        this.userId = ret.userId;
        this.setState({tip: tipText, tipsModal: true, loadingModal: false});
        if (ret.code === 401) {
          // 需要验证手机号
          this.setState({
            phoneModal: true,
            loadingModal: false,
          });
        } else if (ret.orders && ret.orders.length > 0) {
          let goodsArr = [];
          ret.orders.map(v1 => {
            v1.goods.map(v2 => {
              goodsArr.push(v2);
            });
          });
          this.setState({
            orderDetailsModal: true,
            loadingModal: false,
            goodsArr,
            customerPhone: ret.phone || '0000',
            current: 1,
          });
        }
      } else if (ret.msg) {
        let tipText = ret.msg.replace(/扫码/g, '人脸识别');
        Speech.speak(tipText);
        if (ret.code !== 1) {
          this.setState({tip: tipText, tipsModal: true, loadingModal: false});
        }
      }
    } else {
      Speech.speak('正在重新识别，请靠中间站稳');
    }
  };

  authinfo = async () => {
    const rawdata = await WxFacepay.rawdata();
    const {data} = await this.props.dispatch({
      type: 'goods/faceinfo',
      rawdata,
    });
    return data;
  };

  // 微信人脸身份识别
  wechatFace = async () => {
    const {orderDetailsModal, tipsModal} = this.state;
    if (orderDetailsModal || tipsModal) {
      return;
    } // 出现订单弹窗，不做人脸识别
    const tipText = '正在人脸识别，请看向屏幕，靠中间站稳';
    Speech.speak(tipText);
    // this.setState({tip: tipText, tipsModal: true});
    let auth = (await this.authinfo()) || {};
    if (
      auth.return_code === 'SUCCESS' ||
      (auth.code === 1 && auth.data.bizCode === '0000')
    ) {
      if (auth.data) {
        auth = auth.data;
      }
      const params = {
        appid: auth.appid || auth.subAppId,
        mch_id: auth.mch_id || auth.subMchId,
        store_id: this.storeKey,
        authinfo: auth.authinfo || auth.authInfo,
        face_authtype: 'FACEID-ONCE',
        ask_unionid: 1,
      };
      let res = (await WxFacepay.faceinfo(params)) || {};
      if (!res.openid) {
        // 返回错误自动重新识别
        res = (await WxFacepay.faceinfo(params)) || {};
      }
      if (window.socket) {
        // 返回结果，立即重新连接socket
        window.socket.connect();
      }
      if (!res.openid) {
        // 没识别到人脸不开门
        return;
      }
      if (res.sub_openid) {
        res.openid = res.sub_openid;
      }
      this.loading(true);
      const ret = await this.props.dispatch({
        type: 'store/wxdoor',
        openid: res.openid,
        wxtoken: res.token,
        nickname: res.nickname,
      });
      this.loading(false);
      this.handleDoorLogin(ret);
    }
  };

  alipayinfo = async () => {
    const {data} = await this.props.dispatch({type: 'goods/alipayinfo'});
    this.alipayInfo = await Smilepay.init(data);
    if (this.alipayInfo.code === '1000')
      this.alipayInfo.metaInfo = JSON.parse(this.alipayInfo.metaInfo);
    return this.alipayInfo;
  };

  smileFace = async () => {
    const {orderDetailsModal, tipsModal} = this.state;
    if (orderDetailsModal || tipsModal) {
      return;
    } // 出现订单弹窗，不做人脸识别
    const tipText = '正在人脸识别，请看向屏幕，靠中间站稳';
    Speech.speak(tipText);
    await this.alipayinfo();
    if (!this.alipayInfo || !this.alipayInfo.metaInfo) {
      this.props.speak('刷脸支付启动失败，请重新刷脸或扫码支付', true);
      return;
    }
    const {data} = await this.props.dispatch({
      type: 'goods/smilepay',
      service_id: 'auth',
      zimmetainfo: this.alipayInfo.metaInfo,
    });
    if (data.code === 1) {
      const res = await Smilepay.verify(JSON.parse(data.data));
      if (res.code !== '1000') {
        Toast.show(res.msg);
        return;
      }
      this.loading(true);
      const ret = await this.props.dispatch({
        type: 'store/wxdoor',
        alipayUid: res.uid,
      });
      this.loading(false);
      this.handleDoorLogin(ret);
    }
  };

  loading = flag => {
    this.setState({
      loadingModal: flag,
    });
  };

  // 语音通话请求
  onCall = async () => {
    const {talkCall} = this.state;
    if (talkCall === 2) {
      Speech.speak('正在接通中请稍候');
      this.talkCall();
      clearInterval(this.noTalkCall);
      this.noTalkCall = setInterval(() => this.talkCall(), 10000);
      this.setState({
        talkCall: 0,
      });
      clearInterval(this.callTimeout);
      this.callTimeout = setTimeout(() => {
        clearInterval(this.noTalkCall);
        this.setState({
          talkCall: 2,
        });
      }, 30000);
    }
  };

  talkCall = () => {
    this.props.dispatch({
      type: 'agora/talkCall',
    });
  };

  dropUp = () => {
    let {current} = this.state;
    if (current > 1) {
      this.setState({
        current: --current,
      });
    }
  };

  dropDown = goodsLength => {
    let {current} = this.state;
    if (current < goodsLength) {
      this.setState({
        current: ++current,
      });
    }
  };

  wakeUp = () => {
    this.setState({sleep: false});
    clearTimeout(this.wakeUpTimeout);
    this.wakeUpTimeout = setTimeout(() => {
      this.setState({sleep: true});
    }, 18888);
  };

  closeTips = async () => {
    await this.setState({tipsModal: false});
    await this.face();
  };

  render() {
    const {
      verifyCodeModal,
      phoneModal,
      orderDetailsModal,
      goodsArr,
      talkCall,
      storeName,
      contact,
      customerPhone,
      current,
      tip,
      tipsModal,
      sleep,
      faceType,
      loadingModal,
    } = this.state;
    let {dispatch} = this.props;
    if (faceType === 'alipay') {
      styles.header = {...styles.header, backgroundColor: '#1b7dc7'};
      styles.btnCome = {...styles.btnCome, backgroundColor: '#1b7dc7'};
      styles.footer = {...styles.footer, backgroundColor: '#1b7dc7'};
      styles.onCall = {...styles.onCall, backgroundColor: '#1b7dc7'};
    }
    return sleep ? (
      <Screensaver onPress={this.wakeUp} />
    ) : (
      <View style={styles.content}>
        <PhoneModal
          visible={phoneModal}
          transparent
          onCall={this.onCall}
          onSubmit={this.onSubmit}
          faceType={faceType}
        />
        <VerifyCodeModal
          visible={verifyCodeModal}
          transparent
          onCall={this.onCall}
          onSubmit={this.onCodeSubmit}
          faceType={faceType}
        />
        <OrderDetailsModal
          visible={orderDetailsModal}
          transparent
          maskClosable
          onClose={this.handleOrderClose}
          onRequestClose={this.handleOrderClose}
          onCall={this.onCall}
          dropUp={this.dropUp}
          dropDown={this.dropDown}
          goodsArr={goodsArr}
          dispatch={dispatch}
          talkCall={talkCall}
          customerPhone={customerPhone}
          current={current}
          faceType={faceType}
        />
        <TipsModal
          visible={tipsModal}
          transparent
          title={'操作失败'}
          tip={tip}
          leftText={'呼叫客服'}
          rightText={'重新识别'}
          leftTouch={this.onCall}
          rightTouch={this.closeTips}
          faceType={faceType}
        />
        <LoadingModal transparent visible={loadingModal} />
        <View style={styles.header}>
          <View style={styles.title}>
            <View style={styles.left}>
              <Image
                source={require('../assets/logo2.png')}
                style={styles.img}
              />
              <Text style={styles.text}>{storeName}</Text>
            </View>
            <View style={styles.right}>
              <Text style={styles.text}>{contact}</Text>
              <Image style={styles.phone} source={phone} />
            </View>
          </View>
          <View style={styles.headline}>
            <Text style={styles.headTitle}>刷脸开门系统</Text>
          </View>
        </View>
        <View style={styles.face}>
          <View style={styles.faceRecogn}>
            <Touch style={styles.faceGif} onPress={this.face} feedback={false}>
              <Image
                source={require('../assets/Vertical/face.gif')}
                style={{flex: 1, width}}
              />
            </Touch>
          </View>
          <Touch onPress={this.face} style={styles.btnCome} feedback={false}>
            <View style={styles.click}>
              <Image
                source={
                  faceType === 'wxpay'
                    ? require('../assets/wxpay.png')
                    : require('../assets/Vertical/alipay01.png')
                }
                style={styles.wxpay}
                tintColor="white"
              />
              <Text style={styles.clickText}>点击进入</Text>
              <Image source={require('../assets/up.png')} style={styles.up} />
              <Text style={styles.clickText}>刷脸开门</Text>
            </View>
          </Touch>
        </View>
        {talkCall === 1 ? (
          <View style={styles.onCall}>
            <Image
              source={
                faceType === 'wxpay'
                  ? require('../assets/call.gif')
                  : require('../assets/call_blue.gif')
              }
              style={styles.callGif}
            />
            <Text style={styles.onCallText}>正在语音通话中</Text>
          </View>
        ) : talkCall === 0 ? (
          <View style={styles.onCall}>
            <Image
              source={
                faceType === 'wxpay'
                  ? require('../assets/call.gif')
                  : require('../assets/call_blue.gif')
              }
              style={styles.callGif}
            />
            <Text style={styles.onCallText}>正在接通中请稍候...</Text>
          </View>
        ) : (
          <Touch onPress={this.onCall} style={styles.footer} feedback={false}>
            <View style={styles.call}>
              <Image
                source={
                  faceType === 'wxpay'
                    ? require('../assets/call.gif')
                    : require('../assets/call_blue.gif')
                }
                style={styles.callGif}
              />
              <Text style={styles.callText}>呼叫客服</Text>
            </View>
          </Touch>
        )}
      </View>
    );
  }
}

const styles = {
  content: {
    flex: 1,
    alignItems: 'center',
    backgroundColor: '#fff',
  },
  header: {
    flex: 0.2,
    backgroundColor: 'rgb(0,205,102)',
    width: '100%',
    flexDirection: 'column',
  },
  title: {
    flexDirection: 'row',
    justifyContent: 'space-between',
    marginLeft: scaleSize(30),
    marginRight: scaleSize(30),
    marginTop: scaleSize(10),
  },
  headline: {
    flexDirection: 'row',
    justifyContent: 'center',
    alignItems: 'center',
    flex: 1,
    marginBottom: scaleSize(20),
  },
  headTitle: {
    fontSize: setSpText(100),
    color: '#fff',
  },
  left: {
    flexDirection: 'row',
    alignItems: 'center',
  },
  right: {
    flexDirection: 'row-reverse',
    alignItems: 'center',
  },
  img: {
    width: scaleSize(90),
    height: scaleSize(90),
    marginRight: scaleSize(20),
    resizeMode: 'contain',
  },
  text: {
    color: '#FFFFFF',
    fontSize: setSpText(65),
  },
  phone: {
    width: scaleSize(80),
    height: scaleSize(80),
    marginRight: scaleSize(15),
    resizeMode: 'contain',
  },
  face: {
    flex: 0.6,
    width: '100%',
    flexDirection: 'column',
    alignItems: 'center',
    justifyContent: 'space-around',
  },
  faceRecogn: {
    flex: 0.7,
  },
  faceGif: {
    position: 'relative',
    zIndex: 2,
  },
  btnCome: {
    flex: 0.15,
    backgroundColor: 'rgb(0,205,102)',
    width: '80%',
    borderRadius: 30,
    flexDirection: 'row',
    alignItems: 'center',
    justifyContent: 'center',
    elevation: 2,
  },
  click: {
    flexDirection: 'row',
    alignItems: 'center',
    justifyContent: 'center',
  },
  clickText: {
    fontSize: setSpText(70),
    color: '#fff',
  },
  wxpay: {
    width: scaleSize(90),
    height: scaleSize(80),
    marginRight: scaleSize(20),
  },
  up: {
    width: scaleSize(180),
    height: scaleSize(200),
  },
  footer: {
    flex: 0.2,
    width: '100%',
    backgroundColor: 'rgb(68, 197, 114)',
  },
  call: {
    felx: 1,
    flexDirection: 'row',
    alignItems: 'center',
    justifyContent: 'center',
  },
  callGif: {
    width: scaleSize(500),
    height: scaleSize(320),
    marginLeft: scaleSize(-240),
  },
  callText: {
    fontSize: setSpText(150),
    color: '#fff',
  },
  onCall: {
    flex: 0.2,
    width: '100%',
    // backgroundColor: '#44c571',
    backgroundColor: 'rgb(68, 197, 114)',
    flexDirection: 'row',
    justifyContent: 'center',
    alignItems: 'center',
  },
  onCallText: {
    fontSize: setSpText(85),
    color: '#fff',
    marginLeft: scaleSize(-100),
  },
};

export default connect(({store}) => ({store}))(FacePage);
