import AsyncStorage from '@react-native-community/async-storage';
import * as api from '../services/admin';

export default {
  namespace: 'admin',
  state: {
    auth: {},
    socket: '',
  },
  reducers: {
    setAuth(state, {id, auth, login}) {
      state.id = id;
      state.auth = auth;
      window.auth = auth;
      if (window.socket) {
        window.socket.io.opts.query = {
          token: auth.token,
        };
      }
      AsyncStorage.setItem('auth', JSON.stringify(auth));
      if (login) {
        AsyncStorage.setItem('login', login);
      }
      return {...state};
    },
    setSocket(state, {socket}) {
      state.socket = socket;
      return {...state};
    },
  },
  effects: {
    *auth(action, {put, call}) {
      let login = action.login;
      action.device = login;
      delete action.login;
      const {data} = action.key
        ? yield call(api.token, action)
        : yield call(api.refreshToken);
      if (data && data.code === 1) {
        if (data.data && data.data.contact) {
          yield call(AsyncStorage.setItem, 'CONTACT', data.data.contact);
        }
        if (action.key) {
          yield call(AsyncStorage.setItem, 'KEY', action.key);
        }
        yield put({type: 'setAuth', id: data.id, auth: data.data, login});
      }
      return data;
    },
    *logout(action, {put, call}) {
      yield call(AsyncStorage.removeItem, 'auth');
      yield put({type: 'app/replace', route: 'home'});
    },
    *version(action, {call}) {
      yield call(api.version);
    },
  },
};
