import React, {Component} from 'react';
import {Modal, View, Text, Image, FlatList} from 'react-native';
import Icon from 'react-native-vector-icons/Ionicons';
import AsyncStorage from '@react-native-community/async-storage';
import ModalStyles from './Modal/styles';
import {font} from '../utils/common';
import Touch from './Touch';
import NP from '../utils/np';
import phone from '../assets/Vertical/phone.png';
import {width} from '../utils/screen';

let pageSize = 6; // 分页大小

const mStyles = {
  ...ModalStyles,
  innerContainer: {
    ...ModalStyles.innerContainer,
  },
  header: {
    ...ModalStyles.header,
    fontSize: font.title,
  },
};

// const goodsArr = [
//   {
//     name: '百事可乐',
//     price: 10,
//     prePrice: 12,
//     num: 1,
//   },
//   {
//     name: '百事可乐车时断时续测试市场上',
//     price: 10,
//     prePrice: 12,
//     num: 1,
//   },
//   {
//     name: '百事可乐车时断时续测试市场上',
//     price: 10,
//     prePrice: 12,
//     num: 1,
//   },
//   {
//     name: '百事可乐车时断时续测试市场上',
//     price: 10,
//     prePrice: 12,
//     num: 1,
//   },
//   {
//     name: '百事可乐车时断时续测试市场上',
//     price: 10,
//     prePrice: 12,
//     num: 1,
//   },
//   {
//     name: '百事可乐车时断时续测试市场上',
//     price: 10,
//     prePrice: 12,
//     num: 1,
//   },
//   {
//     name: '百事可乐车时断时续测试市场上',
//     price: 10,
//     prePrice: 12,
//     num: 1,
//   },
//   {
//     name: '百事可乐车时断时续测试市场上',
//     price: 10,
//     prePrice: 12,
//     num: 1,
//   },
// ];

class OrderDetailsModal extends Component {
  state = {
    conatct: '',
    storeName: '',
  };

  async componentWillMount() {
    let contact = await AsyncStorage.getItem('CONTACT');
    let storeName = await AsyncStorage.getItem('NAME');
    this.setState({
      contact,
      storeName,
    });
  }

  // 生成不重复的key
  keyExtractor = (item: any, index: number) => {
    return String(index);
  };

  renderHeader = () => {
    return (
      <View style={{flex: 1, flexDirection: 'column'}}>
        <View style={{backgroundColor: '#fff'}}>
          <View
            style={{
              flexDirection: 'row',
              alignItems: 'center',
              justifyContent: 'center',
            }}>
            <View style={styles.firstThStyle}>
              <Text style={styles.ThText}>商品名称</Text>
            </View>
            <View style={styles.ThStyle}>
              <Text style={styles.ThText}>单价</Text>
            </View>
            <View style={styles.ThStyle}>
              <Text style={styles.ThText}>数量</Text>
            </View>
            <View style={styles.ThStyle}>
              <Text style={styles.ThText}>金额</Text>
            </View>
          </View>
        </View>
        <View style={styles.line} />
      </View>
    );
  };

  // 显示数据
  renderCell = (item, index) => (
    <View style={index % 2 === 0 ? styles.oddCell : styles.evenCell}>
      <View style={styles.firstTdStyle}>
        <Text style={styles.TdText} numberOfLines={1}>
          {item.name}
        </Text>
      </View>
      <View style={styles.TdStyle}>
        {item.price ? (
          <Text style={styles.TdText}>
            {NP.round(item.price, 2).toFixed(2)}
          </Text>
        ) : (
          <Text style={styles.TdText}>
            {NP.round(item.prePrice, 2).toFixed(2)}
          </Text>
        )}
      </View>
      <View style={styles.TdStyle}>
        <Text style={styles.TdText}> {NP.round(item.num, 0).toFixed(0)} </Text>
      </View>
      <View style={styles.TdStyle}>
        {item.price ? (
          <Text style={styles.TdText}>
            {NP.round(item.price * item.num, 2).toFixed(2)}
          </Text>
        ) : (
          <Text style={styles.TdText}>
            {NP.round(item.prePrice * item.num, 2).toFixed(2)}
          </Text>
        )}
      </View>
    </View>
  );

  render() {
    const {
      onClose,
      goodsArr,
      talkCall,
      onCall,
      customerPhone,
      current,
      faceType,
      ...props
    } = this.props;
    const {contact, storeName} = this.state;
    let goodsLength = Math.ceil(parseFloat(goodsArr.length / pageSize));
    let gaTemp = goodsArr.slice((current - 1) * pageSize, current * pageSize);
    let totalPrice = 0; // 总价
    let totalCount = 0; // 总优惠
    let number = 0; // 总数量
    goodsArr.map(item => {
      // item.url = config.imgUrl + item.barcode + config.watermark;
      number += item.num;
      if (item.price) {
        totalPrice += item.price * item.num;
        totalCount += (item.prePrice - item.price) * item.num;
      } else {
        totalPrice += item.prePrice * item.num;
      }
    });
    this.totalPrice = totalPrice;
    this.totalCount = totalCount;
    let phoneText = '';
    if (customerPhone.length === 15) {
      phoneText = '用户号：' + customerPhone;
    } else {
      phoneText =
        '手机号：' +
        customerPhone.substring(0, 3) +
        '****' +
        customerPhone.substring(customerPhone.length - 4, customerPhone.length);
    }
    if (faceType === 'alipay') {
      styles.header = {...styles.header, backgroundColor: '#1b7dc7'};
      styles.footer = {...styles.footer, backgroundColor: '#1b7dc7'};
      styles.onCall = {...styles.onCall, backgroundColor: '#1b7dc7'};
      styles.customerPhone = {
        ...styles.customerPhone,
        backgroundColor: '#1E90FF',
      };
    }
    return (
      <Modal styles={mStyles} {...props}>
        <View style={styles.modal}>
          <View style={styles.header}>
            <View style={styles.title}>
              <View style={styles.left}>
                <Image
                  source={require('../assets/logo2.png')}
                  style={styles.img}
                />
                <Text style={styles.text}>{storeName}</Text>
              </View>
              <View style={styles.right}>
                <Touch onPress={() => onClose()}>
                  <Icon
                    name="md-close"
                    color={'#FFFFFF'}
                    size={width > 471 ? 50 : 35}
                  />
                </Touch>
                <Text style={styles.text}>{contact}</Text>
                <Image style={styles.phone} source={phone} />
              </View>
            </View>
            <View style={styles.headline}>
              <Text style={styles.headTitle}>核对订单页面</Text>
            </View>
            <View style={styles.customerPhone}>
              <Text style={styles.number}>{phoneText}</Text>
            </View>
          </View>
          {goodsArr && goodsArr.length > 0 ? (
            <View style={styles.container}>
              <View style={{flexDirection: 'row', flex: 1}}>
                <View style={{width: '90%'}}>
                  <FlatList
                    style={styles.goodsStyle}
                    ListHeaderComponent={this.renderHeader}
                    keyExtractor={this.keyExtractor}
                    horizontal={false}
                    data={gaTemp}
                    renderItem={({item, index}) => this.renderCell(item, index)}
                  />
                </View>
                <View
                  style={{
                    width: '10%',
                    flexDirection: 'column',
                  }}>
                  <View style={{height: 81, backgroundColor: '#fff'}} />
                  <View style={{height: 8}} />
                  <View style={styles.pagination}>
                    <Touch
                      disabled={current <= 1}
                      onPress={() => this.props.dropUp()}>
                      <Image
                        source={
                          current > 1
                            ? require('../assets/Vertical/arrowu01.png')
                            : require('../assets/Vertical/arrowu02.png')
                        }
                        style={styles.imgPagination}
                      />
                    </Touch>
                    <Text style={styles.paginationText}>
                      {goodsLength === 0 ? 0 : current}/{goodsLength}
                    </Text>
                    <Touch
                      disabled={current >= goodsLength}
                      onPress={() => this.props.dropDown(goodsLength)}>
                      <Image
                        source={
                          current < goodsLength
                            ? require('../assets/Vertical/arrowd01.png')
                            : require('../assets/Vertical/arrowd02.png')
                        }
                        style={styles.imgPagination}
                      />
                    </Touch>
                  </View>
                </View>
              </View>
              <View style={styles.line} />
              <View style={styles.amount}>
                <View style={styles.total}>
                  <Text style={styles.totalText}>合计</Text>
                  <Text style={styles.totalText}>
                    ￥{' '}
                    {NP.round(
                      Number(totalPrice) + Number(totalCount),
                      2,
                    ).toFixed(2)}
                  </Text>
                </View>
                <View style={styles.total}>
                  <Text style={styles.totalText}>数量</Text>
                  <Text style={styles.totalText}>
                    {NP.round(number, 0).toFixed(0)}
                  </Text>
                </View>
                <View style={styles.total}>
                  <Text style={styles.totalText}>优惠</Text>
                  <Text style={styles.discount}>
                    -￥ {NP.round(totalCount, 2).toFixed(2)}
                  </Text>
                </View>
              </View>
              <View style={styles.line} />
              <View style={styles.realPay}>
                <View style={styles.total}>
                  <Text style={styles.totalText}>实付金额</Text>
                  <Text style={styles.totalText}>
                    ￥ {NP.round(totalPrice, 2).toFixed(2)}
                  </Text>
                </View>
                <View style={styles.tip}>
                  <Text style={styles.tips}>
                    ***请核对您的商品订单，将商品拿给买单的人***
                  </Text>
                </View>
              </View>
            </View>
          ) : (
            <View style={styles.container}>
              <View style={styles.emptyContainer}>
                <View style={styles.empty}>
                  <Image
                    source={require('../assets/empty.png')}
                    style={styles.emptyImg}
                  />
                </View>
                <View style={styles.empty}>
                  <Text style={styles.tips}>
                    您没有商品记录哦，请将商品拿给买单的人
                  </Text>
                </View>
              </View>
            </View>
          )}
          {talkCall === 1 ? (
            <View style={styles.onCall}>
              <Image
                source={
                  faceType === 'wxpay'
                    ? require('../assets/call.gif')
                    : require('../assets/call_blue.gif')
                }
                style={styles.callGif}
              />
              <Text style={styles.onCallText}>正在语音通话中</Text>
            </View>
          ) : talkCall === 0 ? (
            <View style={styles.onCall}>
              <Image
                source={
                  faceType === 'wxpay'
                    ? require('../assets/call.gif')
                    : require('../assets/call_blue.gif')
                }
                style={styles.callGif}
              />
              <Text style={styles.onCallText}>正在接通中请稍候...</Text>
            </View>
          ) : (
            <Touch
              onPress={() => onCall()}
              style={styles.footer}
              feedback={false}>
              <View style={styles.call}>
                <Image
                  source={
                    faceType === 'wxpay'
                      ? require('../assets/call.gif')
                      : require('../assets/call_blue.gif')
                  }
                  style={styles.callGif}
                />
                <Text style={styles.callText}>呼叫客服</Text>
              </View>
            </Touch>
          )}
        </View>
      </Modal>
    );
  }
}

const styles = {
  modal: {
    height: '100%',
    width: '100%',
    backgroundColor: '#fff',
    flexDirection: 'column',
    justifyContent: 'center',
    alignItems: 'center',
  },
  header: {
    flex: 0.2,
    // backgroundColor: '#00CD66',
    backgroundColor: 'rgb(0,205,102)',
    width: '100%',
    flexDirection: 'column',
    // borderTopRightRadius: 10,
    //     // borderTopLeftRadius: 10,
  },
  title: {
    flexDirection: 'row',
    justifyContent: 'space-between',
    marginLeft: width > 471 ? 30 : 15,
    marginRight: width > 471 ? 30 : 15,
    marginTop: width > 471 ? 10 : 5,
    marginBottom: width > 471 ? 10 : 5,
  },
  left: {
    flexDirection: 'row',
    alignItems: 'center',
  },
  right: {
    flexDirection: 'row-reverse',
    alignItems: 'center',
  },
  img: {
    width: width > 471 ? 60 : 40,
    height: width > 471 ? 60 : 40,
    marginRight: width > 471 ? 10 : 8,
    resizeMode: 'contain',
  },
  text: {
    color: '#FFFFFF',
    fontSize: width > 471 ? 35 : 28,
    marginRight: width > 471 ? 30 : 24,
  },
  phone: {
    width: width > 471 ? 40 : 30,
    height: width > 471 ? 40 : 30,
    marginRight: width > 471 ? 10 : 5,
    resizeMode: 'contain',
  },
  headline: {
    flexDirection: 'row',
    justifyContent: 'center',
    alignItems: 'center',
    flex: 1,
  },
  headTitle: {
    fontSize: width > 471 ? 60 : 48,
    color: '#fff',
  },
  customerPhone: {
    backgroundColor: '#3CB371',
    flexDirection: 'row',
    justifyContent: 'center',
    alignItems: 'center',
    marginLeft: '5%',
    marginRight: '5%',
    marginBottom: '2%',
    paddingTop: width > 471 ? 10 : 8,
    paddingBottom: width > 471 ? 10 : 8,
    elevation: 3,
  },
  number: {
    color: '#FFFFFF',
    fontSize: width > 471 ? 30 : 24,
    marginRight: width > 471 ? 30 : 24,
  },
  container: {
    flex: 0.6,
    width: '100%',
    flexDirection: 'column',
  },
  emptyContainer: {
    flex: 1,
    marginLeft: '5%',
    marginRight: '5%',
    backgroundColor: '#fff',
    flexDirection: 'column',
    justifyContent: 'center',
    alignItems: 'center',
  },
  tip: {
    flexDirection: 'row',
    justifyContent: 'center',
    alignItems: 'center',
    margin: width > 471 ? 10 : 8,
  },
  empty: {
    flexDirection: 'row',
    margin: width > 471 ? 10 : 8,
  },
  emptyImg: {
    width: 400,
    height: 400,
    resizeMode: 'contain',
  },
  tips: {
    fontSize: width > 471 ? 30 : 20,
    // color: '#8B8989',
    color: 'red',
  },
  goodsStyle: {
    width: '100%',
  },
  pagination: {
    flex: 1,
    backgroundColor: '#fff',
    marginTop: '12%',
    flexDirection: 'column',
    alignItems: 'center',
    justifyContent: 'center',
  },
  paginationText: {
    fontSize: width > 471 ? 40 : 32,
  },
  imgPagination: {
    width: width > 471 ? 50 : 40,
    height: width > 471 ? 50 : 40,
  },
  firstThStyle: {
    width: '40%',
    alignItems: 'flex-start',
    paddingTop: width > 471 ? 14 : 10,
    paddingBottom: width > 471 ? 14 : 10,
    paddingLeft: width > 471 ? 10 : 8,
    paddingRight: width > 471 ? 10 : 8,
    marginLeft: '10%',
  },
  ThStyle: {
    width: '20%',
    alignItems: 'center',
    paddingTop: width > 471 ? 14 : 10,
    paddingBottom: width > 471 ? 14 : 10,
    paddingLeft: width > 471 ? 10 : 8,
    paddingRight: width > 471 ? 10 : 8,
  },
  ThText: {
    fontSize: width > 471 ? 30 : 20,
  },
  oddCell: {
    flexDirection: 'row',
    backgroundColor: '#fff',
  },
  evenCell: {
    flexDirection: 'row',
    backgroundColor: '#F0F0F0',
  },
  firstTdStyle: {
    width: '40%',
    justifyContent: 'center',
    alignItems: 'flex-start',
    paddingTop: width > 471 ? 14 : 10,
    paddingBottom: width > 471 ? 14 : 10,
    paddingLeft: width > 471 ? 10 : 8,
    paddingRight: width > 471 ? 10 : 8,
    marginLeft: '5%',
  },
  TdStyle: {
    flexDirection: 'row',
    width: '20%',
    alignItems: 'center',
    justifyContent: 'center',
    paddingTop: width > 471 ? 14 : 10,
    paddingBottom: width > 471 ? 14 : 10,
    paddingLeft: width > 471 ? 10 : 8,
    paddingRight: width > 471 ? 10 : 8,
  },
  TdText: {
    fontSize: width > 471 ? 20 : 16,
  },
  amount: {
    flexDirection: 'column',
    height: width > 471 ? '25%' : '22%',
    backgroundColor: '#FFF',
    marginLeft: '2%',
    marginRight: '2%',
  },
  total: {
    flexDirection: 'row',
    justifyContent: 'space-between',
    alignItems: 'center',
    marginLeft: width > 471 ? 30 : 20,
    marginRight: width > 471 ? 30 : 20,
    marginTop: width > 471 ? 15 : 8,
  },
  totalText: {
    fontSize: width > 471 ? 30 : 20,
  },
  discount: {
    fontSize: width > 471 ? 30 : 20,
    color: 'red',
  },
  line: {
    width: '100%',
    borderWidth: 1,
    borderColor: '#ddd',
    height: 1,
  },
  realPay: {
    flexDirection: 'column',
    height: width > 471 ? '16%' : '14%',
    backgroundColor: '#FFF',
    marginLeft: '2%',
    marginRight: '2%',
  },
  footer: {
    flex: 0.2,
    width: '100%',
    // backgroundColor: '#44c571',
    backgroundColor: 'rgb(68,197,113)',
  },
  call: {
    felx: 1,
    flexDirection: 'row',
    justifyContent: 'center',
    alignItems: 'center',
  },
  callGif: {
    width: width > 471 ? 350 : 240,
    height: width > 471 ? 240 : 150,
    marginLeft: width > 471 ? -120 : -96,
  },
  callText: {
    fontSize: width > 471 ? 70 : 56,
    color: '#fff',
    marginLeft: width > 471 ? -50 : -40,
  },
  onCall: {
    flex: 0.2,
    width: '100%',
    // backgroundColor: '#44c571',
    backgroundColor: 'rgb(68,197,113)',
    flexDirection: 'row',
    justifyContent: 'center',
    alignItems: 'center',
  },
  onCallText: {
    fontSize: width > 471 ? 70 : 40,
    color: '#fff',
    marginLeft: width > 471 ? -70 : -56,
  },
};

export default OrderDetailsModal;
