import AsyncStorage from '@react-native-community/async-storage';
import React, {Component} from 'react';
import {FlatList, Image, Modal, ScrollView, Text, View} from 'react-native';
import {font} from '../utils/common';
import NP from '../utils/np';
import {scaleSize, setSpText} from '../utils/screen';
import ModalStyles from './Modal/styles';

const mStyles = {
  ...ModalStyles,
  innerContainer: {
    ...ModalStyles.innerContainer,
  },
  header: {
    ...ModalStyles.header,
    fontSize: font.title,
  },
};

class OrderDetailMini extends Component {
  state = {
    conatct: '',
    storeName: '',
  };

  async componentWillMount() {
    let contact = await AsyncStorage.getItem('CONTACT');
    let storeName = await AsyncStorage.getItem('NAME');
    this.setState({
      contact,
      storeName,
    });
  }

  // 生成不重复的key
  keyExtractor = (item, index) => {
    return String(index);
  };

  renderHeader = () => {
    return (
      <View
        style={{
          flex: 1,
          flexDirection: 'column',
          paddingLeft: scaleSize(25),
          paddingRight: scaleSize(25),
        }}>
        <View style={{backgroundColor: '#FFFFFF'}}>
          <View
            style={{
              flexDirection: 'row',
              alignItems: 'center',
              justifyContent: 'center',
            }}>
            <View style={styles.firstThStyle}>
              <Text style={styles.ThText}>商品名称</Text>
            </View>
            <View style={styles.ThStyle}>
              <Text style={styles.ThText}>单价</Text>
            </View>
            <View style={styles.ThStyle}>
              <Text style={styles.ThText}>数量</Text>
            </View>
            <View style={styles.ThStyle}>
              <Text style={styles.ThText}>金额</Text>
            </View>
          </View>
        </View>
        <View style={styles.line} />
      </View>
    );
  };

  // 显示数据
  renderCell = (item, index) => (
    <View style={index % 2 === 0 ? styles.oddCell : styles.evenCell}>
      <View style={styles.firstTdStyle}>
        <Text style={styles.TdText} numberOfLines={1}>
          {item.name}
        </Text>
      </View>
      <View style={styles.TdStyle}>
        {item.price ? (
          <Text style={styles.TdText}>
            {NP.round(item.price, 2).toFixed(2)}
          </Text>
        ) : (
          <Text style={styles.TdText}>
            {NP.round(item.prePrice, 2).toFixed(2)}
          </Text>
        )}
      </View>
      <View style={styles.TdStyle}>
        {item.num ? (
          <Text style={styles.TdText}>
            {' '}
            {NP.round(item.num, 0).toFixed(0)}{' '}
          </Text>
        ) : (
          <Text style={styles.TdText}> 0 </Text>
        )}
      </View>
      <View style={styles.TdStyle}>
        {item.num ? (
          item.price ? (
            <Text style={styles.TdText}>
              {NP.round(item.price * item.num, 2).toFixed(2)}
            </Text>
          ) : (
            <Text style={styles.TdText}>
              {NP.round(item.prePrice * item.num, 2).toFixed(2)}
            </Text>
          )
        ) : (
          <Text style={styles.TdText}> 0.00 </Text>
        )}
      </View>
    </View>
  );

  render() {
    const {goodsArr, faceType, ...props} = this.props;
    let totalPrice = 0; // 总价
    let totalCount = 0; // 总优惠
    let number = 0; // 总数量
    let _goodsArr = goodsArr;
    if (!goodsArr || goodsArr.code) {
      _goodsArr = [];
    }
    _goodsArr.map(item => {
      number += item.num;
      if (item.price) {
        totalPrice += item.price * item.num;
        totalCount += (item.prePrice - item.price) * item.num;
      } else {
        totalPrice += item.prePrice * item.num;
      }
    });
    this.totalPrice = totalPrice;
    this.totalCount = totalCount;
    if (faceType === 'alipay') {
      styles.header = {...styles.header, backgroundColor: '#1b7dc7'};
    }
    return (
      <Modal styles={mStyles} {...props}>
        <View style={styles.modalBackgroundStyle}>
          <View style={styles.modal}>
            <View style={styles.header}>
              <View style={styles.headline}>
                <Text style={styles.headTitle}>核对订单页面</Text>
              </View>
            </View>
            {goodsArr && goodsArr.length > 0 ? (
              <View style={styles.container}>
                <View style={{flexDirection: 'row', flex: 1}}>
                  <View style={{width: '100%'}}>
                    <ScrollView>
                      <FlatList
                        style={styles.goodsStyle}
                        ListHeaderComponent={this.renderHeader}
                        keyExtractor={this.keyExtractor}
                        horizontal={false}
                        data={goodsArr}
                        renderItem={({item, index}) =>
                          this.renderCell(item, index)
                        }
                      />
                    </ScrollView>
                  </View>
                </View>
                <View style={styles.line} />
                <View style={styles.amount}>
                  <View style={styles.total}>
                    <Text style={styles.totalText}>合计</Text>
                    <Text style={styles.totalText}>
                      ￥{' '}
                      {NP.round(
                        Number(totalPrice) + Number(totalCount),
                        2,
                      ).toFixed(2)}
                    </Text>
                  </View>
                  <View style={styles.total}>
                    <Text style={styles.totalText}>数量</Text>
                    <Text style={styles.totalText}>
                      {NP.round(number, 0).toFixed(0)}
                    </Text>
                  </View>
                  <View style={styles.total}>
                    <Text style={styles.totalText}>优惠</Text>
                    <Text style={styles.discount}>
                      -￥ {NP.round(totalCount, 2).toFixed(2)}
                    </Text>
                  </View>
                </View>
                <View style={styles.line} />
                <View style={styles.realPay}>
                  <View style={styles.total}>
                    <Text style={styles.totalText}>实付</Text>
                    <Text style={styles.totalText}>
                      ￥ {NP.round(totalPrice, 2).toFixed(2)}
                    </Text>
                  </View>
                </View>
              </View>
            ) : (
              <View style={styles.container}>
                <View style={styles.emptyContainer}>
                  <View style={styles.empty}>
                    <Image
                      source={require('../assets/empty.png')}
                      style={styles.emptyImg}
                    />
                  </View>
                </View>
              </View>
            )}
          </View>
          <View style={styles.loading}>
            <Image source={require('../assets/loading.gif')} />
          </View>
        </View>
      </Modal>
    );
  }
}

const styles = {
  modalBackgroundStyle: {
    position: 'relative',
    justifyContent: 'center',
    alignItems: 'center',
    backgroundColor: 'rgba(0, 0, 0, 0.5)',
    height: '100%',
    width: '100%',
  },
  modal: {
    height: scaleSize(1400),
    width: scaleSize(950),
    backgroundColor: '#fff',
    borderRadius: 20,
    marginBottom: 100,
  },
  header: {
    flex: 0.15,
    backgroundColor: 'rgb(0,205,102)',
    width: '100%',
    flexDirection: 'column',
    borderTopLeftRadius: 20,
    borderTopRightRadius: 20,
  },
  headline: {
    flexDirection: 'row',
    justifyContent: 'center',
    alignItems: 'center',
    flex: 1,
  },
  headTitle: {
    fontSize: setSpText(100),
    color: '#fff',
  },
  container: {
    flex: 0.85,
    width: '100%',
    flexDirection: 'column',
  },
  emptyContainer: {
    flex: 1,
    marginLeft: '5%',
    marginRight: '5%',
    backgroundColor: '#FFFFFF',
    flexDirection: 'column',
    justifyContent: 'center',
    alignItems: 'center',
  },
  empty: {
    flexDirection: 'row',
    margin: scaleSize(5),
  },
  emptyImg: {
    width: scaleSize(600),
    height: scaleSize(700),
    resizeMode: 'contain',
  },
  goodsStyle: {
    width: '100%',
  },
  firstThStyle: {
    width: '40%',
    alignItems: 'flex-start',
    paddingTop: scaleSize(14),
    paddingBottom: scaleSize(14),
    paddingLeft: scaleSize(8),
    paddingRight: scaleSize(8),
    marginLeft: '3%',
  },
  ThStyle: {
    width: '20%',
    alignItems: 'center',
    paddingTop: scaleSize(14),
    paddingBottom: scaleSize(14),
    paddingLeft: scaleSize(8),
    paddingRight: scaleSize(8),
  },
  ThText: {
    fontSize: setSpText(55),
  },
  oddCell: {
    flexDirection: 'row',
    backgroundColor: '#fff',
  },
  evenCell: {
    flexDirection: 'row',
    backgroundColor: '#F0F0F0',
  },
  firstTdStyle: {
    width: '40%',
    justifyContent: 'center',
    alignItems: 'flex-start',
    paddingTop: scaleSize(14),
    paddingBottom: scaleSize(14),
    paddingLeft: scaleSize(8),
    paddingRight: scaleSize(8),
    marginLeft: '5%',
  },
  TdStyle: {
    flexDirection: 'row',
    width: '20%',
    alignItems: 'center',
    justifyContent: 'center',
    paddingTop: scaleSize(14),
    paddingBottom: scaleSize(14),
    paddingLeft: scaleSize(6),
    paddingRight: scaleSize(50),
    marginRight: scaleSize(-15),
  },
  TdText: {
    fontSize: setSpText(45),
  },
  amount: {
    justifyContent: 'center',
    flexDirection: 'column',
    height: '18.5%',
    backgroundColor: '#FFF',
    marginLeft: '10%',
    marginRight: '10%',
  },
  total: {
    flexDirection: 'row',
    justifyContent: 'space-between',
    alignItems: 'center',
    marginTop: scaleSize(5),
  },
  totalText: {
    fontSize: setSpText(55),
  },
  discount: {
    fontSize: setSpText(60),
    color: 'red',
  },
  line: {
    width: '100%',
    borderWidth: 1,
    borderColor: '#ddd',
    height: 1,
  },
  realPay: {
    flexDirection: 'column',
    height: '10%',
    backgroundColor: '#FFF',
    marginLeft: '10%',
    marginRight: '10%',
    marginBottom: scaleSize(50),
    justifyContent: 'center',
  },
  loading: {
    position: 'absolute',
    top: 820,
    left: 0,
    right: 0,
    width: scaleSize(1150),
    height: scaleSize(1150),
    resizeMode: 'contain',
  },
};

export default OrderDetailMini;
